/*
 * Decompiled with CFR 0.152.
 */
package javax.ejb;

import java.io.PrintStream;
import java.io.PrintWriter;

public class EJBException
extends RuntimeException {
    private static final long serialVersionUID = 796770993296843510L;
    private Exception causeException;

    public EJBException() {
    }

    public EJBException(Exception causeException) {
        this.causeException = causeException;
    }

    public EJBException(String message) {
        super(message);
    }

    public EJBException(String message, Exception causeException) {
        super(message);
        this.causeException = causeException;
    }

    public Exception getCausedByException() {
        return this.causeException;
    }

    public Throwable getCause() {
        return super.getCause() != null ? super.getCause() : this.getCausedByException();
    }

    public String getMessage() {
        if (this.causeException == null) {
            return super.getMessage();
        }
        StringBuilder sb = new StringBuilder();
        if (super.getMessage() != null) {
            sb.append(super.getMessage());
            sb.append("; ");
        }
        sb.append("nested exception is: ");
        sb.append(this.causeException.toString());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream ps) {
        if (this.causeException == null || super.getCause() == null || this.causeException == super.getCause()) {
            super.printStackTrace(ps);
        } else {
            PrintStream printStream = ps;
            synchronized (printStream) {
                ps.println(this);
                this.causeException.printStackTrace(ps);
                super.printStackTrace(ps);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter pw) {
        if (this.causeException == null || super.getCause() == null || this.causeException == super.getCause()) {
            super.printStackTrace(pw);
        } else {
            PrintWriter printWriter = pw;
            synchronized (printWriter) {
                pw.println(this);
                this.causeException.printStackTrace(pw);
                super.printStackTrace(pw);
            }
        }
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }
}

