/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanMetaData;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import jakarta.ejb.EJBHome;
import jakarta.ejb.HomeHandle;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.rmi.PortableRemoteObject;

public class EntityHomeHandle
implements HomeHandle,
Serializable {
    private static final TraceComponent tc = Tr.register(EntityHomeHandle.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    String homeJNDIName;
    String homeInterface;
    transient EJBHome home;
    transient ClassLoader classLoader;
    final J2EEName j2eeName;
    final Properties initialContextProperties;
    private static final long serialVersionUID = -9080113035042415332L;

    EntityHomeHandle(BeanId id, String homeInterface, BeanMetaData bmd, Properties props) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"EntityHomeHandle", (Object[])new Object[]{id, homeInterface});
        }
        this.homeJNDIName = id.getJNDIName();
        this.homeInterface = homeInterface;
        this.j2eeName = id.getJ2EEName();
        this.initialContextProperties = props;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"EntityHomeHandle");
        }
    }

    public EJBHome getEJBHome() throws RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getEJBHome", (Object[])new Object[0]);
        }
        if (this.home == null) {
            if (this.homeJNDIName != null && this.homeJNDIName.contains(":")) {
                throw new NoSuchObjectException("EJBHome JNDI name not allowed : " + this.homeJNDIName);
            }
            try {
                Class<?> homeClass = null;
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    if (cl == null) {
                        throw new ClassNotFoundException();
                    }
                    homeClass = cl.loadClass(this.homeInterface);
                }
                catch (ClassNotFoundException ex) {
                    try {
                        homeClass = Class.forName(this.homeInterface);
                    }
                    catch (ClassNotFoundException e) {
                        throw new ClassNotFoundException(this.homeInterface);
                    }
                }
                InitialContext ctx = null;
                try {
                    if (this.initialContextProperties == null) {
                        ctx = new InitialContext();
                    } else {
                        try {
                            ctx = new InitialContext(this.initialContextProperties);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Created an initial context with the initialContextProperties, providerURL = " + (String)this.initialContextProperties.get("java.naming.provider.url") + " INITIAL_CONTEXT_FACTORY = " + (String)this.initialContextProperties.get("java.naming.factory.initial")), (Object[])new Object[0]);
                            }
                        }
                        catch (NamingException ne) {
                            ctx = new InitialContext();
                        }
                    }
                    this.home = (EJBHome)PortableRemoteObject.narrow((Object)ctx.lookup(this.homeJNDIName), homeClass);
                }
                catch (NoInitialContextException e) {
                    Properties p = new Properties();
                    p.put("java.naming.factory.initial", "com.ibm.websphere.naming.WsnInitialContextFactory");
                    ctx = new InitialContext(p);
                    this.home = (EJBHome)PortableRemoteObject.narrow((Object)ctx.lookup(this.homeJNDIName), homeClass);
                }
            }
            catch (NamingException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getEJBHome", (Object)e);
                }
                NoSuchObjectException re = new NoSuchObjectException("Could not find home in JNDI");
                re.detail = e;
                throw re;
            }
            catch (ClassNotFoundException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getEJBHome", (Object)e);
                }
                throw new RemoteException("Could not load home interface", e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getEJBHome");
        }
        return this.home;
    }

    private Method findFindByPrimaryKey(Class<?> c) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findFindByPrimaryKey", (Object[])new Object[]{c});
        }
        Method[] methods = c.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals("findByPrimaryKey")) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"findFindByPrimaryKey");
            }
            return methods[i];
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findFindByPrimaryKey: method findByPrimaryKey not found!");
        }
        return null;
    }
}

