/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.persistence;

import com.ibm.ejs.persistence.FinderCollectionIterator;
import com.ibm.ejs.persistence.PortableFinderEnumerator;
import com.ibm.ejs.persistence.RemoteEnumerator;
import com.ibm.ws.ejb.portable.Constants;
import jakarta.ejb.EJBObject;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;

public class PortableFinderCollection
extends AbstractCollection
implements Serializable {
    private static final long serialVersionUID = -4430653083633582029L;
    static final byte[] eyecatcher = Constants.FINDER_COLLECTION_EYE_CATCHER;
    static final short platform = 1;
    static final short versionID = 1;
    private transient PortableFinderEnumerator finderEnumerator;
    private transient boolean greedy = false;
    private transient EJBObject[] elements;
    private transient boolean exhausted;
    private transient RemoteEnumerator vEnum;

    public PortableFinderCollection(EJBObject[] elements) {
        this.greedy = true;
        this.elements = elements;
        this.finderEnumerator = new PortableFinderEnumerator(elements);
    }

    public PortableFinderCollection(EJBObject[] prefetchElements, boolean exhausted, RemoteEnumerator vEnum) {
        this.elements = prefetchElements;
        this.exhausted = exhausted;
        this.vEnum = vEnum;
        this.finderEnumerator = new PortableFinderEnumerator(prefetchElements, exhausted, vEnum);
    }

    @Override
    public Iterator iterator() {
        this.elements = this.finderEnumerator.loadEntireCollection();
        return new FinderCollectionIterator(this.elements);
    }

    @Override
    public int size() {
        return this.finderEnumerator.size();
    }

    @Override
    public boolean contains(Object obj) {
        this.elements = this.finderEnumerator.loadEntireCollection();
        return super.contains(obj);
    }

    @Override
    public boolean containsAll(Collection collection) {
        this.elements = this.finderEnumerator.loadEntireCollection();
        return super.containsAll(collection);
    }

    @Override
    public Object[] toArray() {
        this.elements = this.finderEnumerator.loadEntireCollection();
        return super.toArray();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.write(eyecatcher);
        out.writeShort(1);
        out.writeShort(1);
        out.writeObject(this.finderEnumerator);
        out.writeBoolean(this.greedy);
        out.writeObject(this.elements);
        out.writeBoolean(this.exhausted);
        out.writeObject(this.vEnum);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] ec = new byte[4];
        int bytesRead = 0;
        for (int offset = 0; offset < 4; offset += bytesRead) {
            bytesRead = in.read(ec, offset, 4 - offset);
            if (bytesRead != -1) continue;
            throw new IOException("end of input stream while reading eye catcher");
        }
        for (int i = 0; i < eyecatcher.length; ++i) {
            if (eyecatcher[i] == ec[i]) continue;
            throw new IOException();
        }
        in.readShort();
        in.readShort();
        this.finderEnumerator = (PortableFinderEnumerator)in.readObject();
        this.greedy = in.readBoolean();
        this.elements = (EJBObject[])in.readObject();
        this.exhausted = in.readBoolean();
        this.vEnum = (RemoteEnumerator)in.readObject();
    }
}

