/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.legacyapi;

import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.ValueAtPercentile;
import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.microprofile.metrics.Snapshot;

public class SnapshotAdapter
extends Snapshot {
    private HistogramSnapshot histogramSnapshot;

    public SnapshotAdapter(HistogramSnapshot histogramSnapshot) {
        this.histogramSnapshot = histogramSnapshot;
    }

    public long size() {
        return this.histogramSnapshot.count();
    }

    public double getMax() {
        return this.histogramSnapshot.max();
    }

    public double getMean() {
        return this.histogramSnapshot.mean();
    }

    public Snapshot.PercentileValue[] percentileValues() {
        ValueAtPercentile[] valueAtPercentiles = this.histogramSnapshot.percentileValues();
        Snapshot.PercentileValue[] percentileValues = new Snapshot.PercentileValue[valueAtPercentiles.length];
        for (int i = 0; i < valueAtPercentiles.length; ++i) {
            percentileValues[i] = new Snapshot.PercentileValue(valueAtPercentiles[i].percentile(), valueAtPercentiles[i].value());
        }
        return percentileValues;
    }

    public void dump(OutputStream output) {
        this.histogramSnapshot.outputSummary(new PrintStream(output), 1.0);
    }
}

