/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer31.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.container.service.annocache.AnnotationsBetaHelper;
import com.ibm.ws.container.service.annotations.WebAnnotations;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.info.ClassInfo;
import com.ibm.wsspi.anno.info.InfoStore;
import com.ibm.wsspi.anno.info.InfoStoreException;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import com.ibm.wsspi.webcontainer.collaborator.WebAppInjectionClassListCollaborator;
import com.ibm.wsspi.webcontainer.filter.IFilterConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.annotation.WebListener;
import jakarta.servlet.annotation.WebServlet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.osgi.service.component.annotations.Component;

@Component(name="com.ibm.ws.webcontainer31.util.ServletInjectionClassListCollaborator", service={WebAppInjectionClassListCollaborator.class}, immediate=true, property={"service.vendor=IBM"})
public class ServletInjectionClassListCollaborator
implements WebAppInjectionClassListCollaborator {
    private static final TraceComponent tc = Tr.register(ServletInjectionClassListCollaborator.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer31.resources.Messages");
    private static final String CLASS_NAME = ServletInjectionClassListCollaborator.class.getName();
    private final String[] SERVLET_CLASS_NAMES = new String[]{"jakarta.servlet.http.HttpServlet"};
    private final String[] FILTER_CLASS_NAMES = new String[]{"jakarta.servlet.Filter"};
    private final String[] LISTENER_CLASS_NAMES = new String[]{"jakarta.servlet.ServletContextListener", "jakarta.servlet.ServletContextAttributeListener", "jakarta.servlet.ServletRequestListener", "jakarta.servlet.ServletRequestAttributeListener", "jakarta.servlet.http.HttpUpgradeHandler", "jakarta.servlet.http.HttpSessionListener", "jakarta.servlet.http.HttpSessionAttributeListener", "jakarta.servlet.http.HttpSessionIdListener", "jakarta.servlet.AsyncListener"};
    private static final boolean IS_INTERFACE = true;
    private static final boolean IS_ABSTRACT_CLASS = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getInjectionClasses(Container moduleContainer) {
        DeferredInfoStore deferredInfoStore;
        AnnotationTargets_Targets annotationTargets;
        WebAppConfig webDD;
        ArrayList<String> injectionClassNames;
        String methodName;
        block35: {
            methodName = "getInjectionClasses";
            injectionClassNames = new ArrayList<String>();
            try {
                webDD = (WebAppConfig)moduleContainer.adapt(WebAppConfig.class);
            }
            catch (UnableToAdaptException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.warning((TraceComponent)tc, (String)CLASS_NAME, (Object[])new Object[]{"Failed to obtain WebAppConfig", e});
                }
                return injectionClassNames;
            }
            if (webDD == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.warning((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"WebAppConfig was null"});
                }
                return injectionClassNames;
            }
            annotationTargets = null;
            deferredInfoStore = null;
            try {
                WebAnnotations webAnnotations = AnnotationsBetaHelper.getWebAnnotations((Container)moduleContainer);
                if (!webDD.isMetadataComplete()) {
                    annotationTargets = webAnnotations.getAnnotationTargets();
                } else {
                    deferredInfoStore = new DeferredInfoStore(webAnnotations);
                }
            }
            catch (UnableToAdaptException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block35;
                Tr.warning((TraceComponent)tc, (String)CLASS_NAME, (Object[])new Object[]{"Failed to obtain web annotations", e});
            }
        }
        try {
            Collection<String> servletClassNames = new ArrayList<String>();
            Iterator servletsDD = webDD.getServletInfos();
            while (servletsDD.hasNext()) {
                String servletClassName;
                IServletConfig servletDD = (IServletConfig)servletsDD.next();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Servlet in web.xml: " + servletDD), (Object[])new Object[0]);
                }
                if ((servletClassName = servletDD.getClassName()) == null) continue;
                servletClassNames.add(servletClassName);
            }
            if (annotationTargets != null) {
                servletClassNames.addAll(this.getAnnotatedClasses(annotationTargets, WebServlet.class.getName(), servletClassNames));
            }
            if (!servletClassNames.isEmpty()) {
                InfoStore infoStore;
                if (annotationTargets != null) {
                    servletClassNames = this.selectValid(annotationTargets, this.SERVLET_CLASS_NAMES, false, servletClassNames);
                } else if (deferredInfoStore != null && (infoStore = deferredInfoStore.get()) != null) {
                    servletClassNames = this.selectValid(infoStore, this.SERVLET_CLASS_NAMES, false, servletClassNames);
                }
                injectionClassNames.addAll(servletClassNames);
            }
            Collection<String> filterClassNames = new ArrayList<String>();
            Iterator filtersDD = webDD.getFilterInfos();
            while (filtersDD.hasNext()) {
                Object filterClassName;
                IFilterConfig filterDD = (IFilterConfig)filtersDD.next();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Filter in web.xml: " + filterDD), (Object[])new Object[0]);
                }
                if ((filterClassName = filterDD.getClassName()) == null) continue;
                filterClassNames.add((String)filterClassName);
            }
            if (annotationTargets != null) {
                filterClassNames.addAll(this.getAnnotatedClasses(annotationTargets, WebFilter.class.getName(), filterClassNames));
            }
            if (!filterClassNames.isEmpty()) {
                InfoStore infoStore;
                if (annotationTargets != null) {
                    filterClassNames = this.selectValid(annotationTargets, this.FILTER_CLASS_NAMES, true, filterClassNames);
                } else if (deferredInfoStore != null && (infoStore = deferredInfoStore.get()) != null) {
                    filterClassNames = this.selectValid(infoStore, this.FILTER_CLASS_NAMES, true, filterClassNames);
                }
                injectionClassNames.addAll(filterClassNames);
            }
            Collection<String> listenerClassNames = new ArrayList<String>();
            for (Object listenerClassName : webDD.getListeners()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Listener in web.xml: " + listenerClassName), (Object[])new Object[0]);
                }
                listenerClassNames.add((String)listenerClassName);
            }
            if (annotationTargets != null) {
                listenerClassNames.addAll(this.getAnnotatedClasses(annotationTargets, WebListener.class.getName(), listenerClassNames));
            }
            if (!listenerClassNames.isEmpty()) {
                InfoStore infoStore;
                if (annotationTargets != null) {
                    listenerClassNames = this.selectValid(annotationTargets, this.LISTENER_CLASS_NAMES, true, listenerClassNames);
                } else if (deferredInfoStore != null && (infoStore = deferredInfoStore.get()) != null) {
                    listenerClassNames = this.selectValid(infoStore, this.LISTENER_CLASS_NAMES, true, listenerClassNames);
                }
                injectionClassNames.addAll(listenerClassNames);
            }
        }
        finally {
            if (deferredInfoStore != null) {
                deferredInfoStore.clear();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
        return injectionClassNames;
    }

    private Collection<String> getAnnotatedClasses(AnnotationTargets_Targets annotationTargets, String annotationClassName, Collection<String> knownClassNames) {
        ArrayList<String> annotatedClassNames = new ArrayList<String>();
        for (String annotatedClassName : annotationTargets.getAnnotatedClasses(annotationClassName)) {
            if (knownClassNames.contains(annotatedClassName)) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Descriptor class " + annotatedClassName + " is redundantly annotated with " + annotationClassName), (Object[])new Object[0]);
                continue;
            }
            annotatedClassNames.add(annotatedClassName);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Class " + annotatedClassName + " is annotated with " + annotationClassName), (Object[])new Object[0]);
        }
        return annotatedClassNames;
    }

    private Collection<String> selectValid(AnnotationTargets_Targets annotationTargets, String[] requiredClassNames, boolean isInterface, Collection<String> candidateClassNames) {
        HashSet<String> selectedClassNames = new HashSet<String>(candidateClassNames.size());
        for (String requiredClassName : requiredClassNames) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (isInterface) {
                    Tr.debug((TraceComponent)tc, (String)("Searching for implementors of " + requiredClassName), (Object[])new Object[0]);
                } else {
                    Tr.debug((TraceComponent)tc, (String)("Searching for extenders of " + requiredClassName), (Object[])new Object[0]);
                }
            }
            Set validClassNames = isInterface ? annotationTargets.getAllImplementorsOf(requiredClassName) : annotationTargets.getSubclassNames(requiredClassName);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                for (String validClassName : validClassNames) {
                    if (isInterface) {
                        Tr.debug((TraceComponent)tc, (String)("Found implementor of " + requiredClassName + " : " + validClassName), (Object[])new Object[0]);
                        continue;
                    }
                    Tr.debug((TraceComponent)tc, (String)("Found extender of " + requiredClassName + " : " + validClassName), (Object[])new Object[0]);
                }
            }
            for (String candidateClassName : candidateClassNames) {
                if (!validClassNames.contains(candidateClassName)) continue;
                selectedClassNames.add(candidateClassName);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                if (isInterface) {
                    Tr.debug((TraceComponent)tc, (String)("Found valid implementor of " + requiredClassName + " : " + candidateClassName), (Object[])new Object[0]);
                    continue;
                }
                Tr.debug((TraceComponent)tc, (String)("Found valid extender of " + requiredClassName + " : " + candidateClassName), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && selectedClassNames.size() != candidateClassNames.size()) {
            for (String candidateClassName : candidateClassNames) {
                if (selectedClassNames.contains(candidateClassName)) continue;
                if (isInterface) {
                    Tr.debug((TraceComponent)tc, (String)("Candidate " + candidateClassName + " does not implement any of the required interfaces"), (Object[])new Object[0]);
                    continue;
                }
                Tr.debug((TraceComponent)tc, (String)("Candidate " + candidateClassName + " does not extend any of the required interfaces"), (Object[])new Object[0]);
            }
        }
        return selectedClassNames;
    }

    private Collection<String> selectValid(InfoStore infoStore, String[] requiredClassNames, boolean isInterface, Collection<String> candidateClassNames) {
        HashSet<String> selectedClassNames = new HashSet<String>(candidateClassNames.size());
        for (String candidateClassName : candidateClassNames) {
            ClassInfo classInfo = infoStore.getDelayableClassInfo(candidateClassName);
            if (classInfo == null) {
                Tr.warning((TraceComponent)tc, (String)("Failed to load web module injection target class " + candidateClassName), (Object[])new Object[0]);
                continue;
            }
            boolean didAdd = false;
            for (String requiredClassName : requiredClassNames) {
                if (classInfo.isInstanceOf(requiredClassName)) {
                    selectedClassNames.add(candidateClassName);
                    didAdd = true;
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)("Matched  " + requiredClassName + " against " + requiredClassName), (Object[])new Object[0]);
                    break;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("No match of   " + requiredClassName + " against " + requiredClassName), (Object[])new Object[0]);
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled() || didAdd) continue;
            Tr.debug((TraceComponent)tc, (String)("Candidate " + candidateClassName + " matched none of the required classes"), (Object[])new Object[0]);
        }
        return selectedClassNames;
    }

    private static class DeferredInfoStore {
        private final WebAnnotations webAnnotations;
        private boolean didInit;
        private InfoStore infoStore;

        public DeferredInfoStore(WebAnnotations webAnnotations) {
            this.webAnnotations = webAnnotations;
            this.didInit = false;
            this.infoStore = null;
        }

        public InfoStore get() {
            if (!this.didInit) {
                this.didInit = true;
                try {
                    this.infoStore = this.webAnnotations.getInfoStore();
                }
                catch (UnableToAdaptException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.warning((TraceComponent)tc, (String)CLASS_NAME, (Object[])new Object[]{"Failed to obtain web info store", e});
                    }
                    this.infoStore = null;
                }
                if (this.infoStore != null) {
                    try {
                        this.infoStore.open();
                    }
                    catch (InfoStoreException e) {
                        this.infoStore = null;
                        Tr.warning((TraceComponent)tc, (String)CLASS_NAME, (Object[])new Object[]{"Failed to open web info store", e});
                    }
                }
            }
            return this.infoStore;
        }

        public void clear() {
            if (!this.didInit) {
                return;
            }
            this.didInit = false;
            if (this.infoStore != null) {
                InfoStore useInfoStore = this.infoStore;
                this.infoStore = null;
                try {
                    useInfoStore.close();
                }
                catch (InfoStoreException e) {
                    Tr.warning((TraceComponent)tc, (String)CLASS_NAME, (Object[])new Object[]{"Failed to close web info store", e});
                }
            }
        }
    }
}

