/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import com.ibm.wsspi.webcontainer.WCCustomProperties;
import jakarta.el.ELContext;
import jakarta.el.ELContextEvent;
import jakarta.el.ELContextListener;
import jakarta.el.ELResolver;
import jakarta.el.ExpressionFactory;
import jakarta.servlet.ServletContext;
import jakarta.servlet.jsp.JspApplicationContext;
import jakarta.servlet.jsp.JspContext;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.jasper.el.ELContextImpl;
import org.apache.jasper.el.JasperELResolver;

public class JspApplicationContextImpl
implements JspApplicationContext {
    private static final String KEY = JspApplicationContextImpl.class.getName();
    protected static final Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    protected final ExpressionFactory expressionFactory;
    private static final ExpressionFactory staticExpressionFactory = ExpressionFactory.newInstance();
    private final List<ELContextListener> contextListeners = new ArrayList<ELContextListener>();
    private final List<ELResolver> resolvers = new ArrayList<ELResolver>();
    private boolean instantiated = false;
    protected boolean listenersContextInitialized = false;
    private ELResolver resolver;

    public JspApplicationContextImpl() {
        if (!WCCustomProperties.ALLOW_EXPRESSION_FACTORY_PER_APP) {
            logger.logp(Level.FINE, KEY, "JspApplicationContextImpl", "Setting expressionFactory to the expression factory of the first loaded application.");
            this.expressionFactory = staticExpressionFactory;
        } else {
            logger.logp(Level.FINE, KEY, "JspApplicationContextImpl", "Setting expressionFactory to a new instance of ExpressionFactory.");
            this.expressionFactory = ExpressionFactory.newInstance();
        }
    }

    public void addELContextListener(ELContextListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("ELConextListener was null");
        }
        this.contextListeners.add(listener);
    }

    public static JspApplicationContextImpl getInstance(ServletContext context) {
        if (context == null) {
            throw new IllegalArgumentException("ServletContext was null");
        }
        JspApplicationContextImpl impl = (JspApplicationContextImpl)context.getAttribute(KEY);
        if (impl == null) {
            impl = new JspApplicationContextImpl();
            context.setAttribute(KEY, (Object)impl);
        }
        if (WCCustomProperties.THROW_EXCEPTION_FOR_ADDELRESOLVER && context.getAttribute("com.ibm.ws.jsp.servletContextListeners.contextInitialized") != null) {
            impl.listenersContextInitialized = true;
        }
        return impl;
    }

    public ELContextImpl createELContext(JspContext context) {
        if (context == null) {
            throw new IllegalArgumentException("JspContext was null");
        }
        ELResolver r = this.createELResolver();
        ELContextImpl ctx = new ELContextImpl(r);
        ctx.putContext(JspContext.class, context);
        ELContextEvent event = new ELContextEvent((ELContext)ctx);
        for (int i = 0; i < this.contextListeners.size(); ++i) {
            this.contextListeners.get(i).contextCreated(event);
        }
        return ctx;
    }

    private ELResolver createELResolver() {
        this.instantiated = true;
        if (this.resolver == null) {
            JasperELResolver r = new JasperELResolver(this.resolvers, this.expressionFactory.getStreamELResolver());
            this.resolver = r;
        }
        return this.resolver;
    }

    public void addELResolver(ELResolver resolver) throws IllegalStateException {
        if (resolver == null) {
            throw new IllegalArgumentException("ELResolver was null");
        }
        if (this.instantiated || this.listenersContextInitialized) {
            throw new IllegalStateException("cannot call addELResolver after the first request has been made");
        }
        this.resolvers.add(resolver);
    }

    public ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }
}

