/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.finder;

import com.ibm.ejs.container.finder.CollectionCannotBeFurtherAccessedException;
import com.ibm.ejs.container.finder.FinderResultClientIterator;
import com.ibm.ejs.container.finder.FinderResultServer;
import com.ibm.ws.ejb.portable.Constants;
import jakarta.ejb.FinderException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class FinderResultClientCollection
extends AbstractCollection
implements Serializable,
Set {
    static final byte[] eyecatcher = Constants.FINDER_RESULT_CLIENT_COLLECTION_EYE_CATCHER;
    static final short platform = 1;
    static final short versionID = 1;
    private static final long serialVersionUID = 96031000330697159L;
    public transient FinderResultServer server;
    public transient Vector allWrappers;
    private transient boolean hasAllWrappers;
    public transient int chunkSize;

    public FinderResultClientCollection(Vector wrappers) throws FinderException, RemoteException {
        this.chunkSize = Integer.MAX_VALUE;
        this.allWrappers = wrappers;
    }

    public FinderResultClientCollection(FinderResultServer serverImpl, int chunkSize) throws FinderException, RemoteException {
        this.chunkSize = chunkSize;
        this.server = serverImpl;
        this.allWrappers = serverImpl.getNextWrapperCollection(0, chunkSize);
        try {
            Class<?> serverImplClass = Class.forName("com.ibm.ejs.container.finder.FinderResultServerImpl");
            Method m = serverImplClass.getMethod("exhaustedCollection", null);
            boolean hasExhaustedCollection = (Boolean)m.invoke((Object)serverImpl, null);
            if (hasExhaustedCollection) {
                this.server = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public int size() {
        try {
            return this.server != null && !this.hasAllWrappers ? this.server.size() : this.allWrappers.size();
        }
        catch (Throwable t) {
            throw new CollectionCannotBeFurtherAccessedException("Caught exception in size() method call:" + t.getMessage());
        }
    }

    @Override
    public Iterator iterator() {
        return new FinderResultClientIterator(this.server, this.allWrappers, this, this.chunkSize);
    }

    void allWrappersCached() {
        this.hasAllWrappers = true;
    }

    boolean hasAllWrappers() {
        return this.hasAllWrappers;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.write(eyecatcher);
        out.writeShort(1);
        out.writeShort(1);
        out.writeObject(this.server);
        out.writeObject(this.allWrappers);
        out.writeInt(this.chunkSize);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] ec = new byte[4];
        int bytesRead = 0;
        for (int offset = 0; offset < 4; offset += bytesRead) {
            bytesRead = in.read(ec, offset, 4 - offset);
            if (bytesRead != -1) continue;
            throw new IOException("end of input stream while reading eye catcher");
        }
        for (int i = 0; i < eyecatcher.length; ++i) {
            if (eyecatcher[i] == ec[i]) continue;
            String eyeCatcherString = new String(ec);
            throw new IOException("Invalid eye catcher '" + eyeCatcherString + "' in FinderResultClientCollection input stream");
        }
        in.readShort();
        in.readShort();
        this.server = (FinderResultServer)in.readObject();
        this.allWrappers = (Vector)in.readObject();
        this.chunkSize = in.readInt();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " : collection increment= " + this.chunkSize + " : local wrapper collection size= " + this.allWrappers.size();
    }
}

