/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rt.security.utils;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.resource.ResourceManager;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public final class SecurityUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(SecurityUtils.class);
    private static boolean doDebug = LOG.isLoggable(Level.FINE);
    static final long serialVersionUID = 9103330478092038294L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private SecurityUtils() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.rt.security.utils.SecurityUtils", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.rt.security.utils.SecurityUtils", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static CallbackHandler getCallbackHandler(Object o) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.rt.security.utils.SecurityUtils", "getCallbackHandler", new Object[]{o});
        }
        CallbackHandler handler = null;
        if (o instanceof CallbackHandler) {
            if (doDebug) {
                LOG.fine("CallbackHandler type object is in use!");
            }
            handler = (CallbackHandler)o;
        } else if (o instanceof String) {
            if (doDebug) {
                LOG.fine("cbh is a string, need to load the class!");
            }
            handler = (CallbackHandler)ClassLoaderUtils.loadClass((String)((String)o), SecurityUtils.class).newInstance();
        }
        CallbackHandler callbackHandler = handler;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            callbackHandler = callbackHandler;
            LOG.exiting("org.apache.cxf.rt.security.utils.SecurityUtils", "getCallbackHandler", callbackHandler);
        }
        return callbackHandler;
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static URL getConfigFileURL(Message message, String configFileKey, String configFileDefault) {
        LOG.entering("SecurityUtils.getConfigFileURL", "message, configFileKey, configFileDefault");
        Object o = message.getContextualProperty(configFileKey);
        if (o == null) {
            o = configFileDefault;
        }
        LOG.exiting("SecurityUtils.getConfigFileURL", "message, configFileKey, configFileDefault");
        return SecurityUtils.loadResource(message, o);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static URL loadResource(Object o) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.rt.security.utils.SecurityUtils", "loadResource", new Object[]{o});
        }
        URL uRL = SecurityUtils.loadResource((Message)null, o);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            uRL = uRL;
            LOG.exiting("org.apache.cxf.rt.security.utils.SecurityUtils", "loadResource", uRL);
        }
        return uRL;
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static URL loadResource(Message message, Object o) {
        LOG.entering("SecurityUtils.loadResource", "message, Object");
        Message msg = message;
        if (msg == null) {
            msg = PhaseInterceptorChain.getCurrentMessage();
        }
        ResourceManager manager = null;
        if (msg != null && msg.getExchange() != null && msg.getExchange().getBus() != null) {
            manager = (ResourceManager)msg.getExchange().getBus().getExtension(ResourceManager.class);
        }
        LOG.exiting("SecurityUtils.loadResource", "Message, Object");
        return SecurityUtils.loadResource(manager, o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static URL loadResource(ResourceManager manager, Object o) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.rt.security.utils.SecurityUtils", "loadResource", new Object[]{manager, o});
        }
        if (o instanceof String) {
            URL uRL;
            ClassLoaderUtils.ClassLoaderHolder orig;
            block22: {
                URL url = ClassLoaderUtils.getResource((String)((String)o), SecurityUtils.class);
                if (url != null) {
                    URL uRL2 = url;
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        uRL2 = uRL2;
                        LOG.exiting("org.apache.cxf.rt.security.utils.SecurityUtils", "loadResource", uRL2);
                    }
                    return uRL2;
                }
                orig = null;
                if (manager != null) {
                    ClassLoader loader = (ClassLoader)manager.resolveResource((String)o, ClassLoader.class);
                    if (loader != null) {
                        orig = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)loader);
                    }
                    url = (URL)manager.resolveResource((String)o, URL.class);
                }
                if (url == null) {
                    try {
                        url = new URL((String)o);
                    }
                    catch (IOException loader) {
                        // empty catch block
                    }
                }
                if (url == null) {
                    try {
                        URI propResourceUri = URI.create((String)o);
                        if (propResourceUri.getScheme() != null) {
                            url = propResourceUri.toURL();
                        } else {
                            File f = new File(propResourceUri.toString());
                            if (f.exists()) {
                                url = f.toURI().toURL();
                            }
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                URL uRL3 = url;
                uRL = uRL3;
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block22;
                uRL = uRL;
                LOG.exiting("org.apache.cxf.rt.security.utils.SecurityUtils", "loadResource", uRL);
            }
            return uRL;
            finally {
                if (orig != null) {
                    orig.reset();
                }
            }
        }
        if (o instanceof URL) {
            URL uRL = (URL)o;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                uRL = uRL;
                LOG.exiting("org.apache.cxf.rt.security.utils.SecurityUtils", "loadResource", uRL);
            }
            return uRL;
        }
        URL uRL = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            uRL = uRL;
            LOG.exiting("org.apache.cxf.rt.security.utils.SecurityUtils", "loadResource", uRL);
        }
        return uRL;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Properties loadProperties(Object o) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.rt.security.utils.SecurityUtils", "loadProperties", new Object[]{o});
        }
        Properties properties = SecurityUtils.loadProperties(null, o);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            properties = properties;
            LOG.exiting("org.apache.cxf.rt.security.utils.SecurityUtils", "loadProperties", properties);
        }
        return properties;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Properties loadProperties(ResourceManager manager, Object o) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.rt.security.utils.SecurityUtils", "loadProperties", new Object[]{manager, o});
        }
        if (o instanceof Properties) {
            Properties properties = (Properties)o;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                properties = properties;
                LOG.exiting("org.apache.cxf.rt.security.utils.SecurityUtils", "loadProperties", properties);
            }
            return properties;
        }
        URL url = null;
        if (o instanceof String) {
            url = SecurityUtils.loadResource(manager, o);
        } else if (o instanceof URL) {
            url = (URL)o;
        }
        if (url != null) {
            Properties properties = new Properties();
            try {
                InputStream ins = url.openStream();
                properties.load(ins);
                ins.close();
            }
            catch (IOException e) {
                LOG.fine(e.getMessage());
                properties = null;
            }
            Properties properties2 = properties;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                properties2 = properties2;
                LOG.exiting("org.apache.cxf.rt.security.utils.SecurityUtils", "loadProperties", properties2);
            }
            return properties2;
        }
        Properties properties = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            properties = properties;
            LOG.exiting("org.apache.cxf.rt.security.utils.SecurityUtils", "loadProperties", properties);
        }
        return properties;
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Object getSecurityPropertyValue(String property, Message message) {
        LOG.entering("SecurityUtils.getSecurityPropertyValue", property);
        Object value = message.getContextualProperty(property);
        if (value != null) {
            return value;
        }
        LOG.exiting("SecurityUtils.getSecurityPropertyValue", "String, Message");
        return message.getContextualProperty("ws-" + property);
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean getSecurityPropertyBoolean(String property, Message message, boolean defaultValue) {
        LOG.entering("SecurityUtils.getSecurityPropertyBoolean", property);
        Object value = SecurityUtils.getSecurityPropertyValue(property, message);
        if (value != null) {
            LOG.exiting("SecurityUtils.getSecurityPropertyBoolean", "String, Message, boolean");
            return PropertyUtils.isTrue((Object)value);
        }
        LOG.exiting("SecurityUtils.getSecurityPropertyBoolean", "String, Message, boolean");
        return defaultValue;
    }
}

