/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.cache;

import java.io.File;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Map;
import org.apache.wss4j.common.cache.EHCacheExpiry;
import org.apache.wss4j.common.cache.EHCacheValue;
import org.apache.wss4j.common.cache.ReplayCache;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.CachePersistenceException;
import org.ehcache.PersistentCacheManager;
import org.ehcache.Status;
import org.ehcache.config.Builder;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.expiry.ExpiryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EHCacheReplayCache
implements ReplayCache {
    private static final Logger LOG = LoggerFactory.getLogger(EHCacheReplayCache.class);
    private Cache<String, EHCacheValue> cache;
    private CacheManager cacheManager;
    private final String key;
    private final Path diskstorePath;
    private final boolean persistent;

    public EHCacheReplayCache(String key) throws WSSecurityException {
        this(key, null);
    }

    public EHCacheReplayCache(String key, Path diskstorePath) throws WSSecurityException {
        this(key, diskstorePath, 50L, 10000L, false);
    }

    public EHCacheReplayCache(String key, Path diskstorePath, long diskSize, long heapEntries, boolean persistent) throws WSSecurityException {
        this.key = key;
        this.diskstorePath = diskstorePath;
        this.persistent = persistent;
        if (key == null || persistent && diskstorePath == null) {
            throw new NullPointerException();
        }
        if (diskstorePath != null && (diskSize < 5L || diskSize > 10000L)) {
            throw new IllegalArgumentException("The diskSize parameter must be between 5 and 10000 (megabytes)");
        }
        if (heapEntries < 100L) {
            throw new IllegalArgumentException("The heapEntries parameter must be greater than 100 (entries)");
        }
        ResourcePoolsBuilder resourcePoolsBuilder = null;
        CacheConfigurationBuilder configurationBuilder = null;
        try {
            resourcePoolsBuilder = ResourcePoolsBuilder.newResourcePoolsBuilder().heap(heapEntries, (ResourceUnit)EntryUnit.ENTRIES);
            if (diskstorePath != null) {
                resourcePoolsBuilder = resourcePoolsBuilder.disk(diskSize, MemoryUnit.MB, persistent);
            }
            configurationBuilder = CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, EHCacheValue.class, (Builder)resourcePoolsBuilder).withExpiry((ExpiryPolicy)new EHCacheExpiry());
            this.cacheManager = diskstorePath != null ? CacheManagerBuilder.newCacheManagerBuilder().with(CacheManagerBuilder.persistence((File)diskstorePath.toFile())).withCache(key, (Builder)configurationBuilder).build() : CacheManagerBuilder.newCacheManagerBuilder().withCache(key, (Builder)configurationBuilder).build();
            this.cacheManager.init();
            this.cache = this.cacheManager.getCache(key, String.class, EHCacheValue.class);
        }
        catch (Exception ex) {
            LOG.debug("Error configuring EHCacheReplayCache (will try again without disk params) : " + ex.getMessage());
            try {
                resourcePoolsBuilder = ResourcePoolsBuilder.newResourcePoolsBuilder().heap(heapEntries, (ResourceUnit)EntryUnit.ENTRIES);
                configurationBuilder = CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, EHCacheValue.class, (Builder)resourcePoolsBuilder).withExpiry((ExpiryPolicy)new EHCacheExpiry());
                this.cacheManager = CacheManagerBuilder.newCacheManagerBuilder().withCache(key, (Builder)configurationBuilder).build();
                this.cacheManager.init();
                this.cache = this.cacheManager.getCache(key, String.class, EHCacheValue.class);
            }
            catch (Exception ex2) {
                LOG.error("Error configuring EHCacheReplayCache " + ex2.getMessage());
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, ex2, "replayCacheError");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EHCacheReplayCache(String cacheKey, Path diskstorePath, Map oldconfig) throws WSSecurityException {
        this.key = cacheKey;
        this.diskstorePath = diskstorePath;
        int diskElements = (Integer)oldconfig.get("getMaxElementsOnDisk");
        long heapEntries = (Long)oldconfig.get("getMaxEntriesLocalHeap");
        this.persistent = (Boolean)oldconfig.get("isDiskPersistent");
        boolean eternal = false;
        ExpiryPolicy expiry3 = null;
        EHCacheExpiry expiry = new EHCacheExpiry();
        expiry.setDefaultTTL((Long)oldconfig.get("getTimeToLiveSeconds"));
        if (this.key == null || this.persistent && diskstorePath == null) {
            throw new NullPointerException();
        }
        if (diskstorePath != null && (diskElements < 5000 || diskElements > 10000000)) {
            throw new IllegalArgumentException("The getMaxElementsOnDisk parameter must be between 5 and 10000 (megabytes)");
        }
        if (heapEntries < 100L) {
            throw new IllegalArgumentException("The getMaxEntriesLocalHeap parameter must be greater than 100 (entries)");
        }
        ResourcePoolsBuilder resourcePoolsBuilder = null;
        CacheConfigurationBuilder configurationBuilder = null;
        try {
            resourcePoolsBuilder = ResourcePoolsBuilder.newResourcePoolsBuilder().heap(heapEntries, (ResourceUnit)EntryUnit.ENTRIES);
            if (diskstorePath != null) {
                resourcePoolsBuilder = resourcePoolsBuilder.disk((long)diskElements, MemoryUnit.MB, this.persistent);
            }
            configurationBuilder = eternal ? CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, EHCacheValue.class, (Builder)resourcePoolsBuilder).withExpiry(expiry3) : CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, EHCacheValue.class, (Builder)resourcePoolsBuilder).withExpiry((ExpiryPolicy)expiry);
            this.cacheManager = diskstorePath != null ? CacheManagerBuilder.newCacheManagerBuilder().with(CacheManagerBuilder.persistence((File)diskstorePath.toFile())).withCache(this.key, (Builder)configurationBuilder).build() : CacheManagerBuilder.newCacheManagerBuilder().withCache(this.key, (Builder)configurationBuilder).build();
            this.cacheManager.init();
            this.cache = this.cacheManager.getCache(this.key, String.class, EHCacheValue.class);
        }
        catch (Exception ex) {
            resourcePoolsBuilder = ResourcePoolsBuilder.newResourcePoolsBuilder().heap(heapEntries, (ResourceUnit)EntryUnit.ENTRIES);
            configurationBuilder = eternal ? CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, EHCacheValue.class, (Builder)resourcePoolsBuilder).withExpiry(expiry3) : CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, EHCacheValue.class, (Builder)resourcePoolsBuilder).withExpiry((ExpiryPolicy)expiry);
            this.cacheManager = CacheManagerBuilder.newCacheManagerBuilder().withCache(this.key, (Builder)configurationBuilder).build();
            this.cacheManager.init();
            this.cache = this.cacheManager.getCache(this.key, String.class, EHCacheValue.class);
        }
    }

    @Override
    public void add(String identifier) {
        this.add(identifier, null);
    }

    @Override
    public void add(String identifier, Instant expiry) {
        if (identifier == null || "".equals(identifier)) {
            return;
        }
        this.cache.put((Object)identifier, (Object)new EHCacheValue(identifier, expiry));
    }

    @Override
    public boolean contains(String identifier) {
        if (this.cache == null) {
            return false;
        }
        EHCacheValue element = (EHCacheValue)this.cache.get((Object)identifier);
        return element != null;
    }

    EHCacheValue get(String identifier) {
        return (EHCacheValue)this.cache.get((Object)identifier);
    }

    @Override
    public synchronized void close() {
        if (this.cacheManager.getStatus() == Status.AVAILABLE) {
            this.cacheManager.removeCache(this.key);
            this.cacheManager.close();
            if (!this.persistent && this.cacheManager instanceof PersistentCacheManager) {
                File file;
                try {
                    ((PersistentCacheManager)this.cacheManager).destroy();
                }
                catch (CachePersistenceException e) {
                    LOG.debug("Error in shutting down persistent cache", (Throwable)e);
                }
                if (this.diskstorePath != null && (file = this.diskstorePath.toFile()).exists() && file.canWrite()) {
                    file.delete();
                }
            }
        }
    }

    public void initComplete() {
    }

    public void preShutdown() {
        this.close();
    }

    public void postShutdown() {
        this.close();
    }
}

