/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.mbean.internal;

import com.ibm.websphere.persistence.mbean.DDLGenerationMBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TrConfigurator;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import com.ibm.wsspi.kernel.service.utils.ServiceAndServiceReferencePair;
import com.ibm.wsspi.logging.TextFileOutputStreamFactory;
import com.ibm.wsspi.persistence.DDLGenerationParticipant;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.DynamicMBean;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={DDLGenerationMBean.class, DynamicMBean.class}, immediate=true, property={"service.vendor=IBM", "jmx.objectname=WebSphere:feature=persistence,type=DDLGenerationMBean,name=DDLGenerationMBean"})
public class DDLGenerationMBeanImpl
extends StandardMBean
implements DDLGenerationMBean {
    private static final String OUTPUT_DIR;
    private static final String KEY_GENERATOR = "generator";
    private final ConcurrentServiceReferenceSet<DDLGenerationParticipant> generators = new ConcurrentServiceReferenceSet("generator");
    private final AtomicReference<WsLocationAdmin> locationService = new AtomicReference();
    static final long serialVersionUID = 164048722294698089L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public DDLGenerationMBeanImpl() throws NotCompliantMBeanException {
        super(DDLGenerationMBean.class);
    }

    @Reference(name="generator", service=DDLGenerationParticipant.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected void setGenerator(ServiceReference<DDLGenerationParticipant> ref) {
        this.generators.addReference(ref);
    }

    protected void unsetGenerator(ServiceReference<DDLGenerationParticipant> ref) {
        this.generators.removeReference(ref);
    }

    @Reference(name="locationService")
    protected void setLocationService(WsLocationAdmin locationService) {
        this.locationService.set(locationService);
    }

    protected void unsetLocationService(WsLocationAdmin locationService) {
        this.locationService.set(null);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.generators.activate(cc);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.generators.deactivate(cc);
    }

    @Override
    public synchronized Map<String, Serializable> generateDDL() {
        HashMap<String, Serializable> returnMap = new HashMap<String, Serializable>();
        WsResource ddlOutputDirectory = this.locationService.get().resolveResource(OUTPUT_DIR);
        if (!ddlOutputDirectory.exists()) {
            ddlOutputDirectory.create();
        }
        try {
            returnMap.put("output.directory", (Serializable)((Object)ddlOutputDirectory.asFile().getCanonicalPath()));
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.persistence.mbean.internal.DDLGenerationMBeanImpl", (String)"126", (Object)this, (Object[])new Object[0]);
            returnMap.put("output.directory", (Serializable)((Object)OUTPUT_DIR));
        }
        boolean success = true;
        int fileCount = 0;
        HashMap<String, DDLGenerationParticipant> participants = new HashMap<String, DDLGenerationParticipant>();
        Iterator i = this.generators.getServicesWithReferences();
        while (i.hasNext()) {
            String id;
            ServiceAndServiceReferencePair generatorPair = (ServiceAndServiceReferencePair)i.next();
            DDLGenerationParticipant generator = (DDLGenerationParticipant)generatorPair.getService();
            String rawId = generator.getDDLFileName();
            String string = id = rawId != null ? PathUtils.replaceRestrictedCharactersInFileName((String)rawId) : null;
            if (id == null || id.length() == 0) {
                throw new IllegalArgumentException("Service " + generator.toString() + " DDL file name: " + rawId);
            }
            participants.put(id, generator);
        }
        for (Map.Entry entry : participants.entrySet()) {
            String id = (String)entry.getKey();
            DDLGenerationParticipant participant = (DDLGenerationParticipant)entry.getValue();
            WsResource ddlOutputResource = this.locationService.get().resolveResource(OUTPUT_DIR + id + ".ddl");
            if (!ddlOutputResource.exists()) {
                ddlOutputResource.create();
            }
            try {
                TextFileOutputStreamFactory f = TrConfigurator.getFileOutputStreamFactory();
                FileOutputStream os = f.createOutputStream(ddlOutputResource.asFile(), false);
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
                participant.generate((Writer)bw);
                bw.close();
                ++fileCount;
            }
            catch (Throwable f) {
                FFDCFilter.processException((Throwable)f, (String)"com.ibm.ws.persistence.mbean.internal.DDLGenerationMBeanImpl", (String)"183", (Object)this, (Object[])new Object[0]);
                success = false;
            }
        }
        returnMap.put("success", Boolean.valueOf(success));
        returnMap.put("file.count", Integer.valueOf(fileCount));
        return returnMap;
    }

    @Override
    protected final String getDescription(MBeanInfo info) {
        return "Generates DDL for components using the PersistenceService.";
    }

    @Override
    protected final String getDescription(MBeanOperationInfo info) {
        String operationName;
        String description = "Unknown operation";
        if (info != null && (operationName = info.getName()) != null && operationName.equals("generateDDL")) {
            description = "Generates DDL for components using the PersistenceService.";
        }
        return description;
    }

    @Override
    protected final String getParameterName(MBeanOperationInfo opInfo, MBeanParameterInfo parmInfo, int sequence) {
        String operation;
        String name = "Unknown";
        if (opInfo == null || parmInfo == null || sequence < 0 || (operation = opInfo.getName()) == null || operation.equals("generateDDL")) {
            // empty if block
        }
        return name;
    }

    @Override
    protected final String getDescription(MBeanOperationInfo opInfo, MBeanParameterInfo parmInfo, int sequence) {
        String parmName;
        String description = "Unknown";
        if (opInfo == null || parmInfo == null || sequence < 0 || (parmName = this.getParameterName(opInfo, parmInfo, sequence)) != null) {
            // empty if block
        }
        return description;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.persistence.mbean.internal.DDLGenerationMBeanImpl", DDLGenerationMBeanImpl.class, (String)"persistenceService", null);
        OUTPUT_DIR = "${server.output.dir}/ddl" + File.separator;
    }
}

