/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.cdi.validation;

import io.smallrye.graphql.cdi.validation.BeanValidationException;
import io.smallrye.graphql.execution.event.InvokeInfo;
import io.smallrye.graphql.spi.EventingService;
import io.smallrye.graphql.spi.LookupService;
import jakarta.validation.Validation;
import jakarta.validation.ValidatorFactory;
import java.lang.reflect.Method;
import java.util.Set;

public class ValidationService
implements EventingService {
    private static ValidatorFactory VALIDATOR_FACTORY = null;
    private final LookupService lookupService = LookupService.get();

    @Override
    public void beforeInvoke(InvokeInfo invokeInfo) throws Exception {
        Set violations;
        Object declaringObject = invokeInfo.getOperationInstance();
        Method method = invokeInfo.getOperationMethod();
        Object[] arguments = invokeInfo.getOperationTransformedArguments();
        if (VALIDATOR_FACTORY == null) {
            VALIDATOR_FACTORY = this.getValidatorFactory();
        }
        if (!(violations = VALIDATOR_FACTORY.getValidator().forExecutables().validateParameters(declaringObject, method, arguments, new Class[0])).isEmpty()) {
            throw new BeanValidationException(violations, method);
        }
    }

    @Override
    public String getConfigKey() {
        return "smallrye.graphql.validation.enabled";
    }

    private ValidatorFactory getValidatorFactory() {
        try {
            ValidatorFactory validatorFactory = (ValidatorFactory)this.lookupService.getInstance(ValidatorFactory.class);
            return validatorFactory;
        }
        catch (Exception t) {
            return Validation.buildDefaultValidatorFactory();
        }
    }
}

