/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.utils.metagen;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jca.utils.metagen.DeploymentDescriptorParser;
import com.ibm.ws.jca.utils.xml.ra.RaActivationSpec;
import com.ibm.ws.jca.utils.xml.ra.RaAdminObject;
import com.ibm.ws.jca.utils.xml.ra.RaConfigProperty;
import com.ibm.ws.jca.utils.xml.ra.RaConnectionDefinition;
import com.ibm.ws.jca.utils.xml.ra.RaConnector;
import com.ibm.ws.jca.utils.xml.ra.RaInboundResourceAdapter;
import com.ibm.ws.jca.utils.xml.ra.RaMessageAdapter;
import com.ibm.ws.jca.utils.xml.ra.RaMessageListener;
import com.ibm.ws.jca.utils.xml.ra.RaOutboundResourceAdapter;
import com.ibm.ws.jca.utils.xml.ra.RaResourceAdapter;
import com.ibm.ws.jca.utils.xml.wlp.ra.WlpRaActivationSpec;
import com.ibm.ws.jca.utils.xml.wlp.ra.WlpRaAdminObject;
import com.ibm.ws.jca.utils.xml.wlp.ra.WlpRaConfigProperty;
import com.ibm.ws.jca.utils.xml.wlp.ra.WlpRaConnectionDefinition;
import com.ibm.ws.jca.utils.xml.wlp.ra.WlpRaConnector;
import com.ibm.ws.jca.utils.xml.wlp.ra.WlpRaInboundResourceAdapter;
import com.ibm.ws.jca.utils.xml.wlp.ra.WlpRaMessageAdapter;
import com.ibm.ws.jca.utils.xml.wlp.ra.WlpRaMessageListener;
import com.ibm.ws.jca.utils.xml.wlp.ra.WlpRaOutboundResourceAdapter;
import com.ibm.ws.jca.utils.xml.wlp.ra.WlpRaResourceAdapter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.List;
import javax.resource.spi.Activation;
import javax.resource.spi.ConnectionDefinition;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.UnavailableException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class DeploymentDescriptorMerger {
    private static final TraceComponent tc = Tr.register(DeploymentDescriptorParser.class, (String)"rarInstall", (String)"com.ibm.ws.jca.utils.internal.resources.JcaUtilsMessages");
    private static final RA_Widget raWidget = new RA_Widget();
    private static final AO_Widget aoWidget = new AO_Widget();
    private static final CD_Widget cdWidget = new CD_Widget();
    private static final AS_Widget asWidget = new AS_Widget();
    static final long serialVersionUID = 1986459860475316167L;

    private static String format(String msgCode, Object ... parms) {
        return Tr.formatMessage((TraceComponent)tc, (String)msgCode, (Object[])parms);
    }

    private static UnavailableException missingElementException(String elementName, String typeName, Class<?> elementClass, String adapterName) {
        return DeploymentDescriptorMerger.unavailableException("J2CA9911.missing.matching.type", elementName, typeName, elementClass.getSimpleName(), adapterName);
    }

    private static UnavailableException unavailableException(String msgId, Object ... parms) {
        return new UnavailableException(DeploymentDescriptorMerger.format(msgId, parms));
    }

    private static InvalidPropertyException propertyException(String msgId, String pName, String adapterName) {
        String msg = DeploymentDescriptorMerger.format(msgId, pName, adapterName);
        return new InvalidPropertyException(msg);
    }

    public static void merge(String adapterName, RaConnector raConnector, WlpRaConnector wlpRaConnector) throws InvalidPropertyException, UnavailableException {
        WlpRaInboundResourceAdapter wlpInboundAdapter;
        WlpRaOutboundResourceAdapter wlpOutboundAdapter;
        raConnector.copyWlpSettings(wlpRaConnector);
        WlpRaResourceAdapter wlpResourceAdapter = wlpRaConnector.getResourceAdapter();
        if (wlpResourceAdapter == null) {
            return;
        }
        RaResourceAdapter raResourceAdapter = raConnector.getResourceAdapter();
        raResourceAdapter.copyWlpSettings(wlpResourceAdapter);
        DeploymentDescriptorMerger.mergeProperties(adapterName, wlpResourceAdapter, raResourceAdapter, raWidget);
        List<WlpRaAdminObject> wlpAdminObjects = wlpResourceAdapter.getAdminObjects();
        if (wlpAdminObjects != null) {
            for (WlpRaAdminObject wlpAdminObject : wlpAdminObjects) {
                Object aoClass;
                String aoInterface = wlpAdminObject.getAdminObjectInterface();
                RaAdminObject raAdminObject = raResourceAdapter.getAdminObject(aoInterface, (String)(aoClass = wlpAdminObject.getAdminObjectClass()));
                if (raAdminObject == null) {
                    throw DeploymentDescriptorMerger.unavailableException("J2CA9910.missing.matching.adminobject", aoInterface, aoClass, adapterName);
                }
                raAdminObject.copyWlpSettings(wlpAdminObject);
                DeploymentDescriptorMerger.mergeProperties(adapterName, wlpAdminObject, raAdminObject, aoWidget);
            }
        }
        if ((wlpOutboundAdapter = wlpResourceAdapter.getOutboundResourceAdapter()) != null) {
            RaOutboundResourceAdapter raOutboundAdapter = raResourceAdapter.getOutboundResourceAdapter();
            List<WlpRaConnectionDefinition> wlpConnectionDefinitions = wlpOutboundAdapter.getConnectionDefinitions();
            if (wlpConnectionDefinitions != null) {
                for (WlpRaConnectionDefinition wlpConnectionDefinition : wlpConnectionDefinitions) {
                    RaConnectionDefinition raConnectionDefinition = raOutboundAdapter.getConnectionDefinitionByInterface(wlpConnectionDefinition.getConnectionFactoryInterface());
                    if (raConnectionDefinition == null) {
                        throw DeploymentDescriptorMerger.missingElementException("connection-definition", wlpConnectionDefinition.getConnectionFactoryInterface(), ConnectionDefinition.class, adapterName);
                    }
                    raConnectionDefinition.copyWlpSettings(wlpConnectionDefinition);
                    DeploymentDescriptorMerger.mergeProperties(adapterName, wlpConnectionDefinition, raConnectionDefinition, cdWidget);
                }
            }
        }
        if ((wlpInboundAdapter = wlpResourceAdapter.getInboundResourceAdapter()) != null) {
            RaInboundResourceAdapter raInboundAdapter = raResourceAdapter.getInboundResourceAdapter();
            WlpRaMessageAdapter wlpMessageAdapter = wlpInboundAdapter.getMessageAdapter();
            if (wlpMessageAdapter != null) {
                RaMessageAdapter raMessageAdapter = raInboundAdapter.getMessageAdapter();
                List<WlpRaMessageListener> wlpMessageListeners = wlpMessageAdapter.getMessageListeners();
                if (wlpMessageListeners != null) {
                    for (WlpRaMessageListener wlpMessageListener : wlpMessageListeners) {
                        RaMessageListener raMessageListener;
                        RaMessageListener raMessageListener2 = raMessageListener = raMessageAdapter == null ? null : raMessageAdapter.getMessageListenerByType(wlpMessageListener.getMessageListenerType());
                        if (raMessageListener == null) {
                            throw DeploymentDescriptorMerger.missingElementException("messagelistener", wlpMessageListener.getMessageListenerType(), Activation.class, adapterName);
                        }
                        raMessageListener.copyWlpSettings(wlpMessageListener);
                        WlpRaActivationSpec wlpActivationSpec = wlpMessageListener.getActivationSpec();
                        if (wlpActivationSpec == null) continue;
                        RaActivationSpec raActivationSpec = raMessageListener.getActivationSpec();
                        if (raActivationSpec == null) {
                            throw DeploymentDescriptorMerger.missingElementException("activationspec", raMessageListener.getMessageListenerType(), Activation.class, adapterName);
                        }
                        DeploymentDescriptorMerger.mergeProperties(adapterName, wlpActivationSpec, raActivationSpec, asWidget);
                    }
                }
            }
        }
    }

    private static <SourceT, SinkT> void mergeProperties(String adapterName, SourceT source, SinkT sink, PWidget<SourceT, SinkT> pWidget) throws InvalidPropertyException, UnavailableException {
        List<WlpRaConfigProperty> sourceProperties = pWidget.getSourceProperties(source);
        if (sourceProperties == null) {
            return;
        }
        for (WlpRaConfigProperty sourceProperty : sourceProperties) {
            RaConfigProperty sinkProperty;
            String pName = sourceProperty.getWlpPropertyName();
            if (sourceProperty.addWlpPropertyToMetatype()) {
                if (pWidget.isPresent(sink, pName)) {
                    throw DeploymentDescriptorMerger.propertyException("J2CA9908.duplicate.copy", pName, adapterName);
                }
                sinkProperty = new RaConfigProperty();
                sinkProperty.copyWlpSettings(sourceProperty);
                pWidget.getSinkProperties(sink).add(sinkProperty);
                continue;
            }
            sinkProperty = pWidget.getSinkProperty(sink, pName);
            if (sinkProperty == null) {
                throw DeploymentDescriptorMerger.unavailableException("J2CA9909.missing.matching.config.prop", pName, adapterName);
            }
            sinkProperty.copyWlpSettings(sourceProperty);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class AS_Widget
    implements PWidget<WlpRaActivationSpec, RaActivationSpec> {
        static final long serialVersionUID = -6487513555796508098L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public List<WlpRaConfigProperty> getSourceProperties(WlpRaActivationSpec pHolder) {
            return pHolder.getConfigProperties();
        }

        @Override
        public List<RaConfigProperty> getSinkProperties(RaActivationSpec pHolder) {
            return pHolder.getConfigProperties();
        }

        @Override
        public boolean isPresent(RaActivationSpec pHolder, String pName) {
            return pHolder.isConfigPropertyAlreadyDefined(pName);
        }

        @Override
        public RaConfigProperty getSinkProperty(RaActivationSpec pHolder, String pName) {
            return pHolder.getConfigPropertyById(pName);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jca.utils.metagen.DeploymentDescriptorMerger$AS_Widget", AS_Widget.class, (String)"rarInstall", (String)"com.ibm.ws.jca.utils.internal.resources.JcaUtilsMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class CD_Widget
    implements PWidget<WlpRaConnectionDefinition, RaConnectionDefinition> {
        static final long serialVersionUID = 3685540767552130846L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public List<WlpRaConfigProperty> getSourceProperties(WlpRaConnectionDefinition pHolder) {
            return pHolder.getConfigProperties();
        }

        @Override
        public List<RaConfigProperty> getSinkProperties(RaConnectionDefinition pHolder) {
            return pHolder.getConfigProperties();
        }

        @Override
        public boolean isPresent(RaConnectionDefinition pHolder, String pName) {
            return pHolder.isConfigPropertyAlreadyDefined(pName);
        }

        @Override
        public RaConfigProperty getSinkProperty(RaConnectionDefinition pHolder, String pName) {
            return pHolder.getConfigPropertyById(pName);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jca.utils.metagen.DeploymentDescriptorMerger$CD_Widget", CD_Widget.class, (String)"rarInstall", (String)"com.ibm.ws.jca.utils.internal.resources.JcaUtilsMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class AO_Widget
    implements PWidget<WlpRaAdminObject, RaAdminObject> {
        static final long serialVersionUID = -8036897890325014842L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public List<WlpRaConfigProperty> getSourceProperties(WlpRaAdminObject pHolder) {
            return pHolder.getConfigProperties();
        }

        @Override
        public List<RaConfigProperty> getSinkProperties(RaAdminObject pHolder) {
            return pHolder.getConfigProperties();
        }

        @Override
        public boolean isPresent(RaAdminObject pHolder, String pName) {
            return pHolder.isConfigPropertyAlreadyDefined(pName);
        }

        @Override
        public RaConfigProperty getSinkProperty(RaAdminObject pHolder, String pName) {
            return pHolder.getConfigPropertyById(pName);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jca.utils.metagen.DeploymentDescriptorMerger$AO_Widget", AO_Widget.class, (String)"rarInstall", (String)"com.ibm.ws.jca.utils.internal.resources.JcaUtilsMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class RA_Widget
    implements PWidget<WlpRaResourceAdapter, RaResourceAdapter> {
        static final long serialVersionUID = 828939881421665252L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public List<WlpRaConfigProperty> getSourceProperties(WlpRaResourceAdapter pHolder) {
            return pHolder.getConfigProperties();
        }

        @Override
        public List<RaConfigProperty> getSinkProperties(RaResourceAdapter pHolder) {
            return pHolder.getConfigProperties();
        }

        @Override
        public boolean isPresent(RaResourceAdapter pHolder, String pName) {
            return pHolder.isConfigPropertyAlreadyDefined(pName);
        }

        @Override
        public RaConfigProperty getSinkProperty(RaResourceAdapter pHolder, String pName) {
            return pHolder.getConfigPropertyById(pName);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jca.utils.metagen.DeploymentDescriptorMerger$RA_Widget", RA_Widget.class, (String)"rarInstall", (String)"com.ibm.ws.jca.utils.internal.resources.JcaUtilsMessages");
        }
    }

    public static interface PWidget<SourceT, SinkT> {
        public List<WlpRaConfigProperty> getSourceProperties(SourceT var1);

        public List<RaConfigProperty> getSinkProperties(SinkT var1);

        public boolean isPresent(SinkT var1, String var2);

        public RaConfigProperty getSinkProperty(SinkT var1, String var2);
    }
}

