/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.SignatureSigningParametersResolver;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.criterion.SignatureSigningConfigurationCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateSignatureSigningParametersHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateSignatureSigningParametersHandler.class);
    @Nonnull
    private Function<MessageContext, SecurityParametersContext> securityParametersContextLookupStrategy = new ChildContextLookup(SecurityParametersContext.class, true);
    @Nullable
    private Function<MessageContext, SecurityParametersContext> existingParametersContextLookupStrategy;
    @NonnullAfterInit
    private Function<MessageContext, List<SignatureSigningConfiguration>> configurationLookupStrategy;
    @Nullable
    private Function<MessageContext, SAMLMetadataContext> metadataContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(SAMLMetadataContext.class), (Function)new ChildContextLookup(SAMLPeerEntityContext.class));
    @NonnullAfterInit
    private SignatureSigningParametersResolver resolver;
    private boolean noResultIsError;

    public void setSecurityParametersContextLookupStrategy(@Nonnull Function<MessageContext, SecurityParametersContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.securityParametersContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SecurityParametersContext lookup strategy cannot be null");
    }

    public void setExistingParametersContextLookupStrategy(@Nullable Function<MessageContext, SecurityParametersContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.existingParametersContextLookupStrategy = strategy;
    }

    public void setMetadataContextLookupStrategy(@Nullable Function<MessageContext, SAMLMetadataContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.metadataContextLookupStrategy = strategy;
    }

    public void setConfigurationLookupStrategy(@Nonnull Function<MessageContext, List<SignatureSigningConfiguration>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.configurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SignatureSigningConfiguration lookup strategy cannot be null");
    }

    public void setSignatureSigningParametersResolver(@Nonnull SignatureSigningParametersResolver newResolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.resolver = (SignatureSigningParametersResolver)Constraint.isNotNull((Object)newResolver, (String)"SignatureSigningParametersResolver cannot be null");
    }

    public void setNoResultIsError(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.noResultIsError = flag;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resolver == null) {
            throw new ComponentInitializationException("SignatureSigningParametersResolver cannot be null");
        }
        if (this.configurationLookupStrategy == null) {
            this.configurationLookupStrategy = new Function<MessageContext, List<SignatureSigningConfiguration>>(){

                public List<SignatureSigningConfiguration> apply(MessageContext input) {
                    return Collections.singletonList(SecurityConfigurationSupport.getGlobalSignatureSigningConfiguration());
                }
            };
        }
    }

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (super.doPreInvoke(messageContext)) {
            this.log.debug("{} Signing enabled", (Object)this.getLogPrefix());
            return true;
        }
        this.log.debug("{} Signing not enabled", (Object)this.getLogPrefix());
        return false;
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        SAMLMetadataContext metadataCtx;
        SecurityParametersContext existingCtx;
        this.log.debug("{} Resolving SignatureSigningParameters for request", (Object)this.getLogPrefix());
        SecurityParametersContext paramsCtx = (SecurityParametersContext)((Object)this.securityParametersContextLookupStrategy.apply((Object)messageContext));
        if (paramsCtx == null) {
            this.log.debug("{} No SecurityParametersContext returned by lookup strategy", (Object)this.getLogPrefix());
            throw new MessageHandlerException("No SecurityParametersContext returned by lookup strategy");
        }
        if (this.existingParametersContextLookupStrategy != null && (existingCtx = (SecurityParametersContext)((Object)this.existingParametersContextLookupStrategy.apply((Object)messageContext))) != null && existingCtx.getSignatureSigningParameters() != null) {
            this.log.debug("{} Found existing SecurityParametersContext to copy from", (Object)this.getLogPrefix());
            paramsCtx.setSignatureSigningParameters(existingCtx.getSignatureSigningParameters());
            return;
        }
        List configs = (List)this.configurationLookupStrategy.apply((Object)messageContext);
        if (configs == null || configs.isEmpty()) {
            this.log.error("{} No SignatureSigningConfiguration returned by lookup strategy", (Object)this.getLogPrefix());
            throw new MessageHandlerException("No SignatureSigningConfiguration returned by lookup strategy");
        }
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new SignatureSigningConfigurationCriterion(configs)});
        if (this.metadataContextLookupStrategy != null && (metadataCtx = (SAMLMetadataContext)((Object)this.metadataContextLookupStrategy.apply((Object)messageContext))) != null && metadataCtx.getRoleDescriptor() != null) {
            this.log.debug("{} Adding metadata to resolution criteria for signing/digest algorithms", (Object)this.getLogPrefix());
            criteria.add((Object)new RoleDescriptorCriterion(metadataCtx.getRoleDescriptor()));
        }
        try {
            SignatureSigningParameters params = (SignatureSigningParameters)this.resolver.resolveSingle(criteria);
            if (params == null && this.noResultIsError) {
                this.log.error("Failed to resolve SignatureSigningParameters");
                throw new MessageHandlerException("Failed to resolve SignatureSigningParameters");
            }
            this.log.debug("{} {} SignatureSigningParameters", (Object)this.getLogPrefix(), (Object)(params != null ? "Resolved" : "Failed to resolve"));
            paramsCtx.setSignatureSigningParameters(params);
        }
        catch (ResolverException e) {
            this.log.error("{} Error resolving SignatureSigningParameters", (Object)this.getLogPrefix(), (Object)e);
            throw new MessageHandlerException("Error resolving SignatureSigningParameters", (Exception)((Object)e));
        }
    }
}

