/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.service.impl;

import com.ibm.tx.remote.Vote;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jaxws.wsat.Constants;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsat.common.impl.WSATCoordinator;
import com.ibm.ws.wsat.common.impl.WSATCoordinatorTran;
import com.ibm.ws.wsat.common.impl.WSATParticipant;
import com.ibm.ws.wsat.common.impl.WSATParticipantState;
import com.ibm.ws.wsat.common.impl.WSATTransaction;
import com.ibm.ws.wsat.service.WSATException;
import com.ibm.ws.wsat.service.WebClient;
import com.ibm.ws.wsat.tm.impl.TranManagerImpl;
import jakarta.xml.bind.JAXBElement;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.EndpointReferenceUtils;
import org.apache.cxf.ws.addressing.ReferenceParametersType;

@TraceObjectField(fieldName="TC", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ProtocolImpl {
    private static final TraceComponent TC = Tr.register(ProtocolImpl.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
    private static final ProtocolImpl INSTANCE = new ProtocolImpl();
    private final TranManagerImpl tranService = TranManagerImpl.getInstance();
    private EndpointReferenceType coordinatorEndpoint;
    private EndpointReferenceType participantEndpoint;
    static final long serialVersionUID = -6976469975460432575L;

    public static ProtocolImpl getInstance() {
        return INSTANCE;
    }

    public synchronized void setCoordinatorEndpoint(EndpointReferenceType epr) {
        this.coordinatorEndpoint = epr;
        this.notifyAll();
    }

    public synchronized void setParticipantEndpoint(EndpointReferenceType epr) {
        this.participantEndpoint = epr;
        this.notifyAll();
    }

    public synchronized EndpointReferenceType getCoordinatorEndpoint(String globalId) throws WSATException {
        while (this.coordinatorEndpoint == null) {
            try {
                this.wait(30000L);
                if (this.coordinatorEndpoint != null) continue;
                throw new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"NO_SERVICE_ENDPOINT_CWLIB0209", (Object[])new Object[0]));
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.wsat.service.impl.ProtocolImpl", (String)"83", (Object)this, (Object[])new Object[]{globalId});
            }
        }
        return this.getEndpoint(this.coordinatorEndpoint, globalId);
    }

    public synchronized EndpointReferenceType getParticipantEndpoint(String globalId) throws WSATException {
        while (this.participantEndpoint == null) {
            try {
                this.wait(30000L);
                if (this.participantEndpoint != null) continue;
                throw new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"NO_SERVICE_ENDPOINT_CWLIB0209", (Object[])new Object[0]));
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.wsat.service.impl.ProtocolImpl", (String)"96", (Object)this, (Object[])new Object[]{globalId});
            }
        }
        return this.getEndpoint(this.participantEndpoint, globalId);
    }

    private EndpointReferenceType getEndpoint(EndpointReferenceType epr, String ctxId) {
        EndpointReferenceType eprCopy = EndpointReferenceUtils.duplicate((EndpointReferenceType)epr);
        ReferenceParametersType refs = new ReferenceParametersType();
        refs.getAny().add(new JAXBElement(Constants.WS_WSAT_CTX_REF, String.class, (Object)ctxId));
        eprCopy.setReferenceParameters(refs);
        return eprCopy;
    }

    @FFDCIgnore(value={WSATException.class})
    public void prepare(String globalId, EndpointReferenceType fromEpr) throws WSATException {
        WSATTransaction tran = WSATTransaction.getTran(globalId);
        try {
            Vote vote = this.tranService.prepareTransaction(globalId);
            WSATParticipantState resp = vote == Vote.VoteCommit ? WSATParticipantState.PREPARED : (vote == Vote.VoteReadOnly ? WSATParticipantState.READONLY : WSATParticipantState.ABORTED);
            this.participantResponse(tran, globalId, fromEpr, resp);
        }
        catch (WSATException e) {
            this.participantResponse(tran, globalId, fromEpr, WSATParticipantState.ROLLBACK);
        }
    }

    @FFDCIgnore(value={WSATException.class})
    public void commit(String globalId, EndpointReferenceType fromEpr) {
        block2: {
            try {
                WSATTransaction tran = WSATTransaction.getTran(globalId);
                this.tranService.commitTransaction(globalId);
                this.participantResponse(tran, globalId, fromEpr, WSATParticipantState.COMMITTED);
            }
            catch (WSATException e) {
                if (!TC.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)TC, (String)"Unable to complete commit: {0}", (Object[])new Object[]{e});
            }
        }
    }

    @FFDCIgnore(value={WSATException.class})
    public void rollback(String globalId, EndpointReferenceType fromEpr) {
        block6: {
            WSATTransaction tran;
            block5: {
                tran = WSATTransaction.getTran(globalId);
                if (tran != null) {
                    try {
                        this.tranService.rollbackTransaction(globalId);
                    }
                    catch (WSATException e) {
                        if (!TC.isDebugEnabled()) break block5;
                        Tr.debug((TraceComponent)TC, (String)"Unable to complete rollback: {0}", (Object[])new Object[]{e});
                    }
                }
            }
            try {
                this.participantResponse(tran, globalId, fromEpr, WSATParticipantState.ABORTED);
            }
            catch (WSATException e) {
                if (!TC.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)TC, (String)"Unable to send rollback response: {0}", (Object[])new Object[]{e});
            }
        }
    }

    private void coordinatorResponse(String globalId, EndpointReferenceType fromEpr, String partId, WSATParticipantState response) throws WSATException {
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"From EPR address: {0}", (Object[])new Object[]{fromEpr.getAddress().getValue()});
            Tr.debug((TraceComponent)TC, (String)"Coordinator Endpoint: {0}", (Object[])new Object[]{this.coordinatorEndpoint.getAddress().getValue()});
            Tr.debug((TraceComponent)TC, (String)"From EPR address: {0}", (Object[])new Object[]{this.participantEndpoint.getAddress().getValue()});
        }
        WSATParticipant part = new WSATParticipant(globalId, partId, fromEpr);
        WSATCoordinator coord = new WSATCoordinator(globalId, this.coordinatorEndpoint);
        coord.setParticipant(part);
        part.setCoordinator(coord);
        WebClient client = WebClient.getWebClient(part, coord);
        client.rollback();
    }

    private void participantResponse(WSATTransaction tran, String globalId, EndpointReferenceType fromEpr, WSATParticipantState response) throws WSATException {
        WSATCoordinator coord = null;
        if (tran != null) {
            coord = tran.getCoordinator();
        } else if (fromEpr != null) {
            coord = new WSATCoordinator(globalId, fromEpr);
        }
        if (coord != null) {
            WebClient client = WebClient.getWebClient(coord, coord.getParticipant());
            if (response == WSATParticipantState.PREPARED) {
                client.prepared();
            } else if (response == WSATParticipantState.COMMITTED) {
                client.committed();
            } else if (response == WSATParticipantState.READONLY) {
                client.readOnly();
            } else {
                client.aborted();
            }
        } else if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"Unable to find response coordinator", (Object[])new Object[0]);
        }
    }

    public void prepared(String globalId, String partId, EndpointReferenceType fromEpr) throws WSATException {
        WSATParticipant participant = this.findParticipant(globalId, partId);
        if (participant != null) {
            participant.setResponse(WSATParticipantState.PREPARED);
        } else {
            if (TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)"Unsolicited PREPARED received: {0}/{1}/{2}. Replaying completion", (Object[])new Object[]{globalId, partId, fromEpr.getAddress()});
            }
            if (!this.tranService.replayCompletion(globalId) && TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)"Couldn't find tran. Need to send rollback", (Object[])new Object[0]);
                this.coordinatorResponse(globalId, fromEpr, partId, WSATParticipantState.ROLLBACK);
            }
        }
    }

    public void readOnly(String globalId, String partId) throws WSATException {
        WSATParticipant participant = this.findParticipant(globalId, partId);
        if (participant != null) {
            participant.setResponse(WSATParticipantState.READONLY);
        }
    }

    public void aborted(String globalId, String partId) throws WSATException {
        WSATParticipant participant = this.findParticipant(globalId, partId);
        if (participant != null) {
            participant.setResponse(WSATParticipantState.ABORTED);
        }
    }

    public void committed(String globalId, String partId) throws WSATException {
        WSATParticipant participant = this.findParticipant(globalId, partId);
        if (participant != null) {
            participant.setResponse(WSATParticipantState.COMMITTED);
        }
    }

    private WSATParticipant findParticipant(String globalId, String partId) {
        WSATParticipant participant = null;
        WSATCoordinatorTran wsatTran = WSATTransaction.getCoordTran(globalId);
        if (wsatTran != null) {
            participant = wsatTran.getParticipant(partId);
            if (participant == null && TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)"Unable to find participant for transaction: {0}/{1}", (Object[])new Object[]{globalId, partId});
            }
        } else if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"Unable to find transaction: {0}", (Object[])new Object[]{globalId});
        }
        return participant;
    }
}

