/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.service.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.wsat.Constants;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsat.common.impl.WSATCoordinator;
import com.ibm.ws.wsat.common.impl.WSATCoordinatorTran;
import com.ibm.ws.wsat.common.impl.WSATParticipant;
import com.ibm.ws.wsat.common.impl.WSATTransaction;
import com.ibm.ws.wsat.service.WSATContext;
import com.ibm.ws.wsat.service.WSATException;
import com.ibm.ws.wsat.service.WSATFault;
import com.ibm.ws.wsat.service.WSATFaultException;
import com.ibm.ws.wsat.service.WebClient;
import com.ibm.ws.wsat.service.impl.ProtocolImpl;
import com.ibm.ws.wsat.tm.impl.TranManagerImpl;
import jakarta.xml.bind.JAXBElement;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.EndpointReferenceUtils;
import org.apache.cxf.ws.addressing.ReferenceParametersType;

@TraceObjectField(fieldName="TC", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RegistrationImpl {
    private static final String CLASS_NAME = RegistrationImpl.class.getName();
    private static final TraceComponent TC = Tr.register(RegistrationImpl.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
    private static final RegistrationImpl INSTANCE = new RegistrationImpl();
    private final TranManagerImpl tranService = TranManagerImpl.getInstance();
    private final ProtocolImpl protocolService = ProtocolImpl.getInstance();
    private EndpointReferenceType registrationEndpoint;
    static final long serialVersionUID = -8727507342468453578L;

    public static RegistrationImpl getInstance() {
        return INSTANCE;
    }

    public synchronized void setRegistrationEndpoint(EndpointReferenceType epr) {
        this.registrationEndpoint = epr;
        this.notifyAll();
    }

    public synchronized EndpointReferenceType getRegistrationEndpoint(String global) throws WSATException {
        while (this.registrationEndpoint == null) {
            try {
                this.wait(30000L);
                if (this.registrationEndpoint != null) continue;
                throw new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"NO_SERVICE_ENDPOINT_CWLIB0209", (Object[])new Object[0]));
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.wsat.service.impl.RegistrationImpl", (String)"73", (Object)this, (Object[])new Object[]{global});
            }
        }
        EndpointReferenceType epr = EndpointReferenceUtils.duplicate((EndpointReferenceType)this.registrationEndpoint);
        ReferenceParametersType refs = new ReferenceParametersType();
        refs.getAny().add(new JAXBElement(Constants.WS_WSAT_CTX_REF, String.class, (Object)global));
        epr.setReferenceParameters(refs);
        return epr;
    }

    public WSATContext activate(String globalId, long timeout, boolean recovery) throws WSATException {
        if (timeout < 0L) {
            throw new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"WSAT_TRAN_EXPIRED_CWLIB0203", (Object[])new Object[0]));
        }
        WSATCoordinatorTran wsatTran = new WSATCoordinatorTran(globalId, timeout, recovery);
        wsatTran.setRegistration(this.getRegistrationEndpoint(wsatTran.getGlobalId()));
        wsatTran.setCoordinator(this.protocolService.getCoordinatorEndpoint(wsatTran.getGlobalId()));
        WSATTransaction.putTran(wsatTran);
        return wsatTran.getContext();
    }

    public WSATContext activate(String globalId, EndpointReferenceType registration, long timeout, boolean recovery) throws WSATException {
        if (timeout < 0L) {
            throw new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"WSAT_TRAN_EXPIRED_CWLIB0203", (Object[])new Object[0]));
        }
        WSATTransaction wsatTran = new WSATTransaction(globalId, timeout, recovery);
        wsatTran.setRegistration(registration);
        WSATTransaction.putTran(wsatTran);
        return wsatTran.getContext();
    }

    public EndpointReferenceType register(String globalId, EndpointReferenceType partEpr) throws WSATException {
        WSATCoordinatorTran wsatTran = WSATTransaction.getCoordTran(globalId);
        if (wsatTran == null) {
            throw new WSATFaultException(WSATFault.getCannotRegisterParticipant(Tr.formatMessage((TraceComponent)TC, (String)"NO_WSAT_TRAN_CWLIB0201", (Object[])new Object[]{globalId})));
        }
        WSATParticipant participant = wsatTran.addParticipant(partEpr);
        this.tranService.registerParticipant(globalId, participant);
        return participant.getCoordinator().getEndpointReference();
    }

    public void registerParticipant(String globalId, WSATTransaction wsatTran) throws WSATException {
        EndpointReferenceType participant = this.protocolService.getParticipantEndpoint(globalId);
        WSATCoordinator wsatCoord = wsatTran.getRegistration();
        WebClient webClient = WebClient.getWebClient(wsatCoord, null);
        EndpointReferenceType coordinator = webClient.register(participant);
        WSATCoordinator remoteCoord = wsatTran.setCoordinator(coordinator);
        this.tranService.registerCoordinator(globalId, remoteCoord);
    }
}

