/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.service.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsat.common.impl.WSATEndpoint;
import com.ibm.ws.wsat.service.WSATException;
import com.ibm.ws.wsat.service.WebClient;
import com.ibm.ws.wsat.service.impl.HandlerImpl;
import com.ibm.ws.wsat.webservice.client.CoordinatorPortType;
import com.ibm.ws.wsat.webservice.client.CoordinatorService;
import com.ibm.ws.wsat.webservice.client.ParticipantPortType;
import com.ibm.ws.wsat.webservice.client.ParticipantService;
import com.ibm.ws.wsat.webservice.client.RegistrationPortType;
import com.ibm.ws.wsat.webservice.client.RegistrationService;
import com.ibm.ws.wsat.webservice.client.SSLClientInterceptor;
import com.ibm.ws.wsat.webservice.client.wsat.Notification;
import com.ibm.ws.wsat.webservice.client.wscoor.RegisterResponseType;
import com.ibm.ws.wsat.webservice.client.wscoor.RegisterType;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.WebServiceFeature;
import jakarta.xml.ws.soap.AddressingFeature;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Callable;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

@TraceObjectField(fieldName="TC", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebClientImpl
extends WebClient {
    private static final TraceComponent TC = Tr.register(WebClientImpl.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
    private static final HandlerImpl handlerService = HandlerImpl.getInstance();
    private static final AddressingFeature wsAddrFeat = new AddressingFeature(true);
    private static volatile ClassLoader tccl;
    private final WSATEndpoint toEpr;
    private final WSATEndpoint fromEpr;
    static final long serialVersionUID = -8981751808317333071L;

    public WebClientImpl(WSATEndpoint toEpr, WSATEndpoint fromEpr) {
        this.toEpr = toEpr;
        this.fromEpr = fromEpr;
    }

    @Override
    public EndpointReferenceType register(final EndpointReferenceType participant) throws WSATException {
        return this.invoke(new Callable<EndpointReferenceType>(){
            static final long serialVersionUID = 2525587835128794226L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public EndpointReferenceType call() throws Exception {
                RegistrationService regService = new RegistrationService();
                RegistrationPortType port = (RegistrationPortType)WebClientImpl.this.getPort((Service)regService, RegistrationPortType.class);
                WebClientImpl.this.setTimeouts(port);
                RegisterType regParm = new RegisterType();
                regParm.setParticipantProtocolService(participant);
                regParm.setProtocolIdentifier("http://docs.oasis-open.org/ws-tx/wsat/2006/06/Durable2PC");
                RegisterResponseType regResp = port.registerOperation(regParm);
                return regResp.getCoordinatorProtocolService();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsat.service.impl.WebClientImpl$1", 1.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
            }
        });
    }

    @Override
    public void prepare() throws WSATException {
        this.invoke(new Callable<Object>(){
            static final long serialVersionUID = 1396544613826770964L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object call() throws Exception {
                ParticipantService partService = new ParticipantService();
                ParticipantPortType port = (ParticipantPortType)WebClientImpl.this.getPort((Service)partService, ParticipantPortType.class);
                WebClientImpl.this.setTimeouts(port);
                Notification parm = new Notification();
                port.prepareOperation(parm);
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsat.service.impl.WebClientImpl$2", 2.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
            }
        });
    }

    @Override
    public void rollback() throws WSATException {
        this.invoke(new Callable<Object>(){
            static final long serialVersionUID = 6027298714470930697L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object call() throws Exception {
                ParticipantService partService = new ParticipantService();
                ParticipantPortType port = (ParticipantPortType)WebClientImpl.this.getPort((Service)partService, ParticipantPortType.class);
                WebClientImpl.this.setTimeouts(port);
                Notification parm = new Notification();
                port.rollbackOperation(parm);
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsat.service.impl.WebClientImpl$3", 3.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
            }
        });
    }

    @Override
    public void commit() throws WSATException {
        this.invoke(new Callable<Object>(){
            static final long serialVersionUID = -3167260504946266799L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object call() throws Exception {
                ParticipantService partService = new ParticipantService();
                ParticipantPortType port = (ParticipantPortType)WebClientImpl.this.getPort((Service)partService, ParticipantPortType.class);
                WebClientImpl.this.setTimeouts(port);
                Notification parm = new Notification();
                port.commitOperation(parm);
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsat.service.impl.WebClientImpl$4", 4.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
            }
        });
    }

    @Override
    public void prepared() throws WSATException {
        this.invoke(new Callable<Object>(){
            static final long serialVersionUID = -3889877303360006025L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object call() throws Exception {
                CoordinatorService coordService = new CoordinatorService();
                CoordinatorPortType port = (CoordinatorPortType)WebClientImpl.this.getPort((Service)coordService, CoordinatorPortType.class);
                WebClientImpl.this.setTimeouts(port);
                Notification parm = new Notification();
                port.preparedOperation(parm);
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsat.service.impl.WebClientImpl$5", 5.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
            }
        });
    }

    @Override
    public void readOnly() throws WSATException {
        this.invoke(new Callable<Object>(){
            static final long serialVersionUID = 3582193814865560076L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object call() throws Exception {
                CoordinatorService coordService = new CoordinatorService();
                CoordinatorPortType port = (CoordinatorPortType)WebClientImpl.this.getPort((Service)coordService, CoordinatorPortType.class);
                WebClientImpl.this.setTimeouts(port);
                Notification parm = new Notification();
                port.readOnlyOperation(parm);
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsat.service.impl.WebClientImpl$6", 6.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
            }
        });
    }

    @Override
    public void aborted() throws WSATException {
        this.invoke(new Callable<Object>(){
            static final long serialVersionUID = -8723281480109193710L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object call() throws Exception {
                CoordinatorService coordService = new CoordinatorService();
                CoordinatorPortType port = (CoordinatorPortType)WebClientImpl.this.getPort((Service)coordService, CoordinatorPortType.class);
                WebClientImpl.this.setTimeouts(port);
                Notification parm = new Notification();
                port.abortedOperation(parm);
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsat.service.impl.WebClientImpl$7", 7.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
            }
        });
    }

    @Override
    public void committed() throws WSATException {
        this.invoke(new Callable<Object>(){
            static final long serialVersionUID = 7183512551803699902L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object call() throws Exception {
                CoordinatorService coordService = new CoordinatorService();
                CoordinatorPortType port = (CoordinatorPortType)WebClientImpl.this.getPort((Service)coordService, CoordinatorPortType.class);
                WebClientImpl.this.setTimeouts(port);
                Notification parm = new Notification();
                port.committedOperation(parm);
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsat.service.impl.WebClientImpl$8", 8.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private <T> T invoke(final Callable<T> action) throws WSATException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<T>(){
                static final long serialVersionUID = -1496340390162159047L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public T run() throws Exception {
                    ClassLoader saveLoader = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(tccl);
                        handlerService.setWsatCall(true);
                        Object v = action.call();
                        return v;
                    }
                    finally {
                        handlerService.setWsatCall(false);
                        Thread.currentThread().setContextClassLoader(saveLoader);
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsat.service.impl.WebClientImpl$9", 9.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.wsat.service.impl.WebClientImpl", (String)"229", (Object)this, (Object[])new Object[]{action});
            throw new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"WEB_SERVICE_ERROR_CWLIB0204", (Object[])new Object[0]), e.getException());
        }
    }

    private <T> T getPort(Service service, Class<T> portType) {
        Object port = service.getPort(this.toEpr.getWsEpr(), portType, new WebServiceFeature[]{wsAddrFeat});
        if (this.fromEpr != null) {
            AddressingProperties wsAddr = new AddressingProperties();
            wsAddr.setReplyTo(this.fromEpr.getEndpointReference());
            ((BindingProvider)port).getRequestContext().put("jakarta.xml.ws.addressing.context", wsAddr);
        }
        if (this.toEpr.isSecure()) {
            Client c = ClientProxy.getClient((Object)port);
            c.getOutInterceptors().add(new SSLClientInterceptor());
        }
        return (T)port;
    }

    public static ClassLoader getTccl() {
        return tccl;
    }

    public static void setTccl(ClassLoader tccl) {
        WebClientImpl.tccl = tccl;
    }
}

