/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.appsecurity.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ssl.Constants;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JaxRsSSLManager {
    private static final TraceComponent tc = Tr.register(JaxRsSSLManager.class, (String)"com.ibm.ws.jaxrs20.appsecurity", null);
    private static final Map<String, SSLSocketFactory> socketFactories = new HashMap<String, SSLSocketFactory>();
    private static final Map<String, SSLContext> sslContexts = new HashMap<String, SSLContext>();
    private static final JSSEHelper jsseHelper = JSSEHelper.getInstance();
    static final long serialVersionUID = -139804234104611644L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static SSLSocketFactory getSSLSocketFactoryBySSLRef(String sslRef, String host, String port) {
        SSLSocketFactory sslSocketFactory = null;
        try {
            Map<String, Object> connectionInfo = JaxRsSSLManager.getConnectionInfo(host, port);
            Properties sslProps = JaxRsSSLManager.getSSLProperties(sslRef, connectionInfo);
            SSLContext sslContext = JaxRsSSLManager.getSSLContext(sslRef, connectionInfo, sslProps);
            if (sslContext == null) {
                return null;
            }
            boolean recache = false;
            Map<String, Object> map = sslContexts;
            synchronized (map) {
                SSLContext cachedSslContext = sslContexts.get(sslRef);
                if (sslContext == null || !sslContext.equals(cachedSslContext)) {
                    sslContexts.put(sslRef, sslContext);
                    recache = true;
                }
            }
            map = socketFactories;
            synchronized (map) {
                sslSocketFactory = socketFactories.get(sslRef);
                if (sslSocketFactory == null || recache) {
                    sslSocketFactory = sslContext.getSocketFactory();
                    socketFactories.put(sslRef, sslSocketFactory);
                }
            }
        }
        catch (SSLException connectionInfo) {
            FFDCFilter.processException((Throwable)connectionInfo, (String)"com.ibm.ws.jaxrs20.appsecurity.security.JaxRsSSLManager", (String)"77", null, (Object[])new Object[]{sslRef, host, port});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("configClientSSL failed to get the SSLSocketFactory with exception: " + e.toString()), (Object[])new Object[0]);
            }
            return null;
        }
        return sslSocketFactory;
    }

    /*
     * WARNING - void declaration
     */
    public static String[] getSSLCipherSuitesBySSLRef(String sslRef, String host, String port) {
        String[] ciphers;
        block10: {
            ciphers = null;
            try {
                Map<String, Object> connectionInfo = JaxRsSSLManager.getConnectionInfo(host, port);
                Properties sslProps = JaxRsSSLManager.getSSLProperties(sslRef, connectionInfo);
                SSLContext sslContext = JaxRsSSLManager.getSSLContext(sslRef, connectionInfo, sslProps);
                if (sslContext == null) {
                    return null;
                }
                String cipherString = sslProps.getProperty("com.ibm.ssl.enabledCipherSuites");
                try {
                    if (cipherString != null) {
                        ciphers = cipherString.split("\\s+");
                        break block10;
                    }
                    String securityLevel = sslProps.getProperty("com.ibm.ssl.securityLevel");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("securityLevel from properties is " + securityLevel), (Object[])new Object[0]);
                    }
                    if (securityLevel == null) {
                        securityLevel = "HIGH";
                    }
                    ciphers = Constants.adjustSupportedCiphersToSecurityLevel((String[])sslContext.createSSLEngine().getEnabledCipherSuites(), (String)securityLevel);
                }
                catch (Exception securityLevel) {
                    FFDCFilter.processException((Throwable)securityLevel, (String)"com.ibm.ws.jaxrs20.appsecurity.security.JaxRsSSLManager", (String)"121", null, (Object[])new Object[]{sslRef, host, port});
                    if (tc.isDebugEnabled()) {
                        void e;
                        Tr.debug((TraceComponent)tc, (String)"Exception getting ciphers.", (Object[])new Object[]{e});
                    }
                }
            }
            catch (SSLException connectionInfo) {
                FFDCFilter.processException((Throwable)connectionInfo, (String)"com.ibm.ws.jaxrs20.appsecurity.security.JaxRsSSLManager", (String)"125", null, (Object[])new Object[]{sslRef, host, port});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)("configClientSSL failed to get the supported SSL ciphers with exception: " + e.toString()), (Object[])new Object[0]);
                }
                return null;
            }
        }
        return ciphers;
    }

    /*
     * WARNING - void declaration
     */
    public static String[] getSSLProtocolsBySSLRef(String sslRef, String host, String port) {
        String[] protocolList = null;
        try {
            ArrayList<String> list = new ArrayList<String>();
            Map<String, Object> connectionInfo = JaxRsSSLManager.getConnectionInfo(host, port);
            Properties sslProps = JaxRsSSLManager.getSSLProperties(sslRef, connectionInfo);
            String cfgProtocolValue = sslProps.getProperty("com.ibm.ssl.protocol");
            if (cfgProtocolValue != null) {
                String[] protocols;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("protocols from config are " + cfgProtocolValue), (Object[])new Object[0]);
                }
                for (String protocol : protocols = cfgProtocolValue.split(",")) {
                    if (!Constants.MULTI_PROTOCOL_LIST.contains(protocol)) continue;
                    list.add(protocol);
                }
                if (!list.isEmpty()) {
                    protocolList = list.toArray(new String[list.size()]);
                }
            }
        }
        catch (SSLException list) {
            FFDCFilter.processException((Throwable)list, (String)"com.ibm.ws.jaxrs20.appsecurity.security.JaxRsSSLManager", (String)"165", null, (Object[])new Object[]{sslRef, host, port});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("configClientSSL failed to get the SSL protocol with exception: " + e.toString()), (Object[])new Object[0]);
            }
            return null;
        }
        return protocolList;
    }

    private static Map<String, Object> getConnectionInfo(String host, String port) {
        HashMap<String, Object> connectionInfo = new HashMap<String, Object>();
        connectionInfo.put("com.ibm.ssl.direction", "outbound");
        connectionInfo.put("com.ibm.ssl.remoteHost", host);
        connectionInfo.put("com.ibm.ssl.remotePort", port);
        return connectionInfo;
    }

    /*
     * WARNING - void declaration
     */
    private static Properties getSSLProperties(final String sslRef, final Map<String, Object> connectionInfo) throws SSLException {
        Properties sslProps;
        try {
            sslProps = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){
                static final long serialVersionUID = 703621746367519474L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Properties run() throws SSLException {
                    return jsseHelper.getProperties(sslRef, connectionInfo, null);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs20.appsecurity.security.JaxRsSSLManager$1", 1.class, (String)"com.ibm.ws.jaxrs20.appsecurity", null);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void pae;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.jaxrs20.appsecurity.security.JaxRsSSLManager", (String)"193", null, (Object[])new Object[]{sslRef, connectionInfo});
            Throwable cause = pae.getCause();
            throw (SSLException)cause;
        }
        return sslProps;
    }

    /*
     * WARNING - void declaration
     */
    private static SSLContext getSSLContext(final String sslRef, Map<String, Object> connectionInfo, Properties sslProps) throws SSLException {
        Boolean sslCfgExists = null;
        if (sslRef != null) {
            try {
                sslCfgExists = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){
                    static final long serialVersionUID = 8787405917918590621L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Boolean run() throws SSLException {
                        return jsseHelper.doesSSLConfigExist(sslRef);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs20.appsecurity.security.JaxRsSSLManager$2", 2.class, (String)"com.ibm.ws.jaxrs20.appsecurity", null);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                void pae;
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.jaxrs20.appsecurity.security.JaxRsSSLManager", (String)"212", null, (Object[])new Object[]{sslRef, connectionInfo, sslProps});
                Throwable cause = pae.getCause();
                throw (SSLException)cause;
            }
            if (!sslCfgExists.booleanValue()) {
                return null;
            }
        }
        return jsseHelper.getSSLContext(connectionInfo, sslProps);
    }
}

