/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.io.smallrye.graphql.component;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.io.smallrye.graphql.component.ConfigFacade;
import com.ibm.ws.io.smallrye.graphql.ui.GraphiQLUIServlet;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.logging.Introspector;
import graphql.schema.GraphQLSchema;
import io.smallrye.graphql.bootstrap.Bootstrap;
import io.smallrye.graphql.cdi.config.GraphQLConfig;
import io.smallrye.graphql.execution.ExecutionService;
import io.smallrye.graphql.execution.SchemaPrinter;
import io.smallrye.graphql.schema.SchemaBuilder;
import io.smallrye.graphql.schema.model.Argument;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.Schema;
import io.smallrye.graphql.servlet.ExecutionServlet;
import io.smallrye.graphql.servlet.IndexInitializer;
import io.smallrye.graphql.servlet.SchemaServlet;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import org.jboss.jandex.IndexView;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(property={"service.vendor=IBM"})
public class GraphQLServletContainerInitializer
implements ServletContainerInitializer,
Introspector {
    private static final TraceComponent tc = Tr.register(GraphQLServletContainerInitializer.class, (String)"GraphQL", (String)"com.ibm.ws.io.smallrye.graphql.SmallRyeGraphQL");
    private static Map<ClassLoader, DiagnosticsBag> diagnostics = new WeakHashMap<ClassLoader, DiagnosticsBag>();
    public static final String EXECUTION_SERVLET_NAME = "ExecutionServlet";
    public static final String SCHEMA_SERVLET_NAME = "SchemaServlet";
    public static final String UI_SERVLET_NAME = "UIServlet";
    static final long serialVersionUID = -2571174331173896776L;

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    @FFDCIgnore(value={Throwable.class})
    public void onStartup(Set<Class<?>> classes, ServletContext ctx) throws ServletException {
        SchemaPrinter printer;
        GraphQLConfig config;
        URL webinfClassesUrl;
        block18: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"onStartup", (Object[])new Object[]{classes, ctx, ctx.getServletContextName(), ctx.getContextPath()});
            }
            DiagnosticsBag diagBag = diagnostics.computeIfAbsent(ctx.getClassLoader(), k -> new DiagnosticsBag());
            webinfClassesUrl = null;
            try {
                String realPath = ctx.getRealPath("/WEB-INF/classes");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("realPath: " + realPath), (Object[])new Object[0]);
                }
                if (realPath != null) {
                    webinfClassesUrl = Paths.get(realPath, new String[0]).toUri().toURL();
                }
            }
            catch (MalformedURLException realPath) {
                void ex;
                FFDCFilter.processException((Throwable)realPath, (String)"com.ibm.ws.io.smallrye.graphql.component.GraphQLServletContainerInitializer", (String)"84", (Object)this, (Object[])new Object[]{classes, ctx});
                throw new ServletException("Unable to find classes in webapp, " + ctx.getServletContextName(), (Throwable)ex);
            }
            if (webinfClassesUrl == null && ctx instanceof WebApp) {
                WebApp wapp = (WebApp)WebApp.class.cast(ctx);
                try {
                    NonPersistentCache overlayCache = (NonPersistentCache)wapp.getModuleContainer().adapt(NonPersistentCache.class);
                    ModuleInfo moduleInfo = (ModuleInfo)overlayCache.getFromCache(ModuleInfo.class);
                    String containerPhysicalPath = moduleInfo.getContainer().getPhysicalPath();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("moduleInfo.getContainer().getPhysicalPath() == " + containerPhysicalPath), (Object[])new Object[0]);
                    }
                    if (containerPhysicalPath == null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Cannot find app path, will not process for GraphQL APIs", (Object[])new Object[0]);
                        }
                        return;
                    }
                    Path containerPath = Paths.get(containerPhysicalPath, new String[0]);
                    Path webinfClassesPath = containerPath.resolve("WEB-INF").resolve("classes");
                    webinfClassesUrl = Files.exists(webinfClassesPath, new LinkOption[0]) ? webinfClassesPath.toUri().toURL() : containerPath.toUri().toURL();
                    diagBag.appName = wapp.getApplicationName();
                }
                catch (Exception overlayCache) {
                    void ex;
                    FFDCFilter.processException((Throwable)overlayCache, (String)"com.ibm.ws.io.smallrye.graphql.component.GraphQLServletContainerInitializer", (String)"113", (Object)this, (Object[])new Object[]{classes, ctx});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block18;
                    Tr.debug((TraceComponent)tc, (String)"Failed to find WEB-INF/classes from container in moduleInfo", (Object[])new Object[]{ex});
                }
            }
        }
        diagBag.webinfClassesUrl = webinfClassesUrl;
        diagBag.config = config = new GraphQLConfig(){
            static final long serialVersionUID = -1565388971934681806L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String getDefaultErrorMessage() {
                return ConfigFacade.getOptionalValue("mp.graphql.defaultErrorMessage", String.class).orElse("Server Error");
            }

            @Override
            public boolean isPrintDataFetcherException() {
                return ConfigFacade.getOptionalValue("mp.graphql.printDataFetcherException", Boolean.TYPE).orElse(false);
            }

            @Override
            public Optional<List<String>> getHideErrorMessageList() {
                return Optional.ofNullable(ConfigFacade.getOptionalValue("mp.graphql.exceptionsBlackList", String.class).map(s -> Arrays.asList(s.split(","))).orElse(null));
            }

            @Override
            public Optional<List<String>> getShowErrorMessageList() {
                return Optional.ofNullable(ConfigFacade.getOptionalValue("mp.graphql.exceptionsWhiteList", String.class).map(s -> Arrays.asList(s.split(","))).orElse(null));
            }

            @Override
            public boolean isAllowGet() {
                return ConfigFacade.getOptionalValue("mp.graphql.allowGet", Boolean.TYPE).orElse(false);
            }

            @Override
            @FFDCIgnore(value={Throwable.class})
            public boolean isMetricsEnabled() {
                try {
                    return null != Class.forName("org.eclipse.microprofile.metrics.SimpleTimer");
                }
                catch (Throwable t) {
                    return false;
                }
            }

            @Override
            public <T> T getConfigValue(String key, Class<T> type, T defaultValue) {
                if ("smallrye.graphql.metrics.enabled".equals(key)) {
                    return (T)Boolean.TRUE;
                }
                return super.getConfigValue(key, type, defaultValue);
            }

            @Override
            public Optional<List<String>> getUnwrapExceptions() {
                Optional<List<String>> unwrapExceptions = super.getUnwrapExceptions();
                return unwrapExceptions == null ? Optional.empty() : unwrapExceptions;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.io.smallrye.graphql.component.GraphQLServletContainerInitializer$1", 1.class, (String)"GraphQL", (String)"com.ibm.ws.io.smallrye.graphql.SmallRyeGraphQL");
            }
        };
        GraphQLSchema graphQLSchema = null;
        try {
            IndexInitializer indexInitializer = new IndexInitializer();
            IndexView index = indexInitializer.createIndex(Collections.singleton(webinfClassesUrl));
            Schema schema = SchemaBuilder.build(index);
            if (schema == null || !schema.hasQueries() && !schema.hasMutations()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("No GraphQL components found in app: " + ctx.getServletContextName()), (Object[])new Object[0]);
                }
                diagnostics.remove(ctx.getClassLoader());
                return;
            }
            diagBag.modelSchema = schema;
            graphQLSchema = Bootstrap.bootstrap(schema, config);
        }
        catch (Throwable t) {
            Tr.error((TraceComponent)tc, (String)"ERROR_GENERATING_SCHEMA_CWMGQ0001E", (Object[])new Object[]{ctx.getServletContextName()});
            throw new ServletException(t);
        }
        diagBag.graphQLSchema = graphQLSchema;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SmallRye GraphQL initialized", (Object[])new Object[0]);
        }
        ctx.setAttribute("io.smallrye.graphql.servlet.bootstrap", (Object)graphQLSchema);
        ExecutionService executionService = new ExecutionService(config, graphQLSchema, null);
        String path = "/" + ConfigFacade.getOptionalValue("mp.graphql.contextpath", String.class).filter(s -> s.replaceAll("/", "").length() > 0).orElse("graphql");
        ExecutionServlet execServlet = new ExecutionServlet(executionService, config);
        ServletRegistration.Dynamic execServletReg = ctx.addServlet(EXECUTION_SERVLET_NAME, (Servlet)execServlet);
        execServletReg.addMapping(new String[]{path + "/*"});
        diagBag.schemaPrinter = printer = new SchemaPrinter(config);
        ServletRegistration.Dynamic schemaServletReg = ctx.addServlet(SCHEMA_SERVLET_NAME, (Servlet)new SchemaServlet(printer));
        schemaServletReg.addMapping(new String[]{path + "/schema.graphql"});
        boolean enableGraphQLUIServlet = ConfigFacade.getOptionalValue("io.openliberty.enableGraphQLUI", Boolean.TYPE).orElse(false);
        if (enableGraphQLUIServlet) {
            GraphiQLUIServlet uiServlet = new GraphiQLUIServlet();
            ServletRegistration.Dynamic uiServletReg = ctx.addServlet(UI_SERVLET_NAME, (Servlet)uiServlet);
            uiServletReg.addMapping(new String[]{"/graphql-ui"});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"onStartup");
        }
    }

    public String getIntrospectorName() {
        return "MPGraphQLIntrospector";
    }

    public String getIntrospectorDescription() {
        return "Diagnostics for GraphQL Applications - schema, model, etc.";
    }

    public void introspect(PrintWriter out) throws Exception {
        for (DiagnosticsBag bag : diagnostics.values()) {
            out.println();
            out.println(bag);
            out.println();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class DiagnosticsBag {
        private static String LS;
        String appName;
        URL webinfClassesUrl;
        GraphQLConfig config;
        GraphQLSchema graphQLSchema;
        SchemaPrinter schemaPrinter;
        Schema modelSchema;
        static final long serialVersionUID = 6026513501362577294L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private DiagnosticsBag() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Diagnostics for ").append(this.appName != null ? this.appName : "unknown app").append(" at location: ");
            sb.append(this.webinfClassesUrl).append(LS);
            sb.append("Config:").append(LS);
            if (this.config == null) {
                sb.append("  null").append(LS);
            } else {
                sb.append("  ").append("defaultErrorMessage: ").append(this.config.getDefaultErrorMessage()).append(LS);
                sb.append("  ").append("printDataFetcherException: ").append(this.config.isPrintDataFetcherException()).append(LS);
                sb.append("  ").append("hideErrorMessageList: ").append(this.config.getHideErrorMessageList()).append(LS);
                sb.append("  ").append("showErrorMessageList: ").append(this.config.getShowErrorMessageList()).append(LS);
                sb.append("  ").append("allowGet: ").append(this.config.isAllowGet()).append(LS);
                sb.append("  ").append("metricsEnabled: ").append(this.config.isMetricsEnabled()).append(LS);
            }
            sb.append("Schema:").append(LS);
            if (this.schemaPrinter == null || this.graphQLSchema == null) {
                sb.append("  null").append(LS);
            } else {
                sb.append(this.schemaPrinter.print(this.graphQLSchema)).append(LS);
            }
            sb.append("Model schema:").append(LS);
            if (this.modelSchema == null) {
                sb.append("  null").append(LS);
            } else {
                sb.append("  Queries:").append(LS);
                for (Operation query : this.modelSchema.getQueries()) {
                    sb.append("    ").append(DiagnosticsBag.toString(query)).append(LS);
                }
                sb.append("  Mutations:").append(LS);
                for (Operation mutation : this.modelSchema.getMutations()) {
                    sb.append("    ").append(DiagnosticsBag.toString(mutation)).append(LS);
                }
                sb.append("  Types:").append(LS);
                for (String typeName : this.modelSchema.getTypes().keySet()) {
                    sb.append("    ").append(typeName).append(LS);
                }
                sb.append("  Inputs:").append(LS);
                for (String inputName : this.modelSchema.getInputs().keySet()) {
                    sb.append("    ").append(inputName).append(LS);
                }
                sb.append("  Interfaces:").append(LS);
                for (String interfaceName : this.modelSchema.getInterfaces().keySet()) {
                    sb.append("    ").append(interfaceName).append(LS);
                }
                sb.append("  Enums:").append(LS);
                for (String enumName : this.modelSchema.getEnums().keySet()) {
                    sb.append("    ").append(enumName).append(LS);
                }
            }
            return sb.toString();
        }

        static String toString(Operation o) {
            List<Argument> arguments;
            String description;
            StringBuilder sb = new StringBuilder();
            sb.append(o.getName()).append(" ").append(o.getClassName()).append(" (prop ").append(o.getPropertyName()).append(") (method ").append(o.getMethodName()).append(") ");
            if (o.isNotNull()) {
                sb.append("NOT_NULL ");
            }
            if (o.hasDefaultValue()) {
                sb.append("DefaultValue = ").append(o.getDefaultValue()).append(" ");
            }
            if ((description = o.getDescription()) != null) {
                sb.append("Description: ").append(o.getDescription());
            }
            if ((arguments = o.getArguments()) != null) {
                sb.append("Arguments: ");
                for (Argument arg : arguments) {
                    if (arg.isSourceArgument()) {
                        sb.append("@Source ");
                    }
                    sb.append(arg.getName()).append(", ");
                }
            }
            return sb.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.io.smallrye.graphql.component.GraphQLServletContainerInitializer$DiagnosticsBag", DiagnosticsBag.class, (String)"GraphQL", (String)"com.ibm.ws.io.smallrye.graphql.SmallRyeGraphQL");
            LS = System.lineSeparator();
        }
    }
}

