/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import graphql.GraphQLContext;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.bootstrap.Config;
import io.smallrye.graphql.execution.context.SmallRyeBatchLoaderContextProvider;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.execution.datafetcher.helper.ArgumentHelper;
import io.smallrye.graphql.execution.datafetcher.helper.BatchLoaderHelper;
import io.smallrye.graphql.execution.event.EventEmitter;
import io.smallrye.graphql.schema.model.Operation;
import java.util.concurrent.CompletableFuture;
import org.dataloader.DataLoader;

public class BatchDataFetcher<T>
implements DataFetcher<T> {
    private final Operation operation;
    private final EventEmitter eventEmitter;
    private final ArgumentHelper argumentHelper;
    private final String batchLoaderName;
    private final BatchLoaderHelper batchLoaderHelper = new BatchLoaderHelper();

    public BatchDataFetcher(Operation operation, Config config) {
        this.operation = operation;
        this.eventEmitter = EventEmitter.getInstance(config);
        this.argumentHelper = new ArgumentHelper(operation.getArguments());
        this.batchLoaderName = this.batchLoaderHelper.getName(operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(DataFetchingEnvironment dfe) throws Exception {
        GraphQLContext graphQLContext = (GraphQLContext)dfe.getContext();
        SmallRyeContext context = ((SmallRyeContext)graphQLContext.get((Object)"context")).withDataFromFetcher(dfe, this.operation);
        this.eventEmitter.fireBeforeDataFetch(context);
        Object[] transformedArguments = this.argumentHelper.getArguments(dfe, true);
        Object source = dfe.getSource();
        DataLoader dataLoader = dfe.getDataLoader(this.batchLoaderName);
        SmallRyeBatchLoaderContextProvider.getForDataLoader(dataLoader).set(context);
        try {
            SmallRyeContext.setContext(context);
            CompletableFuture completableFuture = dataLoader.load(source, (Object)transformedArguments);
            return (T)completableFuture;
        }
        finally {
            SmallRyeContext.remove();
        }
    }
}

