/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.clients.common;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.common.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.ssl.NoSSLSocketFactoryException;
import com.ibm.ws.security.openidconnect.client.jose4j.util.Jose4jUtil;
import com.ibm.ws.security.openidconnect.clients.common.AuthorizationCodeHandler;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OidcAuthenticationResponseValidator;
import com.ibm.ws.security.openidconnect.clients.common.OidcAuthorizationRequest;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientRequest;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientUtil;
import com.ibm.ws.security.openidconnect.clients.common.UserInfoHelper;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.CookieHelper;
import com.ibm.ws.webcontainer.security.PostParameterHelper;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import com.ibm.ws.webcontainer.security.WebAppSecurityCollaboratorImpl;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.wsspi.ssl.SSLSupport;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import io.openliberty.security.oidcclientcore.exceptions.AuthenticationResponseException;
import io.openliberty.security.oidcclientcore.http.OidcClientHttpUtil;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OIDCClientAuthenticatorUtil {
    public static final TraceComponent tc = Tr.register(OIDCClientAuthenticatorUtil.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
    SSLSupport sslSupport = null;
    private Jose4jUtil jose4jUtil = null;
    private static int badStateCount = 0;
    public static final String[] OIDC_COOKIES = new String[]{"WASOidcState", "WASReqURLOidc", "WASOidcCode", "WASOidcNonce"};
    static final long serialVersionUID = -3028069554852938144L;

    public OIDCClientAuthenticatorUtil() {
    }

    public OIDCClientAuthenticatorUtil(SSLSupport sslspt) {
        this.sslSupport = sslspt;
        this.jose4jUtil = this.getJose4jUtil(this.sslSupport);
    }

    protected Jose4jUtil getJose4jUtil(SSLSupport sslSupport) {
        return new Jose4jUtil(sslSupport);
    }

    public ProviderAuthenticationResult handleRedirectToServer(HttpServletRequest req, HttpServletResponse res, ConvergedClientConfig clientConfig) {
        OidcAuthorizationRequest authzRequestHelper = new OidcAuthorizationRequest(req, res, clientConfig);
        return authzRequestHelper.sendRequest();
    }

    public ProviderAuthenticationResult authenticate(HttpServletRequest req, HttpServletResponse res, ConvergedClientConfig clientConfig) {
        if (!this.isAuthorizationEndpointConfigured(clientConfig)) {
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_NULL_AUTH_ENDPOINT", (Object[])new Object[]{clientConfig.getClientId()});
            return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        boolean isImplicit = "implicit".equals(clientConfig.getGrantType());
        String responseState = null;
        Hashtable<String, String> reqParameters = new Hashtable<String, String>();
        String encodedReqParams = CookieHelper.getCookieValue((Cookie[])req.getCookies(), (String)"WASOidcCode");
        OidcClientUtil.invalidateReferrerURLCookie(req, res, "WASOidcCode");
        if (encodedReqParams != null && !encodedReqParams.isEmpty()) {
            boolean validCookie = this.validateReqParameters(clientConfig, reqParameters, encodedReqParams);
            if (validCookie) {
                responseState = reqParameters.get("state");
            } else {
                Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_BAD_PARAM_COOKIE", (Object[])new Object[]{encodedReqParams, clientConfig.getClientId()});
                return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
            }
        }
        return this.processAuthenticateRequest(req, res, clientConfig, isImplicit, responseState, reqParameters);
    }

    ProviderAuthenticationResult processAuthenticateRequest(HttpServletRequest req, HttpServletResponse res, ConvergedClientConfig clientConfig, boolean isImplicit, String responseState, Hashtable<String, String> reqParameters) {
        ProviderAuthenticationResult oidcResult;
        boolean stateValid = true;
        if (responseState != null) {
            this.addTokensToRequestParameters(req, reqParameters);
            stateValid = this.verifyState(req, res, clientConfig, responseState);
        }
        if (responseState == null || !stateValid) {
            if (tc.isDebugEnabled()) {
                if (!stateValid) {
                    Tr.debug((TraceComponent)tc, (String)"*** redirect to server because state is not valid", (Object[])new Object[0]);
                }
                if (responseState == null) {
                    Tr.debug((TraceComponent)tc, (String)"*** redirect to server because responseState is null", (Object[])new Object[0]);
                }
            }
            oidcResult = this.handleRedirectToServer(req, res, clientConfig);
        } else if (isImplicit) {
            oidcResult = this.handleImplicitFlowTokens(req, res, responseState, clientConfig, reqParameters);
        } else {
            String authzCode = reqParameters.get("code");
            oidcResult = this.redirectToServerOrProcessAuthorizationCode(req, res, clientConfig, authzCode, responseState);
        }
        if (oidcResult.getStatus() != AuthResult.REDIRECT_TO_PROVIDER) {
            this.restorePostParametersAndInvalidateCookies(req, res);
        }
        return oidcResult;
    }

    void addTokensToRequestParameters(HttpServletRequest req, Hashtable<String, String> reqParameters) {
        String access_token;
        String id_token = req.getParameter("id_token");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("id_token:" + id_token), (Object[])new Object[0]);
        }
        if (id_token != null) {
            reqParameters.put("id_token", id_token);
        }
        if ((access_token = req.getParameter("access_token")) != null) {
            reqParameters.put("access_token", access_token);
        }
        if (req.getMethod().equals("POST") && req instanceof IExtendedRequest) {
            ((IExtendedRequest)req).setMethod("GET");
        }
    }

    @FFDCIgnore(value={AuthenticationResponseException.class})
    boolean verifyState(HttpServletRequest req, HttpServletResponse res, ConvergedClientConfig clientConfig, String responseState) {
        int n;
        OidcAuthenticationResponseValidator responseValidator = new OidcAuthenticationResponseValidator(req, res);
        boolean stateValid = false;
        try {
            responseValidator.verifyState(responseState, clientConfig.getClientId(), clientConfig.getClientSecret(), clientConfig.getClockSkewInSeconds(), clientConfig.getAuthenticationTimeLimitInSeconds());
            stateValid = true;
        }
        catch (AuthenticationResponseException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught exception verifying state: " + (Object)((Object)e)), (Object[])new Object[0]);
            }
            stateValid = false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Early check of state returns " + stateValid), (Object[])new Object[0]);
        }
        if (stateValid) {
            n = 0;
        } else {
            int n2 = badStateCount;
            n = n2;
            badStateCount = n2 + 1;
        }
        badStateCount = n;
        if (badStateCount > 5) {
            stateValid = true;
            badStateCount = 0;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Got too many bad states, set to true and let the flow fail", (Object[])new Object[0]);
            }
        }
        return stateValid;
    }

    ProviderAuthenticationResult redirectToServerOrProcessAuthorizationCode(HttpServletRequest req, HttpServletResponse res, ConvergedClientConfig clientConfig, String authzCode, String responseState) {
        ProviderAuthenticationResult oidcResult;
        AuthorizationCodeHandler authzCodeHandler = new AuthorizationCodeHandler(req, res, clientConfig, this.sslSupport);
        if (authzCodeHandler.isAuthCodeReused(authzCode)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"*** redirect to server because authcode is reused", (Object[])new Object[0]);
            }
            oidcResult = this.handleRedirectToServer(req, res, clientConfig);
        } else {
            oidcResult = authzCodeHandler.handleAuthorizationCode(authzCode, responseState);
        }
        return oidcResult;
    }

    void restorePostParametersAndInvalidateCookies(HttpServletRequest req, HttpServletResponse res) {
        WebAppSecurityConfig webAppSecConfig = WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig();
        PostParameterHelper pph = new PostParameterHelper(webAppSecConfig);
        pph.restore(req, res, true);
        OidcClientUtil.invalidateReferrerURLCookies(req, res, OIDC_COOKIES);
    }

    ProviderAuthenticationResult handleImplicitFlowTokens(HttpServletRequest req, HttpServletResponse res, String responseState, ConvergedClientConfig clientConfig, Hashtable<String, String> reqParameters) {
        OidcClientRequest oidcClientRequest = (OidcClientRequest)req.getAttribute("com.ibm.wsspi.security.oidc.client.request");
        ProviderAuthenticationResult oidcResult = this.verifyResponseState(req, res, responseState, clientConfig);
        if (oidcResult != null) {
            return oidcResult;
        }
        oidcClientRequest.setTokenType("ID Token");
        oidcResult = this.jose4jUtil.createResultWithJose4J(responseState, reqParameters, clientConfig, oidcClientRequest);
        if (clientConfig.getUserInfoEndpointUrl() != null) {
            this.getUserInfo(clientConfig, reqParameters, oidcClientRequest, oidcResult);
        }
        return oidcResult;
    }

    /*
     * WARNING - void declaration
     */
    void getUserInfo(ConvergedClientConfig clientConfig, Hashtable<String, String> reqParameters, OidcClientRequest oidcClientRequest, ProviderAuthenticationResult oidcResult) {
        SSLSocketFactory sslSocketFactory;
        block3: {
            boolean needHttps = clientConfig.getUserInfoEndpointUrl().toLowerCase().startsWith("https");
            sslSocketFactory = null;
            try {
                sslSocketFactory = new OidcClientHttpUtil().getSSLSocketFactory(clientConfig.getSSLConfigurationName(), this.sslSupport);
            }
            catch (SSLException sSLException) {
                void e;
                FFDCFilter.processException((Throwable)sSLException, (String)"com.ibm.ws.security.openidconnect.clients.common.OIDCClientAuthenticatorUtil", (String)"249", (Object)this, (Object[])new Object[]{clientConfig, reqParameters, oidcClientRequest, oidcResult});
                Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_HTTPS_WITH_SSLCONTEXT_NULL", (Object[])new Object[]{e, clientConfig.getClientId()});
            }
            catch (NoSSLSocketFactoryException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.openidconnect.clients.common.OIDCClientAuthenticatorUtil", (String)"251", (Object)this, (Object[])new Object[]{clientConfig, reqParameters, oidcClientRequest, oidcResult});
                if (!needHttps) break block3;
                Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_HTTPS_WITH_SSLCONTEXT_NULL", (Object[])new Object[]{"Null ssl socket factory", clientConfig.getClientId()});
            }
        }
        new UserInfoHelper(clientConfig, this.sslSupport).getUserInfoIfPossible(oidcResult, reqParameters, sslSocketFactory, oidcClientRequest);
    }

    public static boolean checkHttpsRequirement(ConvergedClientConfig clientConfig, String urlStr) {
        boolean metHttpsRequirement = true;
        if (clientConfig.isHttpsRequired()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Checking if URL starts with https: " + urlStr), (Object[])new Object[0]);
            }
            if (urlStr != null && !urlStr.startsWith("https")) {
                metHttpsRequirement = false;
            }
        }
        return metHttpsRequirement;
    }

    public boolean isAuthorizationEndpointConfigured(ConvergedClientConfig clientConfig) {
        return clientConfig.getAuthorizationEndpointUrl() != null;
    }

    public static String setRedirectUrlIfNotDefined(HttpServletRequest req, ConvergedClientConfig clientConfig) {
        String redirect_url = null;
        redirect_url = clientConfig.isSocial() ? OIDCClientAuthenticatorUtil.getRedirectUrlFromServerToClient(clientConfig.getId(), clientConfig.getContextPath(), clientConfig.getRedirectUrlFromServerToClient()) : clientConfig.getRedirectUrlFromServerToClient();
        if (redirect_url == null || redirect_url.isEmpty()) {
            String uri = clientConfig.getContextPath() + "/redirect/" + clientConfig.getId();
            redirect_url = new OidcClientUtil().getRedirectUrl(req, uri);
        }
        redirect_url = clientConfig.getRedirectUrlWithJunctionPath(redirect_url);
        return redirect_url;
    }

    /*
     * WARNING - void declaration
     */
    public static String getRedirectUrlFromServerToClient(String clientId, String contextPath, String redirectToRPHostAndPort) {
        String redirectURL;
        block5: {
            redirectURL = null;
            if (redirectToRPHostAndPort != null && redirectToRPHostAndPort.length() > 0) {
                try {
                    final String fHostPort = redirectToRPHostAndPort;
                    URL url = (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){
                        static final long serialVersionUID = -513975806075385149L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        public Object run() throws Exception {
                            return new URL(fHostPort);
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.openidconnect.clients.common.OIDCClientAuthenticatorUtil$1", 1.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
                        }
                    });
                    int port = url.getPort();
                    String path = url.getPath();
                    if (path == null) {
                        path = "";
                    }
                    if (path.endsWith("/")) {
                        path = path.substring(0, path.length() - 1);
                    }
                    String entryPoint = path + contextPath + "/redirect/" + clientId;
                    redirectURL = url.getProtocol() + "://" + url.getHost() + (port > 0 ? ":" + port : "");
                    redirectURL = redirectURL + (entryPoint.startsWith("/") ? "" : "/") + entryPoint;
                }
                catch (Exception fHostPort) {
                    void e;
                    FFDCFilter.processException((Throwable)fHostPort, (String)"com.ibm.ws.security.openidconnect.clients.common.OIDCClientAuthenticatorUtil", (String)"319", null, (Object[])new Object[]{clientId, contextPath, redirectToRPHostAndPort});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)tc, (String)("the value of redirectToRPHostAndPort might not valid. Please verify that the format is <protocol>://<host>:<port> " + redirectToRPHostAndPort + "\n" + e), (Object[])new Object[0]);
                }
            }
        }
        return redirectURL;
    }

    public static String getResources(ConvergedClientConfig clientConfig) {
        String[] resources = clientConfig.getResources();
        String result = null;
        if (resources != null && resources.length > 0) {
            result = "";
            for (int iI = 0; iI < resources.length; ++iI) {
                if (iI > 0) {
                    result = result.concat(" ");
                }
                result = result.concat(resources[iI]);
            }
        }
        return result;
    }

    @FFDCIgnore(value={IndexOutOfBoundsException.class})
    public boolean validateReqParameters(ConvergedClientConfig clientConfig, Hashtable<String, String> reqParameters, String cookieValue) {
        boolean validCookie;
        block3: {
            validCookie = true;
            try {
                String encoded = this.extractEncodedValueFromCodeCookie(clientConfig, cookieValue);
                if (encoded != null) {
                    validCookie = this.populateHashtableFromEncodedCookieValue(reqParameters, encoded);
                }
            }
            catch (IndexOutOfBoundsException e) {
                validCookie = false;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"unexpected exception:", (Object[])new Object[]{e});
            }
        }
        return validCookie;
    }

    String extractEncodedValueFromCodeCookie(ConvergedClientConfig clientConfig, String cookieValue) {
        int lastindex = cookieValue.lastIndexOf("_");
        if (lastindex < 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The cookie may have been tampered with.", (Object[])new Object[0]);
                if (lastindex < 0) {
                    Tr.debug((TraceComponent)tc, (String)"The cookie does not contain an underscore.", (Object[])new Object[0]);
                }
                if (lastindex == 0) {
                    Tr.debug((TraceComponent)tc, (String)"The cookie does not contain a value before the underscore.", (Object[])new Object[0]);
                }
            }
            return null;
        }
        String encoded = cookieValue.substring(0, lastindex);
        String testCookie = OidcClientUtil.addSignatureToStringValue(encoded, clientConfig);
        if (!cookieValue.equals(testCookie)) {
            String cookieName = "WASOidcCode";
            String msg = "The value for the OIDC state cookie [" + cookieName + "] failed validation.";
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
            }
            return null;
        }
        return encoded;
    }

    boolean populateHashtableFromEncodedCookieValue(Hashtable<String, String> reqParameters, String encoded) {
        String requestParameters = Base64Coder.toString((byte[])Base64Coder.base64DecodeString((String)encoded));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("decodedRequestParameters:" + requestParameters), (Object[])new Object[0]);
        }
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(requestParameters);
        Set entries = jsonObject.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if (element.isJsonObject() || element.isJsonPrimitive()) {
                reqParameters.put(key, element.getAsString());
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("parameterKey:" + key + "  value:" + element.getAsString()), (Object[])new Object[0]);
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("unexpected json element:" + element.getClass().getName()), (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    @FFDCIgnore(value={AuthenticationResponseException.class})
    public ProviderAuthenticationResult verifyResponseState(HttpServletRequest req, HttpServletResponse res, String responseState, ConvergedClientConfig clientConfig) {
        boolean bValidState = false;
        if (responseState != null) {
            OidcAuthenticationResponseValidator responseValidator = new OidcAuthenticationResponseValidator(req, res);
            try {
                responseValidator.verifyState(responseState, clientConfig.getClientId(), clientConfig.getClientSecret(), clientConfig.getClockSkewInSeconds(), clientConfig.getAuthenticationTimeLimitInSeconds());
                bValidState = true;
            }
            catch (AuthenticationResponseException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Caught exception verifying state: " + (Object)((Object)e)), (Object[])new Object[0]);
                }
                bValidState = false;
            }
        }
        if (!bValidState) {
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_RESPONSE_STATE_ERR", (Object[])new Object[]{responseState, clientConfig.getClientId()});
            return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        return null;
    }

    public static String getIssuerIdentifier(ConvergedClientConfig clientConfig) {
        String issuer = null;
        issuer = clientConfig.getIssuerIdentifier();
        if (issuer == null || issuer.isEmpty()) {
            issuer = OIDCClientAuthenticatorUtil.extractIssuerFromTokenEndpointUrl(clientConfig);
        }
        return issuer;
    }

    static String extractIssuerFromTokenEndpointUrl(ConvergedClientConfig clientConfig) {
        String issuer = null;
        String tokenEndpoint = clientConfig.getTokenEndpointUrl();
        if (tokenEndpoint != null) {
            int endOfSchemeIndex = tokenEndpoint.indexOf("//");
            int lastSlashIndex = tokenEndpoint.lastIndexOf("/");
            boolean urlContainsScheme = endOfSchemeIndex > -1;
            boolean urlContainsSlash = lastSlashIndex > -1;
            issuer = !urlContainsScheme && !urlContainsSlash || urlContainsScheme && lastSlashIndex == endOfSchemeIndex + 1 ? tokenEndpoint : tokenEndpoint.substring(0, lastSlashIndex);
        }
        return issuer;
    }
}

