/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.clients.common;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientUtil;
import com.ibm.ws.webcontainer.security.CookieHelper;
import java.util.Objects;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OidcSessionInfo {
    private static final TraceComponent tc = Tr.register(OidcSessionInfo.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
    private static String DELIMITER = ":";
    private final String sessionId;
    private final String configId;
    private final String iss;
    private final String sub;
    private final String sid;
    private final String timestamp;
    static final long serialVersionUID = 1303566599828579098L;

    public OidcSessionInfo(String configId, String iss, String sub, String sid, String timestamp, ConvergedClientConfig clientConfig) {
        this.configId = configId != null ? configId : "";
        this.iss = iss != null ? iss : "";
        this.sub = sub != null ? sub : "";
        this.sid = sid != null ? sid : "";
        this.timestamp = timestamp != null ? timestamp : "";
        this.sessionId = this.createSessionId(clientConfig);
    }

    public static OidcSessionInfo getSessionInfo(HttpServletRequest request, ConvergedClientConfig clientConfig) {
        String sessionId = OidcSessionInfo.getSessionIdFromCookies(request.getCookies());
        if (sessionId == null || sessionId.isEmpty()) {
            return null;
        }
        String sessionIdWithoutHash = sessionId.split("_")[0];
        String testSessionId = OidcClientUtil.addSignatureToStringValue(sessionIdWithoutHash, clientConfig);
        if (!testSessionId.equals(sessionId)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The cookie may have been tampered with.", (Object[])new Object[0]);
            }
            return null;
        }
        String[] parts = sessionIdWithoutHash.split(DELIMITER);
        if (parts.length != 5) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The cookie may have been tampered with.", (Object[])new Object[0]);
            }
            return null;
        }
        String configId = new String(Base64.decodeBase64((String)parts[0]));
        String iss = new String(Base64.decodeBase64((String)parts[1]));
        String sub = new String(Base64.decodeBase64((String)parts[2]));
        String sid = new String(Base64.decodeBase64((String)parts[3]));
        String timestamp = new String(Base64.decodeBase64((String)parts[4]));
        return new OidcSessionInfo(configId, iss, sub, sid, timestamp, clientConfig);
    }

    private static String getSessionIdFromCookies(Cookie[] cookies) {
        return CookieHelper.getCookieValue((Cookie[])cookies, (String)"WASOidcSession");
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getConfigId() {
        return this.configId;
    }

    public String getIss() {
        return this.iss;
    }

    public String getSub() {
        return this.sub;
    }

    public String getSid() {
        return this.sid;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return this.sessionId;
    }

    private String createSessionId(ConvergedClientConfig clientConfig) {
        String encodedConfigId = new String(Base64.encodeBase64((byte[])this.configId.getBytes()));
        String encodedIss = new String(Base64.encodeBase64((byte[])this.iss.getBytes()));
        String encodedSub = new String(Base64.encodeBase64((byte[])this.sub.getBytes()));
        String encodedSid = new String(Base64.encodeBase64((byte[])this.sid.getBytes()));
        String encodedTimestamp = new String(Base64.encodeBase64((byte[])this.timestamp.getBytes()));
        String sessionId = String.join((CharSequence)DELIMITER, encodedConfigId, encodedIss, encodedSub, encodedSid, encodedTimestamp);
        return OidcClientUtil.addSignatureToStringValue(sessionId, clientConfig);
    }

    public int hashCode() {
        return Objects.hash(this.configId, this.iss, this.sid, this.sub, this.timestamp);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OidcSessionInfo other = (OidcSessionInfo)obj;
        return Objects.equals(this.configId, other.configId) && Objects.equals(this.iss, other.iss) && Objects.equals(this.sid, other.sid) && Objects.equals(this.sub, other.sub) && Objects.equals(this.timestamp, other.timestamp);
    }
}

