/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.clients.common.token.auth;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.token.auth.TokenEndpointAuthMethod;
import com.ibm.ws.security.openidconnect.clients.common.token.auth.TokenEndpointAuthMethodSettingsException;
import com.ibm.ws.ssl.KeyStoreService;
import io.openliberty.security.oidcclientcore.token.TokenRequestor;
import java.security.Key;
import java.security.PrivateKey;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PrivateKeyJwtAuthMethod
extends TokenEndpointAuthMethod {
    public static final TraceComponent tc = Tr.register(PrivateKeyJwtAuthMethod.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
    public static final String AUTH_METHOD = "private_key_jwt";
    private final ConvergedClientConfig clientConfig;
    static final long serialVersionUID = -8360915252970547004L;

    public PrivateKeyJwtAuthMethod(ConvergedClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    @Sensitive
    public static PrivateKey getPrivateKeyForClientAuthentication(String clientId, String keyAliasName, String keyStoreRef, KeyStoreService keyStoreService) throws Exception {
        if (keyAliasName == null || keyAliasName.isEmpty()) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"PRIVATE_KEY_JWT_MISSING_KEY_ALIAS_NAME", (Object[])new Object[]{clientId});
            throw new Exception(errorMsg);
        }
        if (keyStoreRef == null || keyStoreRef.isEmpty()) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"PRIVATE_KEY_JWT_MISSING_KEYSTORE_REF", (Object[])new Object[]{clientId});
            throw new Exception(errorMsg);
        }
        return keyStoreService.getPrivateKeyFromKeyStore(keyStoreRef, keyAliasName, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setAuthMethodSpecificSettings(TokenRequestor.Builder tokenRequestBuilder) throws TokenEndpointAuthMethodSettingsException {
        try {
            tokenRequestBuilder.clientAssertionSigningAlgorithm(this.clientConfig.getTokenEndpointAuthSigningAlgorithm());
            tokenRequestBuilder.clientAssertionSigningKey((Key)this.clientConfig.getPrivateKeyForClientAuthentication());
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.clients.common.token.auth.PrivateKeyJwtAuthMethod", (String)"52", (Object)this, (Object[])new Object[]{tokenRequestBuilder});
            throw new TokenEndpointAuthMethodSettingsException(this.clientConfig.getClientId(), this.clientConfig.getTokenEndpointAuthMethod(), e.getMessage());
        }
    }
}

