/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics.internal.monitor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics.internal.monitor.internal.MappingTable;
import io.openliberty.microprofile.metrics.internal.monitor.internal.MonitorMetrics;
import io.openliberty.microprofile.metrics50.SharedMetricRegistries;
import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="io.openliberty.microprofile.metrics.internal.monitor.MonitorMetricsHandler", property={"service.vendor=IBM"})
public class MonitorMetricsHandler {
    private static final TraceComponent tc = Tr.register(MonitorMetricsHandler.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.monitor.resources.MonitorMetrics");
    protected SharedMetricRegistries sharedMetricRegistry;
    protected ExecutorService execServ;
    protected MappingTable mappingTable;
    protected Set<MonitorMetrics> metricsSet = new HashSet<MonitorMetrics>();
    protected NotificationListener listener;
    static final long serialVersionUID = -6647936241512955768L;

    @Activate
    protected void activate(ComponentContext context) {
        this.mappingTable = MappingTable.getInstance();
        this.register();
        this.addMBeanListener();
        Tr.info((TraceComponent)tc, (String)"FEATURE_REGISTERED", (Object[])new Object[0]);
    }

    @Reference
    public void setSharedMetricRegistries(SharedMetricRegistries sharedMetricRegistry) {
        this.sharedMetricRegistry = sharedMetricRegistry;
    }

    public void unsetSharedMetricRegistries(SharedMetricRegistries sharedMetricRegistry) {
        this.sharedMetricRegistry = null;
    }

    @Reference
    public void setExecutorService(ExecutorService execServ) {
        this.execServ = execServ;
    }

    public void unsetExecutorService(ExecutorService execServ) {
        this.execServ = null;
    }

    /*
     * WARNING - void declaration
     */
    @Deactivate
    protected void deactivate(ComponentContext context) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (this.listener != null) {
            block3: {
                try {
                    mbs.removeNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this.listener);
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.microprofile.metrics.internal.monitor.MonitorMetricsHandler", (String)"87", (Object)this, (Object[])new Object[]{context});
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)"deactivate exception message: ", (Object[])new Object[]{e.getMessage()});
                    FFDCFilter.processException((Throwable)e, (String)this.getClass().getSimpleName(), (String)"deactivate:Exception");
                }
            }
            this.listener = null;
        }
        Tr.info((TraceComponent)tc, (String)"FEATURE_UNREGISTERED", (Object[])new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    protected void addMBeanListener() {
        block2: {
            this.listener = new NotificationListener(){
                static final long serialVersionUID = 6086641722545172693L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void handleNotification(Notification notification, Object handback) {
                    MBeanServerNotification mbsn = (MBeanServerNotification)notification;
                    String objectName = mbsn.getMBeanName().toString();
                    if ("JMX.mbean.registered".equals(mbsn.getType())) {
                        Tr.debug((TraceComponent)tc, (String)"MBean Registered [", (Object[])new Object[]{objectName + "]"});
                        String[][] data = MonitorMetricsHandler.this.mappingTable.getData(objectName);
                        if (data != null) {
                            MonitorMetricsHandler.this.register(objectName, data);
                        }
                    } else if ("JMX.mbean.unregistered".equals(mbsn.getType())) {
                        Tr.debug((TraceComponent)tc, (String)("MBean Unregistered [" + objectName + "]"), (Object[])new Object[0]);
                        if (MonitorMetricsHandler.this.mappingTable.contains(objectName)) {
                            MonitorMetricsHandler.this.unregister(objectName);
                        }
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.metrics.internal.monitor.MonitorMetricsHandler$1", 1.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.monitor.resources.MonitorMetrics");
                }
            };
            try {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                mbs.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this.listener, null, null);
            }
            catch (InstanceNotFoundException mbs) {
                void e;
                FFDCFilter.processException((Throwable)mbs, (String)"io.openliberty.microprofile.metrics.internal.monitor.MonitorMetricsHandler", (String)"124", (Object)this, (Object[])new Object[0]);
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"getCount exception message: ", (Object[])new Object[]{e.getMessage()});
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getSimpleName(), (String)"addMBeanListener:Exception");
            }
        }
    }

    protected void unregister(String objectName) {
        HashSet<MonitorMetrics> removeSet = new HashSet<MonitorMetrics>();
        for (MonitorMetrics mm : this.metricsSet) {
            if (!mm.getObjectName().equals(objectName)) continue;
            removeSet.add(mm);
            mm.unregisterMetrics(this.sharedMetricRegistry);
            Tr.debug((TraceComponent)tc, (String)("Monitoring MXBean " + objectName + " was unregistered from mpMetrics."), (Object[])new Object[0]);
        }
        this.metricsSet.removeAll(removeSet);
    }

    /*
     * WARNING - void declaration
     */
    protected void register() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        for (String sName : this.mappingTable.getKeys()) {
            try {
                Set<ObjectInstance> mBeanObjectInstanceSet = mbs.queryMBeans(new ObjectName(sName), null);
                if (sName.contains("ThreadPoolStats") && mBeanObjectInstanceSet.isEmpty() && this.execServ != null) {
                    this.execServ.execute(() -> {
                        int MAX_TIME_OUT = 5000;
                        Set<ObjectInstance> mBeanObjectInstanceSetTemp = mBeanObjectInstanceSet;
                        for (int currentTimeOut = 0; mBeanObjectInstanceSetTemp.isEmpty() && currentTimeOut <= 5000; currentTimeOut += 50) {
                            try {
                                Thread.sleep(50L);
                                mBeanObjectInstanceSetTemp = mbs.queryMBeans(new ObjectName(sName), null);
                                continue;
                            }
                            catch (Exception e) {
                                if (!tc.isDebugEnabled()) break;
                                Tr.debug((TraceComponent)tc, (String)"register exception message: ", (Object[])new Object[]{e.getMessage()});
                                FFDCFilter.processException((Throwable)e, (String)MonitorMetricsHandler.class.getSimpleName(), (String)"register:Exception");
                                break;
                            }
                        }
                        this.registerMbeanObjects(mBeanObjectInstanceSetTemp);
                    });
                }
                this.registerMbeanObjects(mBeanObjectInstanceSet);
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.microprofile.metrics.internal.monitor.MonitorMetricsHandler", (String)"178", (Object)this, (Object[])new Object[0]);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"register exception message: ", (Object[])new Object[]{e.getMessage()});
                FFDCFilter.processException((Throwable)e, (String)MonitorMetricsHandler.class.getSimpleName(), (String)"register:Exception");
            }
        }
    }

    private synchronized void registerMbeanObjects(Set<ObjectInstance> mBeanObjectInstanceSet) {
        for (ObjectInstance objInstance : mBeanObjectInstanceSet) {
            String objectName = objInstance.getObjectName().toString();
            String[][] data = this.mappingTable.getData(objectName);
            if (data == null) continue;
            this.register(objectName, data);
        }
    }

    protected void register(String objectName, String[][] data) {
        MonitorMetrics metrics = null;
        if (!this.containMetrics(objectName)) {
            metrics = new MonitorMetrics(objectName);
            metrics.createMetrics(this.sharedMetricRegistry, data);
            this.metricsSet.add(metrics);
            Tr.debug((TraceComponent)tc, (String)("Monitoring MXBean " + objectName + " is registered to mpMetrics."), (Object[])new Object[0]);
        } else {
            Tr.debug((TraceComponent)tc, (String)(objectName + " is already registered."), (Object[])new Object[0]);
        }
    }

    protected boolean containMetrics(String objectName) {
        for (MonitorMetrics mm : this.metricsSet) {
            if (!mm.getObjectName().equals(objectName)) continue;
            return true;
        }
        return false;
    }
}

