/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.container.application;

import com.ibm.ws.jsf.container.JSFContainer;
import com.ibm.ws.jsf.container.Messages;
import com.ibm.ws.jsf.container.application.JSFContainerApplication;
import com.ibm.ws.jsf.container.cdi.CDIJSFInitializer;
import jakarta.faces.application.Application;
import jakarta.faces.application.ApplicationFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JSFContainerApplicationFactory
extends ApplicationFactory {
    private static final String clazz = JSFContainerApplicationFactory.class.getCanonicalName();
    private static final Logger log = Logger.getLogger("com.ibm.ws.jsf.container.application");
    private final ApplicationFactory delegate;
    private final JSFContainer.JSF_PROVIDER providerType;
    private volatile String appName = null;
    private volatile Application application;

    public JSFContainerApplicationFactory() {
        try {
            this.providerType = JSFContainer.getJSFProvider();
            this.delegate = this.providerType == JSFContainer.JSF_PROVIDER.MOJARRA ? (ApplicationFactory)Class.forName("com.sun.faces.application.ApplicationFactoryImpl").newInstance() : (ApplicationFactory)Class.forName("org.apache.myfaces.application.ApplicationFactoryImpl").newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw this.noJsfProviderFound();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Application getApplication() {
        if (this.application == null) {
            JSFContainerApplicationFactory jSFContainerApplicationFactory = this;
            synchronized (jSFContainerApplicationFactory) {
                if (this.application == null) {
                    this.application = this.delegate.getApplication();
                    String m = "getApplication";
                    try {
                        this.appName = (String)InitialContext.doLookup("java:app/AppName");
                    }
                    catch (NamingException e) {
                        throw new RuntimeException(Messages.get("jsf.container.no.app.name", this.application.toString()), e);
                    }
                    if (log.isLoggable(Level.FINEST)) {
                        log.logp(Level.FINEST, clazz, "getApplication", "Performing first time initialization checks on: " + this.appName);
                    }
                    this.serviceabilityChecks();
                    this.application = new JSFContainerApplication(this.application, this.appName);
                    CDIJSFInitializer.initialize(this.application, this.appName);
                    if (JSFContainer.isBeanValidationEnabled()) {
                        JSFContainer.initializeBeanValidation();
                    }
                    if (log.isLoggable(Level.INFO)) {
                        log.logp(Level.INFO, clazz, "getApplication", Messages.get("jsf.container.init", this.providerType.toString(), this.appName));
                    }
                }
            }
        }
        return this.application;
    }

    public void setApplication(Application application) {
        this.delegate.setApplication(application);
    }

    public ApplicationFactory getWrapped() {
        return this.delegate.getWrapped();
    }

    private void serviceabilityChecks() {
        String implVersion;
        Class<?> appFactoryClass;
        String m = "serviceabilityChecks";
        String requiredSpecVersionRange = JSFContainer.getJSFSpecLevel() + ".*";
        String apiVersion = ApplicationFactory.class.getPackage().getSpecificationVersion();
        if (apiVersion != null && !JSFContainerApplicationFactory.isVersionValid(apiVersion)) {
            IllegalStateException ex = new IllegalStateException(Messages.get("jsf.container.bad.spec.api.version", this.appName, requiredSpecVersionRange, apiVersion));
            if (log.isLoggable(Level.SEVERE)) {
                log.logp(Level.SEVERE, clazz, "serviceabilityChecks", ex.getMessage(), ex);
            }
            throw ex;
        }
        for (appFactoryClass = this.delegate.getClass(); appFactoryClass != Object.class && !appFactoryClass.getCanonicalName().equals("org.apache.myfaces.application.ApplicationFactoryImpl") && !appFactoryClass.getCanonicalName().equals("com.sun.faces.application.ApplicationFactoryImpl"); appFactoryClass = appFactoryClass.getSuperclass()) {
        }
        String appFactoryClassName = appFactoryClass.getCanonicalName();
        if ((appFactoryClassName.equals("org.apache.myfaces.application.ApplicationFactoryImpl") || appFactoryClassName.equals("com.sun.faces.application.ApplicationFactoryImpl")) && (implVersion = appFactoryClass.getPackage().getSpecificationVersion()) != null && !JSFContainerApplicationFactory.isVersionValid(implVersion)) {
            IllegalStateException ex = new IllegalStateException(Messages.get("jsf.container.bad.impl.version", this.appName, requiredSpecVersionRange, implVersion));
            if (log.isLoggable(Level.SEVERE)) {
                log.logp(Level.SEVERE, clazz, "serviceabilityChecks", ex.getMessage(), ex);
            }
            throw ex;
        }
    }

    private static boolean isVersionValid(String version) {
        String specLevel = JSFContainer.getJSFSpecLevel();
        return version.equals(specLevel) || version.startsWith(specLevel + ".");
    }

    private IllegalStateException noJsfProviderFound() {
        String message = Messages.get("jsf.container.no.jsf.impl", this.appName, "[ com.sun.faces.application.ApplicationFactoryImpl, org.apache.myfaces.application.ApplicationFactoryImpl ]");
        IllegalStateException e = new IllegalStateException(message);
        if (log.isLoggable(Level.SEVERE)) {
            log.logp(Level.SEVERE, clazz, "noJsfProviderFound", message, e);
        }
        return e;
    }
}

