/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml.multi;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchema;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.ehcache.config.Configuration;
import org.ehcache.xml.ConfigurationParser;
import org.ehcache.xml.XmlConfiguration;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.ehcache.xml.multi.model.Configurations;
import org.ehcache.xml.multi.model.ObjectFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XmlMultiConfiguration {
    private static final URL MULTI_SCHEMA_URL = XmlMultiConfiguration.class.getResource("/ehcache-multi.xsd");
    private static final QName MULTI_SCHEMA_ROOT_NAME = new QName(Configurations.class.getPackage().getAnnotation(XmlSchema.class).namespace(), Configurations.class.getAnnotation(XmlRootElement.class).name());
    private final Map<String, Config> configurations;
    private final Document document;
    private final String renderedDocument;

    private XmlMultiConfiguration(URL url, BiFunction<String, Document, XmlConfiguration> configParser) throws XmlConfigurationException {
        try {
            Schema schema = ConfigurationParser.discoverSchema(new StreamSource(XmlConfiguration.CORE_SCHEMA_URL.openStream()), new StreamSource(MULTI_SCHEMA_URL.openStream()));
            DocumentBuilder domBuilder = ConfigurationParser.documentBuilder(schema);
            this.document = domBuilder.parse(url.toExternalForm());
            this.renderedDocument = ConfigurationParser.urlToText(url, this.document.getInputEncoding());
            Element rootElement = this.document.getDocumentElement();
            QName rootName = new QName(rootElement.getNamespaceURI(), rootElement.getLocalName());
            if (!MULTI_SCHEMA_ROOT_NAME.equals(rootName)) {
                throw new XmlConfigurationException("Expecting " + MULTI_SCHEMA_ROOT_NAME + " element; found " + rootName);
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Configurations.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Configurations value = (Configurations)unmarshaller.unmarshal((Node)rootElement, Configurations.class).getValue();
            this.configurations = value.getConfiguration().stream().collect(Collectors.toMap(Configurations.Configuration::getIdentity, c -> {
                List<Object> configOrVariant = c.getConfigOrVariant();
                if (configOrVariant.size() == 1 && configOrVariant.get(0) instanceof Node) {
                    Document configDoc = domBuilder.newDocument();
                    configDoc.appendChild(configDoc.importNode((Element)configOrVariant.get(0), true));
                    return new SingleConfig((Configuration)configParser.apply(c.getIdentity(), configDoc));
                }
                return new VariantConfig(configOrVariant.stream().map(e -> (JAXBElement)e).map(JAXBElement::getValue).collect(Collectors.toMap(Configurations.Configuration.Variant::getType, v -> {
                    Document configDoc = domBuilder.newDocument();
                    configDoc.appendChild(configDoc.importNode(v.getConfig(), true));
                    return (Configuration)configParser.apply(c.getIdentity(), configDoc);
                })));
            }));
        }
        catch (JAXBException | IOException | ParserConfigurationException | SAXException e) {
            throw new XmlConfigurationException(e);
        }
    }

    private XmlMultiConfiguration(Map<String, Config> configurations) {
        try {
            Schema schema = ConfigurationParser.discoverSchema(new StreamSource(XmlConfiguration.CORE_SCHEMA_URL.openStream()), new StreamSource(MULTI_SCHEMA_URL.openStream()));
            this.configurations = configurations;
            ObjectFactory objectFactory = new ObjectFactory();
            Configurations jaxb = objectFactory.createConfigurations().withConfiguration(configurations.entrySet().stream().map(entry -> objectFactory.createConfigurationsConfiguration().withIdentity((String)entry.getKey()).withConfigOrVariant(((Config)entry.getValue()).unparse(objectFactory))).collect(Collectors.toList()));
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Configurations.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setSchema(schema);
            this.document = ConfigurationParser.documentBuilder(schema).newDocument();
            marshaller.marshal((Object)jaxb, (Node)this.document);
            this.renderedDocument = ConfigurationParser.documentToText(this.document);
        }
        catch (JAXBException | IOException | ParserConfigurationException | TransformerException | SAXException e) {
            throw new XmlConfigurationException(e);
        }
    }

    public Configuration configuration(String identity) throws IllegalArgumentException {
        Config variants = this.configurations.get(identity);
        if (variants == null) {
            return null;
        }
        return variants.configuration();
    }

    public Configuration configuration(String identity, String variant) {
        Config config = this.configurations.get(identity);
        if (config == null) {
            return null;
        }
        return config.configuration(variant);
    }

    public Set<String> variants(String identity) throws IllegalArgumentException {
        Config config = this.configurations.get(identity);
        if (config == null) {
            throw new IllegalArgumentException("Identity " + identity + " does not exist.");
        }
        return config.variants();
    }

    public Set<String> identities() {
        return Collections.unmodifiableSet(this.configurations.keySet());
    }

    public Document asDocument() {
        return this.document;
    }

    public String asRenderedDocument() {
        return this.renderedDocument;
    }

    public String toString() {
        return this.asRenderedDocument();
    }

    private static Element unparseEhcacheConfiguration(Configuration config) {
        if (config instanceof XmlConfiguration) {
            return ((XmlConfiguration)config).asDocument().getDocumentElement();
        }
        return new XmlConfiguration(config).asDocument().getDocumentElement();
    }

    public static Builder from(URL xml) {
        return XmlMultiConfiguration.from(new XmlMultiConfiguration(xml, (identity, dom) -> new XmlConfiguration((Document)dom)));
    }

    public static Builder from(URL xml, ClassLoader classLoader) {
        return XmlMultiConfiguration.from(new XmlMultiConfiguration(xml, (identity, dom) -> new XmlConfiguration((Document)dom, classLoader)));
    }

    public static Builder from(final XmlMultiConfiguration config) {
        return new Builder(){

            @Override
            public Builder withManager(String identity, Configuration configuration) {
                HashMap<String, SingleConfig> configurations = new HashMap<String, SingleConfig>(config.configurations);
                configurations.put(identity, new SingleConfig(configuration));
                return XmlMultiConfiguration.from(new XmlMultiConfiguration(configurations));
            }

            @Override
            public Builder withoutManager(String identity) {
                Map configurations = config.configurations;
                configurations.remove(identity);
                return XmlMultiConfiguration.from(new XmlMultiConfiguration(configurations));
            }

            @Override
            public Variant withManager(final String identity) {
                final HashMap variants = new HashMap();
                Config current = (Config)config.configurations.get(identity);
                if (current instanceof VariantConfig) {
                    variants.putAll(((VariantConfig)current).configs);
                } else if (current != null) {
                    throw new IllegalStateException("Existing non-variant configuration cannot be replaced - it must be removed first.");
                }
                return new Variant(){

                    @Override
                    public Variant withoutVariant(String variant) {
                        variants.remove(variant);
                        return this;
                    }

                    @Override
                    public Variant variant(String variant, Configuration configuration) {
                        variants.put(variant, configuration);
                        return this;
                    }

                    @Override
                    public Builder withoutManager(String identity2) {
                        return XmlMultiConfiguration.from(this.build()).withoutManager(identity2);
                    }

                    @Override
                    public Builder withManager(String identity2, Configuration configuration) {
                        return XmlMultiConfiguration.from(this.build()).withManager(identity2, configuration);
                    }

                    @Override
                    public Variant withManager(String identity2) {
                        return XmlMultiConfiguration.from(this.build()).withManager(identity2);
                    }

                    @Override
                    public XmlMultiConfiguration build() {
                        HashMap<String, VariantConfig> configurations = new HashMap<String, VariantConfig>(config.configurations);
                        configurations.put(identity, new VariantConfig(variants));
                        return new XmlMultiConfiguration(configurations);
                    }
                };
            }

            @Override
            public XmlMultiConfiguration build() {
                return config;
            }
        };
    }

    public static Builder fromNothing() {
        return XmlMultiConfiguration.from(new XmlMultiConfiguration(Collections.emptyMap()));
    }

    public static interface Variant
    extends Builder {
        public Variant withoutVariant(String var1);

        public Variant variant(String var1, Configuration var2);

        default public Variant variant(String variant, org.ehcache.config.Builder<? extends Configuration> builder) {
            return this.variant(variant, builder.build());
        }
    }

    public static interface Builder {
        public Builder withoutManager(String var1);

        public Builder withManager(String var1, Configuration var2);

        default public Builder withManager(String identity, org.ehcache.config.Builder<? extends Configuration> builder) {
            return this.withManager(identity, builder.build());
        }

        public Variant withManager(String var1);

        public XmlMultiConfiguration build();
    }

    private static class VariantConfig
    implements Config {
        private final Map<String, Configuration> configs;

        private VariantConfig(Map<String, Configuration> configs) {
            this.configs = configs;
        }

        @Override
        public Configuration configuration() {
            switch (this.configs.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return this.configs.values().iterator().next();
                }
            }
            throw new IllegalStateException("Please choose a variant: " + this.configs.keySet());
        }

        @Override
        public Configuration configuration(String variant) {
            Configuration configuration = this.configs.get(variant);
            if (configuration == null) {
                throw new IllegalArgumentException("Please choose a valid variant: " + this.configs.keySet());
            }
            return configuration;
        }

        @Override
        public Collection<Object> unparse(ObjectFactory factory) {
            return this.configs.entrySet().stream().map(v -> factory.createConfigurationsConfigurationVariant().withType((String)v.getKey()).withConfig(XmlMultiConfiguration.unparseEhcacheConfiguration((Configuration)v.getValue()))).map(factory::createConfigurationsConfigurationVariant).collect(Collectors.toList());
        }

        @Override
        public Set<String> variants() {
            return Collections.unmodifiableSet(this.configs.keySet());
        }
    }

    private static class SingleConfig
    implements Config {
        private final Configuration config;

        private SingleConfig(Configuration config) {
            this.config = config;
        }

        @Override
        public Configuration configuration() {
            return this.config;
        }

        @Override
        public Configuration configuration(String variant) {
            return this.configuration();
        }

        @Override
        public Collection<Object> unparse(ObjectFactory factory) {
            return Collections.singleton(XmlMultiConfiguration.unparseEhcacheConfiguration(this.config));
        }

        @Override
        public Set<String> variants() {
            return Collections.emptySet();
        }
    }

    private static interface Config {
        public Configuration configuration() throws IllegalStateException;

        public Configuration configuration(String var1);

        public Collection<Object> unparse(ObjectFactory var1);

        public Set<String> variants();
    }
}

