/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CacheObject
implements Serializable {
    private static transient TraceComponent tc = Tr.register(CacheObject.class, null, null);
    private static final long serialVersionUID = -2299564519252837462L;
    private transient Subject subject;
    private final List<Object> lookupKeys = Collections.synchronizedList(new ArrayList(8));
    private final short serializationVersion = 1;

    public CacheObject(Subject subject) {
        this.subject = subject;
    }

    public void addLookupKey(Object key) {
        if (key != null) {
            this.lookupKeys.add(key);
        }
    }

    public List<Object> getLookupKeys() {
        return this.lookupKeys;
    }

    public Subject getSubject() {
        return this.subject;
    }

    private void readObject(ObjectInputStream input) throws ClassNotFoundException, IOException {
        input.defaultReadObject();
        boolean subjectReadOnly = input.readBoolean();
        Set subjectPrincipals = (Set)input.readObject();
        Set subjectPubCreds = (Set)input.readObject();
        Set subjectPrivCreds = (Set)input.readObject();
        this.subject = new Subject(subjectReadOnly, subjectPrincipals, subjectPubCreds, subjectPrivCreds);
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        output.writeBoolean(this.subject.isReadOnly());
        output.writeObject(new HashSet<Principal>(this.subject.getPrincipals()));
        output.writeObject(new HashSet<Object>(this.subject.getPublicCredentials()));
        output.writeObject(new HashSet<Object>(this.subject.getPrivateCredentials()));
    }
}

