/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy.mtom;

import com.ibm.websphere.ras.annotation.Sensitive;
import java.util.Collection;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.mtom.MetadataConstants;

public class MTOMPolicyInterceptor
extends AbstractPhaseInterceptor<Message> {
    public MTOMPolicyInterceptor() {
        super("post-logical");
    }

    public void handleMessage(@Sensitive Message message) throws Fault {
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        if (aim != null) {
            Collection ais = (Collection)aim.get(MetadataConstants.MTOM_ASSERTION_QNAME);
            for (AssertionInfo ai : ais) {
                if (MessageUtils.isRequestor((Message)message)) {
                    message.put((Object)"mtom-enabled", (Object)Boolean.TRUE);
                    ai.setAsserted(true);
                    continue;
                }
                String contentType = (String)message.getExchange().getInMessage().get((Object)"Content-Type");
                if (contentType == null || !contentType.contains("type=\"application/xop+xml\"")) continue;
                ai.setAsserted(true);
                message.put((Object)"mtom-enabled", (Object)Boolean.TRUE);
            }
        }
    }
}

