/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.util;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class JAXBUtils {
    private JAXBUtils() {
    }

    private static Node innerJaxbBinding(Element schema) {
        String schemaNamespace = schema.getNamespaceURI();
        List annoList = DOMUtils.findAllElementsByTagNameNS((Element)schema, (String)schemaNamespace, (String)"annotation");
        Element annotation = null;
        annotation = !annoList.isEmpty() ? (Element)annoList.get(0) : schema.getOwnerDocument().createElementNS(schemaNamespace, "annotation");
        List appList = DOMUtils.findAllElementsByTagNameNS((Element)annotation, (String)schemaNamespace, (String)"appinfo");
        Element appInfo = null;
        if (!appList.isEmpty()) {
            appInfo = (Element)appList.get(0);
        } else {
            appInfo = schema.getOwnerDocument().createElementNS(schemaNamespace, "appinfo");
            annotation.appendChild(appInfo);
        }
        Element jaxbBindings = null;
        List jaxbList = DOMUtils.findAllElementsByTagNameNS((Element)schema, (String)"https://jakarta.ee/xml/ns/jaxb", (String)"schemaBindings");
        if (!jaxbList.isEmpty()) {
            jaxbBindings = (Element)jaxbList.get(0);
        } else {
            jaxbBindings = schema.getOwnerDocument().createElementNS("https://jakarta.ee/xml/ns/jaxb", "schemaBindings");
            appInfo.appendChild(jaxbBindings);
        }
        return jaxbBindings;
    }

    public static Node innerJaxbPackageBinding(Element schema, String packagevalue) {
        Document doc = schema.getOwnerDocument();
        if (!DOMUtils.hasAttribute((Element)schema, (String)"https://jakarta.ee/xml/ns/jaxb")) {
            Attr attr = schema.getOwnerDocument().createAttributeNS("https://jakarta.ee/xml/ns/jaxb", "version");
            attr.setValue("2.0");
            schema.setAttributeNodeNS(attr);
        }
        Node schemaBindings = JAXBUtils.innerJaxbBinding(schema);
        List pkgList = DOMUtils.findAllElementsByTagNameNS((Element)schema, (String)"https://jakarta.ee/xml/ns/jaxb", (String)"package");
        Element packagename = null;
        packagename = !pkgList.isEmpty() ? (Element)pkgList.get(0) : doc.createElementNS("https://jakarta.ee/xml/ns/jaxb", "package");
        packagename.setAttributeNS(null, "name", packagevalue);
        schemaBindings.appendChild(packagename);
        return schemaBindings.getParentNode().getParentNode();
    }

    public static File getPackageMappingSchemaBindingFile(String namespace, String pkgName) {
        Document doc = DOMUtils.getEmptyDocument();
        Element rootElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "schema");
        rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2001/XMLSchema");
        rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:jaxb", "https://jakarta.ee/xml/ns/jaxb");
        rootElement.setAttributeNS("https://jakarta.ee/xml/ns/jaxb", "jaxb:version", "2.0");
        rootElement.setAttributeNS(null, "targetNamespace", namespace);
        Element annoElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "annotation");
        Element appInfo = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
        Element schemaBindings = doc.createElementNS("https://jakarta.ee/xml/ns/jaxb", "jaxb:schemaBindings");
        Element pkgElement = doc.createElementNS("https://jakarta.ee/xml/ns/jaxb", "jaxb:package");
        pkgElement.setAttributeNS(null, "name", pkgName);
        annoElement.appendChild(appInfo);
        appInfo.appendChild(schemaBindings);
        schemaBindings.appendChild(pkgElement);
        rootElement.appendChild(annoElement);
        File tmpFile = null;
        try {
            tmpFile = FileUtils.createTempFile((String)"customzied", (String)".xsd");
            try (OutputStream out = Files.newOutputStream(tmpFile.toPath(), new OpenOption[0]);){
                StaxUtils.writeTo((Node)rootElement, (OutputStream)out);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tmpFile;
    }
}

