/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.grpc.internal.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.http2.GrpcServletServices;
import com.ibm.ws.managedobject.ManagedObjectContext;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.grpc.internal.config.GrpcServiceConfigImpl;
import io.openliberty.grpc.internal.servlet.GrpcServerComponent;
import java.util.HashSet;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class GrpcServletApplication {
    private static final TraceComponent tc = Tr.register(GrpcServerComponent.class, (String)"GRPC", (String)"io.openliberty.grpc.internal.resources.grpcmessages");
    private Set<String> serviceNames = new HashSet<String>();
    private Set<String> serviceClassNames = new HashSet<String>();
    private Set<ManagedObjectContext> managedObectContexts = new HashSet<ManagedObjectContext>();
    private String j2eeAppName;
    static final long serialVersionUID = -3682643453112070205L;

    GrpcServletApplication() {
    }

    void addServiceName(String serviceName, String contextPath, Class<?> clazz) {
        this.serviceNames.add(serviceName);
        if (serviceName != null && contextPath != null && clazz != null) {
            GrpcServletServices.addServletGrpcService((String)serviceName, (String)contextPath, clazz, (String)this.j2eeAppName);
        }
    }

    void addServiceClassName(String name) {
        this.serviceClassNames.add(name);
    }

    Set<String> getServiceClassNames() {
        return this.serviceClassNames;
    }

    void setAppName(String name) {
        this.j2eeAppName = name;
        GrpcServiceConfigImpl.addApplication(this.j2eeAppName);
    }

    String getAppName() {
        return this.j2eeAppName;
    }

    void addManagedObjectContext(ManagedObjectContext mo) {
        if (mo != null) {
            this.managedObectContexts.add(mo);
        }
    }

    @ManualTrace
    void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy", (Object[])new Object[]{this});
        }
        for (String service : this.serviceNames) {
            GrpcServletServices.removeServletGrpcService((String)service, (String)this.j2eeAppName);
        }
        if (this.j2eeAppName != null) {
            GrpcServiceConfigImpl.removeApplication(this.j2eeAppName);
        }
        for (ManagedObjectContext mo : this.managedObectContexts) {
            mo.release();
        }
        this.managedObectContexts = null;
        this.serviceNames = null;
        this.serviceClassNames = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GrpcServletApplication [");
        sb.append(" j2eeAppName: " + this.j2eeAppName);
        sb.append(" serviceClassNames: {");
        for (String service : this.serviceClassNames) {
            sb.append(" " + service);
        }
        sb.append(" } serviceNames: {");
        for (String service : this.serviceNames) {
            sb.append(" " + service);
        }
        sb.append(" } ]");
        return sb.toString();
    }
}

