/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal.proxy.extractors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Set;
import org.jboss.resteasy.annotations.Body;
import org.jboss.resteasy.annotations.LinkHeaderParam;
import org.jboss.resteasy.annotations.Status;
import org.jboss.resteasy.client.jaxrs.ProxyConfig;
import org.jboss.resteasy.client.jaxrs.i18n.Messages;
import org.jboss.resteasy.client.jaxrs.internal.proxy.ClientInvoker;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.BodyEntityExtractor;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.ClientContext;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.DefaultEntityExtractorFactory;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.EntityExtractor;
import org.jboss.resteasy.util.IsHttpMethod;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class ResponseObjectEntityExtractorFactory
extends DefaultEntityExtractorFactory {
    static final long serialVersionUID = 3432184795724939758L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    public EntityExtractor createExtractor(Method method) {
        Class<?> returnType = method.getReturnType();
        if (method.isAnnotationPresent(Status.class)) {
            if (returnType == Integer.class || returnType == Integer.TYPE) {
                return new EntityExtractor<Integer>(){
                    static final long serialVersionUID = -8771026980119120249L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Integer extractEntity(ClientContext context, Object ... args) {
                        return context.getClientResponse().getStatus();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.ResponseObjectEntityExtractorFactory$1", 1.class, null, null);
                    }
                };
            }
            if (returnType == Response.Status.class) {
                return ResponseObjectEntityExtractorFactory.createStatusExtractor(false);
            }
        }
        if (method.isAnnotationPresent(Body.class)) {
            return new BodyEntityExtractor(method);
        }
        final HeaderParam headerParam = method.getAnnotation(HeaderParam.class);
        if (headerParam != null) {
            return new EntityExtractor(){
                static final long serialVersionUID = 4189588003043524085L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public Object extractEntity(ClientContext context, Object ... args) {
                    return context.getClientResponse().getHeaderString(headerParam.value());
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.ResponseObjectEntityExtractorFactory$2", 2.class, null, null);
                }
            };
        }
        LinkHeaderParam link = method.getAnnotation(LinkHeaderParam.class);
        if (link != null) {
            return this.processLinkHeader(method, returnType, link);
        }
        if (Response.class.isAssignableFrom(returnType)) {
            return clientResponseExtractor;
        }
        return null;
    }

    private EntityExtractor processLinkHeader(final Method method, Class<?> returnType, final LinkHeaderParam link) {
        if ("".equals(link.rel()) && "".equals(link.title())) {
            throw new RuntimeException(Messages.MESSAGES.mustSetLinkHeaderParam(method.getClass().getName(), method.getName()));
        }
        if (!"".equals(link.rel()) && !"".equals(link.title())) {
            throw new RuntimeException(Messages.MESSAGES.canOnlySetOneLinkHeaderParam(method.getClass().getName(), method.getName()));
        }
        if (returnType == Link.class) {
            return new EntityExtractor(){
                static final long serialVersionUID = 7503166445286925002L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public Object extractEntity(ClientContext context, Object ... args) {
                    return ResponseObjectEntityExtractorFactory.this.getLink(link, context);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.ResponseObjectEntityExtractorFactory$3", 3.class, null, null);
                }
            };
        }
        if (ResponseObjectEntityExtractorFactory.isInvokerMethod(method)) {
            return new EntityExtractor(){
                static final long serialVersionUID = 3002241891960347591L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public Object extractEntity(ClientContext context, Object ... args) {
                    URI uri = ResponseObjectEntityExtractorFactory.this.getURI(method, link, context);
                    if (uri == null) {
                        return null;
                    }
                    return ResponseObjectEntityExtractorFactory.this.createClientInvoker(context, uri, method).invoke(args);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.ResponseObjectEntityExtractorFactory$4", 4.class, null, null);
                }
            };
        }
        if (returnType == String.class) {
            return new EntityExtractor<String>(){
                static final long serialVersionUID = -8604690098210487455L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public String extractEntity(ClientContext context, Object ... args) {
                    Link link2 = ResponseObjectEntityExtractorFactory.this.getLink(link, context);
                    return link2 == null ? null : link2.getUri().toString();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.ResponseObjectEntityExtractorFactory$5", 5.class, null, null);
                }
            };
        }
        if (returnType == URL.class) {
            return new EntityExtractor<URL>(){
                static final long serialVersionUID = 8310736519692382307L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public URL extractEntity(ClientContext context, Object ... args) {
                    return ResponseObjectEntityExtractorFactory.this.getURL(method, link, context);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.ResponseObjectEntityExtractorFactory$6", 6.class, null, null);
                }
            };
        }
        if (returnType == URI.class) {
            return new EntityExtractor<URI>(){
                static final long serialVersionUID = 2128450371708838730L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public URI extractEntity(ClientContext context, Object ... args) {
                    return ResponseObjectEntityExtractorFactory.this.getURI(method, link, context);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.ResponseObjectEntityExtractorFactory$7", 7.class, null, null);
                }
            };
        }
        if (returnType.equals(Invocation.Builder.class)) {
            return new EntityExtractor<Invocation.Builder>(){
                static final long serialVersionUID = 6956609198453705228L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Invocation.Builder extractEntity(ClientContext context, Object ... args) {
                    return context.getInvocation().getClient().target(ResponseObjectEntityExtractorFactory.this.getLink(link, context)).request();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.ResponseObjectEntityExtractorFactory$8", 8.class, null, null);
                }
            };
        }
        if (returnType.equals(WebTarget.class)) {
            return new EntityExtractor<WebTarget>(){
                static final long serialVersionUID = -2562411415170414119L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public WebTarget extractEntity(ClientContext context, Object ... args) {
                    return context.getInvocation().getClient().target(ResponseObjectEntityExtractorFactory.this.getLink(link, context));
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.ResponseObjectEntityExtractorFactory$9", 9.class, null, null);
                }
            };
        }
        return null;
    }

    private ClientInvoker createClientInvoker(ClientContext context, URI uri, Method method) {
        ClientInvoker clientInvoker = new ClientInvoker(context.getInvocation().getClient().target(uri), method.getDeclaringClass(), method, new ProxyConfig(Thread.currentThread().getContextClassLoader(), null, null));
        Set<String> httpMethods = IsHttpMethod.getHttpMethods(method);
        clientInvoker.setHttpMethod(httpMethods.iterator().next());
        return clientInvoker;
    }

    private static boolean isInvokerMethod(Method method) {
        Set<String> httpMethods = IsHttpMethod.getHttpMethods(method);
        return httpMethods != null && httpMethods.size() == 1;
    }

    private Link getLink(LinkHeaderParam link, ClientContext context) {
        return context.getClientResponse().getLink(link.rel());
    }

    private URI getURI(Method method, Link link) {
        if (link == null) {
            return null;
        }
        return link.getUri();
    }

    private URI getURI(Method method, LinkHeaderParam link, ClientContext context) {
        return this.getURI(method, this.getLink(link, context));
    }

    private URL getURL(Method method, LinkHeaderParam link, ClientContext context) {
        URI uri = this.getURI(method, link, context);
        try {
            return uri == null ? null : uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(Messages.MESSAGES.couldNotCreateURL(uri.toASCIIString(), method.getClass().getName(), method.getName()), e);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.ResponseObjectEntityExtractorFactory", ResponseObjectEntityExtractorFactory.class, null, null);
    }
}

