/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.sse.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.ws.rs.ServiceUnavailableException;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.sse.InboundSseEvent;
import jakarta.ws.rs.sse.SseEventSource;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.jboss.resteasy.plugins.providers.sse.SseEventInputImpl;
import org.jboss.resteasy.plugins.providers.sse.client.SseEventSourceScheduler;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class SseEventSourceImpl
implements SseEventSource {
    public static final long RECONNECT_DEFAULT = 500L;
    private final WebTarget target;
    private final long reconnectDelay;
    private final SseEventSourceScheduler sseEventSourceScheduler;
    private final AtomicReference<State> state = new AtomicReference<State>(State.PENDING);
    private final AtomicBoolean completionListenersInvoked = new AtomicBoolean(false);
    private final List<Consumer<InboundSseEvent>> onEventConsumers = new CopyOnWriteArrayList<Consumer<InboundSseEvent>>();
    private final List<Consumer<Throwable>> onErrorConsumers = new CopyOnWriteArrayList<Consumer<Throwable>>();
    private final List<Runnable> onCompleteConsumers = new CopyOnWriteArrayList<Runnable>();
    private final boolean alwaysReconnect;
    private volatile ClientResponse response;
    static final long serialVersionUID = -3626970065656947683L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SseEventSourceImpl(WebTarget target) {
        this(target, true);
    }

    public SseEventSourceImpl(WebTarget target, boolean open) {
        this(target, null, 500L, open, null, true);
    }

    private SseEventSourceImpl(WebTarget target, String name, long reconnectDelay, boolean open, ScheduledExecutorService executor, boolean alwaysReconnect) {
        if (target == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.webTargetIsNotSetForEventSource());
        }
        this.target = target;
        this.reconnectDelay = reconnectDelay;
        this.alwaysReconnect = alwaysReconnect;
        if (executor == null) {
            ScheduledExecutorService scheduledExecutor = null;
            if (target instanceof ResteasyWebTarget) {
                scheduledExecutor = ((ResteasyWebTarget)target).getResteasyClient().getScheduledExecutor();
            }
            this.sseEventSourceScheduler = name != null ? new SseEventSourceScheduler(scheduledExecutor, name) : new SseEventSourceScheduler(scheduledExecutor, String.format("sse-event-source(%s)", target.getUri()));
        } else {
            this.sseEventSourceScheduler = name != null ? new SseEventSourceScheduler(executor, name) : new SseEventSourceScheduler(executor, String.format("sse-event-source(%s)", target.getUri()));
        }
        if (open) {
            this.open();
        }
    }

    public void open() {
        this.open(null);
    }

    public void open(String lastEventId) {
        this.open(lastEventId, "GET", null, MediaType.SERVER_SENT_EVENTS_TYPE);
    }

    public void open(String lastEventId, String verb, Entity<?> entity, MediaType ... mediaTypes) {
        if (!this.state.compareAndSet(State.PENDING, State.OPEN)) {
            throw new IllegalStateException(Messages.MESSAGES.eventSourceIsNotReadyForOpen());
        }
        EventHandler handler = new EventHandler(this.reconnectDelay, lastEventId, verb, entity, mediaTypes);
        this.sseEventSourceScheduler.schedule(handler, 0L, TimeUnit.SECONDS);
        handler.awaitConnected();
    }

    public boolean isOpen() {
        return this.state.get() == State.OPEN;
    }

    public void register(Consumer<InboundSseEvent> onEvent) {
        if (onEvent == null) {
            throw new IllegalArgumentException();
        }
        this.onEventConsumers.add(onEvent);
    }

    public void register(Consumer<InboundSseEvent> onEvent, Consumer<Throwable> onError) {
        if (onEvent == null) {
            throw new IllegalArgumentException();
        }
        if (onError == null) {
            throw new IllegalArgumentException();
        }
        this.onEventConsumers.add(onEvent);
        this.onErrorConsumers.add(onError);
    }

    public void register(Consumer<InboundSseEvent> onEvent, Consumer<Throwable> onError, Runnable onComplete) {
        if (onEvent == null) {
            throw new IllegalArgumentException();
        }
        if (onError == null) {
            throw new IllegalArgumentException();
        }
        if (onComplete == null) {
            throw new IllegalArgumentException();
        }
        this.onEventConsumers.add(onEvent);
        this.onErrorConsumers.add(onError);
        this.onCompleteConsumers.add(onComplete);
    }

    public boolean close(long timeout, TimeUnit unit) {
        this.internalClose();
        try {
            return this.sseEventSourceScheduler.awaitTermination(timeout, unit);
        }
        catch (InterruptedException e) {
            this.onErrorConsumers.forEach(consumer -> consumer.accept(e));
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private void runCompletionListeners() {
        if (!this.completionListenersInvoked.getAndSet(true)) {
            this.onCompleteConsumers.forEach(Runnable::run);
        }
    }

    private void internalClose() {
        if (this.state.getAndSet(State.CLOSED) == State.CLOSED) {
            return;
        }
        ClientResponse clientResponse = this.response;
        if (clientResponse != null) {
            try {
                clientResponse.releaseConnection(false);
            }
            catch (IOException e) {
                this.onErrorConsumers.forEach(consumer -> consumer.accept(e));
            }
        }
        this.sseEventSourceScheduler.shutdownNow();
        this.runCompletionListeners();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.providers.sse.client.SseEventSourceImpl", SseEventSourceImpl.class, null, null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private class EventHandler
    implements Runnable {
        private final CountDownLatch connectedLatch;
        private String lastEventId;
        private long reconnectDelay;
        private String verb;
        private Entity<?> entity;
        private MediaType[] mediaTypes;
        static final long serialVersionUID = 196070737882445290L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        EventHandler(long reconnectDelay, String lastEventId, String verb, Entity<?> entity, MediaType ... mediaTypes) {
            this.connectedLatch = new CountDownLatch(1);
            this.reconnectDelay = reconnectDelay;
            this.lastEventId = lastEventId;
            this.verb = verb;
            this.entity = entity;
            this.mediaTypes = mediaTypes;
        }

        private EventHandler(EventHandler anotherHandler) {
            this.connectedLatch = anotherHandler.connectedLatch;
            this.reconnectDelay = anotherHandler.reconnectDelay;
            this.lastEventId = anotherHandler.lastEventId;
            this.verb = anotherHandler.verb;
            this.entity = anotherHandler.entity;
            this.mediaTypes = anotherHandler.mediaTypes;
        }

        @Override
        public void run() {
            if (SseEventSourceImpl.this.state.get() != State.OPEN) {
                return;
            }
            SseEventInputImpl eventInput = null;
            InboundSseEvent event = null;
            ClientConfiguration providers = (ClientConfiguration)SseEventSourceImpl.this.target.getConfiguration();
            try {
                ClientResponse clientResponse;
                Invocation.Builder requestBuilder = this.buildRequest(this.mediaTypes);
                Invocation request = null;
                request = this.entity == null ? requestBuilder.build(this.verb) : requestBuilder.build(this.verb, this.entity);
                SseEventSourceImpl.this.response = clientResponse = (ClientResponse)request.invoke();
                if (Response.Status.Family.SUCCESSFUL.equals((Object)clientResponse.getStatusInfo().getFamily())) {
                    this.onConnection();
                    if (clientResponse.getStatus() == 204) {
                        SseEventSourceImpl.this.runCompletionListeners();
                        return;
                    }
                    eventInput = clientResponse.readEntity(SseEventInputImpl.class);
                    if (eventInput == null) {
                        if (!SseEventSourceImpl.this.alwaysReconnect) {
                            SseEventSourceImpl.this.runCompletionListeners();
                        } else {
                            this.reconnect(this.reconnectDelay);
                        }
                        return;
                    }
                    event = eventInput.read(providers);
                } else {
                    clientResponse.bufferEntity();
                    ClientInvocation.handleErrorStatus(clientResponse);
                }
            }
            catch (ServiceUnavailableException ex) {
                if (ex.hasRetryAfter()) {
                    try {
                        this.onConnection();
                        Date requestTime = new Date();
                        long localReconnectDelay = ex.getRetryTime(requestTime).getTime() - requestTime.getTime();
                        this.reconnect(localReconnectDelay);
                    }
                    catch (Throwable t) {
                        this.onUnrecoverableError(t);
                    }
                } else {
                    this.onUnrecoverableError(ex);
                }
                return;
            }
            catch (Throwable e) {
                this.onUnrecoverableError(e);
                return;
            }
            while (!Thread.currentThread().isInterrupted() && SseEventSourceImpl.this.state.get() == State.OPEN) {
                if (event == null && eventInput.isClosed()) {
                    this.reconnect(this.reconnectDelay);
                    break;
                }
                if (eventInput != null && eventInput.isClosed()) break;
                try {
                    if (event != null) {
                        this.onEvent(event);
                    } else if (!SseEventSourceImpl.this.alwaysReconnect || eventInput == null || eventInput.isClosed()) {
                        SseEventSourceImpl.this.runCompletionListeners();
                        break;
                    }
                    if ((event = eventInput.read(providers)) != null) continue;
                    SseEventSourceImpl.this.runCompletionListeners();
                }
                catch (IOException e) {
                    this.reconnect(this.reconnectDelay);
                }
                break;
            }
        }

        public void awaitConnected() {
            try {
                this.connectedLatch.await();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }

        private void onConnection() {
            this.connectedLatch.countDown();
        }

        private void onUnrecoverableError(Throwable throwable) {
            this.connectedLatch.countDown();
            SseEventSourceImpl.this.onErrorConsumers.forEach(consumer -> consumer.accept(throwable));
            SseEventSourceImpl.this.internalClose();
        }

        private void onEvent(InboundSseEvent event) {
            if (event.getId() != null) {
                this.lastEventId = event.getId();
            }
            if (event.isReconnectDelaySet()) {
                this.reconnectDelay = event.getReconnectDelay();
            }
            SseEventSourceImpl.this.onEventConsumers.forEach(consumer -> consumer.accept(event));
        }

        private Invocation.Builder buildRequest(MediaType ... mediaTypes) {
            Invocation.Builder request;
            Invocation.Builder builder = request = mediaTypes != null && mediaTypes.length > 0 ? SseEventSourceImpl.this.target.request(mediaTypes) : SseEventSourceImpl.this.target.request();
            if (this.lastEventId != null && !this.lastEventId.isEmpty()) {
                request.header("Last-Event-ID", (Object)this.lastEventId);
            }
            return request;
        }

        private void reconnect(long delay) {
            if (SseEventSourceImpl.this.state.get() != State.OPEN) {
                return;
            }
            EventHandler processor = new EventHandler(this);
            SseEventSourceImpl.this.sseEventSourceScheduler.schedule(processor, delay, TimeUnit.MILLISECONDS);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.providers.sse.client.SseEventSourceImpl$EventHandler", EventHandler.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    public static class SourceBuilder
    extends SseEventSource.Builder {
        private WebTarget target = null;
        private long reconnect = 500L;
        private String name = null;
        private ScheduledExecutorService executor;
        private boolean alwaysReconnect = true;
        static final long serialVersionUID = -7828878481544759670L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public SseEventSource.Builder named(String name) {
            this.name = name;
            return this;
        }

        public SseEventSource build() {
            return new SseEventSourceImpl(this.target, this.name, this.reconnect, false, this.executor, this.alwaysReconnect);
        }

        public SseEventSource.Builder target(WebTarget target) {
            if (target == null) {
                throw new NullPointerException();
            }
            this.target = target;
            return this;
        }

        public SseEventSource.Builder reconnectingEvery(long delay, TimeUnit unit) {
            this.reconnect = unit.toMillis(delay);
            return this;
        }

        public SseEventSource.Builder executor(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public SseEventSource.Builder alwaysReconnect(boolean alwaysReconnect) {
            this.alwaysReconnect = alwaysReconnect;
            return this;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.providers.sse.client.SseEventSourceImpl$SourceBuilder", SourceBuilder.class, null, null);
        }
    }

    private static enum State {
        PENDING,
        OPEN,
        CLOSED;

    }
}

