/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.openidconnect.backchannellogout;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.web.OAuth20Request;
import com.ibm.ws.webcontainer.security.UnprotectedResourceService;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServerConfig;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import com.ibm.wsspi.kernel.service.utils.ServiceAndServiceReferencePair;
import io.openliberty.security.openidconnect.backchannellogout.BackchannelLogoutRequestHelper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={UnprotectedResourceService.class})
public class BackchannelLogoutService
implements UnprotectedResourceService {
    private static TraceComponent tc = Tr.register(BackchannelLogoutService.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
    private static final ConcurrentServiceReferenceSet<OidcServerConfig> oidcServerConfigRef = new ConcurrentServiceReferenceSet("oidcServerConfigService");
    private static final Pattern ACCESS_ID_PATTERN = Pattern.compile("^[^:]+:.*/([^/]+)$");
    static final long serialVersionUID = -993841013725238546L;

    @Reference(name="oidcServerConfigService", service=OidcServerConfig.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected void setOidcClientConfigService(ServiceReference<OidcServerConfig> reference) {
        oidcServerConfigRef.addReference(reference);
    }

    protected void unsetOidcClientConfigService(ServiceReference<OidcServerConfig> reference) {
        oidcServerConfigRef.removeReference(reference);
    }

    public void activate(ComponentContext cc) {
        oidcServerConfigRef.activate(cc);
    }

    public void deactivate(ComponentContext cc) {
        oidcServerConfigRef.deactivate(cc);
    }

    public boolean isAuthenticationRequired(HttpServletRequest request) {
        return false;
    }

    public boolean postLogout(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    public boolean logout(HttpServletRequest request, HttpServletResponse response, String userName) {
        if (userName == null || userName.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The userName is null or empty, so logout will not be performed.", (Object[])new Object[0]);
            }
            return false;
        }
        userName = this.normalizeUserName(userName);
        String requestUri = request.getRequestURI();
        OidcServerConfig oidcServerConfig = this.getMatchingConfig(requestUri);
        if (oidcServerConfig == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Failed to find a matching OIDC provider for the request sent to [" + requestUri + "]"), (Object[])new Object[0]);
            }
            return false;
        }
        String idTokenString = request.getParameter("id_token_hint");
        this.sendBackchannelLogoutRequests(oidcServerConfig, userName, idTokenString);
        return true;
    }

    String normalizeUserName(String userName) {
        Matcher userNameMatcher = ACCESS_ID_PATTERN.matcher(userName);
        if (userNameMatcher.matches()) {
            userName = userNameMatcher.group(1);
        }
        return userName;
    }

    private OidcServerConfig getMatchingConfig(String requestUri) {
        Iterator servicesWithRefs = oidcServerConfigRef.getServicesWithReferences();
        while (servicesWithRefs.hasNext()) {
            ServiceAndServiceReferencePair configServiceAndRef = (ServiceAndServiceReferencePair)servicesWithRefs.next();
            OidcServerConfig config = (OidcServerConfig)configServiceAndRef.getService();
            String configId = config.getProviderId();
            if (!this.isEndpointThatMatchesConfig(requestUri, configId)) continue;
            return config;
        }
        return null;
    }

    boolean isEndpointThatMatchesConfig(String requestUri, String providerId) {
        return requestUri.endsWith("/" + providerId + "/" + OAuth20Request.EndpointType.end_session.name()) || requestUri.endsWith("/" + providerId + "/" + OAuth20Request.EndpointType.logout.name());
    }

    void sendBackchannelLogoutRequests(OidcServerConfig oidcServerConfig, String userName, String idTokenString) {
        BackchannelLogoutRequestHelper bclRequestCreator = new BackchannelLogoutRequestHelper(oidcServerConfig);
        bclRequestCreator.sendBackchannelLogoutRequests(userName, idTokenString);
    }
}

