/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.jfapchannel.AcceptListener;
import com.ibm.ws.sib.jfapchannel.ConnectionClosedListener;
import com.ibm.ws.sib.jfapchannel.ConnectionInterface;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationMetaData;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.ConversationUsageType;
import com.ibm.ws.sib.jfapchannel.HandshakeProperties;
import com.ibm.ws.sib.jfapchannel.JFapByteBuffer;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.jfapchannel.SendListener;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBuffer;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBufferPool;
import com.ibm.ws.sib.jfapchannel.framework.FrameworkException;
import com.ibm.ws.sib.jfapchannel.framework.IOConnectionContext;
import com.ibm.ws.sib.jfapchannel.framework.IOReadRequestContext;
import com.ibm.ws.sib.jfapchannel.framework.IOWriteRequestContext;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnection;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnectionContext;
import com.ibm.ws.sib.jfapchannel.impl.ConnectionReadCompletedCallback;
import com.ibm.ws.sib.jfapchannel.impl.ConnectionWriteCompletedCallback;
import com.ibm.ws.sib.jfapchannel.impl.ConversationImpl;
import com.ibm.ws.sib.jfapchannel.impl.ConversationTable;
import com.ibm.ws.sib.jfapchannel.impl.InternalJFapByteBuffer;
import com.ibm.ws.sib.jfapchannel.impl.JFapUtils;
import com.ibm.ws.sib.jfapchannel.impl.PriorityQueue;
import com.ibm.ws.sib.jfapchannel.impl.eventrecorder.ConnectionEventRecorder;
import com.ibm.ws.sib.jfapchannel.impl.eventrecorder.ConnectionEventRecorderFactory;
import com.ibm.ws.sib.mfp.ConnectionSchemaSet;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;

public abstract class Connection
implements ConnectionInterface {
    private static final TraceComponent tc = SibTr.register(Connection.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    public static final short FIRST_CONVERSATION_ID = 1;
    protected boolean first = true;
    private PriorityQueue priorityQueue = null;
    protected IOConnectionContext tcpCtx = null;
    private IOReadRequestContext tcpReadCtx = null;
    private IOWriteRequestContext tcpWriteCtx = null;
    protected ConversationTable conversationTable = null;
    private ConnectionWriteCompletedCallback writeCompletedCallback = null;
    private ConnectionReadCompletedCallback readCompletedCallback = null;
    private volatile Object userAttachment = null;
    private volatile ConnectionSchemaSet schemaSet = null;
    private AtomicInteger nextRequestNumber = new AtomicInteger();
    private NetworkConnection vc = null;
    protected NetworkConnectionContext connChannel = null;
    private volatile int heartbeatInterval;
    private volatile int heartbeatTimeout;
    private Conversation.ConversationType conversationType = Conversation.UNKNOWN;
    private final Map<ConversationUsageType, ConnectionClosedListener> closeListeners = new EnumMap<ConversationUsageType, ConnectionClosedListener>(ConversationUsageType.class);
    private HandshakeProperties handshakeProperties;
    private final ConnectionEventRecorder eventRecorder;
    private StateHolder state = new StateHolder();
    private final ReadWriteLock stateLock = new ReentrantReadWriteLock();
    private final AtomicInteger threadsSendingData = new AtomicInteger(0);
    private volatile Throwable invalidatePendingThrowable = null;
    private int maxTransmissionSize = 0x100000;
    protected String description = "";
    protected String remoteHostAddress;
    protected String chainName;
    private final boolean logIOEvents;

    private static L obtainLock(Lock lock) {
        lock.lock();
        return lock::unlock;
    }

    public Connection(NetworkConnectionContext channel, NetworkConnection vc, int heartbeatInterval, int heartbeatTimeout) throws FrameworkException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{channel, vc, "" + heartbeatInterval, "" + heartbeatTimeout});
        }
        this.first = true;
        this.priorityQueue = new PriorityQueue();
        this.conversationTable = new ConversationTable();
        if (heartbeatInterval < 0 || heartbeatTimeout < 1) {
            throw new SIErrorException(nls.getFormattedMessage("CONNECTION_INTERNAL_SICJ0043", null, "CONNECTION_INTERNAL_SICJ0043"));
        }
        this.heartbeatInterval = heartbeatInterval;
        this.heartbeatTimeout = heartbeatTimeout;
        this.tcpCtx = channel.getIOContextForDevice();
        if (this.tcpCtx == null) {
            throw new FrameworkException(nls.getFormattedMessage("NETWORK_FAILURE_SICJ0083", null, "NETWORK_FAILURE_SICJ0083"));
        }
        this.tcpReadCtx = this.tcpCtx.getReadInterface();
        this.tcpWriteCtx = this.tcpCtx.getWriteInterface();
        this.connChannel = channel;
        this.vc = vc;
        this.writeCompletedCallback = new ConnectionWriteCompletedCallback(this.priorityQueue, this.tcpWriteCtx, this);
        this.logIOEvents = RuntimeInfo.getProperty((String)"com.ibm.ws.sib.jfapchannel.impl.LOG_IO_TO_FFDC_EVENLOG") != null;
        int numConversationEvents = -1;
        int numConnectionEvents = -1;
        try {
            if (RuntimeInfo.getProperty((String)"com.ibm.ws.sib.jfapchannel.impl.CONNECTION_FFDC_EVENTLOG_SIZE") != null) {
                numConnectionEvents = Integer.parseInt(RuntimeInfo.getProperty((String)"com.ibm.ws.sib.jfapchannel.impl.CONNECTION_FFDC_EVENTLOG_SIZE"));
            }
            if (RuntimeInfo.getProperty((String)"com.ibm.ws.sib.jfapchannel.impl.CONVERSATION_FFDC_EVENTLOG_SIZE") != null) {
                numConversationEvents = Integer.parseInt(RuntimeInfo.getProperty((String)"com.ibm.ws.sib.jfapchannel.impl.CONVERSATION_FFDC_EVENTLOG_SIZE"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.eventRecorder = numConnectionEvents < 0 && numConversationEvents < 0 ? ConnectionEventRecorderFactory.getConnectionEventRecorder() : (numConversationEvents < 0 ? ConnectionEventRecorderFactory.getConnectionEventRecorder(numConnectionEvents) : ConnectionEventRecorderFactory.getConnectionEventRecorder(numConnectionEvents, numConversationEvents));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    protected abstract ConversationImpl startNewConversation(ConversationImpl var1) throws SIResourceException;

    protected ConversationImpl startNewConversationGeneric(ConversationImpl conv, boolean onClientSide, AcceptListener acceptListener) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"startNewConversationGeneric", (Object)new Object[]{conv, onClientSide, acceptListener});
        }
        if (onClientSide) {
            conv.setOnClientSide();
        }
        try (L l = Connection.obtainLock(this.stateLock.readLock());){
            if (this.state.currentState() != State.OPEN) {
                throw new SIResourceException(nls.getFormattedMessage("CONNECTION_CLOSED_SICJ0044", null, "CONNECTION_CLOSED_SICJ0044"));
            }
            this.conversationTable.add(conv);
        }
        if (this.first) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"first conversation for connection");
            }
            this.readCompletedCallback = new ConnectionReadCompletedCallback(this, onClientSide, acceptListener, this.conversationTable, conv, this.tcpCtx);
            if (this.tcpReadCtx.getBuffer() == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"needs new buffer");
                }
                WsByteBuffer buffer = WsByteBufferPool.getInstance().wrap(new byte[1024]);
                this.tcpReadCtx.setBuffer(buffer);
            }
            this.first = false;
            int timeout = 0;
            if (this.heartbeatInterval > 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("setting timeout hint to: " + this.heartbeatInterval * 1000 + " milliseconds"));
                }
                timeout = this.heartbeatInterval * 1000;
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"not setting timeout - heartbeating disabled");
                }
                timeout = -1;
            }
            if (this.tcpReadCtx.getBuffer().remaining() < this.tcpReadCtx.getBuffer().capacity()) {
                this.readCompletedCallback.complete(this.vc, this.tcpReadCtx);
            } else {
                NetworkConnection conn;
                WsByteBuffer readBuffer = this.tcpReadCtx.getBuffer();
                if (!readBuffer.isDirect()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("replacing read buffer with direct version (read buffer = " + readBuffer + ")"));
                    }
                    WsByteBuffer newBuffer = WsByteBufferPool.getInstance().allocateDirect(readBuffer.capacity());
                    int pos = readBuffer.position();
                    int limit = readBuffer.limit();
                    newBuffer.position(0);
                    newBuffer.limit(pos);
                    readBuffer.position(0);
                    readBuffer.limit(pos);
                    newBuffer.put(readBuffer);
                    newBuffer.position(pos);
                    newBuffer.limit(limit);
                    this.tcpReadCtx.setBuffer(newBuffer);
                }
                if (this.logIOEvents) {
                    this.getConnectionEventRecorder().logDebug("invoking readCtx.read() on context " + System.identityHashCode(this.tcpReadCtx) + " with a timeout of " + timeout);
                }
                if ((conn = this.tcpReadCtx.read(1, this.readCompletedCallback, false, timeout)) != null) {
                    this.readCompletedCallback.complete(conn, this.tcpReadCtx);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"startNewConversationGeneric", (Object)conv);
        }
        return conv;
    }

    private final void preSendProcessing(boolean okayIfClosing) throws SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"preSendProcessing", (Object)("" + okayIfClosing));
        }
        try (L l = Connection.obtainLock(this.stateLock.readLock());){
            if (this.state.currentState() != State.OPEN && (!okayIfClosing || this.state.currentState() != State.CLOSE_IN_PROGRESS && this.state.currentState() != State.INVALIDATE_NOTIFYING_PEER_IN_PROGRESS)) {
                throw new SIConnectionDroppedException(nls.getFormattedMessage("CONNECTION_CLOSED_SICJ0044", null, "CONNECTION_CLOSED_SICJ0044"));
            }
            this.threadsSendingData.incrementAndGet();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"preSendProcessing");
        }
    }

    private final void postSendProcessing() {
        Optional<Object> previousState;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"postSendProcessing");
        }
        try (L l = Connection.obtainLock(this.stateLock.writeLock());){
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("state = " + this.state + ", threadsSendingData=" + this.threadsSendingData));
            }
            if (this.threadsSendingData.decrementAndGet() == 0) {
                switch (this.state.currentState()) {
                    case CLOSE_PENDING: 
                    case CLOSE_NOTIFYING_PEER_PENDING: {
                        previousState = Optional.of(this.state.currentState());
                        this.state.changeState((State)((Object)previousState.get()), State.CLOSE_IN_PROGRESS);
                        break;
                    }
                    case INVALIDATE_PENDING: {
                        previousState = Optional.of(this.state.currentState());
                        this.state.changeState((State)((Object)previousState.get()), State.INVALIDATE_IN_PROGRESS);
                        break;
                    }
                    case INVALIDATE_NOTIFYING_PEER_PENDING: {
                        previousState = Optional.of(this.state.currentState());
                        this.state.changeState((State)((Object)previousState.get()), State.INVALIDATE_NOTIFYING_PEER_IN_PROGRESS);
                        break;
                    }
                    default: {
                        previousState = Optional.empty();
                        break;
                    }
                }
            } else {
                previousState = Optional.empty();
            }
        }
        previousState.ifPresent(action -> {
            if (TraceComponent.isAnyTracingEnabled()) {
                JFapUtils.debugSummaryMessage(tc, this, null, "Performing deferred action: " + (Object)action);
            }
            switch (action) {
                case CLOSE_PENDING: {
                    this.nonThreadSafePhysicalClose(false);
                    break;
                }
                case CLOSE_NOTIFYING_PEER_PENDING: {
                    this.nonThreadSafePhysicalClose(true);
                    break;
                }
                case INVALIDATE_PENDING: {
                    this.nonThreadSafeInvalidate(false, this.invalidatePendingThrowable);
                    break;
                }
                case INVALIDATE_NOTIFYING_PEER_PENDING: {
                    this.nonThreadSafeInvalidate(true, this.invalidatePendingThrowable);
                }
            }
        });
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"postSendProcessing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long send(JFapByteBuffer buffer, int segmentType, int conversationId, int requestNumber, int priority, boolean pooledBuffersHint, boolean partOfExchange, Conversation.ThrottlingPolicy throttlingPolicy, SendListener sendListener, Conversation conversation, boolean userRequest) throws SIConnectionLostException, SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{buffer, "" + segmentType, "" + conversationId, "" + requestNumber, "" + priority, "" + pooledBuffersHint, throttlingPolicy, sendListener, "" + userRequest});
        }
        if (TraceComponent.isAnyTracingEnabled()) {
            String msg = null;
            msg = !userRequest ? (partOfExchange ? "System exchange " : "System send ") : (partOfExchange ? "Exchange " : "Send ");
            if (requestNumber > 0) {
                msg = msg + "[Request Id:" + requestNumber + "] ";
            }
            msg = msg + Integer.toHexString(segmentType) + " (" + JFapChannelConstants.getSegmentName(segmentType) + ")";
            JFapUtils.debugSummaryMessage(tc, this, (ConversationImpl)conversation, msg, requestNumber);
        }
        long sendAmount = 0L;
        this.preSendProcessing(false);
        try {
            sendAmount = buffer.prepareForTransmission();
            this.priorityQueue.queue(buffer, segmentType, requestNumber, priority, sendListener, conversation, this, conversationId, pooledBuffersHint, partOfExchange, sendAmount, false, throttlingPolicy);
            this.writeCompletedCallback.proddle();
        }
        finally {
            this.postSendProcessing();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"send", (Object)("" + sendAmount));
        }
        return sendAmount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long send(JFapByteBuffer buffer, int segmentType, int priority, boolean pooledBuffersHint, boolean partOfExchange, Conversation.ThrottlingPolicy throttlingPolicy, SendListener sendListener, boolean terminate) throws SIConnectionLostException, SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{buffer, "" + segmentType, "" + priority, "" + pooledBuffersHint, sendListener, "" + terminate});
        }
        if (TraceComponent.isAnyTracingEnabled()) {
            String msg = null;
            msg = partOfExchange ? "System connection level exchange " : "System connection level send ";
            msg = msg + Integer.toHexString(segmentType) + " (" + JFapChannelConstants.getSegmentName(segmentType) + ")";
            JFapUtils.debugSummaryMessage(tc, this, null, msg);
        }
        long sendAmount = 0L;
        this.preSendProcessing(terminate);
        try {
            sendAmount = buffer.prepareForTransmission();
            this.priorityQueue.queue(buffer, segmentType, 0, priority, sendListener, null, this, 0, pooledBuffersHint, partOfExchange, sendAmount, terminate, throttlingPolicy);
            this.writeCompletedCallback.proddle();
        }
        finally {
            this.postSendProcessing();
            if (terminate) {
                this.priorityQueue.waitForCloseToComplete();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"send", (Object)("" + sendAmount));
        }
        return sendAmount;
    }

    protected void sendHeartbeat() throws SIConnectionDroppedException, SIConnectionLostException {
        InternalJFapByteBuffer buffer = new InternalJFapByteBuffer();
        this.send(buffer, 1, 15, true, false, Conversation.ThrottlingPolicy.DO_NOT_THROTTLE, null, false);
    }

    public void setAttachment(Object attachment) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setAttachment", (Object)attachment);
        }
        this.userAttachment = attachment;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setAttachment");
        }
    }

    public Object getAttachment() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getAttachment");
        }
        Object returnValue = this.userAttachment;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getAttachment", (Object)returnValue);
        }
        return returnValue;
    }

    protected abstract void connectionClosedByPeer();

    public abstract void closeNotification(Conversation var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conversation[] getConversations() {
        Conversation[] returnConversations;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConversations");
        }
        ConversationTable conversationTable = this.conversationTable;
        synchronized (conversationTable) {
            Iterator iterator = this.conversationTable.iterator();
            ArrayList<Conversation> list = new ArrayList<Conversation>();
            while (iterator.hasNext()) {
                list.add((Conversation)iterator.next());
            }
            returnConversations = new Conversation[list.size()];
            for (int i = 0; i < returnConversations.length; ++i) {
                returnConversations[i] = (Conversation)list.get(i);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)tc, (String)("conversation " + i), (Object)returnConversations[i]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConversations", (Object)returnConversations);
        }
        return returnConversations;
    }

    protected byte getNextRequestNumber() {
        return (byte)this.nextRequestNumber.getAndIncrement();
    }

    public void physicalClose(boolean notifyPeer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"physicalClose", (Object)("" + notifyPeer));
        }
        if (TraceComponent.isAnyTracingEnabled()) {
            JFapUtils.debugSummaryMessage(tc, this, null, "Connection close requested (notifyPeer=" + notifyPeer + ")");
        }
        boolean performCloseOnThisThread = false;
        try (L l = Connection.obtainLock(this.stateLock.writeLock());){
            if (this.state.currentState() == State.OPEN) {
                if (this.threadsSendingData.get() > 0) {
                    if (notifyPeer) {
                        this.state.changeState(State.OPEN, State.CLOSE_NOTIFYING_PEER_PENDING);
                    } else {
                        this.state.changeState(State.OPEN, State.CLOSE_PENDING);
                    }
                    if (TraceComponent.isAnyTracingEnabled()) {
                        JFapUtils.debugSummaryMessage(tc, this, null, "Deferring call to close");
                    }
                } else {
                    this.state.changeState(State.OPEN, State.CLOSE_IN_PROGRESS);
                    performCloseOnThisThread = true;
                }
            }
        }
        if (performCloseOnThisThread) {
            this.nonThreadSafePhysicalClose(notifyPeer);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"physicalClose");
        }
    }

    public void physicalCloseFromInvalidateImpl(boolean notifyPeer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"physicalCloseFromInvalidateImpl", (Object)notifyPeer);
        }
        this.nonThreadSafePhysicalClose(notifyPeer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"physicalCloseFromInvalidateImpl");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nonThreadSafePhysicalClose(boolean notifyPeer) {
        boolean completeClose;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"nonThreadSafePhysicalClose", (Object)("" + notifyPeer));
        }
        if (notifyPeer) {
            InternalJFapByteBuffer buffer = new InternalJFapByteBuffer();
            buffer.put((byte)1);
            try {
                this.send(buffer, 255, 11, true, false, Conversation.ThrottlingPolicy.DO_NOT_THROTTLE, null, true);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.jfapchannel.impl.Connection", (String)"00040001", (Object)this.getDiagnostics(true));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)e));
                }
            }
        } else {
            this.priorityQueue.close(true);
        }
        try (L l = Connection.obtainLock(this.stateLock.writeLock());){
            completeClose = this.state.currentState() != State.CLOSED;
            this.state.changeState(this.state.currentState(), State.CLOSED);
        }
        if (completeClose) {
            try {
                this.priorityQueue.waitForCloseToComplete();
                this.readCompletedCallback.physicalCloseNotification();
                this.writeCompletedCallback.physicalCloseNotification();
                if (this.vc.requestPermissionToClose((this.heartbeatInterval + this.heartbeatTimeout) * 1000)) {
                    WsByteBuffer[] writeBuffers;
                    WsByteBuffer[] readBuffers = this.tcpReadCtx.getBuffers();
                    if (readBuffers != null) {
                        for (WsByteBuffer readBuffer : readBuffers) {
                            try {
                                readBuffer.release();
                            }
                            catch (RuntimeException e) {
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught exception on releasing buffer.", (Object)e);
                            }
                        }
                        this.tcpReadCtx.setBuffers(null);
                    }
                    if ((writeBuffers = this.tcpWriteCtx.getBuffers()) != null) {
                        for (WsByteBuffer writeBuffer : writeBuffers) {
                            try {
                                writeBuffer.release();
                            }
                            catch (RuntimeException e) {
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught exception on releasing buffer.", (Object)e);
                            }
                        }
                        this.tcpWriteCtx.setBuffers(null);
                    }
                    this.connChannel.close(this.vc, new Exception());
                } else {
                    FFDCFilter.processException((Throwable)new Exception("Did not get permission to close"), (String)"com.ibm.ws.sib.jfapchannel.impl.Connection", (String)"00040006", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Did not get permission to close!");
                    }
                }
            }
            finally {
                this.notifyCloseListeners();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"nonThreadSafePhysicalClose");
        }
    }

    protected void setHeartbeatInterval(int seconds) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setHeartbeatInterval", (Object)("seconds=" + seconds));
        }
        if (seconds < 0) {
            throw new SIErrorException(nls.getFormattedMessage("CONNECTION_INTERNAL_SICJ0043", null, "CONNECTION_INTERNAL_SICJ0043"));
        }
        this.heartbeatInterval = seconds;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setHeartbeatInterval");
        }
    }

    protected int getHeartbeatInterval() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getHeartbeatInterval");
        }
        int rc = this.heartbeatInterval;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getHeartbeatInterval", (Object)("rc=" + rc));
        }
        return rc;
    }

    protected int getHeartbeatIntervalForToString() {
        return this.heartbeatInterval;
    }

    protected void setHeartbeatTimeout(int seconds) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setHeartbeatTimeout", (Object)("seconds=" + seconds));
        }
        if (seconds < 1) {
            throw new SIErrorException(nls.getFormattedMessage("CONNECTION_INERNAL_SICJ0043", null, "CONNECTION_INERNAL_SICJ0043"));
        }
        this.heartbeatTimeout = seconds;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setHeartbeatTimeout");
        }
    }

    protected int getHeartbeatTimeout() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getHeartbeatTimeout");
        }
        int rc = this.heartbeatTimeout;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getHeartbeatTimeout", (Object)("rc=" + rc));
        }
        return rc;
    }

    protected int getHeartbeatTimeoutForToString() {
        return this.heartbeatTimeout;
    }

    @Override
    public final void invalidate(boolean notifyPeer, Throwable throwable, String debugReason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"invalidate", (Object)new Object[]{notifyPeer, throwable});
        }
        if (TraceComponent.isAnyTracingEnabled()) {
            JFapUtils.debugSummaryMessage(tc, this, null, "Connection invalidated (reason: " + debugReason + ")");
        }
        boolean purgePriorityQueue = false;
        boolean performInvalidateOnThisThread = false;
        try (L l = Connection.obtainLock(this.stateLock.writeLock());){
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("state = " + this.state + ", threadsSendingData = " + this.threadsSendingData));
            }
            if (this.state.currentState() == State.OPEN) {
                boolean bl = purgePriorityQueue = !notifyPeer;
                if (this.threadsSendingData.get() > 0) {
                    if (notifyPeer) {
                        this.state.changeState(State.OPEN, State.INVALIDATE_NOTIFYING_PEER_PENDING);
                    } else {
                        this.state.changeState(State.OPEN, State.INVALIDATE_PENDING);
                    }
                    if (TraceComponent.isAnyTracingEnabled()) {
                        JFapUtils.debugSummaryMessage(tc, this, null, "Deferring call to invalidate");
                    }
                    this.invalidatePendingThrowable = throwable;
                } else {
                    if (notifyPeer) {
                        this.state.changeState(State.OPEN, State.INVALIDATE_NOTIFYING_PEER_IN_PROGRESS);
                    } else {
                        this.state.changeState(State.OPEN, State.INVALIDATE_IN_PROGRESS);
                    }
                    performInvalidateOnThisThread = true;
                }
            } else if (this.state.currentState() == State.CLOSE_NOTIFYING_PEER_PENDING || this.state.currentState() == State.CLOSE_PENDING) {
                purgePriorityQueue = true;
                notifyPeer = false;
                this.state.changeState(this.state.currentState(), State.INVALIDATE_PENDING);
                if (TraceComponent.isAnyTracingEnabled()) {
                    JFapUtils.debugSummaryMessage(tc, this, null, "Deferring call to invalidate");
                }
                this.invalidatePendingThrowable = throwable;
            } else if (this.state.currentState() == State.CLOSE_IN_PROGRESS) {
                purgePriorityQueue = true;
                notifyPeer = false;
                performInvalidateOnThisThread = true;
                this.state.changeState(State.CLOSE_IN_PROGRESS, State.INVALIDATE_IN_PROGRESS);
            }
        }
        if (purgePriorityQueue) {
            this.priorityQueue.purge();
        }
        if (performInvalidateOnThisThread) {
            this.nonThreadSafeInvalidate(notifyPeer, throwable);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"invalidate");
        }
    }

    private void nonThreadSafeInvalidate(boolean notifyPeer, Throwable throwable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"nonThreadSafeInvalidate", (Object)new Object[]{"" + notifyPeer, "" + throwable});
        }
        this.invalidateImpl(notifyPeer, throwable);
        this.notifyCloseListeners();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"nonThreadSafeInvalidate");
        }
    }

    private void notifyCloseListeners() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"notifyCloseListeners");
        }
        Stream.of(ConversationUsageType.values()).map(this.closeListeners::remove).filter(Objects::nonNull).forEach(listener -> {
            block2: {
                try {
                    listener.connectionClosed(this);
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.sib.jfapchannel.impl.Connection", (String)"00040005", (Object[])new Object[]{this, listener});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Exception invoking close listener", (Object)new Object[]{listener, t});
                }
            }
        });
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"notifyCloseListeners");
        }
    }

    public abstract void invalidateImpl(boolean var1, Throwable var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wakeupAllConversationsWithException(SIException exception, boolean alwaysDeliverToConversationReceiveListener) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"wakeupAllConversationsWithException", (Object)new Object[]{exception, "" + alwaysDeliverToConversationReceiveListener});
        }
        ArrayList<ConversationImpl> toInvalidateList = new ArrayList<ConversationImpl>();
        ConversationTable conversationTable = this.conversationTable;
        synchronized (conversationTable) {
            Iterator conversationIterator = this.conversationTable.iterator();
            while (conversationIterator.hasNext()) {
                toInvalidateList.add((ConversationImpl)conversationIterator.next());
            }
            this.conversationTable.clear();
        }
        for (int i = 0; i < toInvalidateList.size(); ++i) {
            ConversationImpl conversation = (ConversationImpl)toInvalidateList.get(i);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("conversation: " + conversation));
            }
            conversation.invalidate(exception);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"wakeupAllConversationsWithException");
        }
    }

    protected boolean processData(int segmentType, int priority, boolean isPooled, boolean isExchange, WsByteBuffer data) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"processData", (Object)new Object[]{"" + segmentType, "" + priority, "" + isPooled, "" + isExchange, data});
        }
        boolean closed = false;
        switch (segmentType) {
            case 1: {
                this.processHeartbeat();
                break;
            }
            case 2: {
                this.readCompletedCallback.heartbeatReceived();
                break;
            }
            case 255: {
                this.processPhysicalClose();
                closed = true;
                break;
            }
            default: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("unexpected segment type: " + segmentType));
                }
                this.invalidate(false, new RuntimeException(), "received unexpected segment for a connection based transmission");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"processData", (Object)closed);
        }
        return closed;
    }

    private void processHeartbeat() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"processHeartbeat");
        }
        InternalJFapByteBuffer buffer = new InternalJFapByteBuffer();
        try {
            this.send(buffer, 2, 0, 0, 15, true, false, Conversation.ThrottlingPolicy.DO_NOT_THROTTLE, null, null, false);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.jfapchannel.impl.Connection", (String)"00040002");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)e));
            }
            this.invalidate(false, e, "SIException thrown from a system send operation");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"processHeartbeat");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPhysicalClose() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"processPhysicalClose");
        }
        this.readCompletedCallback.stopReceiving();
        ArrayList<ConversationImpl> conversations = new ArrayList<ConversationImpl>();
        ConversationTable conversationTable = this.conversationTable;
        synchronized (conversationTable) {
            Iterator conversationIterator = this.conversationTable.iterator();
            while (conversationIterator.hasNext()) {
                conversations.add((ConversationImpl)conversationIterator.next());
            }
        }
        if (!conversations.isEmpty()) {
            Throwable closeException = null;
            new SIConnectionLostException(nls.getFormattedMessage("CONVERSATIONIMPL_INVALIDATE_SICJ0045", new Object[]{this.remoteHostAddress, this.chainName}, null));
            for (ConversationImpl conversation : conversations) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("invoking invalidate on conversation " + conversation));
                }
                conversation.invalidate(closeException);
            }
        }
        this.physicalClose(false);
        this.connectionClosedByPeer();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"processPhysicalClose");
        }
    }

    protected int getMaxTransmissionSize() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMaxTransmissionSize");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMaxTransmissionSize", (Object)("" + this.maxTransmissionSize));
        }
        return this.maxTransmissionSize;
    }

    protected void setMaxTransmissionSize(int newMaxTransmissionSize) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setMaxTransmissionSize", (Object)("" + newMaxTransmissionSize));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMaxTransmissionSize");
        }
        this.maxTransmissionSize = newMaxTransmissionSize;
    }

    protected abstract void handshakeComplete();

    protected abstract void handshakeFailed();

    protected abstract Conversation cloneConversation(ConversationReceiveListener var1) throws SIResourceException;

    public ConversationImpl getConversationById(int id) {
        return this.conversationTable.get(id);
    }

    protected void removeConversationById(int id) {
        this.conversationTable.remove(id);
    }

    protected abstract ConversationMetaData getMetaData();

    public Conversation.ConversationType getConversationType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConversationType");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConversationType", (Object)this.conversationType);
        }
        return this.conversationType;
    }

    protected void setConversationType(Conversation.ConversationType type) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setConversationType", (Object)type);
        }
        if (this.conversationType == Conversation.UNKNOWN && type != Conversation.UNKNOWN) {
            this.conversationType = type;
            this.priorityQueue.setType(type);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setConversationType");
        }
    }

    public void addConnectionClosedListener(ConnectionClosedListener listener, ConversationUsageType usageType) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addConnectionClosedListener", (Object)new Object[]{listener, usageType});
        }
        ConnectionClosedListener oldListener = this.closeListeners.put(usageType, listener);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addConnectionClosedListener", (Object)oldListener);
        }
    }

    public ConnectionClosedListener getConnectionClosedListener(ConversationUsageType usageType) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConnectionClosedListener", (Object)((Object)usageType));
        }
        ConnectionClosedListener listener = this.closeListeners.get((Object)usageType);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConnectionClosedListener", (Object)listener);
        }
        return listener;
    }

    protected abstract boolean isInbound();

    protected HandshakeProperties getHandshakeProperties() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getHandshakeProperties");
        }
        HandshakeProperties result = this.handshakeProperties;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getHandshakeProperties", (Object)result);
        }
        return result;
    }

    protected void setHandshakeProperties(HandshakeProperties handshakeProperties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setHandshakeProperties", (Object)handshakeProperties);
        }
        this.handshakeProperties = handshakeProperties;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setHandshakeProperties");
        }
    }

    protected ConnectionEventRecorder getConnectionEventRecorder() {
        return this.eventRecorder;
    }

    protected boolean isLoggingIOEvents() {
        return this.logIOEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDiagnostics(boolean includeConversations) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.eventRecorder);
        if (includeConversations) {
            ConversationTable conversationTable = this.conversationTable;
            synchronized (conversationTable) {
                Iterator iterator = this.conversationTable.iterator();
                while (iterator.hasNext()) {
                    sb.append(iterator.next());
                }
            }
        }
        return sb.toString();
    }

    public boolean isCloseDeferred() {
        try (L l = Connection.obtainLock(this.stateLock.readLock());){
            boolean bl = this.state.currentState() == State.CLOSE_NOTIFYING_PEER_PENDING || this.state.currentState() == State.CLOSE_PENDING;
            return bl;
        }
    }

    public boolean isInvalidateDeferred() {
        try (L l = Connection.obtainLock(this.stateLock.readLock());){
            boolean bl = this.state.currentState() == State.INVALIDATE_NOTIFYING_PEER_PENDING || this.state.currentState() == State.INVALIDATE_PENDING;
            return bl;
        }
    }

    public void setSchemaSet(ConnectionSchemaSet schemaSet) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setSchemaSet", (Object)schemaSet);
        }
        this.schemaSet = schemaSet;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setSchemaSet");
        }
    }

    public ConnectionSchemaSet getSchemaSet() throws SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSchemaSet");
        }
        try (L l = Connection.obtainLock(this.stateLock.readLock());){
            if (this.state.currentState() != State.OPEN) {
                throw new SIConnectionDroppedException(nls.getFormattedMessage("CONNECTION_CLOSED_SICJ0044", null, "CONNECTION_CLOSED_SICJ0044"));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSchemaSet", (Object)this.schemaSet);
        }
        return this.schemaSet;
    }

    public abstract String getEyeCatcher();

    @Override
    public boolean isClosed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isClosed");
        }
        try (L l = Connection.obtainLock(this.stateLock.readLock());){
            boolean answer;
            boolean bl = answer = this.state.currentState() != State.OPEN;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"isClosed", (Object)answer);
            }
            boolean bl2 = answer;
            return bl2;
        }
    }

    private static interface L
    extends AutoCloseable {
        @Override
        public void close();
    }

    public static class StateHolder {
        private State state = State.OPEN;

        State currentState() {
            return this.state;
        }

        synchronized boolean changeState(State from, State to) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("changeState from=" + (Object)((Object)from) + ", to=" + (Object)((Object)to)));
            }
            if (from != this.state) {
                return false;
            }
            if (from.transitions.contains((Object)to)) {
                this.state = to;
                return true;
            }
            throw new IllegalStateException("Illegal attempt to change state from " + (Object)((Object)from) + " to " + (Object)((Object)to));
        }
    }

    public static enum State {
        CLOSED(new State[0]),
        INVALIDATE_IN_PROGRESS(CLOSED),
        CLOSE_IN_PROGRESS(CLOSED, INVALIDATE_IN_PROGRESS),
        INVALIDATE_NOTIFYING_PEER_IN_PROGRESS(CLOSED),
        INVALIDATE_PENDING(INVALIDATE_IN_PROGRESS),
        INVALIDATE_NOTIFYING_PEER_PENDING(INVALIDATE_NOTIFYING_PEER_IN_PROGRESS),
        CLOSE_PENDING(CLOSE_IN_PROGRESS, INVALIDATE_PENDING),
        CLOSE_NOTIFYING_PEER_PENDING(CLOSE_IN_PROGRESS, INVALIDATE_PENDING),
        OPEN(CLOSE_PENDING, CLOSE_NOTIFYING_PEER_PENDING, CLOSE_IN_PROGRESS, INVALIDATE_PENDING, INVALIDATE_IN_PROGRESS, INVALIDATE_NOTIFYING_PEER_PENDING, INVALIDATE_NOTIFYING_PEER_IN_PROGRESS);

        final Set<State> transitions;

        private State(State ... nextStates) {
            this.transitions = Collections.unmodifiableSet(new HashSet<State>(Arrays.asList(nextStates)));
        }
    }
}

