/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.tm.impl;

import com.ibm.tx.remote.RecoveryCoordinator;
import com.ibm.tx.remote.RecoveryCoordinatorFactory;
import com.ibm.tx.remote.RecoveryCoordinatorNotAvailableException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsat.common.impl.WSATCoordinator;
import com.ibm.ws.wsat.common.impl.WSATParticipant;
import com.ibm.ws.wsat.common.impl.WSATTransaction;
import com.ibm.ws.wsat.service.WSATException;
import com.ibm.ws.wsat.service.impl.ProtocolImpl;
import com.ibm.ws.wsat.service.impl.RegistrationImpl;
import com.ibm.ws.wsat.tm.impl.CoordinatorResource;
import com.ibm.ws.wsat.tm.impl.ParticipantFactoryService;
import java.io.Serializable;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="TC", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(property={"type=com.ibm.ws.wsat.Coordinator", "service.vendor=IBM"})
public class CoordinatorFactoryService
implements RecoveryCoordinatorFactory {
    private static final String CLASS_NAME = CoordinatorFactoryService.class.getName();
    private static final TraceComponent TC = Tr.register(CoordinatorFactoryService.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
    private final RegistrationImpl registrationService = RegistrationImpl.getInstance();
    private final ProtocolImpl protocolService = ProtocolImpl.getInstance();
    static final long serialVersionUID = 8026695221156155037L;

    /*
     * WARNING - void declaration
     */
    public RecoveryCoordinator getRecoveryCoordinator(Serializable recoveryCoordinatorInfo) throws RecoveryCoordinatorNotAvailableException {
        CoordinatorResource recovCoord = null;
        WSATCoordinator coord = (WSATCoordinator)ParticipantFactoryService.deserialize(recoveryCoordinatorInfo);
        if (coord != null) {
            WSATTransaction wsatTran = this.reconstructTran(coord);
            WSATCoordinator coordinator = this.reconstructCoordinator(wsatTran, coord);
            try {
                EndpointReferenceType eprPart = this.protocolService.getParticipantEndpoint(wsatTran.getGlobalId());
                coordinator.setParticipant(new WSATParticipant(wsatTran.getGlobalId(), "", eprPart));
                recovCoord = new CoordinatorResource(coordinator);
            }
            catch (WSATException eprPart) {
                void e;
                FFDCFilter.processException((Throwable)eprPart, (String)"com.ibm.ws.wsat.tm.impl.CoordinatorFactoryService", (String)"66", (Object)this, (Object[])new Object[]{recoveryCoordinatorInfo});
                throw new RecoveryCoordinatorNotAvailableException((Exception)e);
            }
        } else {
            throw new RecoveryCoordinatorNotAvailableException((Exception)new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"UNABLE_TO_DESERIALIZE_CWLIB0208", (Object[])new Object[0])));
        }
        return recovCoord;
    }

    /*
     * WARNING - void declaration
     */
    private WSATTransaction reconstructTran(WSATCoordinator coord) throws RecoveryCoordinatorNotAvailableException {
        String globalId = coord.getGlobalId();
        WSATTransaction wsatTran = WSATTransaction.getTran(globalId);
        if (wsatTran == null) {
            if (TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)"Cannot locate transaction, recovering state: {0}", (Object[])new Object[]{globalId});
            }
            try {
                this.registrationService.activate(globalId, null, 0L, true);
                wsatTran = WSATTransaction.getTran(globalId);
            }
            catch (WSATException wSATException) {
                void e;
                FFDCFilter.processException((Throwable)wSATException, (String)"com.ibm.ws.wsat.tm.impl.CoordinatorFactoryService", (String)"87", (Object)this, (Object[])new Object[]{coord});
                throw new RecoveryCoordinatorNotAvailableException((Exception)e);
            }
        }
        return wsatTran;
    }

    private WSATCoordinator reconstructCoordinator(WSATTransaction wsatTran, WSATCoordinator coord) {
        WSATCoordinator coordinator = wsatTran.getCoordinator();
        if (coordinator == null) {
            if (TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)"Cannot locate coordinator, recovering state: {0}", (Object[])new Object[]{coord});
            }
            coordinator = wsatTran.setCoordinator(coord);
        }
        return coordinator;
    }
}

