/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.tm.impl;

import com.ibm.tx.remote.RemoteTransactionController;
import com.ibm.tx.remote.Vote;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.Transaction.JTA.HeuristicHazardException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsat.common.impl.WSATCoordinator;
import com.ibm.ws.wsat.common.impl.WSATParticipant;
import com.ibm.ws.wsat.service.WSATException;
import com.ibm.ws.wsat.tm.impl.ParticipantFactoryService;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.uow.UOWManager;
import java.io.Serializable;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="TC", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TranManagerImpl {
    private static final TraceComponent TC = Tr.register(TranManagerImpl.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
    private static final TranManagerImpl INSTANCE = new TranManagerImpl();
    private TransactionManager localTranMgr;
    private RemoteTransactionController remoteTranMgr;
    private UOWManager uowManager;
    private TransactionSynchronizationRegistry syncRegistry;
    private ClassLoadingService clService;
    static final long serialVersionUID = -7924475223392472144L;

    public static TranManagerImpl getInstance() {
        return INSTANCE;
    }

    public synchronized TransactionManager getLocalTranMgr() {
        if (this.localTranMgr == null) {
            this.localTranMgr = this.getService(TransactionManager.class);
        }
        return this.localTranMgr;
    }

    public synchronized RemoteTransactionController getRemoteTranMgr() {
        if (this.remoteTranMgr == null) {
            this.remoteTranMgr = this.getService(RemoteTransactionController.class);
        }
        return this.remoteTranMgr;
    }

    public synchronized UOWManager getUOWManager() {
        if (this.uowManager == null) {
            this.uowManager = this.getService(UOWManager.class);
        }
        return this.uowManager;
    }

    public synchronized TransactionSynchronizationRegistry getTranSyncRegistry() {
        if (this.syncRegistry == null) {
            this.syncRegistry = this.getService(TransactionSynchronizationRegistry.class);
        }
        return this.syncRegistry;
    }

    public synchronized ClassLoadingService getClassLoadingService() {
        if (this.clService == null) {
            this.clService = this.getService(ClassLoadingService.class);
        }
        return this.clService;
    }

    private <T> T getService(Class<T> service) {
        Object impl = null;
        BundleContext context = FrameworkUtil.getBundle(service).getBundleContext();
        ServiceReference ref = context.getServiceReference(service);
        if (ref != null) {
            impl = context.getService(ref);
        } else if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"Unable to locate service: {0}", (Object[])new Object[]{service});
        }
        return (T)impl;
    }

    public boolean isTranActive() {
        boolean active = false;
        try {
            int status = this.getLocalTranMgr().getStatus();
            if (status == 0 || status == 1) {
                active = true;
            }
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.ws.wsat.tm.impl.TranManagerImpl", (String)"127", (Object)this, (Object[])new Object[0]);
        }
        return active;
    }

    /*
     * WARNING - void declaration
     */
    public Transaction getTransaction() throws WSATException {
        Transaction txTran = null;
        try {
            this.getLocalTranMgr().getTransaction();
        }
        catch (SystemException systemException) {
            void e;
            FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.ws.wsat.tm.impl.TranManagerImpl", (String)"139", (Object)this, (Object[])new Object[0]);
            throw new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"TRAN_MGR_ERROR_CWLIB0205", (Object[])new Object[0]), (Throwable)e);
        }
        return txTran;
    }

    /*
     * WARNING - void declaration
     */
    public void markRollback() throws WSATException {
        try {
            this.getLocalTranMgr().setRollbackOnly();
        }
        catch (SystemException systemException) {
            void e;
            FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.ws.wsat.tm.impl.TranManagerImpl", (String)"151", (Object)this, (Object[])new Object[0]);
            throw new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"TRAN_MGR_ERROR_CWLIB0205", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public long getTimeout() throws IllegalStateException, WSATException {
        long expireTime = this.getUOWManager().getUOWExpiration();
        if (expireTime != 0L) {
            return expireTime - System.currentTimeMillis();
        }
        return 0x1FFFFFFFFFFFFFFFL;
    }

    /*
     * WARNING - void declaration
     */
    public String getGlobalId() throws WSATException {
        String globalId = null;
        try {
            globalId = this.getRemoteTranMgr().getGlobalId();
        }
        catch (SystemException systemException) {
            void e;
            FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.ws.wsat.tm.impl.TranManagerImpl", (String)"176", (Object)this, (Object[])new Object[0]);
            throw new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"TRAN_MGR_ERROR_CWLIB0205", (Object[])new Object[0]), (Throwable)e);
        }
        return globalId;
    }

    /*
     * WARNING - void declaration
     */
    public String exportTransaction() throws WSATException {
        String globalId = null;
        try {
            globalId = this.getRemoteTranMgr().exportTransaction();
        }
        catch (SystemException systemException) {
            void e;
            FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.ws.wsat.tm.impl.TranManagerImpl", (String)"189", (Object)this, (Object[])new Object[0]);
            throw new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"TRAN_MGR_ERROR_CWLIB0205", (Object[])new Object[0]), (Throwable)e);
        }
        return globalId;
    }

    /*
     * WARNING - void declaration
     */
    public void unexportTransaction(String globalId) throws WSATException {
        try {
            this.getRemoteTranMgr().unexportTransaction(globalId);
        }
        catch (SystemException systemException) {
            void e;
            FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.ws.wsat.tm.impl.TranManagerImpl", (String)"198", (Object)this, (Object[])new Object[]{globalId});
            throw new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"TRAN_MGR_ERROR_CWLIB0205", (Object[])new Object[0]), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setRollbackOnly(String globalId) throws WSATException {
        try {
            this.getRemoteTranMgr().setRollbackOnly(globalId);
        }
        catch (SystemException systemException) {
            void e;
            FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.ws.wsat.tm.impl.TranManagerImpl", (String)"206", (Object)this, (Object[])new Object[]{globalId});
            throw new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"TRAN_MGR_ERROR_CWLIB0205", (Object[])new Object[0]), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean importTransaction(String globalId, int timeout) throws WSATException {
        boolean imported = false;
        try {
            imported = this.getRemoteTranMgr().importTransaction(globalId, timeout);
        }
        catch (SystemException systemException) {
            void e;
            FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.ws.wsat.tm.impl.TranManagerImpl", (String)"215", (Object)this, (Object[])new Object[]{globalId, timeout});
            throw new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"TRAN_MGR_ERROR_CWLIB0205", (Object[])new Object[0]), (Throwable)e);
        }
        return imported;
    }

    /*
     * WARNING - void declaration
     */
    public void unimportTransaction(String globalId) throws WSATException {
        try {
            this.getRemoteTranMgr().unimportTransaction(globalId);
        }
        catch (SystemException systemException) {
            void e;
            FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.ws.wsat.tm.impl.TranManagerImpl", (String)"224", (Object)this, (Object[])new Object[]{globalId});
            throw new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"TRAN_MGR_ERROR_CWLIB0205", (Object[])new Object[0]), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean registerParticipant(String globalId, WSATParticipant participant) throws WSATException {
        boolean result = false;
        try {
            Serializable key = ParticipantFactoryService.serialize(participant);
            result = this.getRemoteTranMgr().registerRemoteParticipant("(type=com.ibm.ws.wsat.Participant)", key, globalId);
        }
        catch (SystemException key) {
            void e;
            FFDCFilter.processException((Throwable)key, (String)"com.ibm.ws.wsat.tm.impl.TranManagerImpl", (String)"237", (Object)this, (Object[])new Object[]{globalId, participant});
            throw new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"TRAN_MGR_ERROR_CWLIB0205", (Object[])new Object[0]), (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public boolean registerCoordinator(String globalId, WSATCoordinator coordinator) throws WSATException {
        boolean result = false;
        try {
            Serializable key = ParticipantFactoryService.serialize(coordinator);
            result = this.getRemoteTranMgr().registerRecoveryCoordinator("(type=com.ibm.ws.wsat.Coordinator)", key, globalId);
        }
        catch (SystemException key) {
            void e;
            FFDCFilter.processException((Throwable)key, (String)"com.ibm.ws.wsat.tm.impl.TranManagerImpl", (String)"251", (Object)this, (Object[])new Object[]{globalId, coordinator});
            throw new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"TRAN_MGR_ERROR_CWLIB0205", (Object[])new Object[0]), (Throwable)e);
        }
        return result;
    }

    @FFDCIgnore(value={SystemException.class})
    public Vote prepareTransaction(String globalId) throws WSATException {
        try {
            return this.getRemoteTranMgr().prepare(globalId);
        }
        catch (SystemException e) {
            throw new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"TRAN_MGR_ERROR_CWLIB0205", (Object[])new Object[0]), e);
        }
        catch (HeuristicHazardException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wsat.tm.impl.TranManagerImpl", (String)"282", (Object)this, (Object[])new Object[]{globalId});
            throw new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"TRAN_MGR_ERROR_CWLIB0205", (Object[])new Object[0]), e);
        }
        catch (HeuristicMixedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wsat.tm.impl.TranManagerImpl", (String)"284", (Object)this, (Object[])new Object[]{globalId});
            throw new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"TRAN_MGR_ERROR_CWLIB0205", (Object[])new Object[0]), e);
        }
        catch (RollbackException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wsat.tm.impl.TranManagerImpl", (String)"286", (Object)this, (Object[])new Object[]{globalId});
            throw new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"TRAN_MGR_ERROR_CWLIB0205", (Object[])new Object[0]), e);
        }
    }

    @FFDCIgnore(value={SystemException.class})
    public void commitTransaction(String globalId) throws WSATException {
        try {
            this.getRemoteTranMgr().commit(globalId);
        }
        catch (SystemException e) {
            throw new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"TRAN_MGR_ERROR_CWLIB0205", (Object[])new Object[0]), e);
        }
        catch (HeuristicHazardException heuristicHazardException) {
            FFDCFilter.processException((Throwable)heuristicHazardException, (String)"com.ibm.ws.wsat.tm.impl.TranManagerImpl", (String)"297", (Object)this, (Object[])new Object[]{globalId});
        }
        catch (HeuristicRollbackException heuristicRollbackException) {
            FFDCFilter.processException((Throwable)heuristicRollbackException, (String)"com.ibm.ws.wsat.tm.impl.TranManagerImpl", (String)"299", (Object)this, (Object[])new Object[]{globalId});
        }
        catch (HeuristicMixedException heuristicMixedException) {
            FFDCFilter.processException((Throwable)heuristicMixedException, (String)"com.ibm.ws.wsat.tm.impl.TranManagerImpl", (String)"301", (Object)this, (Object[])new Object[]{globalId});
        }
    }

    @FFDCIgnore(value={SystemException.class})
    public void rollbackTransaction(String globalId) throws WSATException {
        try {
            this.getRemoteTranMgr().rollback(globalId);
        }
        catch (SystemException e) {
            throw new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"TRAN_MGR_ERROR_CWLIB0205", (Object[])new Object[0]), e);
        }
        catch (HeuristicHazardException heuristicHazardException) {
            FFDCFilter.processException((Throwable)heuristicHazardException, (String)"com.ibm.ws.wsat.tm.impl.TranManagerImpl", (String)"312", (Object)this, (Object[])new Object[]{globalId});
        }
        catch (HeuristicCommitException heuristicCommitException) {
            FFDCFilter.processException((Throwable)heuristicCommitException, (String)"com.ibm.ws.wsat.tm.impl.TranManagerImpl", (String)"314", (Object)this, (Object[])new Object[]{globalId});
        }
        catch (HeuristicMixedException heuristicMixedException) {
            FFDCFilter.processException((Throwable)heuristicMixedException, (String)"com.ibm.ws.wsat.tm.impl.TranManagerImpl", (String)"320", (Object)this, (Object[])new Object[]{globalId});
        }
    }

    public boolean replayCompletion(String globalId) {
        return this.getRemoteTranMgr().replayCompletion(globalId);
    }

    public void registerTranSync(Synchronization tranSync) {
        this.getTranSyncRegistry().registerInterposedSynchronization(tranSync);
    }

    public ClassLoader getThreadClassLoader(Class<?> cl) {
        return this.getClassLoadingService().createThreadContextClassLoader(cl.getClassLoader());
    }

    public void destroyThreadClassLoader(ClassLoader loader) {
        this.getClassLoadingService().destroyThreadContextClassLoader(loader);
    }
}

