/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.springboot.support.web.server.initializer;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.app.manager.springboot.container.ApplicationError;
import com.ibm.ws.app.manager.springboot.container.ApplicationTr;
import com.ibm.ws.app.manager.springboot.container.SpringBootConfigFactory;
import com.ibm.ws.app.manager.springboot.container.config.ConfigElementList;
import com.ibm.ws.app.manager.springboot.container.config.HttpEndpoint;
import com.ibm.ws.app.manager.springboot.container.config.KeyEntry;
import com.ibm.ws.app.manager.springboot.container.config.KeyStore;
import com.ibm.ws.app.manager.springboot.container.config.SSLConfig;
import com.ibm.ws.app.manager.springboot.container.config.ServerConfiguration;
import com.ibm.ws.app.manager.springboot.container.config.VirtualHost;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ServerConfigurationFactory {
    private static final String SECURITY_DIR = "resources/security/";
    public static final String LIBERTY_USE_DEFAULT_HOST = "server.liberty.use-default-host";
    public static final String PORT = "port";
    public static final String ADDRESS = "address";
    public static final String SERVER_HEADER = "server.header";
    public static final String SSL_CIPHERS = "ssl.ciphers";
    public static final String SSL_CLIENT_AUTH = "ssl.client-auth";
    public static final String SSL_ENABLED = "ssl.enabled";
    public static final String SSL_ENABLED_PROTOCOLS = "ssl.enabled-protocols";
    public static final String SSL_KEY_ALIAS = "ssl.key-alias";
    public static final String SSL_KEY_PASSWORD = "ssl.key-password";
    public static final String SSL_KEY_STORE = "ssl.key-store";
    public static final String SSL_KEY_STORE_PASSWORD = "ssl.key-store-password";
    public static final String SSL_KEY_STORE_PROVIDER = "ssl.key-store-provider";
    public static final String SSL_KEY_STORE_TYPE = "ssl.key-store-type";
    public static final String SSL_PROTOCOL = "ssl.protocol";
    public static final String SSL_TRUST_STORE = "ssl.trust-store";
    public static final String SSL_TRUST_STORE_PASSWORD = "ssl.trust-store-password";
    public static final String SSL_TRUST_STORE_PROVIDER = "ssl.trust-store-provider";
    public static final String SSL_TRUST_STORE_TYPE = "ssl.trust-store-type";
    public static final String HTTP2 = "http2";
    public static final String NEED = "NEED";
    public static final String WANT = "WANT";
    private static final String HTTP_11 = "http/1.1";
    private static final String HTTP_2 = "http/2";
    static final long serialVersionUID = 6655347443526275746L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static ServerConfiguration createServerConfiguration(Map<String, Object> serverProperties, SpringBootConfigFactory configFactory, Function<String, URL> urlGetter) {
        Integer port;
        ServerConfiguration sc = new ServerConfiguration();
        Boolean useDefaultHost = (Boolean)serverProperties.get(LIBERTY_USE_DEFAULT_HOST);
        if (useDefaultHost == null) {
            useDefaultHost = Boolean.FALSE;
        }
        if ((port = (Integer)serverProperties.get(PORT)) == null) {
            throw new IllegalArgumentException("No port specified.");
        }
        if (!useDefaultHost.booleanValue()) {
            ServerConfigurationFactory.configureVirtualHost(sc, port);
        }
        ServerConfigurationFactory.configureSSL(sc, port, serverProperties, configFactory, urlGetter);
        ServerConfigurationFactory.configureHttpEndpoint(sc, port, serverProperties);
        return sc;
    }

    public static void checkSpringBootVersion(String min, String max, String actual) {
        VersionRange range = null;
        Version vActual = null;
        try {
            vActual = Version.valueOf((String)actual);
            range = max == null ? new VersionRange(min) : new VersionRange('[' + min + ',' + max + ')');
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.springboot.support.web.server.initializer.ServerConfigurationFactory", (String)"108", null, (Object[])new Object[]{min, max, actual});
        }
        if (!range.includes(vActual)) {
            throw new ApplicationError(ApplicationTr.Type.ERROR_UNSUPPORTED_SPRING_BOOT_VERSION, new Object[]{actual, range.toString()});
        }
    }

    private static void configureVirtualHost(ServerConfiguration sc, Integer port) {
        ConfigElementList virtualHosts = sc.getVirtualHosts();
        virtualHosts.clear();
        VirtualHost virtualHost = new VirtualHost();
        virtualHost.setId("springBootVirtualHost-" + port);
        Set aliases = virtualHost.getHostAliases();
        aliases.clear();
        aliases.add("*:" + port);
        virtualHosts.add(virtualHost);
    }

    private static void configureHttpEndpoint(ServerConfiguration sc, Integer port, Map<String, Object> serverProperties) {
        Boolean isHttp2Enabled;
        ConfigElementList endpoints = sc.getHttpEndpoints();
        endpoints.clear();
        HttpEndpoint endpoint = new HttpEndpoint();
        endpoints.add(endpoint);
        endpoint.setId("springBootHttpEndpoint-" + port);
        String address = (String)serverProperties.get(ADDRESS);
        if (address != null) {
            endpoint.setHost(address);
        } else {
            endpoint.setHost("*");
        }
        if (sc.getSsls().isEmpty()) {
            endpoint.setHttpPort(port);
            endpoint.setHttpsPort(Integer.valueOf(-1));
        } else {
            endpoint.setHttpPort(Integer.valueOf(-1));
            endpoint.setHttpsPort(port);
            endpoint.getSslOptions().setSslRef("springBootSsl-" + port);
        }
        String serverHeader = (String)serverProperties.get(SERVER_HEADER);
        if (serverHeader != null) {
            endpoint.getHttpOptions().setServerHeaderValue(serverHeader);
        }
        if ((isHttp2Enabled = (Boolean)serverProperties.get(HTTP2)) != null) {
            if (isHttp2Enabled.booleanValue()) {
                endpoint.setProtocolVersion(HTTP_2);
            } else {
                endpoint.setProtocolVersion(HTTP_11);
            }
        }
    }

    private static void configureSSL(ServerConfiguration sc, Integer port, Map<String, Object> serverProperties, SpringBootConfigFactory configFactory, Function<String, URL> urlGetter) {
        String clientAuth;
        String[] ciphers;
        Boolean enabled = (Boolean)serverProperties.get(SSL_ENABLED);
        if (enabled != null && !enabled.booleanValue()) {
            return;
        }
        String keyStore = (String)serverProperties.get(SSL_KEY_STORE);
        if (keyStore == null) {
            return;
        }
        ConfigElementList ssls = sc.getSsls();
        ssls.clear();
        SSLConfig sslConfig = new SSLConfig();
        sslConfig.setId("springBootSsl-" + port);
        sslConfig.setKeyStoreRef("springBootKeyStore-" + port);
        ssls.add((Object)sslConfig);
        String protocol = (String)serverProperties.get(SSL_PROTOCOL);
        if (protocol != null) {
            sslConfig.setSslProtocol(protocol);
        }
        if ((ciphers = (String[])serverProperties.get(SSL_CIPHERS)) != null && ciphers.length > 0) {
            StringBuilder enabledCiphers = new StringBuilder();
            for (String cipher : ciphers) {
                enabledCiphers.append(cipher).append(" ");
            }
            sslConfig.setEnabledCiphers(enabledCiphers.toString());
        }
        ConfigElementList keyStores = sc.getKeyStores();
        keyStores.clear();
        ServerConfigurationFactory.configureKeyStore((ConfigElementList<KeyStore>)keyStores, port, serverProperties, configFactory, urlGetter);
        String trustStore = (String)serverProperties.get(SSL_TRUST_STORE);
        if (trustStore != null) {
            sslConfig.setTrustStoreRef("springBootTrustStore-" + port);
            ServerConfigurationFactory.configureTrustStore((ConfigElementList<KeyStore>)keyStores, port, serverProperties, configFactory, urlGetter);
        }
        if ((clientAuth = (String)serverProperties.get(SSL_CLIENT_AUTH)) != null) {
            if (NEED.equals(clientAuth)) {
                sslConfig.setClientAuthentication(Boolean.valueOf(true));
            } else if (WANT.equals(clientAuth)) {
                sslConfig.setClientAuthenticationSupported(Boolean.valueOf(true));
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void configureKeyStore(ConfigElementList<KeyStore> keyStores, Integer port, Map<String, Object> serverProperties, SpringBootConfigFactory configFactory, Function<String, URL> urlGetter) {
        String provider;
        String ksType;
        String keyStoreName;
        KeyStore keyStore;
        block13: {
            keyStore = new KeyStore();
            keyStores.add((Object)keyStore);
            keyStore.setId("springBootKeyStore-" + port);
            URL keyStoreURL = urlGetter.apply((String)serverProperties.get(SSL_KEY_STORE));
            String keyStoreURLString = keyStoreURL.toString();
            keyStoreName = keyStoreURLString.substring(keyStoreURLString.lastIndexOf("/") + 1);
            int dot = keyStoreName.lastIndexOf(".");
            keyStoreName = keyStoreName.substring(0, dot) + "-" + port + keyStoreName.substring(dot);
            File securityDir = new File(configFactory.getServerDir(), SECURITY_DIR);
            File keyStoreFile = new File(securityDir, keyStoreName);
            try {
                InputStream in = keyStoreURL.openStream();
                try {
                    ServerConfigurationFactory.writeFile(in, keyStoreFile);
                    if (in == null) break block13;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.springboot.support.web.server.initializer.ServerConfigurationFactory", (String)"236", null, (Object[])new Object[]{keyStores, port, serverProperties, configFactory, urlGetter});
                    if (in == null) throw throwable;
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.springboot.support.web.server.initializer.ServerConfigurationFactory", (String)"236", null, (Object[])new Object[]{keyStores, port, serverProperties, configFactory, urlGetter});
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                in.close();
            }
            catch (IOException in) {
                void e;
                FFDCFilter.processException((Throwable)in, (String)"com.ibm.ws.springboot.support.web.server.initializer.ServerConfigurationFactory", (String)"238", null, (Object[])new Object[]{keyStores, port, serverProperties, configFactory, urlGetter});
                throw new RuntimeException("Unable to copy keystore to server home/resources/security directory.", (Throwable)e);
            }
        }
        keyStore.setLocation(keyStoreName);
        String ksPass = (String)serverProperties.get(SSL_KEY_STORE_PASSWORD);
        if (ksPass != null) {
            keyStore.setPassword(ksPass);
        }
        if ((ksType = (String)serverProperties.get(SSL_KEY_STORE_TYPE)) != null) {
            keyStore.setType(ksType);
        }
        if ((provider = (String)serverProperties.get(SSL_KEY_STORE_PROVIDER)) != null) {
            keyStore.setExtraAttribute("provider", provider);
        }
        String keyAlias = (String)serverProperties.get(SSL_KEY_ALIAS);
        String keyPass = (String)serverProperties.get(SSL_KEY_PASSWORD);
        if (keyAlias == null) {
            if (keyPass == null) return;
        }
        ConfigElementList keyEntries = keyStore.getKeyEntries();
        keyEntries.clear();
        KeyEntry keyEntry = new KeyEntry();
        keyEntries.add((Object)keyEntry);
        if (keyAlias != null) {
            keyEntry.setName(keyAlias);
        } else {
            keyEntry.setName("keyEntry");
        }
        if (keyPass != null) {
            keyEntry.setKeyPassword(keyPass);
        }
        keyEntries.add((Object)keyEntry);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void configureTrustStore(ConfigElementList<KeyStore> keyStores, Integer port, Map<String, Object> serverProperties, SpringBootConfigFactory configFactory, Function<String, URL> urlGetter) {
        String provider;
        String tsType;
        String trustStoreName;
        KeyStore keyStore;
        block8: {
            keyStore = new KeyStore();
            keyStores.add((Object)keyStore);
            keyStore.setId("springBootTrustStore-" + port);
            URL trustStoreURL = urlGetter.apply((String)serverProperties.get(SSL_TRUST_STORE));
            String trustStoreURLString = trustStoreURL.toString();
            trustStoreName = trustStoreURLString.substring(trustStoreURLString.lastIndexOf("/") + 1);
            int dot = trustStoreName.lastIndexOf(".");
            trustStoreName = trustStoreName.substring(0, dot) + "-" + port + trustStoreName.substring(dot);
            File trustStoreDir = new File(configFactory.getServerDir(), SECURITY_DIR);
            File trustStoreFile = new File(trustStoreDir, trustStoreName);
            try {
                InputStream in = trustStoreURL.openStream();
                try {
                    ServerConfigurationFactory.writeFile(in, trustStoreFile);
                    if (in == null) break block8;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.springboot.support.web.server.initializer.ServerConfigurationFactory", (String)"292", null, (Object[])new Object[]{keyStores, port, serverProperties, configFactory, urlGetter});
                    if (in == null) throw throwable;
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.springboot.support.web.server.initializer.ServerConfigurationFactory", (String)"292", null, (Object[])new Object[]{keyStores, port, serverProperties, configFactory, urlGetter});
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                in.close();
            }
            catch (IOException in) {
                void e;
                FFDCFilter.processException((Throwable)in, (String)"com.ibm.ws.springboot.support.web.server.initializer.ServerConfigurationFactory", (String)"294", null, (Object[])new Object[]{keyStores, port, serverProperties, configFactory, urlGetter});
                throw new RuntimeException("Unable to copy truststore to server home/resources/security directory.", (Throwable)e);
            }
        }
        keyStore.setLocation(trustStoreName);
        String tsPass = (String)serverProperties.get(SSL_TRUST_STORE_PASSWORD);
        if (tsPass != null) {
            keyStore.setPassword(tsPass);
        }
        if ((tsType = (String)serverProperties.get(SSL_TRUST_STORE_TYPE)) != null) {
            keyStore.setType(tsType);
        }
        if ((provider = (String)serverProperties.get(SSL_TRUST_STORE_PROVIDER)) == null) return;
        keyStore.setExtraAttribute("provider", provider);
    }

    private static void writeFile(InputStream in, File dest) throws FileNotFoundException, IOException {
        dest.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(dest);
        try {
            int count;
            byte[] buffer = new byte[4096];
            while ((count = in.read(buffer, 0, buffer.length)) > 0) {
                fos.write(buffer, 0, count);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.springboot.support.web.server.initializer.ServerConfigurationFactory", (String)"316", null, (Object[])new Object[]{in, dest});
            try {
                fos.close();
            }
            catch (Throwable throwable2) {
                FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.springboot.support.web.server.initializer.ServerConfigurationFactory", (String)"316", null, (Object[])new Object[]{in, dest});
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        fos.close();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ServerConfigurationFactory.class, (String[])new String[]{"springboot", "applications"}, null, (String)"com.ibm.ws.springboot.support.web.server.initializer.ServerConfigurationFactory");
    }
}

