/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.ejb.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.internal.interfaces.SecurityContextStore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.ejb.EJBContext;
import java.security.Principal;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.cdi.ejb.security.EJBSecurityContextStore", immediate=true, property={"service.vendor=IBM", "service.ranking:Integer=99"})
public class EjbSecurityContextStore
implements SecurityContextStore {
    private static final TraceComponent tc = Tr.register(EjbSecurityContextStore.class, (String)"JCDI", (String)"com.ibm.ws.cdi.ejb.resources.CDIEJB");
    private static final AtomicReference<EjbSecurityContextStore> INSTANCE = new AtomicReference();
    private final ThreadLocal<Stack<EJBContext>> ejbContexts = new ThreadLocal();
    static final long serialVersionUID = 2932477752254141761L;

    protected void activate(ComponentContext compcontext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Activating " + this.getClass().getName()), (Object[])new Object[0]);
        }
        INSTANCE.set(this);
    }

    protected void deactivate(ComponentContext compcontext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Deactivating " + this.getClass().getName()), (Object[])new Object[0]);
        }
        INSTANCE.compareAndSet(this, null);
    }

    public static EjbSecurityContextStore getCurrentInstance() {
        return INSTANCE.get();
    }

    public Principal getCurrentPrincipal() {
        Stack<EJBContext> ejbContextStack = this.getStackOfEjbContexts();
        if (ejbContextStack.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getCurrentPrincipal: no ejbContexts in stack, returning null", (Object[])new Object[0]);
            }
            return null;
        }
        EJBContext currentContext = ejbContextStack.peek();
        if (currentContext != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (currentContext.getCallerPrincipal() == null) {
                    Tr.debug((TraceComponent)tc, (String)"getCurrentPrincipal: null", (Object[])new Object[0]);
                } else {
                    Tr.debug((TraceComponent)tc, (String)("getCurrentPrincipal: " + currentContext.getCallerPrincipal().getName()), (Object[])new Object[0]);
                }
            }
            return currentContext.getCallerPrincipal();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getCurrentPrincipal: null context", (Object[])new Object[0]);
        }
        return null;
    }

    public void storeEJBContext(EJBContext ejb) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("storeEJBContext: " + ejb), (Object[])new Object[0]);
        }
        Stack<EJBContext> stack = this.getStackOfEjbContexts();
        stack.push(ejb);
    }

    public void removeEJBContext() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removeEJBContext: " + this.ejbContexts.get()), (Object[])new Object[0]);
        }
        Stack<EJBContext> stack = this.getStackOfEjbContexts();
        stack.pop();
        if (stack.isEmpty()) {
            this.ejbContexts.remove();
        }
    }

    private Stack<EJBContext> getStackOfEjbContexts() {
        Stack<Object> stackejb = this.ejbContexts.get();
        if (null == stackejb) {
            stackejb = new Stack();
            this.ejbContexts.set(stackejb);
        }
        return stackejb;
    }
}

