/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.targets.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.service.internal.AnnotationCacheServiceImpl_Logging;
import com.ibm.ws.annocache.targets.internal.TargetsTableImpl;
import com.ibm.ws.annocache.targets.internal.TargetsVisitorAnnotationImpl;
import com.ibm.ws.annocache.util.internal.UtilImpl_IdentityStringSet;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.asm.ASMHelper;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class TargetsVisitorClassImpl
extends ClassVisitor {
    protected static final Logger logger = AnnotationCacheServiceImpl_Logging.ANNO_LOGGER;
    public static final String CLASS_NAME = TargetsVisitorClassImpl.class.getSimpleName();
    public static final String PACKAGE_INFO_CLASS_NAME = "package-info";
    public static final Set<String> SELECT_ALL_ANNOTATIONS = null;
    public static final Set<String> SELECT_NO_ANNOTATIONS = Collections.emptySet();
    public static final boolean DO_RECORD_ANNOTATION_DETAIL = true;
    public static final boolean DO_NOT_RECORD_ANNOTATION_DETAIL = false;
    protected final String hashText;
    protected final TargetsTableImpl targetsData;
    protected String externalName;
    protected final ClassData classData;
    public static final Set<String> DONT_RECORD_NEW_UNRESOLVED = null;
    public static final Set<String> DONT_RECORD_UNRESOLVED = null;
    protected final Set<String> i_newUnresolvedClassNames;
    protected final Set<String> i_unresolvedClassNames;
    public static final Set<String> DONT_RECORD_NEW_RESOLVED = null;
    public static final Set<String> DONT_RECORD_RESOLVED = null;
    protected final Set<String> i_newResolvedClassNames;
    protected final Set<String> i_resolvedClassNames;
    protected final Set<String> i_selectAnnotationClassNames;
    protected final FieldVisitor fieldVisitor;
    protected final MethodVisitor methodVisitor;
    protected final TargetsVisitorAnnotationImpl annotationVisitor;
    public static final VisitEnded VISIT_ENDED_CLASS_MISMATCH = new VisitEnded(VisitEndCase.VISIT_END_CLASS_MISMATCH);
    public static final VisitEnded VISIT_ENDED_PACKAGE_MISMATCH = new VisitEnded(VisitEndCase.VISIT_END_PACKAGE_MISMATCH);
    static final long serialVersionUID = 526752971670680976L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isPackageName(String className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "isPackageName", new Object[]{className});
        }
        boolean bl = className.endsWith(PACKAGE_INFO_CLASS_NAME);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "isPackageName", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String stripPackageNameFromClassName(String className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "stripPackageNameFromClassName", new Object[]{className});
        }
        String string = className.substring(0, className.length() - (PACKAGE_INFO_CLASS_NAME.length() + 1));
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "stripPackageNameFromClassName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static String getResourceNameFromDescription(String desc) {
        String resourceName;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "getResourceNameFromDescription", new Object[]{desc});
        }
        Type type = Type.getType((String)desc);
        String className = type.getClassName();
        String string = resourceName = className.replace(".", "/");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "getResourceNameFromDescription", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static String getClassResourceNameFromAnnotationDescription(String desc) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "getClassResourceNameFromAnnotationDescription", new Object[]{desc});
        }
        String string = desc.substring(1, desc.length() - 1);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "getClassResourceNameFromAnnotationDescription", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static String getClassNameFromPartialResourceName(String partialResourceName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "getClassNameFromPartialResourceName", new Object[]{partialResourceName});
        }
        String string = partialResourceName.replace("/", ".");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "getClassNameFromPartialResourceName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetsVisitorClassImpl(TargetsTableImpl parentData, String classSourceName, Set<String> i_newResolvedClassNames, Set<String> i_resolvedClassNames, Set<String> i_newUnresolvedClassNames, Set<String> i_unresolvedClassNames, Set<String> i_selectAnnotationClassNames, boolean recordDetail) {
        super(ASMHelper.getCurrentASM());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "<init>", new Object[]{parentData, classSourceName, i_newResolvedClassNames, i_resolvedClassNames, i_newUnresolvedClassNames, i_unresolvedClassNames, i_selectAnnotationClassNames, recordDetail});
        }
        String methodName = "<init>";
        this.hashText = ((Object)((Object)this)).getClass().getSimpleName() + "@" + Integer.toHexString(((Object)((Object)this)).hashCode());
        this.targetsData = parentData;
        this.classData = new ClassData(classSourceName);
        if (i_resolvedClassNames == null != (i_unresolvedClassNames == null)) {
            throw new IllegalArgumentException("Both or neither of the class names stores must be null.");
        }
        this.i_newResolvedClassNames = i_newResolvedClassNames;
        this.i_resolvedClassNames = i_resolvedClassNames;
        this.i_newUnresolvedClassNames = i_newUnresolvedClassNames;
        this.i_unresolvedClassNames = i_unresolvedClassNames;
        this.i_selectAnnotationClassNames = i_selectAnnotationClassNames;
        this.fieldVisitor = new AnnoFieldVisitor();
        this.methodVisitor = new AnnoMethodVisitor();
        TargetsVisitorAnnotationImpl targetsVisitorAnnotationImpl = this.annotationVisitor = recordDetail ? new TargetsVisitorAnnotationImpl(this) : null;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] on [ {1} ]", new Object[]{this.hashText, this.targetsData.getHashText()});
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] detail [ {1} ]", new Object[]{this.hashText, recordDetail});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void reset() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "reset", new Object[0]);
        }
        this.externalName = null;
        this.classData.reset();
        if (this.annotationVisitor != null) {
            this.annotationVisitor.reset();
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "reset");
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getHashText() {
        return this.hashText;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetsTableImpl geTargetsData() {
        return this.targetsData;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String internClassName(String className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "internClassName", new Object[]{className});
        }
        String string = this.geTargetsData().internClassName(className);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "internClassName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String internClassName(String className, boolean doForce) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "internClassName", new Object[]{className, doForce});
        }
        String string = this.geTargetsData().internClassName(className, doForce);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "internClassName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String internFieldName(String fieldName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "internFieldName", new Object[]{fieldName});
        }
        String string = this.geTargetsData().internFieldName(fieldName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "internFieldName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String internMethodSignature(String methodSignature) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "internMethodSignature", new Object[]{methodSignature});
        }
        String string = this.geTargetsData().internMethodSignature(methodSignature);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "internMethodSignature", string);
        }
        return string;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Map<String, String> createSmallMap() {
        return new IdentityHashMap<String, String>(3);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Set<String> createIdentitySet() {
        return new UtilImpl_IdentityStringSet();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setExternalName(String externalName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "setExternalName", new Object[]{externalName});
        }
        this.externalName = externalName;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "setExternalName");
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getExternalName() {
        return this.externalName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void recordAnnotation() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "recordAnnotation", new Object[0]);
        }
        this.classData.recordAnnotation();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "recordAnnotation");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void recordAnnotation(String annotationDetail) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "recordAnnotation", new Object[]{annotationDetail});
        }
        this.classData.recordAnnotation(annotationDetail);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "recordAnnotation");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getNewUnresolvedClassNames() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "i_getNewUnresolvedClassNames", new Object[0]);
        }
        Set<String> set = this.i_newUnresolvedClassNames;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "i_getNewUnresolvedClassNames", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getUnresolvedClassNames() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "i_getUnresolvedClassNames", new Object[0]);
        }
        Set<String> set = this.i_unresolvedClassNames;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "i_getUnresolvedClassNames", set);
        }
        return set;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getNewResolvedClassNames() {
        return this.i_newResolvedClassNames;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> i_getResolvedClassNames() {
        return this.i_resolvedClassNames;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void recordDefinition(String i_className) {
        String defCase;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "recordDefinition", new Object[]{i_className});
        }
        String methodName = "recordDefinition";
        if (this.i_resolvedClassNames == null) {
            defCase = "No resolved or unresolved; not recording";
        } else if (!this.i_resolvedClassNames.add(i_className)) {
            defCase = "Already resolved";
        } else {
            if (this.i_newResolvedClassNames != null) {
                this.i_newResolvedClassNames.add(i_className);
            }
            if (this.i_unresolvedClassNames.remove(i_className)) {
                if (this.i_newUnresolvedClassNames != null) {
                    this.i_newUnresolvedClassNames.remove(i_className);
                }
                defCase = "Newly resolved (with references)";
            } else {
                defCase = "Newly resolved (no references)";
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Class [ {0} ] ({1})", new Object[]{i_className, defCase});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "recordDefinition");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void recordReference(String i_className) {
        String referenceCase;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "recordReference", new Object[]{i_className});
        }
        String methodName = "recordReference";
        if (this.i_resolvedClassNames == null) {
            referenceCase = "Null resolved or unresolved; no recording";
        } else if (this.i_resolvedClassNames.contains(i_className)) {
            referenceCase = "Already resolved";
        } else if (!this.i_unresolvedClassNames.add(i_className)) {
            referenceCase = "Already unresolved";
        } else {
            if (this.i_newUnresolvedClassNames != null) {
                this.i_newUnresolvedClassNames.add(i_className);
            }
            referenceCase = "New unresolved";
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Class [ {0} ] ({1})", new Object[]{i_className, referenceCase});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "recordReference");
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Set<String> i_getSelectAnnotationClassNames() {
        return this.i_selectAnnotationClassNames;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String i_selectAnnotationClassName(String annotationClassName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "i_selectAnnotationClassName", new Object[]{annotationClassName});
        }
        if (this.i_selectAnnotationClassNames == null) {
            String string = this.internClassName(annotationClassName);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "i_selectAnnotationClassName", string);
            }
            return string;
        }
        String i_annotationClassName = this.internClassName(annotationClassName, false);
        if (i_annotationClassName == null) {
            String string = null;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "i_selectAnnotationClassName", string);
            }
            return string;
        }
        if (!this.i_selectAnnotationClassNames.contains(i_annotationClassName)) {
            String string = null;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "i_selectAnnotationClassName", string);
            }
            return string;
        }
        String string = i_annotationClassName;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "i_selectAnnotationClassName", string);
        }
        return string;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean getRecordDetail() {
        return this.annotationVisitor != null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void visit(int version, int access, String classResourceName, String signature, String superClassResourceName, String[] interfaceResourceNames) {
        Object[] logParms;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "visit", new Object[]{version, access, classResourceName, signature, superClassResourceName, interfaceResourceNames});
        }
        String methodName = "visit";
        if (logger.isLoggable(Level.FINER)) {
            logParms = new Object[]{this.getHashText(), classResourceName};
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Class [ {1} ]", logParms);
            logParms[1] = superClassResourceName;
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Superclass [ {1} ]", logParms);
            logParms[1] = interfaceResourceNames;
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Interfaces [ {1} ]", logParms);
        } else {
            logParms = null;
        }
        String className = TargetsVisitorClassImpl.getClassNameFromPartialResourceName(classResourceName);
        if (logParms != null) {
            logParms[1] = className + ".class";
        }
        if (TargetsVisitorClassImpl.isPackageName(className)) {
            String externalClassName;
            if (logParms != null && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] [ {1} ] Package load", logParms);
            }
            if (!(className = TargetsVisitorClassImpl.stripPackageNameFromClassName(className)).equals(externalClassName = TargetsVisitorClassImpl.stripPackageNameFromClassName(this.getExternalName()))) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Class name mismatch [ {1} ]", new Object[]{this.getHashText(), externalClassName});
                }
                throw VISIT_ENDED_PACKAGE_MISMATCH;
            }
            this.recordDefinition(this.classData.setClassName(false, className));
        } else {
            if (logParms != null && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] [ {1} ] Class load", logParms);
            }
            if (!className.equals(this.getExternalName())) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Class name mismatch [ {1} ]", new Object[]{this.getHashText(), className});
                }
                throw VISIT_ENDED_CLASS_MISMATCH;
            }
            this.recordDefinition(this.classData.setClassName(true, className));
            this.classData.setModifiers(access);
            if (superClassResourceName != null) {
                String superClassName = TargetsVisitorClassImpl.getClassNameFromPartialResourceName(superClassResourceName);
                this.classData.i_superclassName = this.internClassName(superClassName);
                this.recordReference(this.classData.i_superclassName);
            }
            if (interfaceResourceNames != null && interfaceResourceNames.length > 0) {
                String[] i_interfaceNames = new String[interfaceResourceNames.length];
                for (int nameNo = 0; nameNo < interfaceResourceNames.length; ++nameNo) {
                    String i_nextInterfaceName;
                    String nextInterfaceResourceName = interfaceResourceNames[nameNo];
                    String nextInterfaceName = TargetsVisitorClassImpl.getClassNameFromPartialResourceName(nextInterfaceResourceName);
                    i_interfaceNames[nameNo] = i_nextInterfaceName = this.internClassName(nextInterfaceName);
                    this.recordReference(i_interfaceNames[nameNo]);
                }
                this.classData.i_interfaceNames = i_interfaceNames;
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "visit");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void visitEnd() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "visitEnd", new Object[0]);
        }
        this.targetsData.record(this.classData);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "visitEnd");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "visitAnnotation", new Object[]{desc, visible});
        }
        String annotationResourceName = TargetsVisitorClassImpl.getClassResourceNameFromAnnotationDescription(desc);
        String annotationClassName = TargetsVisitorClassImpl.getClassNameFromPartialResourceName(annotationResourceName);
        String i_annotationClassName = this.i_selectAnnotationClassName(annotationClassName);
        if (i_annotationClassName == null) {
            AnnotationVisitor annotationVisitor = null;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                annotationVisitor = annotationVisitor;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "visitAnnotation", annotationVisitor);
            }
            return annotationVisitor;
        }
        this.classData.i_annotationClassName = i_annotationClassName;
        this.recordReference(this.classData.i_annotationClassName);
        if (this.annotationVisitor == null) {
            this.classData.recordClassAnnotation();
        }
        TargetsVisitorAnnotationImpl targetsVisitorAnnotationImpl = this.annotationVisitor;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            targetsVisitorAnnotationImpl = targetsVisitorAnnotationImpl;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "visitAnnotation", (Object)targetsVisitorAnnotationImpl);
        }
        return targetsVisitorAnnotationImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object defaultValue) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "visitField", new Object[]{access, name, desc, signature, defaultValue});
        }
        this.classData.setFieldName(name);
        FieldVisitor fieldVisitor = this.fieldVisitor;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            fieldVisitor = fieldVisitor;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "visitField", fieldVisitor);
        }
        return fieldVisitor;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "visitMethod", new Object[]{access, name, desc, signature, exceptions});
        }
        if (signature == null) {
            signature = name + desc;
        }
        this.classData.setMethodSignature(signature);
        MethodVisitor methodVisitor = this.methodVisitor;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            methodVisitor = methodVisitor;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl", "visitMethod", methodVisitor);
        }
        return methodVisitor;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected class AnnoMethodVisitor
    extends MethodVisitor {
        static final long serialVersionUID = -6096206221671015043L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public AnnoMethodVisitor() {
            super(ASMHelper.getCurrentASM());
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            String annotationResourceName = TargetsVisitorClassImpl.getClassResourceNameFromAnnotationDescription(desc);
            String annotationClassName = TargetsVisitorClassImpl.getClassNameFromPartialResourceName(annotationResourceName);
            String i_annotationClassName = TargetsVisitorClassImpl.this.i_selectAnnotationClassName(annotationClassName);
            if (i_annotationClassName == null) {
                return null;
            }
            TargetsVisitorClassImpl.this.classData.i_annotationClassName = i_annotationClassName;
            TargetsVisitorClassImpl.this.recordReference(TargetsVisitorClassImpl.this.classData.i_annotationClassName);
            if (TargetsVisitorClassImpl.this.annotationVisitor == null) {
                TargetsVisitorClassImpl.this.classData.recordMethodAnnotation();
            }
            return TargetsVisitorClassImpl.this.annotationVisitor;
        }

        public AnnotationVisitor visitParameterAnnotation(int param, String desc, boolean visible) {
            return null;
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return null;
        }

        public void visitEnd() {
            TargetsVisitorClassImpl.this.classData.setMethodSignature(null);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl$AnnoMethodVisitor", AnnoMethodVisitor.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected class AnnoFieldVisitor
    extends FieldVisitor {
        static final long serialVersionUID = -1200015536480446481L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public AnnoFieldVisitor() {
            super(ASMHelper.getCurrentASM());
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            String annotationResourceName = TargetsVisitorClassImpl.getClassResourceNameFromAnnotationDescription(desc);
            String annotationClassName = TargetsVisitorClassImpl.getClassNameFromPartialResourceName(annotationResourceName);
            String i_annotationClassName = TargetsVisitorClassImpl.this.i_selectAnnotationClassName(annotationClassName);
            if (i_annotationClassName == null) {
                return null;
            }
            TargetsVisitorClassImpl.this.classData.i_annotationClassName = i_annotationClassName;
            TargetsVisitorClassImpl.this.recordReference(TargetsVisitorClassImpl.this.classData.i_annotationClassName);
            if (TargetsVisitorClassImpl.this.annotationVisitor == null) {
                TargetsVisitorClassImpl.this.classData.recordFieldAnnotation();
            }
            return TargetsVisitorClassImpl.this.annotationVisitor;
        }

        public void visitEnd() {
            TargetsVisitorClassImpl.this.classData.setFieldName(null);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl$AnnoFieldVisitor", AnnoFieldVisitor.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class VisitEnded
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        protected final VisitEndCase endCase;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public VisitEnded(VisitEndCase endCase) {
            this.endCase = endCase;
        }

        @Override
        public Throwable fillInStackTrace() {
            return null;
        }

        public VisitEndCase getEndCase() {
            return this.endCase;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl$VisitEnded", VisitEnded.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        }
    }

    public static enum VisitEndCase {
        VISIT_END_CLASS_MISMATCH,
        VISIT_END_PACKAGE_MISMATCH;

    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected class ClassData {
        protected String classSourceName;
        protected boolean isClass;
        protected String className;
        protected String i_className;
        protected String i_superclassName;
        protected String[] i_interfaceNames;
        protected int modifiers;
        protected String i_annotationClassName;
        protected Set<String> i_classAnnotations;
        protected Map<String, String> i_classAnnotationsDetail;
        protected String fieldName;
        protected String i_fieldName;
        protected Map<String, Set<String>> i_classFieldAnnotations;
        protected Map<String, Map<String, String>> i_classFieldAnnotationsDetail;
        protected String methodSignature;
        protected String i_methodSignature;
        protected Map<String, Set<String>> i_classMethodAnnotations;
        protected Map<String, Map<String, String>> i_classMethodAnnotationsDetail;
        public static final boolean IS_CLASS = true;
        public static final boolean IS_NOT_CLASS = false;
        static final long serialVersionUID = -3468639700028925340L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ClassData(String classSourceName) {
            this.classSourceName = classSourceName;
        }

        public String setClassName(boolean isClass, String className) {
            this.isClass = isClass;
            this.className = className;
            this.i_className = TargetsVisitorClassImpl.this.internClassName(className, true);
            return this.i_className;
        }

        public void setModifiers(int modifiers) {
            this.modifiers = modifiers;
        }

        protected void setFieldName(String fieldName) {
            this.fieldName = fieldName;
            this.i_fieldName = null;
        }

        protected String i_getFieldName() {
            if (this.fieldName == null) {
                return null;
            }
            if (this.i_fieldName == null) {
                this.i_fieldName = TargetsVisitorClassImpl.this.internFieldName(this.fieldName);
            }
            return this.i_fieldName;
        }

        protected void setMethodSignature(String methodSignature) {
            this.methodSignature = methodSignature;
            this.i_methodSignature = null;
        }

        protected String i_getMethodSignature() {
            if (this.methodSignature == null) {
                return null;
            }
            if (this.i_methodSignature == null) {
                this.i_methodSignature = TargetsVisitorClassImpl.this.internMethodSignature(this.methodSignature);
            }
            return this.i_methodSignature;
        }

        protected void recordAnnotation() {
            if (this.i_getFieldName() != null) {
                this.recordFieldAnnotation();
            } else if (this.i_getMethodSignature() != null) {
                this.recordMethodAnnotation();
            } else {
                this.recordClassAnnotation();
            }
        }

        protected void recordClassAnnotation() {
            if (this.i_classAnnotations == null) {
                this.i_classAnnotations = TargetsVisitorClassImpl.this.createIdentitySet();
            }
            this.i_classAnnotations.add(this.i_annotationClassName);
            this.i_annotationClassName = null;
        }

        protected void recordFieldAnnotation() {
            Set<String> i_fieldAnnotations;
            if (this.i_classFieldAnnotations == null) {
                this.i_classFieldAnnotations = new IdentityHashMap<String, Set<String>>();
                i_fieldAnnotations = null;
            } else {
                i_fieldAnnotations = this.i_classFieldAnnotations.get(this.i_fieldName);
            }
            if (i_fieldAnnotations == null) {
                i_fieldAnnotations = TargetsVisitorClassImpl.this.createIdentitySet();
                this.i_classFieldAnnotations.put(this.i_fieldName, i_fieldAnnotations);
            }
            i_fieldAnnotations.add(this.i_annotationClassName);
            this.i_annotationClassName = null;
        }

        protected void recordMethodAnnotation() {
            Set<String> i_methodAnnotations;
            if (this.i_classMethodAnnotations == null) {
                this.i_classMethodAnnotations = new IdentityHashMap<String, Set<String>>();
                i_methodAnnotations = null;
            } else {
                i_methodAnnotations = this.i_classMethodAnnotations.get(this.i_methodSignature);
            }
            if (i_methodAnnotations == null) {
                i_methodAnnotations = TargetsVisitorClassImpl.this.createIdentitySet();
                this.i_classMethodAnnotations.put(this.i_methodSignature, i_methodAnnotations);
            }
            i_methodAnnotations.add(this.i_annotationClassName);
            this.i_annotationClassName = null;
        }

        protected void recordAnnotation(String annotationDetail) {
            if (this.i_getFieldName() != null) {
                this.recordFieldAnnotation(annotationDetail);
            } else if (this.i_getMethodSignature() != null) {
                this.recordMethodAnnotation(annotationDetail);
            } else {
                this.recordClassAnnotation(annotationDetail);
            }
        }

        protected void recordClassAnnotation(String annotationDetail) {
            if (this.i_classAnnotationsDetail == null) {
                this.i_classAnnotationsDetail = TargetsVisitorClassImpl.this.createSmallMap();
            }
            this.i_classAnnotationsDetail.put(this.i_annotationClassName, annotationDetail);
            this.i_annotationClassName = null;
        }

        protected void recordFieldAnnotation(String annotationDetail) {
            Map<String, String> i_fieldAnnotations;
            if (this.i_classFieldAnnotationsDetail == null) {
                this.i_classFieldAnnotationsDetail = new IdentityHashMap<String, Map<String, String>>();
                i_fieldAnnotations = null;
            } else {
                i_fieldAnnotations = this.i_classFieldAnnotationsDetail.get(this.i_fieldName);
            }
            if (i_fieldAnnotations == null) {
                i_fieldAnnotations = TargetsVisitorClassImpl.this.createSmallMap();
                this.i_classFieldAnnotationsDetail.put(this.i_fieldName, i_fieldAnnotations);
            }
            i_fieldAnnotations.put(this.i_annotationClassName, annotationDetail);
            this.i_annotationClassName = null;
        }

        protected void recordMethodAnnotation(String annotationDetail) {
            Map<String, String> i_methodAnnotations;
            if (this.i_classMethodAnnotationsDetail == null) {
                this.i_classMethodAnnotationsDetail = new IdentityHashMap<String, Map<String, String>>();
                i_methodAnnotations = null;
            } else {
                i_methodAnnotations = this.i_classMethodAnnotationsDetail.get(this.i_methodSignature);
            }
            if (i_methodAnnotations == null) {
                i_methodAnnotations = TargetsVisitorClassImpl.this.createSmallMap();
                this.i_classMethodAnnotationsDetail.put(this.i_methodSignature, i_methodAnnotations);
            }
            i_methodAnnotations.put(this.i_annotationClassName, annotationDetail);
            this.i_annotationClassName = null;
        }

        protected void reset() {
            this.isClass = false;
            this.className = null;
            this.i_className = null;
            this.i_superclassName = null;
            this.i_interfaceNames = null;
            this.modifiers = 0;
            this.fieldName = null;
            this.i_fieldName = null;
            this.methodSignature = null;
            this.i_methodSignature = null;
            this.i_annotationClassName = null;
            this.i_classAnnotations = null;
            this.i_classAnnotationsDetail = null;
            this.i_classMethodAnnotations = null;
            this.i_classMethodAnnotationsDetail = null;
            this.i_classFieldAnnotations = null;
            this.i_classFieldAnnotationsDetail = null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl$ClassData", ClassData.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        }
    }
}

