/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.http.VirtualHost;
import io.openliberty.microprofile.openapi20.internal.utils.CloudUtils;
import io.openliberty.microprofile.openapi20.internal.utils.LoggingUtils;
import io.openliberty.microprofile.openapi20.internal.utils.ServerInfo;
import java.util.Arrays;
import java.util.Map;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={DefaultHostListener.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true)
public class DefaultHostListener {
    private static final TraceComponent tc = Tr.register(DefaultHostListener.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    private static DefaultHostListener instance = null;
    private final ServerInfo defaultHostServerInfo = new ServerInfo();
    static final long serialVersionUID = -924385989789340969L;

    public static DefaultHostListener getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerInfo getDefaultHostServerInfo() {
        ServerInfo serverInfo = this.defaultHostServerInfo;
        synchronized (serverInfo) {
            return new ServerInfo(this.defaultHostServerInfo);
        }
    }

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        instance = this;
        if (LoggingUtils.isEventEnabled(tc)) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"Activating DefaultHostListener", (Object[])new Object[]{properties});
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
        instance = null;
        if (LoggingUtils.isEventEnabled(tc)) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Deactivating DefaultHostListener, reason=" + reason), (Object[])new Object[0]);
        }
    }

    @Reference(service=VirtualHost.class, target="(&(enabled=true)(id=default_host)(|(aliases=*)(httpsAlias=*)))", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)
    protected void setVirtualHost(VirtualHost vhost, Map<String, Object> props) {
        this.updateDefaultHostServerInfo(vhost, props);
    }

    protected void updatedVirtualHost(VirtualHost vhost, Map<String, Object> props) {
        this.updateDefaultHostServerInfo(vhost, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDefaultHostServerInfo(VirtualHost vhost, Map<String, Object> props) {
        String host;
        String vcapHost;
        Object value = props.get("httpsAlias");
        if (value == null) {
            CharSequence[] aliases = (String[])props.get("aliases");
            if (LoggingUtils.isDebugEnabled(tc)) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("httpsAlias is null. aliases : " + String.join((CharSequence)", ", aliases)), (Object[])new Object[0]);
            }
            value = Arrays.stream(aliases).filter(a -> !a.endsWith(":-1")).findFirst().orElse(null);
            if (LoggingUtils.isDebugEnabled(tc)) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Found non-secure alias: " + value), (Object[])new Object[0]);
            }
        }
        String alias = String.valueOf(value);
        if (LoggingUtils.isEventEnabled(tc)) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Received new alias: " + alias), (Object[])new Object[0]);
        }
        if ((vcapHost = CloudUtils.getVCAPHost()) == null) {
            host = vhost.getHostName(alias);
        } else {
            host = vcapHost;
            if (LoggingUtils.isEventEnabled(tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Changed host using VCAP_APPLICATION.  New value: " + this.defaultHostServerInfo.getHost()), (Object[])new Object[0]);
            }
        }
        ServerInfo serverInfo = this.defaultHostServerInfo;
        synchronized (serverInfo) {
            this.defaultHostServerInfo.setHttpPort(vhost.getHttpPort(alias));
            this.defaultHostServerInfo.setHttpsPort(vhost.getSecureHttpPort(alias));
            this.defaultHostServerInfo.setHost(host);
        }
        if (LoggingUtils.isEventEnabled(tc)) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Updated server information: " + this.defaultHostServerInfo), (Object[])new Object[0]);
        }
    }
}

