/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.tokenstore;

import java.io.Closeable;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Supplier;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.tokenstore.TokenStoreException;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.Status;
import org.ehcache.config.Builder;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.expiry.ExpiryPolicy;
import org.ehcache.xml.XmlConfiguration;

public class EHCacheTokenStore
implements TokenStore,
Closeable,
BusLifeCycleListener {
    protected static Duration timetoidle = null;
    protected static Duration timetolive = null;
    private final Bus bus;
    private Cache<String, SecurityToken> cache;
    private CacheManager cacheManager;
    private final String key;

    public EHCacheTokenStore(String key, Bus b, URL configFileURL) throws TokenStoreException {
        this.bus = b;
        if (this.bus != null) {
            ((BusLifeCycleManager)b.getExtension(BusLifeCycleManager.class)).registerLifeCycleListener((BusLifeCycleListener)this);
        }
        this.key = key;
        try {
            XmlConfiguration xmlConfig = new XmlConfiguration(configFileURL);
            String template = key;
            if (template.contains("-")) {
                template = key.substring(0, key.lastIndexOf(45));
            }
            CacheConfigurationBuilder configurationBuilder = xmlConfig.newCacheConfigurationBuilderFromTemplate(template, String.class, SecurityToken.class);
            this.cacheManager = CacheManagerBuilder.newCacheManagerBuilder().withCache(key, (Builder)configurationBuilder).build();
            this.cacheManager.init();
            this.cache = this.cacheManager.getCache(key, String.class, SecurityToken.class);
        }
        catch (Exception e) {
            throw new TokenStoreException(e);
        }
    }

    public EHCacheTokenStore(String cachekey, Bus bus, HashMap oldconfig) {
        this.key = cachekey;
        this.bus = bus;
        this.cacheManager = null;
        this.cache = null;
        Path diskstorePath = null;
        String path = (String)oldconfig.get("getDiskStorePath");
        if ("java.io.tmpdir".equals(path)) {
            path = path + File.separator + bus.getId();
        }
        diskstorePath = Paths.get(path, new String[0]);
        int diskElements = (Integer)oldconfig.get("getMaxElementsOnDisk");
        long heapEntries = (Long)oldconfig.get("getMaxEntriesLocalHeap");
        boolean persistent = (Boolean)oldconfig.get("isDiskPersistent");
        boolean eternal = (Boolean)oldconfig.get("isEternal");
        ExpiryPolicy custom_expiry = null;
        if (eternal) {
            custom_expiry = ExpiryPolicy.NO_EXPIRY;
        } else {
            timetoidle = Duration.of((Long)oldconfig.get("getTimeToIdleSeconds"), ChronoUnit.SECONDS);
            timetolive = Duration.of((Long)oldconfig.get("getTimeToLiveSeconds"), ChronoUnit.SECONDS);
            custom_expiry = new ExpiryPolicy<Object, Object>(){

                public String toString() {
                    return "Custom Expiry";
                }

                public Duration getExpiryForCreation(Object key, Object value) {
                    return timetolive;
                }

                public Duration getExpiryForAccess(Object key, Supplier<?> value) {
                    return timetoidle;
                }

                public Duration getExpiryForUpdate(Object key, Supplier<?> oldValue, Object newValue) {
                    return null;
                }
            };
        }
        ResourcePoolsBuilder resourcePoolsBuilder = null;
        CacheConfigurationBuilder configurationBuilder = null;
        resourcePoolsBuilder = ResourcePoolsBuilder.newResourcePoolsBuilder().heap(heapEntries, (ResourceUnit)EntryUnit.ENTRIES);
        configurationBuilder = CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, SecurityToken.class, (Builder)resourcePoolsBuilder).withExpiry(custom_expiry);
        this.cacheManager = CacheManagerBuilder.newCacheManagerBuilder().withCache(cachekey, (Builder)configurationBuilder).build();
        this.cacheManager.init();
        this.cache = this.cacheManager.getCache(cachekey, String.class, SecurityToken.class);
    }

    @Override
    public void add(SecurityToken token) {
        if (token != null && !StringUtils.isEmpty((String)token.getId())) {
            this.cache.put((Object)token.getId(), (Object)token);
        }
    }

    @Override
    public void add(String identifier, SecurityToken token) {
        if (token != null && !StringUtils.isEmpty((String)identifier)) {
            this.cache.put((Object)identifier, (Object)token);
        }
    }

    @Override
    public void remove(String identifier) {
        if (this.cache != null && !StringUtils.isEmpty((String)identifier)) {
            this.cache.remove((Object)identifier);
        }
    }

    @Override
    public Collection<String> getTokenIdentifiers() {
        if (this.cache == null) {
            return null;
        }
        HashSet<String> keys = new HashSet<String>();
        for (Cache.Entry entry : this.cache) {
            keys.add((String)entry.getKey());
        }
        return keys;
    }

    @Override
    public SecurityToken getToken(String identifier) {
        if (this.cache == null) {
            return null;
        }
        return (SecurityToken)this.cache.get((Object)identifier);
    }

    @Override
    public synchronized void close() {
        if (this.cacheManager.getStatus() == Status.AVAILABLE) {
            this.cacheManager.removeCache(this.key);
            this.cacheManager.close();
        }
    }

    public void initComplete() {
    }

    public void preShutdown() {
        this.close();
    }

    public void postShutdown() {
        this.close();
    }
}

