/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.diagnostics.puscanner;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.AnnotationInfoType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.AnnotationValueType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.AnnotationsType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ArrayEntryType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ArrayInstanceType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ClassInfoType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ClassInformationType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ExceptionType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.FieldInfoType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.FieldsType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.InterfacesType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ListEntryType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ListInstanceType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.MapEntryType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.MapInstanceType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.MethodInfoType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.MethodsType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ModifierType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ModifiersType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ObjectFieldInstanceType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ObjectInstanceType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ParameterType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ParametersType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ValueInstanceType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ValueType;
import com.ibm.ws.jpa.diagnostics.ormparser.EntityMappingsDefinition;
import com.ibm.ws.jpa.diagnostics.utils.encapsulation.EncapsulatedData;
import com.ibm.ws.jpa.diagnostics.utils.encapsulation.EncapsulatedDataGroup;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

public class PersistenceUnitScannerResults {
    private final List<PersistenceUnitInfo> puiList = new ArrayList<PersistenceUnitInfo>();
    private final Map<URL, String> pxmlMap = new HashMap<URL, String>();
    private final Set<URL> urlSet = new HashSet<URL>();
    private final Map<URL, Set<ClassInfoType>> scannedClassesMap = new HashMap<URL, Set<ClassInfoType>>();
    private final Map<URL, EntityMappingsDefinition> scanned_ormfile_map = new HashMap<URL, EntityMappingsDefinition>();
    private final Map<PersistenceUnitInfo, List<EntityMappingsDefinition>> pu_ormFileParsed_map = new HashMap<PersistenceUnitInfo, List<EntityMappingsDefinition>>();

    public PersistenceUnitScannerResults(List<PersistenceUnitInfo> puiList, Map<URL, String> pxmlMap, Set<URL> urlSet, Map<URL, Set<ClassInfoType>> scannedClassesMap, Map<URL, EntityMappingsDefinition> scanned_ormfile_map, Map<PersistenceUnitInfo, List<EntityMappingsDefinition>> pu_ormFileParsed_map) {
        if (puiList != null) {
            this.puiList.addAll(puiList);
        }
        if (pxmlMap != null) {
            this.pxmlMap.putAll(pxmlMap);
        }
        if (urlSet != null) {
            this.urlSet.addAll(urlSet);
        }
        if (scannedClassesMap != null) {
            this.scannedClassesMap.putAll(scannedClassesMap);
        }
        if (scanned_ormfile_map != null) {
            this.scanned_ormfile_map.putAll(scanned_ormfile_map);
        }
        if (pu_ormFileParsed_map != null) {
            this.pu_ormFileParsed_map.putAll(pu_ormFileParsed_map);
        }
    }

    public List<PersistenceUnitInfo> getPersistenceUnitInfoList() {
        return Collections.unmodifiableList(this.puiList);
    }

    public Map<URL, EntityMappingsDefinition> getAllEntityMappingsDefinitions() {
        return Collections.unmodifiableMap(this.scanned_ormfile_map);
    }

    public Map<URL, Set<ClassInfoType>> getAllScannedClasses() {
        HashMap<URL, Set<ClassInfoType>> retMap = new HashMap<URL, Set<ClassInfoType>>();
        for (Map.Entry<URL, Set<ClassInfoType>> entry : this.scannedClassesMap.entrySet()) {
            retMap.put(entry.getKey(), Collections.unmodifiableSet(entry.getValue()));
        }
        return retMap;
    }

    public List<EntityMappingsDefinition> getEntityMappingsForPersistenceUnit(PersistenceUnitInfo pui) {
        List<EntityMappingsDefinition> entMappings = this.pu_ormFileParsed_map.get(pui);
        if (entMappings == null) {
            return new ArrayList<EntityMappingsDefinition>();
        }
        return Collections.unmodifiableList(entMappings);
    }

    public Map<URL, Set<ClassInfoType>> getScannedClassesForPersistenceUnit(PersistenceUnitInfo pui) {
        HashSet<URL> urlSet = new HashSet<URL>();
        urlSet.add(pui.getPersistenceUnitRootUrl());
        if (pui.getJarFileUrls() != null) {
            urlSet.addAll(pui.getJarFileUrls());
        }
        HashMap<URL, Set<ClassInfoType>> retMap = new HashMap<URL, Set<ClassInfoType>>();
        for (URL url : urlSet) {
            if (!this.scannedClassesMap.containsKey(url)) continue;
            retMap.put(url, Collections.unmodifiableSet(this.scannedClassesMap.get(url)));
        }
        return retMap;
    }

    public void generateORMDump(PrintWriter out) {
        Object docId;
        HashMap<URL, ArrayList<PersistenceUnitInfo>> commonPuRootMap = new HashMap<URL, ArrayList<PersistenceUnitInfo>>();
        for (PersistenceUnitInfo pui : this.puiList) {
            URL puRoot = pui.getPersistenceUnitRootUrl();
            ArrayList<PersistenceUnitInfo> puList = (ArrayList<PersistenceUnitInfo>)commonPuRootMap.get(puRoot);
            if (puList == null) {
                puList = new ArrayList<PersistenceUnitInfo>();
                commonPuRootMap.put(puRoot, puList);
            }
            puList.add(pui);
        }
        EncapsulatedDataGroup root = EncapsulatedDataGroup.createEncapsulatedDataGroup("ORMDiagnostics", "ORMDiagnostics");
        int id = 0;
        root.setProperty("execution.environment", "WebSphere Liberty");
        String pxmlFolderId = new Integer(id++).toString();
        EncapsulatedDataGroup pxmlFolder = EncapsulatedDataGroup.createEncapsulatedDataGroup("PersistenceXML", pxmlFolderId);
        root.putDataSubGroup(pxmlFolder);
        HashMap<URL, Object> puRootToEncapIdMap = new HashMap<URL, Object>();
        for (Map.Entry<URL, String> entry : this.pxmlMap.entrySet()) {
            String pxmlDocId = new Integer(id++).toString();
            try {
                EncapsulatedData encapsulatedData = EncapsulatedData.createEncapsulatedData("persistence.xml", pxmlDocId, entry.getValue().getBytes());
                encapsulatedData.setProperty("pu.root.url", entry.getKey().toString());
                pxmlFolder.putDataItem(encapsulatedData);
                puRootToEncapIdMap.put(entry.getKey(), pxmlDocId);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(PersistenceUnitScannerResults.class.getName() + ".generateORMDump"), (String)"pxml-proc");
            }
        }
        String pxmlToStringFolderId = new Integer(id++).toString();
        EncapsulatedDataGroup pxmlToStringFolder = EncapsulatedDataGroup.createEncapsulatedDataGroup("PersistenceXMLToString", pxmlToStringFolderId);
        root.putDataSubGroup(pxmlToStringFolder);
        for (Map.Entry entry : commonPuRootMap.entrySet()) {
            for (PersistenceUnitInfo persistenceUnitInfo : (List)entry.getValue()) {
                docId = new Integer(id++).toString();
                try {
                    EncapsulatedData encapsulatedData = EncapsulatedData.createEncapsulatedData("jpa-persistence-unit-info", (String)docId, persistenceUnitInfo.toString().getBytes());
                    encapsulatedData.setProperty("pu.name", persistenceUnitInfo.getPersistenceUnitName());
                    encapsulatedData.setProperty("pu.root.url", ((URL)entry.getKey()).toString());
                    pxmlToStringFolder.putDataItem(encapsulatedData);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(PersistenceUnitScannerResults.class.getName() + ".generateORMDump"), (String)"pxml-tostring");
                }
            }
        }
        String ormFileFolderId = new Integer(id++).toString();
        EncapsulatedDataGroup encapsulatedDataGroup = EncapsulatedDataGroup.createEncapsulatedDataGroup("Object Relational Mapping Files", ormFileFolderId);
        root.putDataSubGroup(encapsulatedDataGroup);
        for (Map.Entry entry : this.scanned_ormfile_map.entrySet()) {
            docId = new Integer(id++).toString();
            try {
                EntityMappingsDefinition entityMappingsDefinition = (EntityMappingsDefinition)entry.getValue();
                EncapsulatedData ed = EncapsulatedData.createEncapsulatedData("ORM File", (String)docId, entityMappingsDefinition.getFileData());
                ed.setProperty("url", entityMappingsDefinition.getSource().toString());
                encapsulatedDataGroup.putDataItem(ed);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(PersistenceUnitScannerResults.class.getName() + ".generateORMDump"), (String)"orm-file-collection");
            }
        }
        String scannedClassesFolderId = new Integer(id++).toString();
        EncapsulatedDataGroup encapsulatedDataGroup2 = EncapsulatedDataGroup.createEncapsulatedDataGroup("Scanned Classes", scannedClassesFolderId);
        root.putDataSubGroup(encapsulatedDataGroup2);
        for (Map.Entry entry : this.scannedClassesMap.entrySet()) {
            String docId2 = new Integer(id++).toString();
            try {
                ClassInformationType cit = new ClassInformationType();
                cit.getClassInfo().addAll((Collection)entry.getValue());
                ClassLoader currentClassLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return PersistenceUnitScannerResults.class.getClassLoader();
                    }
                });
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                JAXBContext jaxbCtx = JAXBContext.newInstance((String)"com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10", (ClassLoader)currentClassLoader);
                Marshaller marshaller = jaxbCtx.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                marshaller.marshal((Object)cit, (OutputStream)baos);
                EncapsulatedData ed = EncapsulatedData.createEncapsulatedData("Classes", docId2, baos.toByteArray());
                ed.setProperty("url", ((URL)entry.getKey()).toString());
                encapsulatedDataGroup2.putDataItem(ed);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(PersistenceUnitScannerResults.class.getName() + ".generateORMDump"), (String)"orm-file-collection");
            }
        }
        out.println();
        out.println("Encapsulated JPA Diagnostic Data:");
        out.println();
        try {
            root.write(out);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(PersistenceUnitScannerResults.class.getName() + ".generateORMDump"), (String)"store-encapsulated-data");
        }
    }

    public void printReport(PrintWriter out) {
        for (Map.Entry<URL, EntityMappingsDefinition> entry : this.scanned_ormfile_map.entrySet()) {
            out.println();
            out.println("- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -");
            out.println("Object Relational Mapping (ORM) File:");
            out.println("Location: " + PersistenceUnitScannerResults.getShortenedURLPath(entry.getKey()));
            out.println("Referenced by Persistence Unit:");
            for (Map.Entry<PersistenceUnitInfo, List<EntityMappingsDefinition>> e2 : this.pu_ormFileParsed_map.entrySet()) {
                if (!e2.getValue().contains(entry.getValue())) continue;
                out.println("   " + e2.getKey().getPersistenceUnitName());
            }
            out.println();
            out.println(new String(entry.getValue().getFileData()));
        }
        for (Map.Entry<URL, Object> entry : this.scannedClassesMap.entrySet()) {
            out.println();
            out.println("Scanned Classes for location: " + entry.getKey());
            ArrayList sortedCitList = new ArrayList((Collection)entry.getValue());
            Collections.sort(sortedCitList, new Comparator<ClassInfoType>(){

                @Override
                public int compare(ClassInfoType o1, ClassInfoType o2) {
                    if (o1 == null || o2 == null || o1.getClassName() == null || o2.getClassName() == null) {
                        return 0;
                    }
                    return o1.getClassName().compareTo(o2.getClassName());
                }
            });
            for (ClassInfoType cit : sortedCitList) {
                out.println("- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -");
                out.println("Class: " + cit.getClassName());
                out.println("Location: " + PersistenceUnitScannerResults.getShortenedURLPath(entry.getKey()));
                out.println();
                out.println(PersistenceUnitScannerResults.process(cit));
            }
            out.println();
        }
    }

    public static String process(ClassInfoType cit) {
        List<String> ifaceList;
        InterfacesType ifaces;
        StringBuilder sb = new StringBuilder();
        sb.append("package ").append(cit.getPackageName()).append(";").append("\n");
        sb.append("\n");
        PersistenceUnitScannerResults.processAnnotationsType(cit.getAnnotations(), "", sb, false);
        PersistenceUnitScannerResults.printModifiersType(cit.getModifiers(), sb);
        if (cit.isIsInterface().booleanValue()) {
            sb.append("interface ");
        } else {
            sb.append("class ");
        }
        sb.append(cit.getName());
        String superclassName = cit.getSuperclassName();
        if (superclassName != null && !superclassName.trim().isEmpty() && !superclassName.trim().equals("java.lang.Object")) {
            sb.append(" extends ").append(superclassName.replace("/", ".")).append(" ");
        }
        if ((ifaces = cit.getInterfaces()) != null && (ifaceList = ifaces.getInterface()).size() > 0) {
            sb.append(" implements ");
            boolean first = true;
            for (String iface : ifaceList) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                sb.append(iface.replace("/", "."));
            }
        }
        sb.append(" {\n");
        PersistenceUnitScannerResults.printFields(cit, sb);
        sb.append("\n");
        PersistenceUnitScannerResults.printMethods(cit, sb);
        sb.append("\n}\n");
        return sb.toString();
    }

    private static void printModifiersType(ModifiersType mods, StringBuilder sb) {
        if (mods == null) {
            return;
        }
        List<ModifierType> modList = mods.getModifier();
        for (ModifierType mt : modList) {
            sb.append(mt.toString().toLowerCase());
            sb.append(" ");
        }
    }

    private static void printFields(ClassInfoType cit, StringBuilder sb) {
        FieldsType ft = cit.getFields();
        if (ft == null) {
            return;
        }
        sb.append("  // Fields\n");
        boolean first = true;
        List<FieldInfoType> fiList = ft.getField();
        for (FieldInfoType fit : fiList) {
            if (first) {
                first = false;
            } else {
                sb.append("\n");
            }
            PersistenceUnitScannerResults.processAnnotationsType(fit.getAnnotations(), "  ", sb, false);
            sb.append("  ");
            PersistenceUnitScannerResults.printModifiersType(fit.getModifiers(), sb);
            sb.append(fit.getType()).append(" ");
            sb.append(fit.getName()).append(";\n");
        }
    }

    private static void printMethods(ClassInfoType cit, StringBuilder sb) {
        MethodsType mt = cit.getMethods();
        if (mt == null) {
            return;
        }
        sb.append("  // Methods\n");
        boolean first = true;
        List<MethodInfoType> miList = mt.getMethod();
        for (MethodInfoType mit : miList) {
            if (first) {
                first = false;
            } else {
                sb.append("\n");
            }
            PersistenceUnitScannerResults.processAnnotationsType(mit.getAnnotations(), "  ", sb, false);
            sb.append("  ");
            PersistenceUnitScannerResults.printModifiersType(mit.getModifiers(), sb);
            if (mit.isIsCtor().booleanValue()) {
                sb.append(cit.getName());
            } else {
                sb.append(mit.getReturnType()).append(" ");
                sb.append(mit.getMethodName());
            }
            sb.append("(");
            ParametersType pt = mit.getParameters();
            if (pt != null) {
                boolean first2 = true;
                List<ParameterType> ptList = pt.getParameter();
                for (ParameterType parmType : ptList) {
                    if (first2) {
                        first2 = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(parmType.getType());
                    if (!parmType.isIsArray().booleanValue()) continue;
                    sb.append("[]");
                }
            }
            sb.append(")");
            if (mit.getExceptions() != null) {
                List<ExceptionType> exList = mit.getExceptions().getException();
                sb.append(" throws ");
                boolean first2 = true;
                for (ExceptionType et : exList) {
                    if (first2) {
                        first2 = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(et.getExceptionType());
                }
                sb.append(" ");
            }
            sb.append(";\n");
        }
    }

    private static void processAnnotationsType(AnnotationsType at, String indent, StringBuilder sb, boolean printComma) {
        if (indent == null) {
            indent = "";
        }
        if (at == null) {
            return;
        }
        boolean first = true;
        List<AnnotationInfoType> annoInfoTypeList = at.getAnnotation();
        for (AnnotationInfoType ait : annoInfoTypeList) {
            if (printComma) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
            }
            PersistenceUnitScannerResults.processAnnotationInfoType(ait, indent, sb);
        }
    }

    private static void processAnnotationInfoType(AnnotationInfoType ait, String indent, StringBuilder sb) {
        String type = ait.getType();
        sb.append(indent).append("@").append(type);
        List<AnnotationValueType> avtList = ait.getAnnoKeyVal();
        if (avtList.size() > 0) {
            sb.append("(");
            boolean first = true;
            for (AnnotationValueType avt : avtList) {
                String name = avt.getName();
                AnnotationInfoType ait2 = avt.getAnnotation();
                AnnotationsType at2 = avt.getAnnotations();
                ValueInstanceType vit = avt.getValue();
                ArrayInstanceType arrit = avt.getValues();
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(name).append("=");
                if (vit != null) {
                    PersistenceUnitScannerResults.processValueInstanceType(vit, sb);
                    continue;
                }
                if (ait2 != null) {
                    PersistenceUnitScannerResults.processAnnotationInfoType(ait2, indent + "  ", sb);
                    continue;
                }
                if (at2 == null) continue;
                sb.append("{ ");
                PersistenceUnitScannerResults.processAnnotationsType(at2, indent + "  ", sb, true);
                sb.append("} ");
            }
            sb.append(")");
        }
        sb.append("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processValueInstanceType(ValueInstanceType vit, StringBuilder sb) {
        ValueType valType = vit.getType();
        if (valType == ValueType.ARRAY) {
            ArrayInstanceType arrIt = vit.getArray();
            List<ArrayEntryType> entryList = arrIt.getEntry();
            try {
                sb.append("[");
                boolean first = true;
                for (ArrayEntryType aet : entryList) {
                    if (!first) {
                        sb.append(", ");
                    } else {
                        first = false;
                    }
                    PersistenceUnitScannerResults.processValueInstanceType(aet.getValue(), sb);
                }
            }
            finally {
                sb.append("]");
            }
        } else if (valType == ValueType.LIST) {
            ListInstanceType lit = vit.getList();
            List<ListEntryType> letList = lit.getEntry();
            try {
                sb.append("{");
                boolean first = true;
                for (ListEntryType let : letList) {
                    if (!first) {
                        sb.append(", ");
                    } else {
                        first = false;
                    }
                    PersistenceUnitScannerResults.processValueInstanceType(let.getValue(), sb);
                }
            }
            finally {
                sb.append("}");
            }
        } else if (valType == ValueType.MAP) {
            MapInstanceType mit = vit.getMap();
            List<MapEntryType> metList = mit.getEntry();
            try {
                sb.append("{");
                boolean first = true;
                for (MapEntryType met : metList) {
                    if (!first) {
                        sb.append(", ");
                    } else {
                        first = false;
                    }
                    PersistenceUnitScannerResults.processValueInstanceType(met.getKey(), sb);
                    sb.append(" = ");
                    PersistenceUnitScannerResults.processValueInstanceType(met.getValue(), sb);
                }
            }
            finally {
                sb.append("}");
            }
        } else if (valType == ValueType.OBJECT) {
            ObjectInstanceType oit = vit.getObject();
            String className = oit.getClassName();
            int id = oit.getId();
            List<ObjectFieldInstanceType> fieldList = oit.getField();
            sb.append("<<Object <").append(className).append("> ");
            sb.append("id=").append(id).append(" ");
            try {
                boolean first = true;
                for (ObjectFieldInstanceType field : fieldList) {
                    if (!first) {
                        sb.append(", ");
                    } else {
                        first = false;
                    }
                    String fieldName = field.getName();
                    sb.append(fieldName).append("= |");
                    PersistenceUnitScannerResults.processValueInstanceType(field.getValue(), sb);
                    sb.append("|");
                }
            }
            finally {
                sb.append(">>");
            }
        } else if (valType == ValueType.JAVA_LANG_STRING) {
            sb.append("\"").append(vit.getSimple()).append("\"");
        } else {
            sb.append(vit.getSimple());
        }
    }

    private static String getShortenedURLPath(URL url) {
        String urlStr = url.toString().replace("%21", "!");
        String ptcols = urlStr.substring(0, urlStr.indexOf("/"));
        String path = urlStr.substring(urlStr.indexOf("/"));
        if (path.contains(".cache")) {
            path = path.substring(path.lastIndexOf(".cache") + 6);
        }
        int index = path.length();
        int temp = path.lastIndexOf(".jar");
        if (temp > 0) {
            index = temp;
        }
        if ((temp = path.lastIndexOf(".war", index)) > 0) {
            index = temp;
        }
        if ((temp = path.lastIndexOf(".ear", index)) > 0) {
            index = temp;
        }
        if (index > 0) {
            index = path.lastIndexOf("/", index);
            path = path.substring(index);
        }
        return ptcols + "..." + path;
    }
}

