/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.shared.util;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.annocache.AnnotationsBetaHelper;
import com.ibm.ws.container.service.annotations.WebAnnotations;
import com.ibm.ws.javaee.dd.common.ParamValue;
import com.ibm.ws.javaee.dd.jsf.FacesConfig;
import com.ibm.ws.javaee.dd.jsf.FacesConfigManagedBean;
import com.ibm.ws.javaee.dd.web.WebApp;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import com.ibm.wsspi.webcontainer.collaborator.WebAppInjectionClassListCollaborator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="log", fieldDesc="Ljava/util/logging/Logger;")
public class JSFInjectionClassListCollaborator
implements WebAppInjectionClassListCollaborator {
    protected static final Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = JSFInjectionClassListCollaborator.class.getName();
    public static final String FACES_CONFIG_NAMES = "jakarta.faces.CONFIG_FILES";
    private final String[] _InjectionInterfaces;
    private final String[] _InjectionSubClasses;
    static final long serialVersionUID = -4402142213111345708L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JSFInjectionClassListCollaborator() {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.jsf.shared.util.JSFInjectionClassListCollaborator", "<init>", new Object[0]);
        }
        this._InjectionInterfaces = new String[]{"jakarta.faces.event.ActionListener", "jakarta.faces.event.SystemEventListener", "jakarta.faces.event.PhaseListener"};
        this._InjectionSubClasses = new String[]{"jakarta.el.ELResolver", "jakarta.faces.application.ApplicationFactory", "jakarta.faces.application.NavigationHandler", "jakarta.faces.application.ResourceHandler", "jakarta.faces.application.StateManager", "jakarta.faces.component.visit.VisitContextFactory", "jakarta.faces.context.ExceptionHandlerFactory", "jakarta.faces.context.ExternalContextFactory", "jakarta.faces.context.FacesContextFactory", "jakarta.faces.context.PartialViewContextFactory", "jakarta.faces.lifecycle.ClientWindowFactory", "jakarta.faces.lifecycle.LifecycleFactory", "jakarta.faces.render.RenderKitFactory", "jakarta.faces.view.ViewDeclarationLanguageFactory", "jakarta.faces.view.facelets.FaceletCacheFactory", "jakarta.faces.view.facelets.TagHandlerDelegateFactory"};
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting("com.ibm.ws.jsf.shared.util.JSFInjectionClassListCollaborator", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void activate(ComponentContext compcontext) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.jsf.shared.util.JSFInjectionClassListCollaborator", "activate", new Object[]{compcontext});
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting("com.ibm.ws.jsf.shared.util.JSFInjectionClassListCollaborator", "activate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void deactivate(ComponentContext compcontext) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.jsf.shared.util.JSFInjectionClassListCollaborator", "deactivate", new Object[]{compcontext});
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting("com.ibm.ws.jsf.shared.util.JSFInjectionClassListCollaborator", "deactivate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<String> getInjectionClasses(Container moduleContainer) {
        ArrayList<String> injectionClassNames;
        String methodName;
        block17: {
            block16: {
                if (log != null && log.isLoggable(Level.FINER)) {
                    log.entering("com.ibm.ws.jsf.shared.util.JSFInjectionClassListCollaborator", "getInjectionClasses", new Object[]{moduleContainer});
                }
                methodName = "getInjectionClasses";
                injectionClassNames = new ArrayList<String>();
                try {
                    WebAnnotations webAnno = AnnotationsBetaHelper.getWebAnnotations((Container)moduleContainer);
                    AnnotationTargets_Targets annoTargets = webAnno.getAnnotationTargets();
                    Set managedBeanClassNames = annoTargets.getAllInheritedAnnotatedClasses("jakarta.faces.bean.ManagedBean");
                    if (TraceComponent.isAnyTracingEnabled() && log.isLoggable(Level.FINE)) {
                        Iterator mbcI = managedBeanClassNames.iterator();
                        while (mbcI.hasNext()) {
                            log.logp(Level.FINE, CLASS_NAME, methodName, "MangagedBean :" + (String)mbcI.next());
                        }
                    }
                    injectionClassNames.addAll(managedBeanClassNames);
                    for (String injectionInterface : this._InjectionInterfaces) {
                        managedBeanClassNames = annoTargets.getAllImplementorsOf(injectionInterface);
                        for (String mbcn : managedBeanClassNames) {
                            if (TraceComponent.isAnyTracingEnabled() && log.isLoggable(Level.FINE)) {
                                log.logp(Level.FINE, CLASS_NAME, methodName, "Found implementor of " + injectionInterface + " : " + mbcn);
                            }
                            if (injectionClassNames.contains(mbcn)) continue;
                            injectionClassNames.add(mbcn);
                            if (!TraceComponent.isAnyTracingEnabled() || !log.isLoggable(Level.FINE)) continue;
                            log.logp(Level.FINE, CLASS_NAME, methodName, "Add implementor :" + mbcn);
                        }
                    }
                    for (String injectionSubClass : this._InjectionSubClasses) {
                        managedBeanClassNames = annoTargets.getSubclassNames(injectionSubClass);
                        for (String mbcn : managedBeanClassNames) {
                            if (TraceComponent.isAnyTracingEnabled() && log.isLoggable(Level.FINE)) {
                                log.logp(Level.FINE, CLASS_NAME, methodName, "Found extender of " + injectionSubClass + " : " + mbcn);
                            }
                            if (injectionClassNames.contains(mbcn) || mbcn.equals(injectionSubClass + "Wrapper")) continue;
                            injectionClassNames.add(mbcn);
                            if (!TraceComponent.isAnyTracingEnabled() || !log.isLoggable(Level.FINE)) continue;
                            log.logp(Level.FINE, CLASS_NAME, methodName, "Add sub class :" + mbcn);
                        }
                    }
                }
                catch (UnableToAdaptException e) {
                    if (!log.isLoggable(Level.FINE)) break block16;
                    log.logp(Level.FINE, CLASS_NAME, methodName, "failed to adapt to InfoStore for class annotations", e);
                }
            }
            try {
                FacesConfig facesConfig = (FacesConfig)moduleContainer.adapt(FacesConfig.class);
                if (TraceComponent.isAnyTracingEnabled() && log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, methodName, "Add managed objects from WEB-INF/faces-config.xml");
                }
                this.addConfigFileManagedObjects(facesConfig, injectionClassNames);
            }
            catch (UnableToAdaptException e) {
                if (!log.isLoggable(Level.FINE)) break block17;
                log.logp(Level.FINE, CLASS_NAME, methodName, "failed to adapt to default faces-config in Container", e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, methodName, "Add managed objects from META-INF/faces-config.xml");
        }
        this.addConfigFileBeans(moduleContainer.getEntry("META-INF/faces-config.xml"), injectionClassNames);
        this.searchJars(moduleContainer, injectionClassNames);
        this.addAlternateNamedFacesConfig(moduleContainer, injectionClassNames);
        ArrayList<String> arrayList = injectionClassNames;
        if (log != null && log.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            log.exiting("com.ibm.ws.jsf.shared.util.JSFInjectionClassListCollaborator", "getInjectionClasses", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addAlternateNamedFacesConfig(Container moduleContainer, List<String> classList) {
        block12: {
            String configNames;
            String methodName;
            block11: {
                WebApp webapp;
                block10: {
                    if (log != null && log.isLoggable(Level.FINER)) {
                        log.entering("com.ibm.ws.jsf.shared.util.JSFInjectionClassListCollaborator", "addAlternateNamedFacesConfig", new Object[]{moduleContainer, classList});
                    }
                    methodName = "addAlternateNamedFacesConfig";
                    webapp = (WebApp)moduleContainer.adapt(WebApp.class);
                    if (webapp != null) break block10;
                    if (log != null && log.isLoggable(Level.FINER)) {
                        log.exiting("com.ibm.ws.jsf.shared.util.JSFInjectionClassListCollaborator", "addAlternateNamedFacesConfig");
                    }
                    return;
                }
                List params = webapp.getContextParams();
                configNames = null;
                for (ParamValue param : params) {
                    if (!param.getName().equals(FACES_CONFIG_NAMES)) continue;
                    configNames = param.getValue();
                    break;
                }
                if (configNames != null) break block11;
                if (log != null && log.isLoggable(Level.FINER)) {
                    log.exiting("com.ibm.ws.jsf.shared.util.JSFInjectionClassListCollaborator", "addAlternateNamedFacesConfig");
                }
                return;
            }
            try {
                StringTokenizer st = new StringTokenizer(configNames, ",");
                while (st.hasMoreTokens()) {
                    this.addConfigFileBeans(moduleContainer.getEntry(st.nextToken()), classList);
                }
            }
            catch (UnableToAdaptException e) {
                if (!log.isLoggable(Level.FINE)) break block12;
                log.logp(Level.FINE, CLASS_NAME, methodName, "failed to adapt conatiner to WebApp", e);
            }
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting("com.ibm.ws.jsf.shared.util.JSFInjectionClassListCollaborator", "addAlternateNamedFacesConfig");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void searchJars(Container moduleContainer, List<String> classList) {
        block14: {
            if (log != null && log.isLoggable(Level.FINER)) {
                log.entering("com.ibm.ws.jsf.shared.util.JSFInjectionClassListCollaborator", "searchJars", new Object[]{moduleContainer, classList});
            }
            String methodName = "searchJars";
            Entry webinfLibEntry = moduleContainer.getEntry("WEB-INF/lib");
            if (webinfLibEntry == null) {
                if (log != null && log.isLoggable(Level.FINER)) {
                    log.exiting("com.ibm.ws.jsf.shared.util.JSFInjectionClassListCollaborator", "searchJars");
                }
                return;
            }
            try {
                Container c = (Container)webinfLibEntry.adapt(Container.class);
                for (Entry current : c) {
                    if (!current.getName().endsWith(".jar")) continue;
                    try {
                        Container jarContainer = (Container)current.adapt(Container.class);
                        if (jarContainer == null) continue;
                        this.addConfigFileBeans(jarContainer.getEntry("META-INF/faces-config.xml"), classList);
                        Entry metainf = jarContainer.getEntry("META-INF");
                        if (metainf == null) {
                            if (log != null && log.isLoggable(Level.FINER)) {
                                log.exiting("com.ibm.ws.jsf.shared.util.JSFInjectionClassListCollaborator", "searchJars");
                            }
                            return;
                        }
                        Container metainfContainer = (Container)metainf.adapt(Container.class);
                        for (Entry currentEntry : metainfContainer) {
                            if (!currentEntry.getName().endsWith(".faces-config.xml")) continue;
                            this.addConfigFileBeans(currentEntry, classList);
                        }
                    }
                    catch (UnableToAdaptException e) {
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.logp(Level.FINE, CLASS_NAME, methodName, "unable to adapt jar or META-INF dir in jar named " + current.getName() + " to a container", e);
                    }
                }
            }
            catch (UnableToAdaptException e) {
                if (!log.isLoggable(Level.FINE)) break block14;
                log.logp(Level.FINE, CLASS_NAME, methodName, "unable to adapt WEB-INF/lib to a container", e);
            }
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting("com.ibm.ws.jsf.shared.util.JSFInjectionClassListCollaborator", "searchJars");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addConfigFileBeans(Entry e, List<String> classList) {
        block6: {
            if (log != null && log.isLoggable(Level.FINER)) {
                log.entering("com.ibm.ws.jsf.shared.util.JSFInjectionClassListCollaborator", "addConfigFileBeans", new Object[]{e, classList});
            }
            if (e == null) {
                if (log != null && log.isLoggable(Level.FINER)) {
                    log.exiting("com.ibm.ws.jsf.shared.util.JSFInjectionClassListCollaborator", "addConfigFileBeans");
                }
                return;
            }
            try {
                FacesConfig facesConfig = (FacesConfig)e.adapt(FacesConfig.class);
                this.addConfigFileManagedObjects(facesConfig, classList);
            }
            catch (UnableToAdaptException ex) {
                if (!log.isLoggable(Level.FINE)) break block6;
                log.logp(Level.FINE, CLASS_NAME, "addConfigFileBeans", "failed to adapt to faces-config from entry:" + e, ex);
            }
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting("com.ibm.ws.jsf.shared.util.JSFInjectionClassListCollaborator", "addConfigFileBeans");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addConfigFileManagedObjects(FacesConfig facesConfig, List<String> classList) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.jsf.shared.util.JSFInjectionClassListCollaborator", "addConfigFileManagedObjects", new Object[]{facesConfig, classList});
        }
        if (facesConfig != null) {
            List beans = facesConfig.getManagedBeans();
            for (FacesConfigManagedBean bean : beans) {
                classList.add(bean.getManagedBeanClass());
            }
            List objects = facesConfig.getManagedObjects();
            for (String object : objects) {
                if (TraceComponent.isAnyTracingEnabled() && log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "addConfigFileManagedObjects", "Found config managed object :" + object);
                }
                if (classList.contains(object)) continue;
                if (TraceComponent.isAnyTracingEnabled() && log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "addConfigFileManagedObjects", "Add config managed object :" + object);
                }
                classList.add(object);
            }
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting("com.ibm.ws.jsf.shared.util.JSFInjectionClassListCollaborator", "addConfigFileManagedObjects");
        }
    }
}

