/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ejbcontainer.mdb.MDBMessageEndpointFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointConfiguration;
import com.ibm.ws.sib.ra.inbound.SibRaMessageDeletionMode;
import com.ibm.ws.sib.ra.inbound.impl.SibRaBatchMessageDeletionDispatcher;
import com.ibm.ws.sib.ra.inbound.impl.SibRaDispatcher;
import com.ibm.ws.sib.ra.inbound.impl.SibRaEndpointActivation;
import com.ibm.ws.sib.ra.inbound.impl.SibRaListener;
import com.ibm.ws.sib.ra.inbound.impl.SibRaNonTransactionalDispatcher;
import com.ibm.ws.sib.ra.inbound.impl.SibRaSingleMessageDeletionDispatcher;
import com.ibm.ws.sib.ra.inbound.impl.SibRaSingleProcessListener;
import com.ibm.ws.sib.ra.inbound.impl.SibRaSynchronizedDispatcher;
import com.ibm.ws.sib.ra.inbound.impl.SibRaTransactionalDispatcher;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AbstractConsumerSession;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import com.ibm.wsspi.sib.core.SICoreConnectionFactorySelector;
import com.ibm.wsspi.sib.core.SICoreConnectionListener;
import com.ibm.wsspi.sib.core.exception.SIAuthenticationException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.selector.FactoryType;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.IllegalStateException;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

final class SibRaMessagingEngineConnection {
    private final SibRaEndpointActivation _endpointActivation;
    private final SibRaEndpointConfiguration _endpointConfiguration;
    private final String _busName;
    private final SICoreConnection _connection;
    private final SibRaConnectionListener _connectionListener;
    private final Map<SIDestinationAddress, SibRaListener> _listeners = Collections.synchronizedMap(new HashMap());
    private volatile boolean _closed = false;
    private final AtomicInteger _dispatcherCount = new AtomicInteger(0);
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaMessagingEngineConnection.class);
    private static final TraceComponent LISTENER_TRACE = SibRaUtils.getTraceComponent(SibRaConnectionListener.class);
    private static final TraceComponent EVENT_TRACE = SibRaUtils.getTraceComponent(SibRaConnectionEventThread.class);
    private static TraceNLS NLS = SibRaUtils.getTraceNls();
    private static final String CLASS_NAME = SibRaMessagingEngineConnection.class.getName();

    SibRaMessagingEngineConnection(SibRaEndpointActivation endpointActivation, JsMessagingEngine messagingEngine) throws ResourceException {
        String methodName = "SibRaMessagingEngineConnection";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaMessagingEngineConnection", (Object)new Object[]{endpointActivation, messagingEngine});
        }
        this._endpointActivation = endpointActivation;
        this._endpointConfiguration = endpointActivation.getEndpointConfiguration();
        this._busName = messagingEngine.getBusName();
        SICoreConnectionFactory factory = (SICoreConnectionFactory)messagingEngine.getMessageProcessor();
        try {
            this._connection = this.createConnection(factory, this._endpointConfiguration.getUserName(), this._endpointConfiguration.getPassword(), null, this._busName);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Obtained Connection <" + this._connection + ">"));
            }
            this._connectionListener = new SibRaConnectionListener();
            this._connection.addConnectionListener((SICoreConnectionListener)this._connectionListener);
        }
        catch (SIAuthenticationException exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "SibRaMessagingEngineConnection"), (String)"1:279:1.59", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
            }
            throw new ResourceException(NLS.getFormattedMessage("CREATE_CONNECTION_CWSIV0954", new Object[]{exception, factory}, null), (Throwable)exception);
        }
        catch (SINotAuthorizedException sinae) {
            FFDCFilter.processException((Throwable)sinae, (String)(CLASS_NAME + "." + "SibRaMessagingEngineConnection"), (String)"1:290:1.59", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sinae));
            }
            if (this._endpointConfiguration.getUserName() == null) {
                throw new ResourceException(NLS.getFormattedMessage("CREATE_CONNECTION_CWSIV0958", new Object[]{sinae, messagingEngine.getUuid(), this._endpointConfiguration.getActivationSpec()}, null), (Throwable)sinae);
            }
            throw new ResourceException(NLS.getFormattedMessage("CREATE_CONNECTION_CWSIV0959", new Object[]{sinae, messagingEngine.getUuid(), this._endpointConfiguration.getActivationSpec()}, null), (Throwable)sinae);
        }
        catch (Exception wsse) {
            FFDCFilter.processException((Throwable)wsse, (String)(CLASS_NAME + "." + "SibRaMessagingEngineConnection"), (String)"1:312:1.59", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)wsse);
            }
            throw new ResourceException(NLS.getFormattedMessage("CREATE_CONNECTION_CWSIV0950", new Object[]{wsse}, null), (Throwable)wsse);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaMessagingEngineConnection");
        }
    }

    SibRaMessagingEngineConnection(SibRaEndpointActivation endpointActivation, String busName, String meUuid) throws ResourceException {
        String methodName = "SibRaMessagingEngineConnection";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaMessagingEngineConnection", (Object)new Object[]{endpointActivation, busName, meUuid});
        }
        this._endpointActivation = endpointActivation;
        this._endpointConfiguration = endpointActivation.getEndpointConfiguration();
        this._busName = busName;
        try {
            SICoreConnectionFactory factory = SICoreConnectionFactorySelector.getSICoreConnectionFactory((FactoryType)FactoryType.TRM_CONNECTION);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("busName", busName);
            properties.put("targetType", "MEUuid");
            properties.put("targetGroup", meUuid);
            properties.put("targetSignificance", "Required");
            String targetTransportChain = this._endpointConfiguration.getTargetTransportChain();
            if (targetTransportChain != null && !"".equals(targetTransportChain)) {
                properties.put("targetTransportChain", targetTransportChain);
            }
            properties.put("remoteServerAddress", this._endpointConfiguration.getProviderEndpoints());
            this._connection = this.createConnection(factory, this._endpointConfiguration.getUserName(), this._endpointConfiguration.getPassword(), properties, busName);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Obtained Connection <" + this._connection + ">"));
            }
            this._connectionListener = new SibRaConnectionListener();
            this._connection.addConnectionListener((SICoreConnectionListener)this._connectionListener);
        }
        catch (SIAuthenticationException exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "SibRaMessagingEngineConnection"), (String)"1:428:1.59", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
            }
            throw new ResourceException(NLS.getFormattedMessage("CREATE_CONNECTION_CWSIV0955", new Object[]{exception, meUuid}, null), (Throwable)exception);
        }
        catch (SINotAuthorizedException sinae) {
            FFDCFilter.processException((Throwable)sinae, (String)(CLASS_NAME + "." + "SibRaMessagingEngineConnection"), (String)"1:438:1.59", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sinae));
            }
            if (this._endpointConfiguration.getUserName() == null) {
                throw new ResourceException(NLS.getFormattedMessage("CREATE_CONNECTION_CWSIV0958", new Object[]{sinae, meUuid, this._endpointConfiguration.getActivationSpec()}, null), (Throwable)sinae);
            }
            throw new ResourceException(NLS.getFormattedMessage("CREATE_CONNECTION_CWSIV0959", new Object[]{sinae, meUuid, this._endpointConfiguration.getActivationSpec()}, null), (Throwable)sinae);
        }
        catch (SIException exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "SibRaMessagingEngineConnection"), (String)"1:471:1.59", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
            }
            throw new ResourceException(NLS.getFormattedMessage("CREATE_CONNECTION_CWSIV0951", new Object[]{exception, meUuid}, null), (Throwable)exception);
        }
        catch (SIErrorException exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "SibRaMessagingEngineConnection"), (String)"1:482:1.59", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
            }
            throw new ResourceException(NLS.getFormattedMessage("CREATE_CONNECTION_CWSIV0951", new Object[]{exception, meUuid}, null), (Throwable)exception);
        }
        catch (Exception wsse) {
            FFDCFilter.processException((Throwable)wsse, (String)(CLASS_NAME + "." + "SibRaMessagingEngineConnection"), (String)"1:460:1.59", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)wsse);
            }
            throw new ResourceException(NLS.getFormattedMessage("CREATE_CONNECTION_CWSIV0950", new Object[]{wsse}, null), (Throwable)wsse);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaMessagingEngineConnection");
        }
    }

    SibRaMessagingEngineConnection(SibRaEndpointActivation endpointActivation, String busName) throws SIException, ResourceException {
        String methodName = "SibRaMessagingEngineConnection";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaMessagingEngineConnection", (Object)new Object[]{endpointActivation, busName});
        }
        this._endpointActivation = endpointActivation;
        this._endpointConfiguration = endpointActivation.getEndpointConfiguration();
        this._busName = busName;
        SICoreConnectionFactory factory = SICoreConnectionFactorySelector.getSICoreConnectionFactory((FactoryType)FactoryType.TRM_CONNECTION);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("busName", busName);
        properties.put("targetGroup", this._endpointConfiguration.getTarget());
        properties.put("targetType", this._endpointConfiguration.getTargetType());
        properties.put("targetSignificance", this._endpointConfiguration.getTargetSignificance());
        properties.put("remoteServerAddress", this._endpointConfiguration.getProviderEndpoints());
        String targetTransportChain = this._endpointConfiguration.getTargetTransportChain();
        if (targetTransportChain != null && !"".equals(targetTransportChain)) {
            properties.put("targetTransportChain", targetTransportChain);
        }
        try {
            this._connection = this.createConnection(factory, this._endpointConfiguration.getUserName(), this._endpointConfiguration.getPassword(), properties, this._busName);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Obtained Connection <" + this._connection + ">"));
            }
            this._connectionListener = new SibRaConnectionListener();
            this._connection.addConnectionListener((SICoreConnectionListener)this._connectionListener);
        }
        catch (SIAuthenticationException siae) {
            FFDCFilter.processException((Throwable)siae, (String)(CLASS_NAME + "." + "SibRaMessagingEngineConnection"), (String)"1:458:1.59", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)siae));
            }
            throw new ResourceException(NLS.getFormattedMessage("CREATE_CONNECTION_CWSIV0962", new Object[]{siae, this._busName, this.getActivationSpecId()}, null), (Throwable)siae);
        }
        catch (SINotAuthorizedException sinae) {
            FFDCFilter.processException((Throwable)sinae, (String)(CLASS_NAME + "." + "SibRaMessagingEngineConnection"), (String)"1:568:1.59", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sinae));
            }
            if (this._endpointConfiguration.getUserName() == null) {
                throw new ResourceException(NLS.getFormattedMessage("CREATE_CONNECTION_CWSIV0960", new Object[]{sinae, this._busName, this._endpointConfiguration.getActivationSpec()}, null), (Throwable)sinae);
            }
            throw new ResourceException(NLS.getFormattedMessage("CREATE_CONNECTION_CWSIV0961", new Object[]{sinae, this._busName, this._endpointConfiguration.getActivationSpec()}, null), (Throwable)sinae);
        }
        catch (Exception wsse) {
            FFDCFilter.processException((Throwable)wsse, (String)(CLASS_NAME + "." + "SibRaMessagingEngineConnection"), (String)"1:589:1.59", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)wsse);
            }
            throw new ResourceException(NLS.getFormattedMessage("CREATE_CONNECTION_CWSIV0950", new Object[]{wsse}, null), (Throwable)wsse);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaMessagingEngineConnection");
        }
    }

    private String getActivationSpecId() {
        String activationSpecId = null;
        activationSpecId = this._endpointActivation.getMessageEndpointFactory() instanceof MDBMessageEndpointFactory ? ((MDBMessageEndpointFactory)this._endpointActivation.getMessageEndpointFactory()).getActivationSpecId() : this._endpointConfiguration.getActivationSpec().toString();
        return activationSpecId;
    }

    SibRaMessagingEngineConnection(SibRaEndpointActivation endpointActivation, String busName, String targetType, String targetSignificance, String target) throws SIException, ResourceException {
        String methodName = "SibRaMessagingEngineConnection";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaMessagingEngineConnection", (Object)new Object[]{endpointActivation, busName, targetType, targetSignificance, target});
        }
        this._endpointActivation = endpointActivation;
        this._endpointConfiguration = endpointActivation.getEndpointConfiguration();
        this._busName = busName;
        SICoreConnectionFactory factory = SICoreConnectionFactorySelector.getSICoreConnectionFactory((FactoryType)FactoryType.TRM_CONNECTION);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("remoteServerAddress", this._endpointConfiguration.getProviderEndpoints());
        properties.put("targetTransport", this._endpointConfiguration.getTargetTransport());
        properties.put("busName", this._endpointConfiguration.getBusName());
        try {
            this._connection = this.createConnection(factory, this._endpointConfiguration.getUserName(), this._endpointConfiguration.getPassword(), properties, this._busName);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Obtained Connection <" + this._connection + ">"));
            }
            this._connectionListener = new SibRaConnectionListener();
            if (this._connection != null) {
                this._connection.addConnectionListener((SICoreConnectionListener)this._connectionListener);
            }
        }
        catch (SIAuthenticationException siae) {
            FFDCFilter.processException((Throwable)siae, (String)(CLASS_NAME + "." + "SibRaMessagingEngineConnection"), (String)"1:564:1.59", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)siae));
            }
            throw new ResourceException(NLS.getFormattedMessage("CREATE_CONNECTION_CWSIV0962", new Object[]{siae, this._busName, this.getActivationSpecId()}, null), (Throwable)siae);
        }
        catch (SINotAuthorizedException sinae) {
            FFDCFilter.processException((Throwable)sinae, (String)(CLASS_NAME + "." + "SibRaMessagingEngineConnection"), (String)"1:681:1.59", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sinae));
            }
            if (this._endpointConfiguration.getUserName() == null) {
                throw new ResourceException(NLS.getFormattedMessage("CREATE_CONNECTION_CWSIV0960", new Object[]{sinae, this._busName, this._endpointConfiguration.getActivationSpec()}, null), (Throwable)sinae);
            }
            throw new ResourceException(NLS.getFormattedMessage("CREATE_CONNECTION_CWSIV0961", new Object[]{sinae, this._busName, this._endpointConfiguration.getActivationSpec()}, null), (Throwable)sinae);
        }
        catch (Exception wsse) {
            FFDCFilter.processException((Throwable)wsse, (String)(CLASS_NAME + "." + "SibRaMessagingEngineConnection"), (String)"1:705:1.59", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)wsse);
            }
            throw new ResourceException(NLS.getFormattedMessage("CREATE_CONNECTION_CWSIV0950", new Object[]{wsse}, null), (Throwable)wsse);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaMessagingEngineConnection");
        }
    }

    SICoreConnection getConnection() {
        return this._connection;
    }

    SibRaEndpointActivation getEndpointActivation() {
        return this._endpointActivation;
    }

    SibRaEndpointConfiguration getEndpointConfiguration() {
        return this._endpointConfiguration;
    }

    String getBusName() {
        return this._busName;
    }

    SibRaListener createListener(SIDestinationAddress destination, MessageEndpointFactory messageEndpointFactory) throws ResourceException {
        String methodName = "createListener";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createListener", (Object)new Object[]{destination, messageEndpointFactory});
        }
        if (this._closed) {
            throw new IllegalStateException(NLS.getString("LISTENER_CLOSED_CWSIV0952"));
        }
        SibRaSingleProcessListener listener = new SibRaSingleProcessListener(this, destination, messageEndpointFactory);
        this._listeners.put(destination, listener);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createListener", (Object)listener);
        }
        return listener;
    }

    SibRaDispatcher createDispatcher(AbstractConsumerSession session, Reliability unrecoveredReliability, int maxFailedDeliveries, int sequentialFailureThreshold) throws ResourceException {
        String methodName = "createDispatcher";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createDispatcher", (Object)new Object[]{session, unrecoveredReliability, maxFailedDeliveries, sequentialFailureThreshold});
        }
        if (this._closed) {
            throw new IllegalStateException(NLS.getString("LISTENER_CLOSED_CWSIV0953"));
        }
        SibRaDispatcher dispatcher = this._endpointActivation.isEndpointMethodTransactional() ? (this._endpointConfiguration.getShareDataSourceWithCMP() ? new SibRaSynchronizedDispatcher(this, session, this._endpointActivation, unrecoveredReliability, maxFailedDeliveries, sequentialFailureThreshold) : new SibRaTransactionalDispatcher(this, session, this._endpointActivation, this._busName, unrecoveredReliability, maxFailedDeliveries, sequentialFailureThreshold)) : (SibRaMessageDeletionMode.BATCH.equals(this._endpointConfiguration.getMessageDeletionMode()) ? new SibRaBatchMessageDeletionDispatcher(this, session, this._endpointActivation, unrecoveredReliability, maxFailedDeliveries, sequentialFailureThreshold) : (SibRaMessageDeletionMode.SINGLE.equals(this._endpointConfiguration.getMessageDeletionMode()) ? new SibRaSingleMessageDeletionDispatcher(this, session, this._endpointActivation, unrecoveredReliability, maxFailedDeliveries, sequentialFailureThreshold) : new SibRaNonTransactionalDispatcher(this, session, this._endpointActivation, unrecoveredReliability, maxFailedDeliveries, sequentialFailureThreshold)));
        this._dispatcherCount.incrementAndGet();
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Creating a dispatcher, there are now " + this._dispatcherCount.get() + " open dispatchers"));
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createDispatcher", (Object)dispatcher);
        }
        return dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeDispatcher(SibRaDispatcher dispatcher) {
        String methodName = "closeDispatcher";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"closeDispatcher");
        }
        dispatcher.close();
        this._dispatcherCount.decrementAndGet();
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Removing a dispatcher - there are " + this._dispatcherCount.get() + " left"));
        }
        AtomicInteger atomicInteger = this._dispatcherCount;
        synchronized (atomicInteger) {
            this._dispatcherCount.notifyAll();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"closeDispatcher");
        }
    }

    void close() {
        String methodName = "close";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"close");
        }
        this.close(false);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean alreadyClosed) {
        block16: {
            String methodName = "close";
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"close", (Object)alreadyClosed);
            }
            this._closed = true;
            if (!alreadyClosed) {
                for (SibRaListener listener : this._listeners.values()) {
                    listener.stop();
                }
            }
            SibRaDispatcher.resetMEName();
            Iterator<SibRaListener> iterator = this._dispatcherCount;
            synchronized (iterator) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("There are still " + this._dispatcherCount.get() + " open dispatchers"));
                }
                if (this._dispatcherCount.get() > 0) {
                    Long mdbQuiescingTimeout = this.getMDBQuiescingTimeoutProperty();
                    this.waitForDispatchersToFinish(mdbQuiescingTimeout);
                }
            }
            if (!alreadyClosed) {
                for (SibRaListener listener : this._listeners.values()) {
                    listener.close();
                }
            }
            this._listeners.clear();
            try {
                this._connection.removeConnectionListener((SICoreConnectionListener)this._connectionListener);
                if (!alreadyClosed) {
                    this._connection.close();
                }
            }
            catch (SIException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "close"), (String)"1:1023:1.59", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
            }
            catch (SIErrorException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "close"), (String)"1:1031:1.59", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE.isEventEnabled()) break block16;
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"close");
        }
    }

    private void waitForDispatchersToFinish(Long mdbQuiescingTimeout) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"waitForDispatchersToFinish", (Object)mdbQuiescingTimeout);
        }
        long wakeupInterval = 10000L;
        long startTime = System.currentTimeMillis();
        if (mdbQuiescingTimeout >= 0L) {
            while (this._dispatcherCount.get() > 0) {
                long timeToWaitThisTimeRound;
                long timeWaiting = System.currentTimeMillis() - startTime;
                if (mdbQuiescingTimeout > 0L) {
                    long timeLeftToWait = mdbQuiescingTimeout - timeWaiting;
                    if (timeLeftToWait <= 0L) {
                        if (!TraceComponent.isAnyTracingEnabled() || !TRACE.isDebugEnabled()) break;
                        SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"Breaking out of loop as we have finished waiting");
                        break;
                    }
                    timeToWaitThisTimeRound = Math.min(timeLeftToWait, 10000L);
                } else {
                    timeToWaitThisTimeRound = 10000L;
                }
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Entering wait for " + timeToWaitThisTimeRound + "ms. Waited " + timeWaiting + "ms so far. " + this._dispatcherCount.get() + " dispatcher(s) still active"));
                }
                try {
                    this._dispatcherCount.wait(timeToWaitThisTimeRound);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"waitForDispatchersToFinish");
        }
    }

    private Long getMDBQuiescingTimeoutProperty() {
        return 0L;
    }

    SICoreConnection createConnection(SICoreConnectionFactory factory, String name, String password, Map properties, String busName) throws SIException, SIErrorException, Exception {
        String methodName = "createConnection";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createConnection", (Object)new Object[]{factory, name, "password not traced", properties, busName});
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"Creating connection with Userid and password");
        }
        SICoreConnection result = factory.createConnection(name, password, properties);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createConnection", (Object)result);
        }
        return result;
    }

    int getNumberListeners() {
        return this._listeners.size();
    }

    boolean isClosed() {
        return this._closed;
    }

    private static class SibRaConnectionEventThread
    implements Runnable {
        public static final int ME_QUIESCING_EVENT = 0;
        public static final int ME_TERMINATED_EVENT = 1;
        public static final int SESSION_ERROR_EVENT = 2;
        public static final int CONNECTION_ERROR_EVENT = 3;
        private static final Object workSync = new Object();
        private static final LinkedList workQueue = new LinkedList();
        private static SibRaConnectionEventThread threadInstance = null;

        private SibRaConnectionEventThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void enqueueEvent(int event_id, SibRaMessagingEngineConnection connection, SibRaEndpointActivation endpointActivation, ConsumerSession session, Throwable throwable) {
            String methodName = "enqueueEvent";
            if (TraceComponent.isAnyTracingEnabled() && EVENT_TRACE.isEntryEnabled()) {
                SibTr.entry((TraceComponent)EVENT_TRACE, (String)"enqueueEvent", (Object)new Object[]{event_id, connection, endpointActivation, session, throwable});
            }
            Object object = workSync;
            synchronized (object) {
                block11: {
                    if (threadInstance == null) {
                        try {
                            SibRaConnectionEventThread newThread;
                            threadInstance = newThread = new SibRaConnectionEventThread();
                            Thread th = new Thread(newThread);
                            th.start();
                        }
                        catch (Throwable e) {
                            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + "." + "enqueueEvent"), (String)"1:1423:1.59");
                            if (TraceComponent.isAnyTracingEnabled() && EVENT_TRACE.isDebugEnabled()) {
                                SibTr.exception((TraceComponent)EVENT_TRACE, (Throwable)e);
                            }
                            if (!(e instanceof ThreadDeath)) break block11;
                            throw (ThreadDeath)e;
                        }
                    }
                }
                if (threadInstance != null) {
                    workQueue.addLast(new SibRaConnectionEvent(event_id, connection, endpointActivation, session, throwable));
                } else {
                    SibRaConnectionEventThread.executeCallback(event_id, connection, endpointActivation, session, throwable);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && EVENT_TRACE.isEntryEnabled()) {
                SibTr.exit((TraceComponent)EVENT_TRACE, (String)"enqueueEvent");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String methodName = "run";
            if (TraceComponent.isAnyTracingEnabled() && EVENT_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)EVENT_TRACE, (String)"run");
            }
            boolean eventsRemain = true;
            while (eventsRemain) {
                SibRaConnectionEvent event = null;
                Object object = workSync;
                synchronized (object) {
                    int eventDepth = workQueue.size();
                    if (TraceComponent.isAnyTracingEnabled() && EVENT_TRACE.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)EVENT_TRACE, (String)(eventDepth + " queued events"));
                    }
                    boolean bl = eventsRemain = eventDepth > 0;
                    if (eventsRemain) {
                        event = (SibRaConnectionEvent)workQueue.removeFirst();
                    } else {
                        threadInstance = null;
                    }
                }
                if (event == null) continue;
                try {
                    SibRaConnectionEventThread.executeCallback(event.event_id, event.connection, event.endpointActivation, event.session, event.throwable);
                }
                catch (Throwable e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + "." + "run"), (String)"1:1483:1.59");
                    if (TraceComponent.isAnyTracingEnabled() && EVENT_TRACE.isDebugEnabled()) {
                        SibTr.exception((TraceComponent)EVENT_TRACE, (Throwable)e);
                    }
                    if (!(e instanceof ThreadDeath)) continue;
                    throw (ThreadDeath)e;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && EVENT_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)EVENT_TRACE, (String)"run");
            }
        }

        private static void executeCallback(int event_id, SibRaMessagingEngineConnection connection, SibRaEndpointActivation endpointActivation, ConsumerSession session, Throwable throwable) {
            String methodName = "executeCallback";
            if (TraceComponent.isAnyTracingEnabled() && EVENT_TRACE.isEntryEnabled()) {
                SibTr.entry((TraceComponent)EVENT_TRACE, (String)"executeCallback", (Object)new Object[]{event_id, connection, endpointActivation, session, throwable});
            }
            switch (event_id) {
                case 0: {
                    endpointActivation.messagingEngineQuiescing(connection);
                    break;
                }
                case 1: {
                    endpointActivation.messagingEngineTerminated(connection);
                    break;
                }
                case 2: {
                    endpointActivation.sessionError(connection, session, throwable);
                    break;
                }
                case 3: {
                    endpointActivation.connectionError(connection, (SIException)throwable);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && EVENT_TRACE.isEntryEnabled()) {
                SibTr.exit((TraceComponent)EVENT_TRACE, (String)"executeCallback");
            }
        }

        private static class SibRaConnectionEvent {
            public int event_id;
            public SibRaMessagingEngineConnection connection;
            public SibRaEndpointActivation endpointActivation;
            public ConsumerSession session;
            public Throwable throwable;

            private SibRaConnectionEvent(int event_id, SibRaMessagingEngineConnection connection, SibRaEndpointActivation endpointActivation, ConsumerSession session, Throwable throwable) {
                this.event_id = event_id;
                this.connection = connection;
                this.endpointActivation = endpointActivation;
                this.session = session;
                this.throwable = throwable;
            }
        }
    }

    private final class SibRaConnectionListener
    implements SICoreConnectionListener {
        private SibRaConnectionListener() {
        }

        public void asynchronousException(ConsumerSession session, Throwable throwable) {
            String methodName = "asynchronousException";
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LISTENER_TRACE, (String)"asynchronousException", (Object)new Object[]{session, throwable});
            }
            SibRaConnectionEventThread.enqueueEvent(2, SibRaMessagingEngineConnection.this, SibRaMessagingEngineConnection.this._endpointActivation, session, throwable);
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LISTENER_TRACE, (String)"asynchronousException");
            }
        }

        public void meQuiescing(SICoreConnection connection) {
            String methodName = "meQuiescing";
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LISTENER_TRACE, (String)"meQuiescing", (Object)connection);
            }
            SibRaConnectionEventThread.enqueueEvent(0, SibRaMessagingEngineConnection.this, SibRaMessagingEngineConnection.this._endpointActivation, null, null);
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LISTENER_TRACE, (String)"meQuiescing");
            }
        }

        public void commsFailure(SICoreConnection connection, SIConnectionLostException exception) {
            String methodName = "commsFailure";
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LISTENER_TRACE, (String)"commsFailure", (Object)new Object[]{connection, exception});
            }
            SibRaConnectionEventThread.enqueueEvent(3, SibRaMessagingEngineConnection.this, SibRaMessagingEngineConnection.this._endpointActivation, null, exception);
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LISTENER_TRACE, (String)"commsFailure");
            }
        }

        public void meTerminated(SICoreConnection connection) {
            String methodName = "meTerminated";
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LISTENER_TRACE, (String)"meTerminated", (Object)connection);
            }
            SibRaConnectionEventThread.enqueueEvent(1, SibRaMessagingEngineConnection.this, SibRaMessagingEngineConnection.this._endpointActivation, null, null);
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LISTENER_TRACE, (String)"meTerminated");
            }
        }
    }
}

