/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.util;

import com.ibm.websphere.logging.hpel.LogRecordContext;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.container.was.ThreadLocalStorage;
import java.util.Iterator;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipSession;

public class SipLogExtension {
    private static final String SAS_ID_EXT_KEY = "SIPASId";
    private static final String CALL_ID_EXT_KEY = "SIPCallId";
    private static final String SESSION_ID_EXT_KEY = "SIPSessionId";
    private static final String CALL_ID_2_EXT_KEY = "SIPCallId2";
    private static final String SESSION_ID_2_EXT_KEY = "SIPSessionId2";
    private static final LogRecordContext.Extension _sasIdExtension = new LogRecordContext.Extension(){

        public String getValue() {
            return SipLogExtension.getSasId();
        }
    };
    private static final LogRecordContext.Extension _callIdExtension = new LogRecordContext.Extension(){

        public String getValue() {
            return SipLogExtension.getCallId();
        }
    };
    private static final LogRecordContext.Extension _sessionIdExtension = new LogRecordContext.Extension(){

        public String getValue() {
            return SipLogExtension.getSessionId();
        }
    };
    private static final LogRecordContext.Extension _addCallIdExtension = new LogRecordContext.Extension(){

        public String getValue() {
            return SipLogExtension.getSecondCallId();
        }
    };
    private static final LogRecordContext.Extension _addSessionIdExtension = new LogRecordContext.Extension(){

        public String getValue() {
            return SipLogExtension.getSecondSessionId();
        }
    };

    public static void init() {
        if (PropertiesStore.getInstance().getProperties().getBoolean("enableHpelSipLogExtension")) {
            LogRecordContext.registerExtension((String)SAS_ID_EXT_KEY, (LogRecordContext.Extension)_sasIdExtension);
            LogRecordContext.registerExtension((String)CALL_ID_EXT_KEY, (LogRecordContext.Extension)_callIdExtension);
            LogRecordContext.registerExtension((String)SESSION_ID_EXT_KEY, (LogRecordContext.Extension)_sessionIdExtension);
            LogRecordContext.registerExtension((String)CALL_ID_2_EXT_KEY, (LogRecordContext.Extension)_addCallIdExtension);
            LogRecordContext.registerExtension((String)SESSION_ID_2_EXT_KEY, (LogRecordContext.Extension)_addSessionIdExtension);
        }
    }

    public static void destroy() {
        if (PropertiesStore.getInstance().getProperties().getBoolean("enableHpelSipLogExtension")) {
            LogRecordContext.unregisterExtension((String)SAS_ID_EXT_KEY);
            LogRecordContext.unregisterExtension((String)CALL_ID_EXT_KEY);
            LogRecordContext.unregisterExtension((String)SESSION_ID_EXT_KEY);
            LogRecordContext.unregisterExtension((String)CALL_ID_2_EXT_KEY);
            LogRecordContext.unregisterExtension((String)SESSION_ID_2_EXT_KEY);
        }
    }

    private static String getSasId() {
        try {
            SipApplicationSession sas = ThreadLocalStorage.getApplicationSession();
            if (sas != null) {
                return sas.getId();
            }
        }
        catch (NullPointerException sas) {
            // empty catch block
        }
        TransactionUserWrapper tu = ThreadLocalStorage.getTuWrapper();
        if (tu != null) {
            try {
                return tu.getApplicationId();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return com.ibm.ws.sip.stack.util.ThreadLocalStorage.getSasID();
    }

    private static String getCallId() {
        try {
            Iterator i;
            SipApplicationSession sas = ThreadLocalStorage.getApplicationSession();
            if (sas != null && (i = sas.getSessions("SIP", false)).hasNext()) {
                SipSession session = (SipSession)i.next();
                return session.getCallId();
            }
            TransactionUserWrapper tu = ThreadLocalStorage.getTuWrapper();
            if (tu != null) {
                try {
                    return tu.getCallId();
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return com.ibm.ws.sip.stack.util.ThreadLocalStorage.getCallID();
    }

    private static String getSessionId() {
        try {
            Iterator i;
            SipApplicationSession sas = ThreadLocalStorage.getApplicationSession();
            if (sas != null && (i = sas.getSessions("SIP", false)).hasNext()) {
                SipSession session = (SipSession)i.next();
                return session.getId();
            }
            TransactionUserWrapper tu = ThreadLocalStorage.getTuWrapper();
            if (tu != null) {
                try {
                    return tu.getSipSessionId();
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    private static String getSecondCallId() {
        try {
            SipApplicationSession sas = ThreadLocalStorage.getApplicationSession();
            if (sas != null) {
                Iterator i = sas.getSessions("SIP", false);
                int sessionsCounter = 0;
                while (i.hasNext() && sessionsCounter < 2) {
                    SipSession session = (SipSession)i.next();
                    if (++sessionsCounter != 2) continue;
                    return session.getCallId();
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    private static String getSecondSessionId() {
        try {
            SipApplicationSession sas = ThreadLocalStorage.getApplicationSession();
            if (sas != null) {
                Iterator i = sas.getSessions("SIP", false);
                int sessionsCounter = 0;
                while (i.hasNext() && sessionsCounter < 2) {
                    SipSession session = (SipSession)i.next();
                    if (++sessionsCounter != 2) continue;
                    return session.getId();
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }
}

