/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.transport.connections;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.message.MessageImpl;
import com.ibm.ws.sip.container.timer.TimerServiceImpl;
import com.ibm.ws.sip.stack.context.MessageContext;
import com.ibm.ws.sip.stack.dispatch.Dispatcher;
import com.ibm.ws.sip.stack.transaction.transport.Hop;
import com.ibm.ws.sip.stack.transaction.transport.PathMtuExceeded;
import com.ibm.ws.sip.stack.transaction.transport.UseCompactHeaders;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPConnection;
import com.ibm.ws.sip.stack.transaction.transport.connections.SipMessageByteBuffer;
import com.ibm.ws.sip.stack.transaction.util.ApplicationProperties;
import com.ibm.ws.sip.stack.transaction.util.SIPStackUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class SIPConnectionAdapter
implements SIPConnection {
    static final LogMgr c_logger = Log.get(SIPConnectionAdapter.class);
    private static final int NEVER_CLOSE_CONNECTION_ON_A_PARSE_ERROR = -1;
    private int m_aliacePort;
    private String m_peerHost;
    private int m_peerPort;
    private Object m_parser;
    private Hop m_key;
    protected ConnectionStatus m_connectionStatus = ConnectionStatus.PRE_CONNECT;
    private boolean m_outbound;
    private int m_numberOfParseErrors;
    private int m_maxParseErrorsAllowed;
    private int m_timerParseErrorsInterval;
    private ScheduledExecutorService m_scheduledExecutorService;
    private ScheduledFuture<?> m_parseErrorsTimer;
    private Object m_parseErrorsSynchronizer = new Object(){};

    public SIPConnectionAdapter(String peerHost, int peerPort) {
        this.m_peerHost = peerHost;
        this.m_peerPort = peerPort;
        this.m_aliacePort = -1;
        this.m_parser = null;
        this.m_key = null;
        this.m_outbound = false;
        this.m_numberOfParseErrors = 0;
        this.m_timerParseErrorsInterval = ApplicationProperties.getProperties().getInt("parseErrorsTimerInterval");
        this.m_maxParseErrorsAllowed = ApplicationProperties.getProperties().getInt("numberOfParseErrorsAllowed");
    }

    @Override
    public void setAliacePort(int port) {
        this.m_aliacePort = port;
    }

    @Override
    public int getAliacePort() {
        return this.m_aliacePort;
    }

    @Override
    public boolean hasAliacePort() {
        return this.m_aliacePort != -1;
    }

    public void setRemotePort(int peerPort) {
        this.m_peerPort = peerPort;
    }

    @Override
    public int getRemotePort() {
        return this.m_peerPort;
    }

    public void setRemoteHost(String peerHost) {
        try {
            this.m_peerHost = SIPStackUtil.getHostAddress(peerHost);
        }
        catch (Throwable t) {
            this.m_peerHost = peerHost;
        }
    }

    @Override
    public String getRemoteHost() {
        return this.m_peerHost;
    }

    @Override
    public Hop getKey() {
        return this.m_key;
    }

    @Override
    public void setKey(Hop key) {
        this.m_key = key;
    }

    public String toString() {
        Hop key = this.getKey();
        return key == null ? "?" : key.toString();
    }

    public Object getParsingObject() {
        return this.m_parser;
    }

    public void setParsingObject(Object parser) {
        this.m_parser = parser;
    }

    @Override
    public void connectionError(Exception e2) {
        if (this.isClosed()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "connection Error", "connection Error on closed connection");
            }
            return;
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "connectionError", "error", e2);
        }
        Dispatcher.instance().queueConnectionClosedEvent(this);
    }

    @Override
    public void writeComplete(MessageContext messageContext) {
    }

    @Override
    public void readComplete() {
    }

    protected void cleanPendingMessages(List<MessageContext> pendingMessages, Exception e2) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "cleanPendingMessages", (Object)"entry");
        }
        if (pendingMessages == null) {
            return;
        }
        Iterator<MessageContext> itr = pendingMessages.iterator();
        while (itr.hasNext()) {
            MessageContext messageSendingContext = itr.next();
            itr.remove();
            messageSendingContext.writeError(e2);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "cleanPendingMessages", "exit");
        }
    }

    protected void prepareBuffer(MessageContext messageContext, boolean considerMtu, UseCompactHeaders useCompactHeaders) throws IOException {
        SipMessageByteBuffer sipMessageByteBuffer;
        MessageImpl.HeaderForm headerForm;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "prepareBuffer", "entry. considerMtu [" + considerMtu + "] useCompactHeaders [" + (Object)((Object)useCompactHeaders) + ']');
        }
        switch (useCompactHeaders) {
            case NEVER: {
                headerForm = MessageImpl.HeaderForm.LONG;
                break;
            }
            case ALWAYS: {
                headerForm = MessageImpl.HeaderForm.COMPACT;
                break;
            }
            default: {
                headerForm = MessageImpl.HeaderForm.DEFAULT;
            }
        }
        MessageImpl message = (MessageImpl)messageContext.getSipMessage();
        try {
            sipMessageByteBuffer = SipMessageByteBuffer.fromMessage(message, headerForm);
        }
        catch (Exception e2) {
            messageContext.writeError(e2);
            throw e2 instanceof IOException ? (IOException)e2 : new IOException(e2.getMessage());
        }
        messageContext.setSipMessageByteBuffer(sipMessageByteBuffer);
        if (considerMtu && !this.isReliable() && this.mtuExceeds(sipMessageByteBuffer)) {
            if (headerForm == MessageImpl.HeaderForm.LONG || headerForm == MessageImpl.HeaderForm.DEFAULT && message.isCompact()) {
                PathMtuExceeded.throwIt();
            } else if (useCompactHeaders == UseCompactHeaders.MTU_EXCEEDS) {
                headerForm = MessageImpl.HeaderForm.COMPACT;
                try {
                    sipMessageByteBuffer = SipMessageByteBuffer.fromMessage(message, headerForm);
                }
                catch (Exception e3) {
                    messageContext.writeError(e3);
                    throw e3 instanceof IOException ? (IOException)e3 : new IOException(e3.getMessage());
                }
                messageContext.setSipMessageByteBuffer(sipMessageByteBuffer);
                if (this.mtuExceeds(sipMessageByteBuffer)) {
                    PathMtuExceeded.throwIt();
                }
            }
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "prepareBuffer", "exit. headerForm [" + (Object)((Object)headerForm) + "] message size [" + sipMessageByteBuffer.getMarkedBytesNumber() + ']');
        }
    }

    protected boolean mtuExceeds(SipMessageByteBuffer sipMessageByteBuffer) {
        int limit;
        int size = sipMessageByteBuffer.getMarkedBytesNumber();
        return size > (limit = this.getPathMTU() - 200);
    }

    @Override
    public boolean isClosed() {
        return this.m_connectionStatus == ConnectionStatus.CLOSED;
    }

    @Override
    public boolean isConnected() {
        return this.m_connectionStatus == ConnectionStatus.CONNECTED;
    }

    @Override
    public boolean isOutbound() {
        return this.m_outbound;
    }

    @Override
    public void setOutbound(boolean outbound) {
        this.m_outbound = outbound;
    }

    protected void logConnection() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "logConnection", "connection [" + System.identityHashCode(this) + "] connection status [" + (Object)((Object)this.m_connectionStatus) + "] key [" + this.getKey() + "] remote [" + this.getRemoteHost() + ':' + this.getRemotePort() + ']');
        }
    }

    private void logParseErrorCounter(String method) {
        c_logger.traceDebug(this, method, "connection [" + System.identityHashCode(this) + "] key [" + this.getKey() + "] parse errors counter = " + this.m_numberOfParseErrors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionEstablished() {
        this.m_connectionStatus = ConnectionStatus.CONNECTED;
        this.initNumberOfParseErrors();
        if (this.m_maxParseErrorsAllowed > 0) {
            if (this.m_timerParseErrorsInterval > 0) {
                this.m_scheduledExecutorService = TimerServiceImpl.getTimerSerivce();
                this.m_parseErrorsTimer = this.m_scheduledExecutorService.scheduleAtFixedRate(new TimerParseErrorsListener(), this.m_timerParseErrorsInterval, this.m_timerParseErrorsInterval, TimeUnit.MILLISECONDS);
            } else if (c_logger.isTraceDebugEnabled()) {
                Object object = this.m_parseErrorsSynchronizer;
                synchronized (object) {
                    this.logParseErrorCounter("connectionEstablished, no interval for parse errors");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementNumberOfParseErrors() {
        Object object = this.m_parseErrorsSynchronizer;
        synchronized (object) {
            ++this.m_numberOfParseErrors;
            if (c_logger.isTraceDebugEnabled()) {
                this.logParseErrorCounter("incrementNumberOfParseErrors");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldDropConnection() {
        if (this.m_maxParseErrorsAllowed == -1) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, " shouldDropConnection ", "maxParseErrorsAllowed is set to -1, shouldDropConnection will return false");
            }
            return false;
        }
        if (this.m_maxParseErrorsAllowed > -1) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, " shouldDropConnection ", "maxParseErrorsAllowed is set to " + this.m_maxParseErrorsAllowed);
            }
            Object object = this.m_parseErrorsSynchronizer;
            synchronized (object) {
                if (this.m_numberOfParseErrors > this.m_maxParseErrorsAllowed) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, " shouldDropConnection ", "number of parse errors is higher than maxParseErrorsAllowed, shouldDropConnection will return true");
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isAParseErrorAllowed() {
        if (this.m_maxParseErrorsAllowed == -1 || this.m_maxParseErrorsAllowed > 0) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, " isAParseErrorAllowed ", "parsing errors are allowed");
            }
            return true;
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, " isAParseErrorAllowed ", "parsing errors are not allowed");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initNumberOfParseErrors() {
        Object object = this.m_parseErrorsSynchronizer;
        synchronized (object) {
            this.m_numberOfParseErrors = 0;
            if (c_logger.isTraceDebugEnabled()) {
                this.logParseErrorCounter("initializes parse errors counter");
            }
        }
    }

    @Override
    public void close() {
        this.cancelTimer(this.m_parseErrorsTimer, TimerParseErrorsListener.class.getName());
    }

    private void cancelTimer(ScheduledFuture<?> timerToCancel, String timerClass) {
        if (timerToCancel != null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "cancelTimer", "Canceling " + timerClass);
            }
            timerToCancel.cancel(true);
        }
    }

    private class TimerParseErrorsListener
    implements Runnable {
        private TimerParseErrorsListener() {
        }

        @Override
        public void run() {
            SIPConnectionAdapter.this.initNumberOfParseErrors();
        }
    }

    protected static enum ConnectionStatus {
        PRE_CONNECT,
        CONNECTED,
        CLOSED;

    }
}

