/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.sip.converge;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.servlet.session.IBMApplicationSession;
import com.ibm.websphere.servlet.session.IBMSession;
import com.ibm.ws.session.IBMApplicationSessionImpl;
import com.ibm.ws.session.SessionContext;
import com.ibm.ws.session.SessionData;
import com.ibm.ws.session.SessionManager;
import com.ibm.ws.session.SessionManagerConfig;
import com.ibm.ws.sip.container.converged.WsHttpSessionFacade;
import com.ibm.ws.sip.container.converged.session.ApplicationSessionCreator;
import com.ibm.ws.sip.container.servlets.WASXSipApplicationSessionFactory;
import com.ibm.ws.webcontainer.session.impl.HttpSessionContextImpl;
import com.ibm.ws.webcontainer.session.impl.HttpSessionImpl;
import com.ibm.wsspi.session.ISession;
import com.ibm.wsspi.sip.converge.ConvergedHttpSessionContextImpl;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.sip.ConvergedHttpSession;
import javax.servlet.sip.SipApplicationSession;

public class ConvergedHttpSessionImpl
extends HttpSessionImpl
implements ConvergedHttpSession {
    String sipCookieInfo = null;
    static ApplicationSessionCreator mAppSessCreator = null;
    private static final transient LogMgr c_logger = Log.get(ConvergedHttpSessionImpl.class);

    public ConvergedHttpSessionImpl(ISession session, SessionContext sessCtx, ServletContext servCtx) {
        super(session, sessCtx, servCtx);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "ConvergedHttpSessionImpl", (Object)" Constructor");
        }
        WASXSipApplicationSessionFactory.getInstance().createSipApplicationSession();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "ConvergedHttpSessionIml", " New Converged created");
        }
    }

    protected WsHttpSessionFacade returnFacade() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "returnFacade", " WsHttpSessionFacade");
        }
        return new WsHttpSessionFacade((SessionData)this);
    }

    public void setSIPCookieInfo(HttpServletRequest _request) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "setSIPCookieInfo", (Object)"setSIPCookieInfo");
        }
        String sipLogicalServerName = null;
        byte[] byteSipLogicalServerName = ((IExtendedRequest)_request).getCookieValueAsBytes(SessionManagerConfig.sipSessionCookieName);
        if (byteSipLogicalServerName != null) {
            sipLogicalServerName = new String(byteSipLogicalServerName);
        }
        if (sipLogicalServerName != null && sipLogicalServerName.length() > 0) {
            this.sipCookieInfo = sipLogicalServerName;
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "setSIPCookieInfo", "sipCookieInfo = " + this.sipCookieInfo);
        }
    }

    public IBMApplicationSession getIBMApplicationSession(boolean create) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getIBMApplicationSession", "getIBMApplicationSession, create = " + create);
        }
        return this.getIBMApplicationSession(create, this.sipCookieInfo);
    }

    public IBMApplicationSession getIBMApplicationSession(boolean create, String logicalServerName) {
        SessionManager sm;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "getIBMApplicationSession", (Object)("for app " + this.appName + " create " + create + " IBMApplicationSession " + this.mIBMApplicationSession));
        }
        ServletContext sc = this.getServletContext();
        boolean isSIP = this.getSessCtx().isSIPApplication();
        if (this.mIBMApplicationSession == null && mAppSessCreator != null && isSIP && create) {
            String scDisplayName = null;
            if (sc != null) {
                scDisplayName = sc.getServletContextName();
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getIBMApplicationSession", "ServletContext is null");
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getIBMApplicationSession", "calling createApplicationSession with ServletContextName " + scDisplayName);
            }
            this.mIBMApplicationSession = mAppSessCreator.createApplicationSession((IBMSession)this._httpSessionFacade, scDisplayName, this.pathInfoForAppSession);
        }
        if (!isSIP && (sm = (SessionManager)this.getSessCtx()._coreHttpAppSessionManager) != null) {
            this.mIBMApplicationSession = (IBMApplicationSession)sm.getSession(this.getId(), this.getISession().getVersion(), true, null);
            if (SessionManagerConfig.getUsingApplicationSessionsAndInvalidateAll() && this.mIBMApplicationSession != null && ((IBMApplicationSessionImpl)this.mIBMApplicationSession).getISession() != null && ((IBMApplicationSessionImpl)this.mIBMApplicationSession).getISession().getMaxInactiveInterval() == 0) {
                this.mIBMApplicationSession.invalidate();
                this.mIBMApplicationSession = null;
            }
            if (this.mIBMApplicationSession == null && create) {
                this.mIBMApplicationSession = (IBMApplicationSession)sm.createSession(this.getId(), this.getISession().getVersion(), (Object)true);
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "getIBMApplicationSession", this.mIBMApplicationSession);
        }
        return this.mIBMApplicationSession;
    }

    @Override
    public String encodeURL(String url) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "encodeURL", (Object)"encodeURL");
        }
        String returnUrl = null;
        if (mAppSessCreator != null) {
            String httpEncoded = ((HttpSessionContextImpl)this.getSessCtx()).encodeURLForSipConvergedApps((HttpSession)this, url);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "encodeURL", "url encoded with httpsession: " + httpEncoded);
            }
            returnUrl = this.getIBMApplicationSession(true).encodeURI(httpEncoded);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "encodeURL", "returned url: " + returnUrl);
        }
        return returnUrl;
    }

    @Override
    public String encodeURL(String relativePath, String scheme) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "encodeURL", "relativePath = " + relativePath + " scheme = " + scheme);
        }
        if (mAppSessCreator != null) {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry((Object)this, "encodeURL", (Object)("encoding url with relative path = " + relativePath + " and scheme = " + scheme));
            }
            String contextPath = this.getServletContext().getContextPath();
            ConvergedHttpSessionContextImpl sessCtx = (ConvergedHttpSessionContextImpl)this.getSessCtx();
            String fullyQualifiedUrl = sessCtx.getSipBaseUrlForEncoding(contextPath, relativePath, scheme);
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit((Object)this, "encodeURL", "going to encode fully qualified url = " + fullyQualifiedUrl);
            }
            return this.encodeURL(fullyQualifiedUrl);
        }
        return null;
    }

    @Override
    public SipApplicationSession getApplicationSession() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getApplicationSession", "getApplicationSession");
        }
        if (mAppSessCreator != null) {
            return (SipApplicationSession)this.getIBMApplicationSession(true);
        }
        return null;
    }

    public static void setAppSessCreator(ApplicationSessionCreator appSessCreator) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(ConvergedHttpSessionImpl.class, "setAppSessCreator", "setting " + appSessCreator);
        }
        mAppSessCreator = appSessCreator;
    }
}

