/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.PropertyException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEvent;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import jakarta.xml.bind.helpers.DefaultValidationEventHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.jaxb.JAXBBeanInfo;
import org.apache.cxf.common.jaxb.JAXBContextCache;
import org.apache.cxf.common.jaxb.JAXBContextProxy;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.databinding.AbstractInterceptorProvidingDataBinding;
import org.apache.cxf.databinding.AbstractWrapperHelper;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.databinding.WrapperCapableDatabinding;
import org.apache.cxf.databinding.WrapperHelper;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxb.JAXBContextInitializer;
import org.apache.cxf.jaxb.JAXBSchemaInitializer;
import org.apache.cxf.jaxb.JAXBWrapperHelper;
import org.apache.cxf.jaxb.WrapperHelperCreator;
import org.apache.cxf.jaxb.attachment.JAXBAttachmentSchemaValidationHack;
import org.apache.cxf.jaxb.io.DataReaderImpl;
import org.apache.cxf.jaxb.io.DataWriterImpl;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.ws.addressing.ObjectFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

@NoJSR250Annotations
@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class JAXBDataBinding
extends AbstractInterceptorProvidingDataBinding
implements WrapperCapableDatabinding,
InterceptorProvider {
    public static final String READER_VALIDATION_EVENT_HANDLER = "jaxb-reader-validation-event-handler";
    public static final String VALIDATION_EVENT_HANDLER = "jaxb-validation-event-handler";
    public static final String SET_VALIDATION_EVENT_HANDLER = "set-jaxb-validation-event-handler";
    public static final String WRITER_VALIDATION_EVENT_HANDLER = "jaxb-writer-validation-event-handler";
    public static final String SCHEMA_RESOURCE = "SCHEMRESOURCE";
    public static final String MTOM_THRESHOLD = "org.apache.cxf.jaxb.mtomThreshold";
    public static final String UNWRAP_JAXB_ELEMENT = "unwrap.jaxb.element";
    public static final String USE_JAXB_BRIDGE = "use.jaxb.bridge";
    public static final String JAXB_SCAN_PACKAGES = "jaxb.scanPackages";
    private static final Logger LOG = LogUtils.getLogger(JAXBDataBinding.class);
    private static final Class<?>[] SUPPORTED_READER_FORMATS = new Class[]{Node.class, XMLEventReader.class, XMLStreamReader.class};
    private static final Class<?>[] SUPPORTED_WRITER_FORMATS = new Class[]{OutputStream.class, Node.class, XMLEventWriter.class, XMLStreamWriter.class};
    private static final boolean ENABLE_MARSHALL_POOLING = true;
    private static final boolean ENABLE_UNMARSHALL_POOLING = true;
    private static final int MAX_LOAD_FACTOR = 50;
    private static final Map<String, DOMResult> BUILT_IN_SCHEMAS = new HashMap<String, DOMResult>();
    Class<?>[] extraClass;
    JAXBContext context;
    Set<Class<?>> contextClasses;
    Collection<Object> typeRefs;
    Class<?> cls;
    private Map<String, Object> contextProperties;
    private List<XmlAdapter<?, ?>> adapters;
    private Map<String, Object> marshallerProperties;
    private Map<String, Object> unmarshallerProperties;
    private Unmarshaller.Listener unmarshallerListener;
    private Marshaller.Listener marshallerListener;
    private ValidationEventHandler validationEventHandler;
    private Object escapeHandler;
    private Object noEscapeHandler;
    private boolean unwrapJAXBElement;
    private boolean scanPackages;
    private boolean qualifiedSchemas;
    private Deque<SoftReference<Marshaller>> escapeMarshallers;
    private Deque<SoftReference<Marshaller>> noEscapeMarshallers;
    private Deque<SoftReference<Unmarshaller>> unmarshallers;
    static final long serialVersionUID = -2219588521542053522L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXBDataBinding() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "<init>", new Object[0]);
        }
        this.typeRefs = new ArrayList<Object>();
        this.contextProperties = new HashMap<String, Object>();
        this.adapters = new ArrayList();
        this.marshallerProperties = new HashMap<String, Object>();
        this.unmarshallerProperties = new HashMap<String, Object>();
        this.unwrapJAXBElement = true;
        this.scanPackages = true;
        this.escapeMarshallers = new LinkedBlockingDeque<SoftReference<Marshaller>>(50);
        this.noEscapeMarshallers = new LinkedBlockingDeque<SoftReference<Marshaller>>(50);
        this.unmarshallers = new LinkedBlockingDeque<SoftReference<Unmarshaller>>(50);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXBDataBinding(boolean q) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "<init>", new Object[]{q});
        }
        this.typeRefs = new ArrayList<Object>();
        this.contextProperties = new HashMap<String, Object>();
        this.adapters = new ArrayList();
        this.marshallerProperties = new HashMap<String, Object>();
        this.unmarshallerProperties = new HashMap<String, Object>();
        this.unwrapJAXBElement = true;
        this.scanPackages = true;
        this.escapeMarshallers = new LinkedBlockingDeque<SoftReference<Marshaller>>(50);
        this.noEscapeMarshallers = new LinkedBlockingDeque<SoftReference<Marshaller>>(50);
        this.unmarshallers = new LinkedBlockingDeque<SoftReference<Unmarshaller>>(50);
        this.qualifiedSchemas = q;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXBDataBinding(Class<?> ... classes) throws JAXBException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "<init>", new Object[]{classes});
        }
        this.typeRefs = new ArrayList<Object>();
        this.contextProperties = new HashMap<String, Object>();
        this.adapters = new ArrayList();
        this.marshallerProperties = new HashMap<String, Object>();
        this.unmarshallerProperties = new HashMap<String, Object>();
        this.unwrapJAXBElement = true;
        this.scanPackages = true;
        this.escapeMarshallers = new LinkedBlockingDeque<SoftReference<Marshaller>>(50);
        this.noEscapeMarshallers = new LinkedBlockingDeque<SoftReference<Marshaller>>(50);
        this.unmarshallers = new LinkedBlockingDeque<SoftReference<Unmarshaller>>(50);
        this.contextClasses = new LinkedHashSet(Arrays.asList(classes));
        this.setContext(this.createJAXBContext(this.contextClasses));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXBDataBinding(boolean qualified, Map<String, Object> props) throws JAXBException {
        this(qualified);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "<init>", new Object[]{qualified, props});
        }
        if (props != null && props.get("jaxb.additionalContextClasses") != null) {
            Class[] o = props.get("jaxb.additionalContextClasses");
            if (o instanceof Class) {
                o = new Class[]{(Class)o};
            }
            this.extraClass = o;
        }
        if (PropertyUtils.isFalse(props, (String)JAXB_SCAN_PACKAGES)) {
            this.scanPackages = false;
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXBDataBinding(JAXBContext context) {
        this();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "<init>", new Object[]{context});
        }
        this.setContext(context);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean getQualifiedSchemas() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getQualifiedSchemas", new Object[0]);
        }
        boolean bl = this.qualifiedSchemas;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getQualifiedSchemas", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXBContext getContext() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getContext", new Object[0]);
        }
        JAXBContext jAXBContext = this.context;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            jAXBContext = jAXBContext;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getContext", jAXBContext);
        }
        return jAXBContext;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public final void setContext(JAXBContext ctx) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "setContext", new Object[]{ctx});
        }
        this.context = ctx;
        this.escapeHandler = JAXBUtils.createMininumEscapeHandler(ctx.getClass());
        this.noEscapeHandler = JAXBUtils.createNoEscapeHandler(ctx.getClass());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "setContext");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object getEscapeHandler() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getEscapeHandler", new Object[0]);
        }
        Object object = this.escapeHandler;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getEscapeHandler", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setEscapeHandler(Object handler) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "setEscapeHandler", new Object[]{handler});
        }
        this.escapeHandler = handler;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "setEscapeHandler");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void applyEscapeHandler(boolean escape, Consumer<Object> consumer) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "applyEscapeHandler", new Object[]{escape, consumer});
        }
        if (escape) {
            consumer.accept(this.escapeHandler);
        } else if (this.noEscapeHandler != null) {
            consumer.accept(this.noEscapeHandler);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "applyEscapeHandler");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> DataWriter<T> createWriter(Class<T> c) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "createWriter", new Object[]{c});
        }
        Integer mtomThresholdInt = this.getMtomThreshold();
        if (c == XMLStreamWriter.class) {
            DataWriterImpl r = new DataWriterImpl(this.getBus(), this, true);
            r.setMtomThreshold(mtomThresholdInt);
            DataWriterImpl dataWriterImpl = r;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                dataWriterImpl = dataWriterImpl;
                LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "createWriter", dataWriterImpl);
            }
            return dataWriterImpl;
        }
        if (c == OutputStream.class) {
            DataWriterImpl r = new DataWriterImpl(this.getBus(), this, false);
            r.setMtomThreshold(mtomThresholdInt);
            DataWriterImpl dataWriterImpl = r;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                dataWriterImpl = dataWriterImpl;
                LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "createWriter", dataWriterImpl);
            }
            return dataWriterImpl;
        }
        if (c == XMLEventWriter.class) {
            DataWriterImpl r = new DataWriterImpl(this.getBus(), this, true);
            r.setMtomThreshold(mtomThresholdInt);
            DataWriterImpl dataWriterImpl = r;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                dataWriterImpl = dataWriterImpl;
                LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "createWriter", dataWriterImpl);
            }
            return dataWriterImpl;
        }
        if (c == Node.class) {
            DataWriterImpl r = new DataWriterImpl(this.getBus(), this, false);
            r.setMtomThreshold(mtomThresholdInt);
            DataWriterImpl dataWriterImpl = r;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                dataWriterImpl = dataWriterImpl;
                LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "createWriter", dataWriterImpl);
            }
            return dataWriterImpl;
        }
        DataWriter<T> dataWriter = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            dataWriter = dataWriter;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "createWriter", dataWriter);
        }
        return dataWriter;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Class<?>[] getSupportedWriterFormats() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getSupportedWriterFormats", new Object[0]);
        }
        Class<?>[] classArray = SUPPORTED_WRITER_FORMATS;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            classArray = classArray;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getSupportedWriterFormats", classArray);
        }
        return classArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> DataReader<T> createReader(Class<T> c) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "createReader", new Object[]{c});
        }
        DataReaderImpl dr = null;
        if (c == XMLStreamReader.class) {
            dr = new DataReaderImpl(this, this.unwrapJAXBElement);
        } else if (c == XMLEventReader.class) {
            dr = new DataReaderImpl(this, this.unwrapJAXBElement);
        } else if (c == Node.class) {
            dr = new DataReaderImpl(this, this.unwrapJAXBElement);
        }
        DataReaderImpl dataReaderImpl = dr;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            dataReaderImpl = dataReaderImpl;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "createReader", dataReaderImpl);
        }
        return dataReaderImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Class<?>[] getSupportedReaderFormats() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getSupportedReaderFormats", new Object[0]);
        }
        Class<?>[] classArray = SUPPORTED_READER_FORMATS;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            classArray = classArray;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getSupportedReaderFormats", classArray);
        }
        return classArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized void initialize(Service service) {
        JAXBContextCache.CachedContextAndSchemas cachedContextAndSchemas;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "initialize", new Object[]{service});
        }
        this.inInterceptors.addIfAbsent((Object)JAXBAttachmentSchemaValidationHack.INSTANCE);
        this.inFaultInterceptors.addIfAbsent((Object)JAXBAttachmentSchemaValidationHack.INSTANCE);
        if (this.context != null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "initialize");
            }
            return;
        }
        this.contextClasses = new LinkedHashSet();
        for (ServiceInfo serviceInfo : service.getServiceInfos()) {
            JAXBContextInitializer initializer = new JAXBContextInitializer(this.getBus(), serviceInfo, this.contextClasses, this.typeRefs, this.getUnmarshallerProperties());
            initializer.walk();
            if (serviceInfo.getProperty("extra.class") == null) continue;
            Set exClasses = (Set)serviceInfo.getProperty("extra.class", Set.class);
            this.contextClasses.addAll(exClasses);
        }
        String tns = this.getNamespaceToUse(service);
        try {
            cachedContextAndSchemas = this.createJAXBContextAndSchemas(this.contextClasses, tns);
        }
        catch (JAXBException e1) {
            throw new ServiceConstructionException((Throwable)e1);
        }
        JAXBContext ctx = cachedContextAndSchemas.getContext();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "CREATED_JAXB_CONTEXT", new Object[]{ctx, this.contextClasses});
        }
        this.setContext(ctx);
        for (ServiceInfo serviceInfo : service.getServiceInfos()) {
            SchemaCollection col = serviceInfo.getXmlSchemaCollection();
            if (col.getXmlSchemas().length > 1) {
                this.justCheckForJAXBAnnotations(serviceInfo);
                continue;
            }
            boolean schemasFromCache = false;
            Collection<DOMSource> schemas = this.getSchemas();
            if (schemas == null || schemas.isEmpty()) {
                schemas = cachedContextAndSchemas.getSchemas();
                if (schemas != null) {
                    schemasFromCache = true;
                }
            } else {
                schemasFromCache = true;
            }
            LinkedHashSet<DOMSource> bi = new LinkedHashSet<DOMSource>();
            if (schemas == null) {
                schemas = new LinkedHashSet<DOMSource>();
                try {
                    for (DOMResult dOMResult : this.generateJaxbSchemas()) {
                        DOMSource src = new DOMSource(dOMResult.getNode(), dOMResult.getSystemId());
                        if (JAXBDataBinding.isInBuiltInSchemas(dOMResult)) {
                            bi.add(src);
                            continue;
                        }
                        schemas.add(src);
                    }
                    schemas.addAll(bi);
                }
                catch (IOException e) {
                    throw new ServiceConstructionException("SCHEMA_GEN_EXC", LOG, (Throwable)e);
                }
            }
            for (DOMSource dOMSource : schemas) {
                String ns;
                if (bi.contains(dOMSource) && serviceInfo.getSchema(ns = ((Document)dOMSource.getNode()).getDocumentElement().getAttribute("targetNamespace")) != null) continue;
                this.addSchemaDocument(serviceInfo, col, (Document)dOMSource.getNode(), dOMSource.getSystemId());
            }
            JAXBSchemaInitializer schemaInit = new JAXBSchemaInitializer(serviceInfo, col, this.context, this.qualifiedSchemas, tns);
            schemaInit.walk();
            if (cachedContextAndSchemas == null || schemasFromCache) continue;
            cachedContextAndSchemas.setSchemas(schemas);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "initialize");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void justCheckForJAXBAnnotations(ServiceInfo serviceInfo) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "justCheckForJAXBAnnotations", new Object[]{serviceInfo});
        }
        for (MessageInfo mi : serviceInfo.getMessages().values()) {
            for (MessagePartInfo mpi : mi.getMessageParts()) {
                this.checkForJAXBAnnotations(mpi, serviceInfo.getXmlSchemaCollection(), serviceInfo.getTargetNamespace());
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "justCheckForJAXBAnnotations");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void checkForJAXBAnnotations(MessagePartInfo mpi, SchemaCollection schemaCollection, String ns) {
        JAXBBeanInfo beanInfo;
        JAXBBeanInfo jtaBeanInfo;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "checkForJAXBAnnotations", new Object[]{mpi, schemaCollection, ns});
        }
        Annotation[] anns = (Annotation[])mpi.getProperty("parameter.annotations");
        JAXBContextProxy ctx = JAXBUtils.createJAXBContextProxy((JAXBContext)this.context, (SchemaCollection)schemaCollection, (String)ns);
        XmlJavaTypeAdapter jta = JAXBSchemaInitializer.findFromTypeAdapter(ctx, mpi.getTypeClass(), anns);
        if (jta != null && (jtaBeanInfo = JAXBSchemaInitializer.findFromTypeAdapter(ctx, jta.value())) != (beanInfo = JAXBSchemaInitializer.getBeanInfo(ctx, mpi.getTypeClass()))) {
            mpi.setProperty("parameter.annotations", (Object)anns);
            mpi.setProperty("honor.jaxb.annotations", (Object)Boolean.TRUE);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "checkForJAXBAnnotations");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String getNamespaceToUse(Service service) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getNamespaceToUse", new Object[]{service});
        }
        if ("true".equals(service.get((Object)"org.apache.cxf.databinding.namespace"))) {
            String string = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getNamespaceToUse", string);
            }
            return string;
        }
        String tns = !service.getServiceInfos().isEmpty() ? ((ServiceInfo)service.getServiceInfos().get(0)).getInterface().getName().getNamespaceURI() : service.getName().getNamespaceURI();
        String string = tns;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getNamespaceToUse", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setExtraClass(Class<?>[] userExtraClass) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "setExtraClass", new Object[]{userExtraClass});
        }
        this.extraClass = userExtraClass;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "setExtraClass");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Class<?>[] getExtraClass() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getExtraClass", new Object[0]);
        }
        Class<?>[] classArray = this.extraClass;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            classArray = classArray;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getExtraClass", classArray);
        }
        return classArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    List<DOMResult> generateJaxbSchemas() throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "generateJaxbSchemas", new Object[0]);
        }
        List list = JAXBUtils.generateJaxbSchemas((JAXBContext)this.context, BUILT_IN_SCHEMAS);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "generateJaxbSchemas", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXBContext createJAXBContext(Set<Class<?>> classes) throws JAXBException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "createJAXBContext", new Object[]{classes});
        }
        JAXBContext jAXBContext = this.createJAXBContext(classes, null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            jAXBContext = jAXBContext;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "createJAXBContext", jAXBContext);
        }
        return jAXBContext;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXBContext createJAXBContext(Set<Class<?>> classes, String defaultNs) throws JAXBException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "createJAXBContext", new Object[]{classes, defaultNs});
        }
        JAXBContext jAXBContext = this.createJAXBContextAndSchemas(classes, defaultNs).getContext();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            jAXBContext = jAXBContext;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "createJAXBContext", jAXBContext);
        }
        return jAXBContext;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXBContextCache.CachedContextAndSchemas createJAXBContextAndSchemas(Set<Class<?>> classes, String defaultNs) throws JAXBException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "createJAXBContextAndSchemas", new Object[]{classes, defaultNs});
        }
        if (this.extraClass != null && this.extraClass.length > 0) {
            for (Class<?> clz : this.extraClass) {
                classes.add(clz);
            }
        }
        if (this.scanPackages) {
            JAXBContextCache.scanPackages(classes);
        }
        this.addWsAddressingTypes(classes);
        JAXBContextCache.CachedContextAndSchemas cachedContextAndSchemas = JAXBContextCache.getCachedContextAndSchemas(classes, (String)defaultNs, this.contextProperties, this.typeRefs, (boolean)true);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            cachedContextAndSchemas = cachedContextAndSchemas;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "createJAXBContextAndSchemas", cachedContextAndSchemas);
        }
        return cachedContextAndSchemas;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addWsAddressingTypes(Set<Class<?>> classes) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "addWsAddressingTypes", new Object[]{classes});
        }
        if (classes.contains(ObjectFactory.class)) {
            try {
                classes.add(Class.forName("org.apache.cxf.ws.addressing.wsdl.ObjectFactory"));
                classes.add(Class.forName("org.apache.cxf.ws.addressing.wsdl.AttributedQNameType"));
                classes.add(Class.forName("org.apache.cxf.ws.addressing.wsdl.ServiceNameType"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "addWsAddressingTypes");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<Class<?>> getContextClasses() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getContextClasses", new Object[0]);
        }
        Set<Class<?>> set = Collections.unmodifiableSet(this.contextClasses);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            set = set;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getContextClasses", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, Object> getContextProperties() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getContextProperties", new Object[0]);
        }
        Map<String, Object> map = this.contextProperties;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            map = map;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getContextProperties", map);
        }
        return map;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setContextProperties(Map<String, Object> contextProperties) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "setContextProperties", new Object[]{contextProperties});
        }
        this.contextProperties = contextProperties;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "setContextProperties");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<XmlAdapter<?, ?>> getConfiguredXmlAdapters() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getConfiguredXmlAdapters", new Object[0]);
        }
        List<XmlAdapter<?, ?>> list = this.adapters;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getConfiguredXmlAdapters", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setConfiguredXmlAdapters(List<XmlAdapter<?, ?>> adpters) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "setConfiguredXmlAdapters", new Object[]{adpters});
        }
        this.adapters = adpters;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "setConfiguredXmlAdapters");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, Object> getMarshallerProperties() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getMarshallerProperties", new Object[0]);
        }
        Map<String, Object> map = this.marshallerProperties;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            map = map;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getMarshallerProperties", map);
        }
        return map;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setMarshallerProperties(Map<String, Object> marshallerProperties) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "setMarshallerProperties", new Object[]{marshallerProperties});
        }
        this.marshallerProperties = marshallerProperties;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "setMarshallerProperties");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, Object> getUnmarshallerProperties() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getUnmarshallerProperties", new Object[0]);
        }
        Map<String, Object> map = this.unmarshallerProperties;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            map = map;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getUnmarshallerProperties", map);
        }
        return map;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setUnmarshallerProperties(Map<String, Object> unmarshallerProperties) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "setUnmarshallerProperties", new Object[]{unmarshallerProperties});
        }
        this.unmarshallerProperties = unmarshallerProperties;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "setUnmarshallerProperties");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Unmarshaller.Listener getUnmarshallerListener() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getUnmarshallerListener", new Object[0]);
        }
        Unmarshaller.Listener listener = this.unmarshallerListener;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            listener = listener;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getUnmarshallerListener", listener);
        }
        return listener;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setUnmarshallerListener(Unmarshaller.Listener unmarshallerListener) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "setUnmarshallerListener", new Object[]{unmarshallerListener});
        }
        this.unmarshallerListener = unmarshallerListener;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "setUnmarshallerListener");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Marshaller.Listener getMarshallerListener() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getMarshallerListener", new Object[0]);
        }
        Marshaller.Listener listener = this.marshallerListener;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            listener = listener;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getMarshallerListener", listener);
        }
        return listener;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setMarshallerListener(Marshaller.Listener marshallerListener) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "setMarshallerListener", new Object[]{marshallerListener});
        }
        this.marshallerListener = marshallerListener;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "setMarshallerListener");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ValidationEventHandler getValidationEventHandler() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getValidationEventHandler", new Object[0]);
        }
        ValidationEventHandler validationEventHandler = this.validationEventHandler;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            validationEventHandler = validationEventHandler;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getValidationEventHandler", validationEventHandler);
        }
        return validationEventHandler;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setValidationEventHandler(ValidationEventHandler validationEventHandler) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "setValidationEventHandler", new Object[]{validationEventHandler});
        }
        this.validationEventHandler = validationEventHandler;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "setValidationEventHandler");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isUnwrapJAXBElement() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "isUnwrapJAXBElement", new Object[0]);
        }
        boolean bl = this.unwrapJAXBElement;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "isUnwrapJAXBElement", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setUnwrapJAXBElement(boolean unwrapJAXBElement) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "setUnwrapJAXBElement", new Object[]{unwrapJAXBElement});
        }
        this.unwrapJAXBElement = unwrapJAXBElement;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "setUnwrapJAXBElement");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WrapperHelper createWrapperHelper(Class<?> wrapperType, QName wrapperName, List<String> partNames, List<String> elTypeNames, List<Class<?>> partClasses) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "createWrapperHelper", new Object[]{wrapperType, wrapperName, partNames, elTypeNames, partClasses});
        }
        ArrayList<Method> getMethods = new ArrayList<Method>(partNames.size());
        ArrayList<Method> setMethods = new ArrayList<Method>(partNames.size());
        ArrayList<Method> jaxbMethods = new ArrayList<Method>(partNames.size());
        ArrayList<Field> fields = new ArrayList<Field>(partNames.size());
        Method[] allMethods = wrapperType.getMethods();
        String packageName = PackageUtils.getPackageName(wrapperType);
        if (wrapperType.getPackage() != null) {
            packageName = wrapperType.getPackage().getName();
        }
        String objectFactoryClassName = packageName + ".ObjectFactory";
        Object objectFactory = null;
        try {
            objectFactory = wrapperType.getClassLoader().loadClass(objectFactoryClassName).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Method[] allOFMethods = objectFactory != null ? objectFactory.getClass().getMethods() : new Method[]{};
        for (int x = 0; x < partNames.size(); ++x) {
            String partName = partNames.get(x);
            if (partName == null) {
                getMethods.add(null);
                setMethods.add(null);
                fields.add(null);
                jaxbMethods.add(null);
                continue;
            }
            String elementType = elTypeNames.get(x);
            String getAccessor = JAXBUtils.nameToIdentifier((String)partName, (JAXBUtils.IdentifierType)JAXBUtils.IdentifierType.GETTER);
            String setAccessor = JAXBUtils.nameToIdentifier((String)partName, (JAXBUtils.IdentifierType)JAXBUtils.IdentifierType.SETTER);
            Method getMethod = null;
            Method setMethod = null;
            Class<?> valueClass = wrapperType;
            try {
                getMethod = valueClass.getMethod(getAccessor, AbstractWrapperHelper.NO_CLASSES);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            Field elField = JAXBDataBinding.getElField(partName, valueClass);
            if (getMethod == null && elementType != null && "boolean".equalsIgnoreCase(elementType) && (elField == null || !Collection.class.isAssignableFrom(elField.getType()) && !elField.getType().isArray())) {
                try {
                    String newAcc = getAccessor.replaceFirst("get", "is");
                    getMethod = wrapperType.getMethod(newAcc, AbstractWrapperHelper.NO_CLASSES);
                }
                catch (NoSuchMethodException newAcc) {
                    // empty catch block
                }
            }
            if (getMethod == null && "return".equals(partName)) {
                try {
                    getMethod = valueClass.getMethod("get_return", AbstractWrapperHelper.NO_CLASSES);
                }
                catch (NoSuchMethodException ex) {
                    try {
                        getMethod = valueClass.getMethod("is_return", new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            if (getMethod == null && elField != null) {
                getAccessor = JAXBUtils.nameToIdentifier((String)elField.getName(), (JAXBUtils.IdentifierType)JAXBUtils.IdentifierType.GETTER);
                setAccessor = JAXBUtils.nameToIdentifier((String)elField.getName(), (JAXBUtils.IdentifierType)JAXBUtils.IdentifierType.SETTER);
                try {
                    getMethod = valueClass.getMethod(getAccessor, AbstractWrapperHelper.NO_CLASSES);
                }
                catch (NoSuchMethodException ex) {
                    // empty catch block
                }
            }
            String setAccessor2 = setAccessor;
            if ("return".equals(partName)) {
                setAccessor2 = "set_return";
            }
            for (Method method : allMethods) {
                if (method.getParameterTypes() == null || method.getParameterTypes().length != 1 || !setAccessor.equals(method.getName()) && !setAccessor2.equals(method.getName())) continue;
                setMethod = method;
                break;
            }
            getMethods.add(getMethod);
            setMethods.add(setMethod);
            if (setMethod != null && JAXBElement.class.isAssignableFrom(setMethod.getParameterTypes()[0])) {
                Type t = setMethod.getGenericParameterTypes()[0];
                Class pcls = null;
                if (t instanceof ParameterizedType) {
                    t = ((ParameterizedType)t).getActualTypeArguments()[0];
                }
                if (t instanceof Class) {
                    pcls = (Class)t;
                }
                String methodName = "create" + wrapperType.getSimpleName() + setMethod.getName().substring(3);
                for (Method m : allOFMethods) {
                    if (!m.getName().equals(methodName) || m.getParameterTypes().length != 1 || pcls != null && !pcls.equals(m.getParameterTypes()[0])) continue;
                    jaxbMethods.add(m);
                }
            } else {
                jaxbMethods.add(null);
            }
            if (elField != null) {
                XmlElement el = elField.getAnnotation(XmlElement.class);
                if (el != null && (partName.equals(el.name()) || "##default".equals(el.name()))) {
                    ReflectionUtil.setAccessible((AccessibleObject)elField);
                    fields.add(elField);
                    continue;
                }
                if (getMethod == null && setMethod == null) {
                    if (el != null) {
                        LOG.warning("Could not create accessor for property " + partName + " of type " + wrapperType.getName() + " as the @XmlElement defines the name as " + el.name());
                    } else {
                        LOG.warning("Could not create accessor for property " + partName + " of type " + wrapperType.getName());
                    }
                }
                fields.add(null);
                continue;
            }
            fields.add(null);
        }
        WrapperHelper wrapperHelper = JAXBDataBinding.createWrapperHelper(this.getBus(), wrapperType, setMethods.toArray(new Method[0]), getMethods.toArray(new Method[0]), jaxbMethods.toArray(new Method[0]), fields.toArray(new Field[0]), objectFactory);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            wrapperHelper = wrapperHelper;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "createWrapperHelper", wrapperHelper);
        }
        return wrapperHelper;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isInBuiltInSchemas(DOMResult schema) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "isInBuiltInSchemas", new Object[]{schema});
        }
        boolean bl = BUILT_IN_SCHEMAS.containsValue(schema);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "isInBuiltInSchemas", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Field getElField(String partName, Class<?> wrapperType) {
        Field[] fields;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getElField", new Object[]{partName, wrapperType});
        }
        String fieldName = JAXBUtils.nameToIdentifier((String)partName, (JAXBUtils.IdentifierType)JAXBUtils.IdentifierType.VARIABLE);
        for (Field field : fields = ReflectionUtil.getDeclaredFields(wrapperType)) {
            XmlElement el = field.getAnnotation(XmlElement.class);
            if (el != null && partName.equals(el.name())) {
                Field field2 = field;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    field2 = field2;
                    LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getElField", field2);
                }
                return field2;
            }
            XmlElementRef xmlElementRefAnnotation = field.getAnnotation(XmlElementRef.class);
            if (xmlElementRefAnnotation != null && partName.equals(xmlElementRefAnnotation.name())) {
                Field field3 = field;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    field3 = field3;
                    LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getElField", field3);
                }
                return field3;
            }
            if (!field.getName().equals(fieldName)) continue;
            Field field4 = field;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                field4 = field4;
                LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getElField", field4);
            }
            return field4;
        }
        Field field = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            field = field;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getElField", field);
        }
        return field;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static WrapperHelper createWrapperHelper(Bus bus, Class<?> wrapperType, Method[] setMethods, Method[] getMethods, Method[] jaxbMethods, Field[] fields, Object objectFactory) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "createWrapperHelper", new Object[]{bus, wrapperType, setMethods, getMethods, jaxbMethods, fields, objectFactory});
        }
        Object wh = JAXBDataBinding.compileWrapperHelper(bus, wrapperType, setMethods, getMethods, jaxbMethods, fields, objectFactory);
        if (wh == null) {
            wh = new JAXBWrapperHelper(wrapperType, setMethods, getMethods, jaxbMethods, fields, objectFactory);
        }
        WrapperHelper wrapperHelper = wh;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            wrapperHelper = wrapperHelper;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "createWrapperHelper", wrapperHelper);
        }
        return wrapperHelper;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static WrapperHelper compileWrapperHelper(Bus bus, Class<?> wrapperType, Method[] setMethods, Method[] getMethods, Method[] jaxbMethods, Field[] fields, Object objectFactory) {
        WrapperHelper wrapperHelper;
        block4: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "compileWrapperHelper", new Object[]{bus, wrapperType, setMethods, getMethods, jaxbMethods, fields, objectFactory});
            }
            try {
                WrapperHelperCreator creator = (WrapperHelperCreator)bus.getExtension(WrapperHelperCreator.class);
                wrapperHelper = creator.compile(wrapperType, setMethods, getMethods, jaxbMethods, fields, objectFactory);
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block4;
            }
            catch (Throwable t) {
                WrapperHelper wrapperHelper2 = null;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    wrapperHelper2 = wrapperHelper2;
                    LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "compileWrapperHelper", wrapperHelper2);
                }
                return wrapperHelper2;
            }
            wrapperHelper = wrapperHelper;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "compileWrapperHelper", wrapperHelper);
        }
        return wrapperHelper;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void releaseJAXBMarshaller(Marshaller marshaller, boolean noEscape) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "releaseJAXBMarshaller", new Object[]{marshaller, noEscape});
        }
        if (marshaller != null) {
            Deque<SoftReference<Marshaller>> marshallers = noEscape ? this.noEscapeMarshallers : this.escapeMarshallers;
            marshallers.offerFirst(new SoftReference<Marshaller>(marshaller));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "releaseJAXBMarshaller");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Marshaller getJAXBMarshaller(boolean noEscape, boolean setEventHandler, Bus bus, ValidationEventHandler veventHandler) throws JAXBException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getJAXBMarshaller", new Object[]{noEscape, setEventHandler, bus, veventHandler});
        }
        Marshaller m = null;
        Deque<SoftReference<Marshaller>> marshallers = noEscape ? this.noEscapeMarshallers : this.escapeMarshallers;
        SoftReference<Marshaller> ref = marshallers.poll();
        while (ref != null && (m = ref.get()) == null) {
            ref = marshallers.poll();
        }
        if (LOG.isLoggable(Level.FINE)) {
            if (m == null) {
                LOG.fine("Marshaller created [not in pool]");
            } else {
                LOG.fine("Marshaller obtained [from  pool]");
            }
        }
        if (m != null) {
            Class<?> handlerClass;
            ValidationEventHandler oldEventHandler = m.getEventHandler();
            Class<?> clazz = handlerClass = oldEventHandler == null ? null : oldEventHandler.getClass();
            if (!setEventHandler) {
                if (handlerClass != DefaultValidationEventHandler.class) {
                    m.setEventHandler(null);
                }
            } else {
                ValidationEventHandler h = veventHandler;
                if (veventHandler == null) {
                    h = new ValidationEventHandler(){
                        static final long serialVersionUID = -5250962864263138740L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        public boolean handleEvent(ValidationEvent event) {
                            return event.getSeverity() == 0;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxb.JAXBDataBinding$1", 1.class, null, null);
                        }
                    };
                }
                m.setEventHandler(h);
            }
        } else {
            m = this.context.createMarshaller();
            m.setProperty("jaxb.encoding", (Object)StandardCharsets.UTF_8.name());
            m.setProperty("jaxb.fragment", (Object)true);
            m.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
            m.setListener(this.marshallerListener);
            if (!noEscape) {
                if (this.escapeHandler != null) {
                    JAXBUtils.setEscapeHandler((Marshaller)m, (Object)this.escapeHandler);
                }
            } else if (this.noEscapeHandler != null) {
                JAXBUtils.setEscapeHandler((Marshaller)m, (Object)this.noEscapeHandler);
            }
            if (setEventHandler) {
                ValidationEventHandler h = veventHandler;
                if (veventHandler == null) {
                    h = new ValidationEventHandler(){
                        static final long serialVersionUID = 3965431848285089875L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        public boolean handleEvent(ValidationEvent event) {
                            return event.getSeverity() == 0;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxb.JAXBDataBinding$2", 2.class, null, null);
                        }
                    };
                }
                m.setEventHandler(h);
            }
            Map nspref = this.getDeclaredNamespaceMappings();
            Map nsctxt = this.getContextualNamespaceMap();
            if (nspref != null || nsctxt != null) {
                Object mapper = JAXBUtils.setNamespaceMapper((Bus)bus, (Map)(nspref != null ? nspref : nsctxt), (Marshaller)m);
                if (nsctxt != null) {
                    DataWriterImpl.setContextualNamespaceDecls(mapper, nsctxt);
                }
            }
            if (this.marshallerProperties != null) {
                for (Map.Entry<String, Object> propEntry : this.marshallerProperties.entrySet()) {
                    try {
                        m.setProperty(propEntry.getKey(), propEntry.getValue());
                    }
                    catch (PropertyException pe) {
                        LOG.log(Level.INFO, "PropertyException setting Marshaller properties", pe);
                    }
                }
            }
        }
        Marshaller marshaller = m;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            marshaller = marshaller;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getJAXBMarshaller", marshaller);
        }
        return marshaller;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Unmarshaller getJAXBUnmarshaller(boolean setEventHandler, ValidationEventHandler veventHandler) throws JAXBException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getJAXBUnmarshaller", new Object[]{setEventHandler, veventHandler});
        }
        Unmarshaller unm = null;
        SoftReference<Unmarshaller> ref = this.unmarshallers.poll();
        while (ref != null && (unm = ref.get()) == null) {
            ref = this.unmarshallers.poll();
        }
        if (LOG.isLoggable(Level.FINE)) {
            if (unm == null) {
                LOG.fine("Unmarshaller created [not in pool]");
            } else {
                LOG.fine("Unmarshaller obtained [from  pool]");
            }
        }
        if (unm != null) {
            Class<?> handlerClass;
            ValidationEventHandler oldEventHandler = unm.getEventHandler();
            Class<?> clazz = handlerClass = oldEventHandler == null ? null : oldEventHandler.getClass();
            if (!setEventHandler) {
                if (handlerClass != DefaultValidationEventHandler.class) {
                    // empty if block
                }
            } else {
                unm.setEventHandler(veventHandler);
            }
        } else {
            unm = this.context.createUnmarshaller();
            if (this.unmarshallerListener != null) {
                unm.setListener(this.unmarshallerListener);
            }
            if (setEventHandler) {
                unm.setEventHandler(veventHandler);
            }
            if (this.unmarshallerProperties != null) {
                for (Map.Entry<String, Object> propEntry : this.unmarshallerProperties.entrySet()) {
                    try {
                        unm.setProperty(propEntry.getKey(), propEntry.getValue());
                    }
                    catch (PropertyException pe) {
                        LOG.log(Level.INFO, "PropertyException setting Marshaller properties", pe);
                    }
                }
            }
        }
        Unmarshaller unmarshaller = unm;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            unmarshaller = unmarshaller;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getJAXBUnmarshaller", unmarshaller);
        }
        return unmarshaller;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void releaseJAXBUnmarshaller(Unmarshaller unmarshaller) {
        block8: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "releaseJAXBUnmarshaller", new Object[]{unmarshaller});
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Unmarshaller placed back into pool");
            }
            if (unmarshaller != null) {
                try {
                    if (!this.unmarshallers.offerFirst(new SoftReference<Unmarshaller>(unmarshaller))) {
                        JAXBUtils.closeUnmarshaller((Unmarshaller)unmarshaller);
                    }
                    break block8;
                }
                catch (Throwable t) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("The following exception is ignored. Processing continues " + t);
                    }
                    break block8;
                }
            }
            JAXBUtils.closeUnmarshaller((Unmarshaller)unmarshaller);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "releaseJAXBUnmarshaller");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static {
        try (URIResolver resolver = new URIResolver();){
            DelayedDOMResult dr2;
            try {
                resolver.resolve("", "classpath:/schemas/wsdl/ws-addr-wsdl.xsd", JAXBDataBinding.class);
                if (resolver.isResolved()) {
                    resolver.getInputStream().close();
                    dr2 = new DelayedDOMResult(resolver.getURL(), "classpath:/schemas/wsdl/ws-addr-wsdl.xsd", "http://www.w3.org/2005/02/addressing/wsdl");
                    BUILT_IN_SCHEMAS.put("http://www.w3.org/2005/02/addressing/wsdl", dr2);
                    resolver.unresolve();
                }
            }
            catch (Exception dr2) {
                // empty catch block
            }
            try {
                resolver.resolve("", "classpath:/schemas/wsdl/ws-addr.xsd", JAXBDataBinding.class);
                if (resolver.isResolved()) {
                    resolver.getInputStream().close();
                    dr2 = new DelayedDOMResult(resolver.getURL(), "classpath:/schemas/wsdl/ws-addr.xsd", "http://www.w3.org/2005/08/addressing");
                    BUILT_IN_SCHEMAS.put("http://www.w3.org/2005/08/addressing", dr2);
                    resolver.unresolve();
                }
            }
            catch (Exception dr3) {
                // empty catch block
            }
            try {
                resolver.resolve("", "classpath:/schemas/wsdl/wsrm.xsd", JAXBDataBinding.class);
                if (resolver.isResolved()) {
                    resolver.getInputStream().close();
                    dr2 = new DelayedDOMResult(resolver.getURL(), "classpath:/schemas/wsdl/wsrm.xsd", "http://schemas.xmlsoap.org/ws/2005/02/rm");
                    BUILT_IN_SCHEMAS.put("http://schemas.xmlsoap.org/ws/2005/02/rm", dr2);
                    resolver.unresolve();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static class DelayedDOMResult
    extends DOMResult {
        private final URL resource;
        private final String publicId;
        static final long serialVersionUID = 3686929494492652374L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        DelayedDOMResult(URL url, String sysId, String pId) {
            super(null, sysId);
            this.resource = url;
            this.publicId = pId;
        }

        @Override
        public synchronized Node getNode() {
            Node nd = super.getNode();
            if (nd == null) {
                try {
                    InputSource src = new InputSource(this.resource.openStream());
                    src.setSystemId(this.getSystemId());
                    src.setPublicId(this.publicId);
                    Document doc = StaxUtils.read((InputSource)src);
                    this.setNode(doc);
                    nd = super.getNode();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            return nd;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxb.JAXBDataBinding$DelayedDOMResult", DelayedDOMResult.class, null, null);
        }
    }
}

