/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authorization.jacc.ejb.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authorization.jacc.MethodInfo;
import com.ibm.ws.security.authorization.jacc.RoleInfo;
import com.ibm.ws.security.authorization.jacc.common.PolicyConfigurationManager;
import com.ibm.ws.security.authorization.jacc.ejb.EJBSecurityPropagator;
import com.ibm.ws.security.authorization.jacc.ejb.impl.ModuleRoleInfo;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class EJBSecurityPropagatorImpl
implements EJBSecurityPropagator {
    private static String STARSTAR = "**";
    private static final TraceComponent tc = Tr.register(EJBSecurityPropagatorImpl.class, (String)"Security.Authorization", (String)"com.ibm.ws.security.authorization.jacc.ejb.resources.JaccEjbAuthorizationMessages");
    private static Map<String, Set<ModuleRoleInfo>> moduleRoleInfoMap = new ConcurrentHashMap<String, Set<ModuleRoleInfo>>();
    static final long serialVersionUID = 5022123086130818540L;

    public void propagateEJBRoles(String contextId, String appName, String beanName, Map<String, String> roleLinkMap, Map<RoleInfo, List<MethodInfo>> methodMap) {
        Set<ModuleRoleInfo> mris = moduleRoleInfoMap.get(contextId);
        if (mris == null) {
            mris = Collections.newSetFromMap(new ConcurrentHashMap());
            moduleRoleInfoMap.put(contextId, mris);
        }
        mris.add(new ModuleRoleInfo(appName, beanName, roleLinkMap, methodMap));
        PolicyConfigurationManager.addEJB((String)appName, (String)contextId);
    }

    /*
     * WARNING - void declaration
     */
    public void processEJBRoles(PolicyConfigurationFactory pcf, String contextId) {
        Set<ModuleRoleInfo> mris = moduleRoleInfoMap.get(contextId);
        if (mris == null) {
            return;
        }
        Set<String> allRoles = this.getAllRoles(mris);
        PolicyConfiguration ejbPC = null;
        String appName = mris.iterator().next().appName;
        boolean exist = PolicyConfigurationManager.containModule((String)appName, (String)contextId);
        try {
            ejbPC = pcf.getPolicyConfiguration(contextId, !exist);
        }
        catch (PolicyContextException policyContextException) {
            void pce;
            FFDCFilter.processException((Throwable)policyContextException, (String)"com.ibm.ws.security.authorization.jacc.ejb.impl.EJBSecurityPropagatorImpl", (String)"74", (Object)this, (Object[])new Object[]{pcf, contextId});
            Tr.error((TraceComponent)tc, (String)"JACC_EJB_GET_POLICYCONFIGURATION_FAILURE", (Object[])new Object[]{contextId, pce});
            return;
        }
        try {
            for (ModuleRoleInfo mri : mris) {
                this.processRoleRefs(ejbPC, mri.beanName, mri.roleLinkMap, allRoles);
                this.processMethodPermissions(ejbPC, mri.beanName, mri.methodMap, allRoles);
            }
            PolicyConfigurationManager.linkConfiguration((String)appName, (PolicyConfiguration)ejbPC);
            moduleRoleInfoMap.remove(contextId);
        }
        catch (PolicyContextException pce) {
            void e;
            FFDCFilter.processException((Throwable)pce, (String)"com.ibm.ws.security.authorization.jacc.ejb.impl.EJBSecurityPropagatorImpl", (String)"87", (Object)this, (Object[])new Object[]{pcf, contextId});
            Tr.error((TraceComponent)tc, (String)"JACC_EJB_PERMISSION_PROPAGATION_FAILURE", (Object[])new Object[]{contextId, e});
        }
    }

    private Set<String> getAllRoles(Set<ModuleRoleInfo> mris) {
        HashSet<String> allRoles = new HashSet<String>();
        for (ModuleRoleInfo mri : mris) {
            if (mri.methodMap == null || mri.methodMap.size() <= 0) continue;
            for (RoleInfo ri : mri.methodMap.keySet()) {
                String roleName = ri.getRoleName();
                if (roleName == null) continue;
                allRoles.add(roleName);
            }
        }
        if (allRoles.isEmpty()) {
            allRoles = null;
        }
        return allRoles;
    }

    private void processMethodPermissions(PolicyConfiguration ejbPC, String beanName, Map<RoleInfo, List<MethodInfo>> methodMap, Set<String> allRoles) throws PolicyContextException {
        if (methodMap != null && methodMap.size() > 0) {
            Permissions ejbRolePerms = null;
            Permissions ejbUncheckedPerms = null;
            Permissions ejbExcludedPerms = null;
            for (Map.Entry<RoleInfo, List<MethodInfo>> entry : methodMap.entrySet()) {
                RoleInfo ri = entry.getKey();
                List<MethodInfo> miList = entry.getValue();
                if (ri.isPermitAll()) {
                    ejbUncheckedPerms = this.getEJBPermCollection(beanName, miList);
                    if (ejbUncheckedPerms == null) continue;
                    ejbPC.addToUncheckedPolicy((PermissionCollection)ejbUncheckedPerms);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("addToUncheckedPolicy permission : " + ejbUncheckedPerms), (Object[])new Object[0]);
                    continue;
                }
                if (ri.isDenyAll()) {
                    ejbExcludedPerms = this.getEJBPermCollection(beanName, miList);
                    if (ejbExcludedPerms == null) continue;
                    ejbPC.addToExcludedPolicy((PermissionCollection)ejbExcludedPerms);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("addToExcludedPolicy permission : " + ejbExcludedPerms), (Object[])new Object[0]);
                    continue;
                }
                ejbRolePerms = this.getEJBPermCollection(beanName, miList);
                if (ejbRolePerms == null) continue;
                String roleName = ri.getRoleName();
                ejbPC.addToRole(roleName, (PermissionCollection)ejbRolePerms);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("addToRole(MethodPermisson) role : " + roleName + " permission : " + ejbRolePerms), (Object[])new Object[0]);
            }
        }
    }

    private Permissions getEJBPermCollection(String beanName, List<MethodInfo> miList) {
        Permissions permCollection = new Permissions();
        if (miList != null && miList.size() > 0) {
            for (MethodInfo mi : miList) {
                String methodName = mi.getMethodName();
                String methodInfName = mi.getMethodInterfaceName();
                if (methodName.equals("*")) {
                    methodName = null;
                }
                if (methodInfName != null && methodInfName.equals("Unspecified")) {
                    methodInfName = null;
                }
                String[] paramArray = null;
                List paramList = mi.getParamList();
                if (paramList != null) {
                    paramArray = paramList.toArray(new String[paramList.size()]);
                }
                if (tc.isDebugEnabled()) {
                    StringBuffer buf = new StringBuffer("addingEJBPermCollection: ejbName = ");
                    buf.append(beanName).append(", methodName = ").append(methodName).append(", methodInfName = ").append(methodInfName);
                    if (paramArray != null) {
                        buf.append(" # of params : " + paramArray.length);
                        for (String p : paramArray) {
                            buf.append(" param : " + p);
                        }
                    }
                    Tr.debug((TraceComponent)tc, (String)buf.toString(), (Object[])new Object[0]);
                }
                EJBMethodPermission ejbMethodPerm = new EJBMethodPermission(beanName, methodName, methodInfName, paramArray);
                permCollection.add((Permission)ejbMethodPerm);
            }
        } else {
            permCollection = null;
        }
        return permCollection;
    }

    private void processRoleRefs(PolicyConfiguration ejbPC, String beanName, Map<String, String> roleLinkMap, Set<String> allRoles) throws PolicyContextException {
        if (roleLinkMap != null) {
            for (Map.Entry<String, String> entry : roleLinkMap.entrySet()) {
                String refName = entry.getKey();
                String refLink = entry.getValue();
                EJBRoleRefPermission ejbRolePerm = new EJBRoleRefPermission(beanName, refName);
                ejbPC.addToRole(refLink, (Permission)ejbRolePerm);
                EJBRoleRefPermission ejbRolePermLink = new EJBRoleRefPermission(beanName, refLink);
                ejbPC.addToRole(refLink, (Permission)ejbRolePermLink);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("addToRole(RefName) role : " + refLink + " permission : " + ejbRolePerm), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("addToRole(RefLink) role : " + refLink + " permission : " + ejbRolePermLink), (Object[])new Object[0]);
            }
        }
        if (allRoles == null || !allRoles.contains(STARSTAR)) {
            EJBRoleRefPermission ejbRolePerm = new EJBRoleRefPermission(beanName, STARSTAR);
            ejbPC.addToRole(STARSTAR, (Permission)ejbRolePerm);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("addToRole(DeclaredRefLink) role : ** permission : " + ejbRolePerm), (Object[])new Object[0]);
            }
        }
        if (allRoles != null) {
            for (String roleName : allRoles) {
                if (roleLinkMap != null && roleLinkMap.containsValue(roleName)) continue;
                EJBRoleRefPermission ejbRolePerm = new EJBRoleRefPermission(beanName, roleName);
                ejbPC.addToRole(roleName, (Permission)ejbRolePerm);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("addToRole(DeclaredRefLink) role : " + roleName + " permission : " + ejbRolePerm), (Object[])new Object[0]);
            }
        }
    }
}

