/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.plugin.merge.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.http.plugin.merge.PluginMergeTool;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@TraceObjectField(fieldName="traceComponent", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={PluginMergeTool.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class PluginMergeToolImpl
implements PluginMergeTool {
    private static final TraceComponent traceComponent = Tr.register(PluginMergeToolImpl.class, (String)"Cluster", (String)"com.ibm.ws.http.plugin.merge.internal.resources.Messages");
    private static final String NO_MERGE_ERR = "Error encountered, no merged file was written";
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("uuuu.MM.dd 'at' HH:mm:ss z");
    private static boolean isXdOnly = true;
    private static boolean debug = false;
    private static int seqNum = 0;
    private static final boolean failOver = true;
    private static boolean precedence = false;
    private static Element mergeConfigNode;
    private static Element mergeConfigNode2;
    private static PluginInfo[] plugins;
    private static ArrayList<PluginInfo> sharedPlugins;
    private static HashSet<String> emptyServerClusters;
    private static String encoding;
    private String tc = null;
    private boolean sortVhostGrp = false;
    public ArrayList<String> G_primaryServers = new ArrayList();
    public ArrayList<String> G_backupServers = new ArrayList();
    private boolean setMatchUriAppVhost = false;
    private static boolean matchUriAppVhost;
    private static final Comparator<FileInfo> FILEINFO_SMALL_TO_LARGE_COMPARATOR;
    private static final Comparator<FileInfo> FILEINFO_LARGE_TO_SMALL_COMPARATOR;
    static final long serialVersionUID = 73310421998814181L;

    @Activate
    protected void activate(ComponentContext cc) {
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
    }

    private void info(String content) {
        if (!traceComponent.isAnyTracingEnabled()) {
            System.out.println(content);
        } else {
            Tr.info((TraceComponent)traceComponent, (String)content, (Object[])new Object[0]);
        }
    }

    private void debug(String content) {
        if (debug) {
            this.info(content);
        } else {
            Tr.debug((TraceComponent)traceComponent, (String)content, (Object[])new Object[0]);
        }
    }

    private boolean removeComments(DocumentBuilder parser, Document doc) {
        try {
            DOMImplementation impl = parser.getDOMImplementation();
            if (!impl.hasFeature("traversal", "2.0")) {
                return false;
            }
            Element root = doc.getDocumentElement();
            DocumentTraversal traversable = (DocumentTraversal)((Object)doc);
            NodeIterator iterator = traversable.createNodeIterator(root, 128, null, true);
            Node node = null;
            while ((node = iterator.nextNode()) != null) {
                if (node.getNodeValue().trim().compareTo("Properties") == 0) continue;
                root.removeChild(node);
            }
        }
        catch (FactoryConfigurationError impl) {
            FFDCFilter.processException((Throwable)impl, (String)"com.ibm.ws.http.plugin.merge.internal.PluginMergeToolImpl", (String)"157", (Object)this, (Object[])new Object[]{parser, doc});
            return false;
        }
        return true;
    }

    public static void trimWhitespace(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 3) {
                child.setTextContent(child.getTextContent().trim());
            }
            PluginMergeToolImpl.trimWhitespace(child);
        }
    }

    private void printMergedCopy(String output) throws IOException, ParserConfigurationException, TransformerConfigurationException, TransformerException {
        int i;
        int i2;
        int i3;
        int i4;
        this.tc = "printMergedCopy - ";
        this.debug(this.tc + "Output File: " + output);
        this.cleanPlugins();
        FileOutputStream fos = new FileOutputStream(output);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = dbf.newDocumentBuilder();
        Document mergeDoc = parser.newDocument();
        Comment comment = mergeDoc.createComment(" This config file was generated by pluginUtility merge v1.0.73 on " + dateTimeFormatter.format(ZonedDateTime.now()) + " ");
        mergeDoc.appendChild(comment);
        mergeDoc.appendChild(mergeDoc.importNode(mergeConfigNode, true));
        mergeConfigNode = mergeDoc.getDocumentElement();
        this.removeComments(parser, mergeDoc);
        mergeConfigNode.appendChild(mergeDoc.importNode(mergeDoc.createComment(" Server Clusters "), true));
        Node[] sc = null;
        sharedPlugins.trimToSize();
        Iterator<PluginInfo> itrSharedPlugins = sharedPlugins.iterator();
        while (itrSharedPlugins.hasNext()) {
            sc = itrSharedPlugins.next().getFailOverServerClusters();
            for (i4 = 0; i4 < sc.length; ++i4) {
                mergeConfigNode.appendChild(mergeDoc.importNode(sc[i4], true));
            }
        }
        for (i4 = 0; i4 < plugins.length; ++i4) {
            if (plugins[i4].getUniquePluginRep().isEmpty()) continue;
            sc = plugins[i4].getUnsharedServerClusters();
            for (int j = 0; j < sc.length; ++j) {
                mergeConfigNode.appendChild(mergeDoc.importNode(sc[j], true));
            }
        }
        mergeConfigNode.appendChild(mergeDoc.createComment(" Virtual Host Groups "));
        Node[] vhgs = null;
        itrSharedPlugins = sharedPlugins.iterator();
        while (itrSharedPlugins.hasNext()) {
            vhgs = itrSharedPlugins.next().getSharedVHostGrps();
            for (i3 = 0; i3 < vhgs.length; ++i3) {
                mergeConfigNode.appendChild(mergeDoc.importNode(vhgs[i3], true));
            }
        }
        vhgs = null;
        for (i3 = 0; i3 < plugins.length; ++i3) {
            vhgs = plugins[i3].getUnsharedVHostGrp();
            for (int j = 0; j < vhgs.length; ++j) {
                mergeConfigNode.appendChild(mergeDoc.importNode(vhgs[j], true));
            }
        }
        mergeConfigNode.appendChild(mergeDoc.createComment(" URI Groups "));
        Node[] uriGrps = null;
        itrSharedPlugins = sharedPlugins.iterator();
        while (itrSharedPlugins.hasNext()) {
            uriGrps = itrSharedPlugins.next().getUriGrps();
            for (i2 = 0; i2 < uriGrps.length; ++i2) {
                mergeConfigNode.appendChild(mergeDoc.importNode(uriGrps[i2], true));
            }
        }
        for (i2 = 0; i2 < plugins.length; ++i2) {
            int j;
            uriGrps = plugins[i2].getUriGrps();
            for (j = 0; j < uriGrps.length; ++j) {
                mergeConfigNode.appendChild(mergeDoc.importNode(uriGrps[j], true));
            }
            uriGrps = plugins[i2].getUniqueUriGrps();
            for (j = 0; j < uriGrps.length; ++j) {
                mergeConfigNode.appendChild(mergeDoc.importNode(uriGrps[j], true));
            }
        }
        mergeConfigNode.appendChild(mergeDoc.createComment(" Routes "));
        Node[] routes = null;
        itrSharedPlugins = sharedPlugins.iterator();
        while (itrSharedPlugins.hasNext()) {
            routes = itrSharedPlugins.next().getRoutes();
            for (i = 0; i < routes.length; ++i) {
                mergeConfigNode.appendChild(mergeDoc.importNode(routes[i], true));
            }
        }
        for (i = 0; i < plugins.length; ++i) {
            routes = plugins[i].getRoutes();
            for (int j = 0; j < routes.length; ++j) {
                mergeConfigNode.appendChild(mergeDoc.importNode(routes[j], true));
            }
        }
        PluginMergeToolImpl.trimWhitespace(mergeConfigNode);
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = transfac.newTransformer();
        trans.setOutputProperty("indent", "yes");
        trans.setOutputProperty("method", "xml");
        trans.setOutputProperty("encoding", encoding);
        trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        StreamResult result = new StreamResult(fos);
        DOMSource source = new DOMSource(mergeDoc);
        trans.transform(source, result);
        fos.flush();
        fos.close();
        Tr.info((TraceComponent)traceComponent, (String)("Merged plugin config file written to " + output), (Object[])new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    private void cleanPlugins() {
        sharedPlugins.trimToSize();
        Iterator<PluginInfo> itrSharedPlugins = sharedPlugins.iterator();
        try {
            while (itrSharedPlugins.hasNext()) {
                itrSharedPlugins.next().cleanPlugin();
            }
            for (int i = 0; i < plugins.length; ++i) {
                PluginMergeToolImpl.plugins[i].cleanPlugin();
            }
        }
        catch (ParserConfigurationException i) {
            void e;
            FFDCFilter.processException((Throwable)i, (String)"com.ibm.ws.http.plugin.merge.internal.PluginMergeToolImpl", (String)"305", (Object)this, (Object[])new Object[0]);
            Tr.info((TraceComponent)traceComponent, (String)NO_MERGE_ERR, (Object[])new Object[0]);
            throw new RuntimeException((Throwable)e);
        }
    }

    private boolean lfMerge() throws ParserConfigurationException {
        this.tc = "lfMerge - ";
        this.debug(this.tc + "Merging plugins.");
        Iterator<PluginInfo> itrShared = null;
        Hashtable<String, AppInfo> p2 = null;
        AppInfo p2AppInfo = null;
        Enumeration<String> p1Uids = null;
        String uid = null;
        this.debug(this.tc + "Looping through all input files");
        for (int i = 1; i < plugins.length; ++i) {
            Hashtable<String, AppInfo> p1;
            p2 = plugins[i].getUniquePluginRep();
            sharedPlugins.trimToSize();
            PluginInfo sharedPlugin2 = null;
            for (PluginInfo sharedPlugin2 : sharedPlugins) {
                p1 = sharedPlugin2.getUniquePluginRep();
                p1Uids = p1.keys();
                int matched = 0;
                while (p1Uids.hasMoreElements()) {
                    uid = p1Uids.nextElement();
                    this.debug(this.tc + "UID: " + uid);
                    if (!p2.containsKey(uid)) continue;
                    ++matched;
                    this.debug(this.tc + "Adding UID to shared: " + uid);
                    p2AppInfo = p2.get(uid);
                    sharedPlugin2.addSharedServers(PluginMergeToolImpl.plugins[i].getSeqNum(), p2AppInfo.getServerCluster(), p1.get(uid), true);
                    p2.remove(uid);
                }
                if (matched == 0 || p1.size() == matched) continue;
                this.debug(this.tc + "Encountered an improperly scoped subset.");
                return false;
            }
            PluginInfo newSharedPlugin = null;
            for (int j = 0; j < i; ++j) {
                p1 = plugins[j].getUniquePluginRep();
                p1Uids = p1.keys();
                while (p1Uids.hasMoreElements()) {
                    uid = p1Uids.nextElement();
                    if (!p2.containsKey(uid)) continue;
                    AppInfo p1AppInfo = p1.get(uid);
                    p2AppInfo = p2.get(uid);
                    if (newSharedPlugin == null) {
                        newSharedPlugin = new PluginInfo(seqNum, p1AppInfo.getServerCluster());
                        ++seqNum;
                    }
                    newSharedPlugin.addMatch(uid, p1AppInfo.getAppName(), p1AppInfo.getServerCluster(), PluginMergeToolImpl.plugins[j].getSeqNum(), p2AppInfo.getServerCluster(), PluginMergeToolImpl.plugins[i].getSeqNum(), p1AppInfo.getUri(), p1AppInfo.getVh());
                    p1.remove(uid);
                    p2.remove(uid);
                }
                this.setReasonForUniqueness(plugins[j], p2);
                this.setReasonForUniqueness(plugins[i], p1);
                this.tc = "lfMerge - ";
            }
            if (newSharedPlugin != null) {
                sharedPlugins.add(newSharedPlugin);
            }
            this.debug(" ");
        }
        return true;
    }

    private void pMerge() {
        for (int i = 1; i < plugins.length; ++i) {
            for (int j = 0; j < i; ++j) {
                Hashtable<String, AppInfo> p1 = plugins[j].getUniquePluginRep();
                Hashtable<String, AppInfo> p2 = plugins[i].getUniquePluginRep();
                Enumeration<String> p1Uids = p1.keys();
                while (p1Uids.hasMoreElements()) {
                    String uid = p1Uids.nextElement();
                    if (!p2.containsKey(uid)) continue;
                    p2.remove(uid);
                }
                this.setReasonForUniqueness(plugins[j], p2);
                this.setReasonForUniqueness(plugins[i], p1);
            }
        }
    }

    private void setReasonForUniqueness(PluginInfo pgi1, Hashtable<String, AppInfo> p2) {
        this.tc = "setReasonForUniqueness - ";
        this.debug(this.tc + "Checking Uniqueness.");
        AppInfo info = null;
        Enumeration<AppInfo> enumP2 = p2.elements();
        while (enumP2.hasMoreElements()) {
            info = enumP2.nextElement();
            String uriName = info.getUri().getAttribute("Name");
            if (!pgi1.containedUris.contains(uriName)) {
                info.uniqueVhgNeeded = true;
                continue;
            }
            if (matchUriAppVhost && !pgi1.containedApps.contains(info.getAppName())) {
                info.uniqueVhgNeeded = true;
                continue;
            }
            info.uniqueVhgNeeded = false;
        }
    }

    public static void nodeListRemoveAll(Element xEml, NodeList nodes) {
        int cnt = nodes.getLength();
        for (int i = 0; i < cnt; ++i) {
            xEml.removeChild(nodes.item(0));
        }
    }

    public static ArrayList<Node> nodeListToDeadArray(NodeList nodes) {
        ArrayList<Node> rtnNodes = null;
        if (nodes != null) {
            rtnNodes = new ArrayList<Node>();
            for (int i = 0; i < nodes.getLength(); ++i) {
                rtnNodes.add(nodes.item(i).cloneNode(true));
            }
            rtnNodes.trimToSize();
        }
        return rtnNodes;
    }

    private List<String> loadParms(String[] args) {
        ArrayList<String> inputFilesList = new ArrayList<String>();
        this.tc = "loadParms - ";
        matchUriAppVhost = Boolean.getBoolean("com.ibm.ws.pluginmerge.match.appname");
        debug = Boolean.getBoolean("com.ibm.ws.pluginmerge.debug");
        for (int j = 0; j < args.length; ++j) {
            if (!args[j].equals("-debug")) continue;
            debug = true;
        }
        this.debug(this.tc + "Loading parameters");
        for (int i = 0; i < args.length; ++i) {
            this.debug(this.tc + " ");
            String parm = args[i];
            if (!parm.startsWith("-")) {
                inputFilesList.add(args[i]);
                continue;
            }
            if (parm.equals("-sortVhostGrp")) {
                this.debug(this.tc + "sortVhostGrp requested");
                this.sortVhostGrp = true;
            }
            if (parm.equals("-setMatchUriAppVhost")) {
                this.setMatchUriAppVhost = true;
                this.debug(this.tc + "setMatchUriAppVhost requested");
            }
            if (parm.equals("-debug")) {
                this.debug(this.tc + "debug requested");
            }
            if (parm.equals("-debug") || parm.equals("-sortVhostGrp") || parm.equals("-setMatchUriAppVhost")) continue;
            this.info("Parameter: " + parm + " is not valid.  It will be ignored");
        }
        return inputFilesList;
    }

    private void loadData(String[] files) throws SAXException, IOException, ParserConfigurationException {
        this.tc = "loadData - ";
        Object fileName = null;
        this.debug(this.tc + "Loading files");
        for (int i = 0; i < files.length; ++i) {
            this.debug(this.tc + "Processing file:  " + files[i]);
            File f = new File(files[i]);
            Tr.info((TraceComponent)traceComponent, (String)("Found file " + files[i] + ": " + f.exists()), (Object[])new Object[0]);
            FileInputStream fis = new FileInputStream(f);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(new InputSource(fis));
            PluginMergeToolImpl.plugins[i] = new PluginInfo(i, dom.getDocumentElement(), files[i]);
            ++seqNum;
            encoding = dom.getXmlEncoding();
            mergeConfigNode2 = (Element)dom.getDocumentElement().cloneNode(true);
            NodeList nl = mergeConfigNode2.getElementsByTagName("IntelligentManagement");
            if (nl.getLength() != 0) {
                this.info("Configurations with IntelligentManagement can not be merged.");
                throw new RuntimeException("Configurations with IntelligentManagement can not be merged.");
            }
            if (i != 0) continue;
            mergeConfigNode = (Element)dom.getDocumentElement().cloneNode(true);
            PluginMergeToolImpl.nodeListRemoveAll(mergeConfigNode, mergeConfigNode.getElementsByTagName("ServerCluster"));
            PluginMergeToolImpl.nodeListRemoveAll(mergeConfigNode, mergeConfigNode.getElementsByTagName("VirtualHostGroup"));
            PluginMergeToolImpl.nodeListRemoveAll(mergeConfigNode, mergeConfigNode.getElementsByTagName("UriGroup"));
            PluginMergeToolImpl.nodeListRemoveAll(mergeConfigNode, mergeConfigNode.getElementsByTagName("Route"));
        }
    }

    public static void printHelp() {
        System.out.println("\nUSAGE\n  <Liberty_Home>/wlp/usr/servers/<Member_Name>/plugin-cfg1.xml <Liberty_Home>/wlp/usr/servers/<Member_Name>/plugin-cfg2.xml [...] <Liberty_Home>/wlp/usr/servers/<Controller_Name>/<ClusterName>-plugin-cfg.xml\n");
        System.out.println("DESCRIPTION\n    The PluginCfgMerge Tool combines the plugin-cfg.xml files from two or more unbridged \n    servers such that the IBM HTTP Server Plugin will route traffic to all servers. \n    A uri is considered to be shared between two unbridged servers if the uri and  \n    corresponding virtual host definitions are identical.\n\n    The contents of the merged plugin-cfg.xml files must be in English language\n\n    Additional parmaters:\n     -debug               = prints additional log statements\n     -sortVhostGrp        = adds VirtualHostGroup name as part of the key.  Use this if a single XML contains\n                            two identical sets of URIs assigned to two different VirtualHostGroup Names.\n     -setMatchUriAppVhost = sets the MatchUriAppVhost value.\n \n Example with Paramters:\n    -sortVhostGrp -debug <Liberty_Home>/wlp/usr/servers/<Member_Name>/plugin-cfg1.xml <Liberty_Home>/wlp/usr/servers/<Member_Name>/plugin-cfg2.xml [...] <Liberty_Home>/wlp/usr/servers/<Controller_Name>/<ClusterName>-plugin-cfg.xml\n");
        System.exit(1);
    }

    private Hashtable<String, Hashtable<String, String>> hashChildNames(Element config, String groupName, String eachName) {
        Hashtable<String, Hashtable<String, String>> names = new Hashtable<String, Hashtable<String, String>>();
        NodeList nodes = config.getElementsByTagName(groupName);
        for (int n = 0; n < nodes.getLength(); ++n) {
            Element e = (Element)nodes.item(n);
            String parentName = e.getAttribute("Name");
            this.debug("++++++++++++++++++ " + groupName + " - " + parentName);
            Hashtable<String, String> table = new Hashtable<String, String>();
            names.put(parentName, table);
            NodeList children = nodes.item(n).getChildNodes();
            for (int c = 0; c < children.getLength(); ++c) {
                Node node = children.item(c);
                if (node.getNodeType() != 1 || !eachName.equals(node.getNodeName())) continue;
                Element child = (Element)node;
                if ("Server".equals(eachName)) {
                    NodeList transports = child.getElementsByTagName("Transport");
                    Element t = (Element)transports.item(0);
                    String s = t.getAttribute("Hostname");
                    table.put(s, "");
                    this.debug(s);
                    continue;
                }
                String childName = child.getAttribute("Name");
                table.put(childName, "");
                this.debug(childName);
            }
        }
        return names;
    }

    /*
     * WARNING - void declaration
     */
    private Hashtable<String, String> getRoutes(File f) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        try {
            FileInputStream fis = new FileInputStream(f);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(new InputSource(fis));
            Element config = dom.getDocumentElement();
            Hashtable<String, Hashtable<String, String>> clusterNames = this.hashChildNames(config, "ServerCluster", "Server");
            Hashtable<String, Hashtable<String, String>> vhGrpNames = this.hashChildNames(config, "VirtualHostGroup", "VirtualHost");
            Hashtable<String, Hashtable<String, String>> uriGrpNames = this.hashChildNames(config, "UriGroup", "Uri");
            NodeList routes = config.getElementsByTagName("Route");
            for (int j = 0; j < routes.getLength(); ++j) {
                Element route = (Element)routes.item(j);
                String cluster = route.getAttribute("ServerCluster");
                String vhGrp = route.getAttribute("VirtualHostGroup");
                String uriGrp = route.getAttribute("UriGroup");
                this.debug(f.getName() + ": " + cluster + "|" + vhGrp + "|" + uriGrp);
                Enumeration<String> serverKeys = clusterNames.get(cluster).keys();
                while (serverKeys.hasMoreElements()) {
                    String k1 = serverKeys.nextElement();
                    Enumeration<String> vhostKeys = vhGrpNames.get(vhGrp).keys();
                    while (vhostKeys.hasMoreElements()) {
                        String k2 = vhostKeys.nextElement();
                        Enumeration<String> uriKeys = uriGrpNames.get(uriGrp).keys();
                        while (uriKeys.hasMoreElements()) {
                            String k3 = uriKeys.nextElement();
                            String fullRoute = k1 + "|" + k2 + "|" + k3;
                            table.put(fullRoute, "");
                            this.debug(fullRoute);
                        }
                    }
                }
                this.debug("--------------");
            }
        }
        catch (Throwable fis) {
            void t;
            FFDCFilter.processException((Throwable)fis, (String)"com.ibm.ws.http.plugin.merge.internal.PluginMergeToolImpl", (String)"675", (Object)this, (Object[])new Object[]{f});
            throw new RuntimeException((Throwable)t);
        }
        return table;
    }

    private boolean validateEach(String[] inputFiles, String mergeFileName) {
        boolean passFail = true;
        File f = new File(mergeFileName);
        Hashtable<String, String> table = this.getRoutes(f);
        for (int i = 0; i < inputFiles.length - 1; ++i) {
            f = new File(inputFiles[i]);
            Hashtable<String, String> routes = this.getRoutes(f);
            Enumeration<String> e = routes.keys();
            while (e.hasMoreElements()) {
                String s = e.nextElement();
                if (table.containsKey(s)) continue;
                this.debug("Merged file is missing the route: " + s + " from input file: " + inputFiles[i]);
                passFail = false;
                break;
            }
            if (!passFail) break;
        }
        return passFail;
    }

    private boolean tryLfMerge(PluginMergeToolImpl tool, String[] inputs, String output) throws IOException, ParserConfigurationException, TransformerConfigurationException, TransformerException {
        boolean done = false;
        if (tool.lfMerge()) {
            tool.printMergedCopy(output);
            done = this.validateEach(inputs, output);
        }
        return done;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void merge(String[] argv) {
        if (argv.length < 2) {
            throw new IllegalArgumentException("Please provide at least 1 plugin-cfg.xml file to merge.");
        }
        PluginMergeToolImpl toolInstance = new PluginMergeToolImpl();
        List<String> filesList = toolInstance.loadParms(argv);
        String mergeFileName = filesList.remove(filesList.size() - 1);
        String[] fileList = new String[filesList.size()];
        fileList = filesList.toArray(fileList);
        plugins = new PluginInfo[fileList.length];
        try {
            Tr.info((TraceComponent)traceComponent, (String)"Merging...", (Object[])new Object[0]);
            fileList = toolInstance.sortFiles(fileList, FILEINFO_SMALL_TO_LARGE_COMPARATOR);
            toolInstance.loadData(fileList);
        }
        catch (Throwable throwable) {
            void t;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.http.plugin.merge.internal.PluginMergeToolImpl", (String)"744", (Object)this, (Object[])new Object[]{argv});
            throw new RuntimeException((Throwable)t);
        }
        try {
            if (precedence) {
                toolInstance.pMerge();
                toolInstance.printMergedCopy(mergeFileName);
            } else {
                int attempts = 0;
                int shuffles = 0;
                boolean done = this.tryLfMerge(toolInstance, fileList, mergeFileName);
                do {
                    if (++shuffles == 2) {
                        this.debug("\nLarge to small.");
                        sharedPlugins = new ArrayList();
                        emptyServerClusters = new HashSet();
                        fileList = toolInstance.sortFiles(fileList, FILEINFO_LARGE_TO_SMALL_COMPARATOR);
                        toolInstance.loadData(fileList);
                        done = this.tryLfMerge(toolInstance, fileList, mergeFileName);
                        attempts = 1;
                    } else if (shuffles == 3) {
                        this.debug("\nRandom shuffle.");
                        sharedPlugins = new ArrayList();
                        emptyServerClusters = new HashSet();
                        ArrayList<String> shuffle = new ArrayList<String>();
                        shuffle.addAll(new ArrayList<String>(Arrays.asList(fileList)));
                        Collections.shuffle(shuffle);
                        fileList = (String[])Arrays.copyOf(shuffle.toArray(), shuffle.size(), String[].class);
                        toolInstance.loadData(fileList);
                        done = this.tryLfMerge(toolInstance, fileList, mergeFileName);
                        attempts = 1;
                    }
                    while (!done && attempts < plugins.length) {
                        this.debug("\nReorder and reprocess " + ++attempts);
                        sharedPlugins = new ArrayList();
                        emptyServerClusters = new HashSet();
                        ArrayList<String> reorder = new ArrayList<String>();
                        reorder.addAll(new ArrayList<String>(Arrays.asList(fileList)));
                        reorder.add((String)reorder.remove(0));
                        fileList = (String[])Arrays.copyOf(reorder.toArray(), reorder.size(), String[].class);
                        toolInstance.loadData(fileList);
                        done = this.tryLfMerge(toolInstance, fileList, mergeFileName);
                    }
                } while (!done && shuffles < 3);
                if (!done) {
                    throw new RuntimeException(NO_MERGE_ERR);
                }
            }
        }
        catch (Throwable attempts) {
            void t;
            FFDCFilter.processException((Throwable)attempts, (String)"com.ibm.ws.http.plugin.merge.internal.PluginMergeToolImpl", (String)"796", (Object)this, (Object[])new Object[]{argv});
            throw new RuntimeException((Throwable)t);
        }
        Tr.info((TraceComponent)traceComponent, (String)"Merge Complete", (Object[])new Object[0]);
    }

    public String[] sortFiles(String[] strFiles, Comparator<FileInfo> comparator) {
        ArrayList<FileInfo> fiList = new ArrayList<FileInfo>();
        for (int i = 0; i < strFiles.length; ++i) {
            fiList.add(new FileInfo(strFiles[i]));
        }
        Collections.sort(fiList, comparator);
        int pos = 0;
        String[] sorted = new String[fiList.size()];
        ListIterator itr = fiList.listIterator();
        while (itr.hasNext()) {
            sorted[pos++] = ((FileInfo)itr.next()).filePath;
        }
        return sorted;
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] argv) {
        if (argv.length < 3) {
            PluginMergeToolImpl.printHelp();
        }
        System.out.println("Merging:");
        try {
            PluginMergeToolImpl toolInstance = new PluginMergeToolImpl();
            toolInstance.merge(argv);
        }
        catch (Exception toolInstance) {
            void e;
            FFDCFilter.processException((Throwable)toolInstance, (String)"com.ibm.ws.http.plugin.merge.internal.PluginMergeToolImpl", (String)"860", null, (Object[])new Object[]{argv});
            e.printStackTrace();
            System.out.println(NO_MERGE_ERR);
            System.exit(5);
        }
        System.out.println("Merge Complete");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        sharedPlugins = new ArrayList();
        emptyServerClusters = new HashSet();
        encoding = null;
        matchUriAppVhost = false;
        FILEINFO_SMALL_TO_LARGE_COMPARATOR = new Comparator<FileInfo>(){
            static final long serialVersionUID = 6414872329318009927L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public int compare(FileInfo o1, FileInfo o2) {
                return o1.compareTo(o2.fileSize);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.plugin.merge.internal.PluginMergeToolImpl$1", 1.class, (String)"Cluster", (String)"com.ibm.ws.http.plugin.merge.internal.resources.Messages");
            }
        };
        FILEINFO_LARGE_TO_SMALL_COMPARATOR = new Comparator<FileInfo>(){
            static final long serialVersionUID = 589250515531859802L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public int compare(FileInfo o1, FileInfo o2) {
                return o2.compareTo(o1.fileSize);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.plugin.merge.internal.PluginMergeToolImpl$2", 2.class, (String)"Cluster", (String)"com.ibm.ws.http.plugin.merge.internal.resources.Messages");
            }
        };
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class AppInfo
    implements Cloneable {
        private String appName = null;
        private Element uriGrp;
        private Element route;
        private Element serverCluster;
        private Element vhg;
        private Element uri;
        private Element vh = null;
        private final Vector sharedUris = new Vector();
        private final Hashtable sharedServers = new Hashtable();
        private boolean uniqueVhgNeeded = false;
        static final long serialVersionUID = 1485288136585737722L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private AppInfo() {
        }

        protected Object clone() throws CloneNotSupportedException {
            this.route = (Element)this.route.cloneNode(true);
            return super.clone();
        }

        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public Element getUriGrp() {
            return this.uriGrp;
        }

        public void setUriGrp(Element uriGrp) {
            this.uriGrp = uriGrp;
        }

        public Element getRoute() {
            return this.route;
        }

        public void setRoute(Element route) {
            this.route = route;
        }

        public Element getServerCluster() {
            return this.serverCluster;
        }

        public void setServerCluster(Element serverCluster) {
            this.serverCluster = serverCluster;
        }

        public Element getVhg() {
            return this.vhg;
        }

        public void setVhg(Element vhg) {
            this.vhg = vhg;
        }

        public Element getUri() {
            return this.uri;
        }

        public void setUri(Element uri) {
            this.uri = uri;
        }

        public Element getVh() {
            return this.vh;
        }

        public void setVh(Element vh) {
            this.vh = vh;
        }

        public void addSharedUriElements(Element uri) {
            this.sharedUris.add(uri);
        }

        public Node[] getSharedUriElemenets() {
            this.sharedUris.trimToSize();
            Object[] rtnNodes = new Node[this.sharedUris.size()];
            this.sharedUris.copyInto(rtnNodes);
            return rtnNodes;
        }

        public boolean setSharedServer(String serverName, Node serverNode) {
            return this.sharedServers.put(serverName, serverNode.cloneNode(true)) == null;
        }

        public Set getAppServerSet() {
            return this.sharedServers.keySet();
        }

        public Hashtable getSharedServersMap() {
            return this.sharedServers;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.plugin.merge.internal.PluginMergeToolImpl$AppInfo", AppInfo.class, (String)"Cluster", (String)"com.ibm.ws.http.plugin.merge.internal.resources.Messages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class PluginInfo {
        private int seqNum = 0;
        private boolean isShared = false;
        private final Hashtable uniquePluginRep = new Hashtable();
        private ArrayList<String> primaryServers = null;
        private ArrayList<String> backupServers = null;
        private Document sharedDoc = null;
        private Document unsharedDoc = null;
        private Element sharedCluster = null;
        private final Vector<Node> unsharedClusters = new Vector();
        private final Hashtable<Set<String>, Node> allSharedScElements = new Hashtable();
        private Hashtable<String, Node> sharedVhosts = null;
        private final Hashtable<String, Node> allSharedServers = new Hashtable();
        private final Vector<Node> unsharedVhg = new Vector();
        private ArrayList<Node> sharedVhgs = null;
        private Hashtable<String, String> uriVhostGrpMap = null;
        private final Hashtable<String, Node> uriGrps = new Hashtable();
        private final Hashtable<String, Node> uniqueUriGrps = new Hashtable();
        private Hashtable<String, Element> routes = new Hashtable();
        private final HashSet<String> containedUris = new HashSet();
        private final HashSet<String> containedApps = new HashSet();
        static final long serialVersionUID = -4872543151856313511L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private void listNodes(Node node, String indent, String Type) {
            NodeList list;
            int i;
            if (node.hasAttributes()) {
                NamedNodeMap attrs = node.getAttributes();
                for (i = 0; i < attrs.getLength(); ++i) {
                    Attr attribute = (Attr)attrs.item(i);
                    if (!attribute.getName().equals("Name")) continue;
                    if (Type == "Primary") {
                        PluginMergeToolImpl.this.debug(indent + "Found PrimaryServer: " + attribute.getName() + " = " + attribute.getValue());
                        PluginMergeToolImpl.this.G_primaryServers.add(attribute.getValue());
                        continue;
                    }
                    PluginMergeToolImpl.this.debug(indent + "Found BackupServer: " + attribute.getName() + " = " + attribute.getValue());
                    PluginMergeToolImpl.this.G_backupServers.add(attribute.getValue());
                }
            }
            if ((list = node.getChildNodes()).getLength() > 0) {
                for (i = 0; i < list.getLength(); ++i) {
                    this.listNodes(list.item(i), indent + "  ", Type);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @FFDCIgnore(value={ArrayIndexOutOfBoundsException.class})
        public PluginInfo(int seqNum, Element config, String fileLoc) {
            Node n;
            this.seqNum = seqNum;
            Stack<Node> stack = new Stack<Node>();
            NodeList nodeList1 = config.getElementsByTagName("PrimaryServers");
            PluginMergeToolImpl.this.debug("Storing Primary Server information");
            for (int i = 0; i < nodeList1.getLength(); ++i) {
                Node n2 = nodeList1.item(i);
                Node node = n2.getFirstChild();
                PluginMergeToolImpl.this.debug("Calling listNodes for : " + n2.getNodeName());
                this.listNodes(n2, "", "Primary");
                while (node != null) {
                    if (node.hasChildNodes()) {
                        if (node.getNextSibling() != null) {
                            stack.push(node.getNextSibling());
                        }
                        node = node.getFirstChild();
                        continue;
                    }
                    if ((node = node.getNextSibling()) != null || stack.isEmpty()) continue;
                    node = (Node)stack.pop();
                }
            }
            NodeList nodeList2 = config.getElementsByTagName("BackupServers");
            PluginMergeToolImpl.this.debug("Gathering Backup Server information");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node n2 = nodeList2.item(i);
                PluginMergeToolImpl.this.debug("Calling listNodes for : " + n2.getNodeName());
                this.listNodes(n2, "", "Backup");
            }
            NodeList nl = config.getElementsByTagName("PrimaryServers");
            int i = 0;
            while (i < nl.getLength()) {
                n = nl.item(i);
                n.getParentNode().removeChild(n);
            }
            nl = config.getElementsByTagName("BackupServers");
            i = 0;
            while (i < nl.getLength()) {
                n = nl.item(i);
                n.getParentNode().removeChild(n);
            }
            Hashtable<String, Node> serverClusters = this.createTable(PluginMergeToolImpl.nodeListToDeadArray(config.getElementsByTagName("ServerCluster")), "Name");
            Hashtable<String, Node> routes = this.createTable(PluginMergeToolImpl.nodeListToDeadArray(config.getElementsByTagName("Route")), "UriGroup");
            Hashtable<String, Node> vHostGrps = this.createTable(PluginMergeToolImpl.nodeListToDeadArray(config.getElementsByTagName("VirtualHostGroup")), "Name");
            Enumeration<String> keys = serverClusters.keys();
            while (keys.hasMoreElements()) {
                Element cluster = (Element)serverClusters.get(keys.nextElement());
                cluster.setAttribute("Name", cluster.getAttribute("Name") + "_" + seqNum);
            }
            keys = vHostGrps.keys();
            while (keys.hasMoreElements()) {
                Element vhg = (Element)vHostGrps.get(keys.nextElement());
                vhg.setAttribute("Name", vhg.getAttribute("Name") + "_" + seqNum);
            }
            keys = routes.keys();
            while (keys.hasMoreElements()) {
                Element route = (Element)routes.get(keys.nextElement());
                route.setAttribute("ServerCluster", route.getAttribute("ServerCluster") + "_" + seqNum);
                route.setAttribute("VirtualHostGroup", route.getAttribute("VirtualHostGroup") + "_" + seqNum);
            }
            Hashtable<String, Node> uriGrpsTmp = this.createTable(PluginMergeToolImpl.nodeListToDeadArray(config.getElementsByTagName("UriGroup")), "Name");
            AppInfo info = new AppInfo();
            String uriName = null;
            Enumeration<String> uriGrpNames = uriGrpsTmp.keys();
            while (uriGrpNames.hasMoreElements()) {
                String uriGrpName;
                block24: {
                    uriGrpName = uriGrpNames.nextElement();
                    if (isXdOnly) {
                        try {
                            info.setAppName(uriGrpName.split("/cell/.+?(/application/)")[1]);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            Tr.info((TraceComponent)traceComponent, (String)"Merging a non-ODC generated plugin-cfg.xml", (Object[])new Object[0]);
                            isXdOnly = false;
                            info.setAppName(uriGrpName);
                            if (!PluginMergeToolImpl.this.setMatchUriAppVhost && matchUriAppVhost) {
                                matchUriAppVhost = false;
                                Tr.info((TraceComponent)traceComponent, (String)"Cannot match based on uri app vhost for non-ODC generated plugin-cfg.xml files. com.ibm.ws.pluginmerge.match.appname set to false", (Object[])new Object[0]);
                                break block24;
                            }
                            matchUriAppVhost = PluginMergeToolImpl.this.setMatchUriAppVhost;
                        }
                    } else {
                        info.setAppName(uriGrpName);
                    }
                }
                this.containedApps.add(info.getAppName());
                Element eUriGrp = (Element)uriGrpsTmp.get(uriGrpName);
                info.setUriGrp((Element)eUriGrp.cloneNode(false));
                try {
                    info.setRoute((Element)((Element)routes.get(uriGrpName)).cloneNode(true));
                }
                catch (NullPointerException nullPointerException) {
                    FFDCFilter.processException((Throwable)nullPointerException, (String)"com.ibm.ws.http.plugin.merge.internal.PluginMergeToolImpl$PluginInfo", (String)"1057", (Object)this, (Object[])new Object[]{seqNum, config, fileLoc});
                    Tr.info((TraceComponent)traceComponent, (String)("Skipping UriGroup " + uriGrpName + " because it does not have a corresponding Route definition"), (Object[])new Object[0]);
                    continue;
                }
                String scName = info.getRoute().getAttribute("ServerCluster");
                info.setServerCluster((Element)((Element)serverClusters.get(scName.substring(0, scName.lastIndexOf("_" + seqNum)))).cloneNode(true));
                String vhgName = info.getRoute().getAttribute("VirtualHostGroup");
                Element eVhg = (Element)vHostGrps.get(vhgName.substring(0, vhgName.lastIndexOf("_" + seqNum)));
                info.setVhg((Element)eVhg.cloneNode(false));
                Hashtable<String, Node> vHosts = this.createTable(PluginMergeToolImpl.nodeListToDeadArray(eVhg.getElementsByTagName("VirtualHost")), "Name");
                Hashtable<String, Node> uris = this.createTable(PluginMergeToolImpl.nodeListToDeadArray(eUriGrp.getElementsByTagName("Uri")), "Name");
                Enumeration<String> uriNames = uris.keys();
                while (uriNames.hasMoreElements()) {
                    uriName = uriNames.nextElement();
                    info.setUri((Element)((Element)uris.get(uriName)).cloneNode(true));
                    this.containedUris.add(uriName);
                    Enumeration<String> eVh = vHosts.keys();
                    while (eVh.hasMoreElements()) {
                        String vhName = eVh.nextElement();
                        info.setVh((Element)((Element)vHosts.get(vhName)).cloneNode(true));
                        try {
                            if (matchUriAppVhost) {
                                this.uniquePluginRep.put("/uri/" + uriName + "/app/" + info.getAppName() + "/vHost/" + vhName, info.clone());
                                continue;
                            }
                            if (PluginMergeToolImpl.this.sortVhostGrp) {
                                this.uniquePluginRep.put("/uri/" + uriName + "/vhostGrp/" + vhgName.substring(0, vhgName.lastIndexOf("_" + seqNum)) + "/vHost/" + vhName, info.clone());
                                continue;
                            }
                            this.uniquePluginRep.put("/uri/" + uriName + "/vHost/" + vhName, info.clone());
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            void e;
                            FFDCFilter.processException((Throwable)cloneNotSupportedException, (String)"com.ibm.ws.http.plugin.merge.internal.PluginMergeToolImpl$PluginInfo", (String)"1093", (Object)this, (Object[])new Object[]{seqNum, config, fileLoc});
                            Tr.info((TraceComponent)traceComponent, (String)("Error processing /uri/" + uriName + "/app/" + info.getAppName() + "/vHost/\n" + e.getLocalizedMessage()), (Object[])new Object[0]);
                            throw new RuntimeException((Throwable)e);
                        }
                    }
                }
            }
        }

        public PluginInfo(int seqNum, Element serverCluster1) throws ParserConfigurationException {
            this.isShared = true;
            this.seqNum = seqNum;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = dbf.newDocumentBuilder();
            this.sharedDoc = parser.newDocument();
            this.sharedCluster = (Element)serverCluster1.cloneNode(false);
            this.sharedVhosts = new Hashtable();
            this.sharedVhgs = new ArrayList();
            this.uriVhostGrpMap = new Hashtable();
            this.primaryServers = new ArrayList();
            this.backupServers = new ArrayList();
        }

        private void addMatch(String uid, String appName, Element serverCluster1, int p1_seq, Element serverCluster2, int p2_seq, Element uri, Element vh) {
            AppInfo sharedAppInfo = null;
            Object sharedServers = null;
            if (this.uniquePluginRep.containsKey(uid)) {
                sharedAppInfo = (AppInfo)this.uniquePluginRep.get(uid);
            } else {
                sharedAppInfo = new AppInfo();
                sharedAppInfo.setAppName(appName);
                this.uniquePluginRep.put(uid, sharedAppInfo);
            }
            sharedAppInfo.setUri(uri);
            sharedAppInfo.setVh(vh);
            this.sharedVhosts.put(vh.getAttribute("Name"), vh);
            this.addSharedServers(p1_seq, serverCluster1, sharedAppInfo, true);
            this.addSharedServers(p2_seq, serverCluster2, sharedAppInfo, true);
        }

        private void addSharedServers(int postfix, Element sc, AppInfo appInfo, boolean isPrimary) {
            Element srvr = null;
            String serverNom = null;
            Iterator<Node> itrServers = PluginMergeToolImpl.nodeListToDeadArray(sc.getElementsByTagName("Server")).iterator();
            if (!itrServers.hasNext()) {
                String scName = sc.getAttribute("Name");
                if (!emptyServerClusters.contains(scName)) {
                    PluginMergeToolImpl.this.debug("ServerCluster element '" + scName.substring(0, scName.lastIndexOf("_")) + "' from " + sc.getBaseURI() + " does not contain any Server elements");
                    emptyServerClusters.add(scName);
                }
            }
            while (itrServers.hasNext()) {
                srvr = (Element)itrServers.next();
                serverNom = srvr.getAttribute("Name") + "_" + postfix;
                srvr.setAttribute("Name", serverNom);
                if (appInfo.setSharedServer(serverNom, srvr)) {
                    if (isPrimary) {
                        this.primaryServers.add(serverNom);
                    } else {
                        this.backupServers.add(serverNom);
                    }
                }
                this.allSharedServers.put(serverNom, srvr.cloneNode(true));
            }
        }

        public String createSharedName(String nom) {
            return "/cell/sharedCell_" + this.seqNum + "/" + nom;
        }

        private Hashtable<String, Node> createTable(ArrayList<Node> elements, String attr) {
            Hashtable<String, Node> table = new Hashtable<String, Node>();
            if (elements != null) {
                String key = null;
                Object var5_5 = null;
                elements.trimToSize();
                for (Element element : elements) {
                    key = element.getAttribute(attr);
                    if (table.put(key, element) == null) continue;
                    PluginMergeToolImpl.this.debug("Replaced value for key: " + key);
                }
            }
            return table;
        }

        private void makeServerClusterElement(int scNum, Set serverNames) {
            Element sc = (Element)this.sharedCluster.cloneNode(true);
            sc = (Element)this.sharedDoc.importNode(sc, true);
            sc.setAttribute("Name", "Shared_" + this.seqNum + "_Cluster_" + scNum);
            Iterator itr = serverNames.iterator();
            while (itr.hasNext()) {
                sc.appendChild(this.sharedDoc.importNode(((Element)this.allSharedServers.get(itr.next())).cloneNode(true), true));
            }
            this.allSharedScElements.put(serverNames, sc.cloneNode(true));
        }

        private void createShared_ServerClusters_VhostGrps() {
            PluginMergeToolImpl.this.tc = "createShared_ServerClusters_VhostGrps - ";
            int scNum = 0;
            int serverCount = 0;
            Set srvrSetTmp = null;
            HashSet<String> vhostSetTmp = null;
            ArrayList srvrSetList = null;
            AppInfo sharedAppInfo = null;
            Hashtable serversSetTbl = new Hashtable();
            Hashtable uriVhostSetTbl = new Hashtable();
            Enumeration e = null;
            e = this.uniquePluginRep.keys();
            while (e.hasMoreElements()) {
                String uid = (String)e.nextElement();
                sharedAppInfo = (AppInfo)this.uniquePluginRep.get(uid);
                srvrSetTmp = ((Hashtable)sharedAppInfo.getSharedServersMap().clone()).keySet();
                serverCount = srvrSetTmp.size();
                if (serversSetTbl.containsKey(new Integer(serverCount))) {
                    ((ArrayList)serversSetTbl.get(new Integer(serverCount))).add(srvrSetTmp);
                } else {
                    srvrSetList = new ArrayList();
                    srvrSetList.add(srvrSetTmp);
                    serversSetTbl.put(new Integer(serverCount), srvrSetList);
                }
                String uriName = uid.substring(0, uid.indexOf("/vHost/"));
                PluginMergeToolImpl.this.debug(PluginMergeToolImpl.this.tc + "uriName: " + uriName);
                if (uriVhostSetTbl.containsKey(uriName)) {
                    ((Set)uriVhostSetTbl.get(uriName)).add(sharedAppInfo.getVh().getAttribute("Name"));
                    continue;
                }
                vhostSetTmp = new HashSet<String>();
                vhostSetTmp.add(sharedAppInfo.getVh().getAttribute("Name"));
                uriVhostSetTbl.put(uriName, vhostSetTmp);
            }
            e = serversSetTbl.keys();
            while (e.hasMoreElements()) {
                int i;
                srvrSetList = (ArrayList)serversSetTbl.get(e.nextElement());
                srvrSetList.trimToSize();
                Set[] sets = new Set[srvrSetList.size()];
                srvrSetList.toArray(sets);
                for (i = 0; i < sets.length - 1; ++i) {
                    for (int j = i + 1; j < sets.length; ++j) {
                        if (!sets[i].containsAll(sets[j])) continue;
                        sets[j].clear();
                    }
                }
                for (i = 0; i < sets.length; ++i) {
                    if (sets[i].isEmpty()) continue;
                    this.makeServerClusterElement(scNum, sets[i]);
                    ++scNum;
                }
            }
            int vhGrpNum = 0;
            Hashtable<Integer, ArrayList[]> vhostSetsTbl = new Hashtable<Integer, ArrayList[]>();
            ArrayList[] vhostSetList = null;
            e = uriVhostSetTbl.keys();
            while (e.hasMoreElements()) {
                String uriNom = (String)e.nextElement();
                vhostSetTmp = (HashSet<String>)uriVhostSetTbl.get(uriNom);
                if (vhostSetsTbl.containsKey(vhostSetTmp.size())) {
                    boolean found = false;
                    vhostSetList = (ArrayList[])vhostSetsTbl.get(vhostSetTmp.size());
                    Iterator itrSetList = vhostSetList[0].iterator();
                    Iterator itrVhgName = vhostSetList[1].iterator();
                    while (itrSetList.hasNext()) {
                        String vhgName = (String)itrVhgName.next();
                        if (!((Set)itrSetList.next()).containsAll(vhostSetTmp)) continue;
                        found = true;
                        this.uriVhostGrpMap.put(uriNom, vhgName);
                        break;
                    }
                    if (found) continue;
                    String newVhgName = this.createSharedVhostGrp(vhostSetTmp, vhGrpNum);
                    ++vhGrpNum;
                    vhostSetList[0].add(vhostSetTmp);
                    vhostSetList[1].add(newVhgName);
                    vhostSetsTbl.put(vhostSetTmp.size(), vhostSetList);
                    this.uriVhostGrpMap.put(uriNom, newVhgName);
                    continue;
                }
                String newVhgName = this.createSharedVhostGrp(vhostSetTmp, vhGrpNum);
                ++vhGrpNum;
                vhostSetList = new ArrayList[]{new ArrayList(), new ArrayList()};
                vhostSetList[0].add(vhostSetTmp);
                vhostSetList[1].add(newVhgName);
                vhostSetsTbl.put(vhostSetTmp.size(), vhostSetList);
                this.uriVhostGrpMap.put(uriNom, newVhgName);
            }
        }

        private String createSharedVhostGrp(HashSet vhostsSet, int grpNum) {
            String sharedVhgName = this.createSharedName("vHostGroup/shared_host_" + grpNum);
            PluginMergeToolImpl.this.debug("createSharedVhostGrp - sharedVghName: " + sharedVhgName);
            Element eVhg = (Element)this.sharedDoc.createElement("VirtualHostGroup").cloneNode(true);
            eVhg.setAttribute("Name", sharedVhgName);
            Iterator itr = vhostsSet.iterator();
            while (itr.hasNext()) {
                eVhg.appendChild(this.sharedDoc.importNode(this.sharedVhosts.get(itr.next()), true));
            }
            this.sharedVhgs.add(eVhg.cloneNode(true));
            return sharedVhgName;
        }

        private void cleanPlugin() throws ParserConfigurationException {
            PluginMergeToolImpl.this.tc = "cleanPlugin - ";
            PluginMergeToolImpl.this.debug(PluginMergeToolImpl.this.tc + "Cleaning the plugin");
            Enumeration<Object> e = null;
            if (this.isShared) {
                this.createShared_ServerClusters_VhostGrps();
                Element eRoute = (Element)this.sharedDoc.createElement("Route").cloneNode(true);
                Hashtable knownUris = new Hashtable();
                e = this.uniquePluginRep.keys();
                while (e.hasMoreElements()) {
                    String uid = (String)e.nextElement();
                    AppInfo sharedAppInfo = (AppInfo)this.uniquePluginRep.get(uid);
                    String appName = sharedAppInfo.getAppName();
                    Element eUriGrp = null;
                    if (!this.uriGrps.containsKey(appName)) {
                        Element sc = null;
                        Set servers = sharedAppInfo.getAppServerSet();
                        Enumeration<Set<String>> serverSets = this.allSharedScElements.keys();
                        while (serverSets.hasMoreElements()) {
                            Set<String> s = serverSets.nextElement();
                            if (servers.size() != s.size() || !s.containsAll(servers)) continue;
                            sc = (Element)this.allSharedScElements.get(s);
                            break;
                        }
                        if (sc == null) {
                            Tr.info((TraceComponent)traceComponent, (String)("Unable to find a mathcing ServerCluster definition for uid " + uid + "\nSkipping the unique instance of " + appName), (Object[])new Object[0]);
                            continue;
                        }
                        eUriGrp = (Element)this.sharedDoc.createElement("UriGroup").cloneNode(true);
                        eUriGrp.setAttribute("Name", this.createSharedName("application/" + appName));
                        HashSet<String> uris = new HashSet<String>();
                        String uriNom = sharedAppInfo.getUri().getAttribute("Name");
                        uris.add(uriNom);
                        knownUris.put(appName, uris);
                        eUriGrp.appendChild(this.sharedDoc.importNode(sharedAppInfo.getUri().cloneNode(true), true));
                        this.uriGrps.put(appName, eUriGrp.cloneNode(true));
                        String newKeyUriVhg = uid.substring(0, uid.indexOf("/vHost/"));
                        eRoute.setAttribute("VirtualHostGroup", this.uriVhostGrpMap.get(newKeyUriVhg));
                        eRoute.setAttribute("UriGroup", eUriGrp.getAttribute("Name"));
                        eRoute.setAttribute("ServerCluster", sc.getAttribute("Name"));
                        this.addRoute(eRoute);
                        continue;
                    }
                    HashSet uris = (HashSet)knownUris.get(appName);
                    if (uris == null) {
                        PluginMergeToolImpl.this.debug("Continue for appName:" + appName);
                        continue;
                    }
                    if (!uris.contains(sharedAppInfo.getUri().getAttribute("Name"))) {
                        uris.add(sharedAppInfo.getUri().getAttribute("Name"));
                        ((Element)this.uriGrps.get(appName)).appendChild(this.sharedDoc.importNode(sharedAppInfo.getUri().cloneNode(true), true));
                    }
                    eUriGrp = (Element)this.uriGrps.get(appName);
                }
            } else {
                HashSet<String> knownSc = new HashSet<String>();
                Hashtable<String, Node> knownVhgs = new Hashtable<String, Node>();
                Hashtable knownVhs = new Hashtable();
                Hashtable<String, HashSet<String>> knownUris = new Hashtable<String, HashSet<String>>();
                Hashtable<String, Node> knownUniqueVhgs = new Hashtable<String, Node>();
                Hashtable knownUniqueVhs = new Hashtable();
                Hashtable knownUniqueUris = new Hashtable();
                e = this.uniquePluginRep.elements();
                while (e.hasMoreElements()) {
                    HashSet<String> uris;
                    AppInfo uid = (AppInfo)e.nextElement();
                    Element uriGrp = (Element)uid.getUriGrp().cloneNode(true);
                    String uriGrpName = uriGrp.getAttribute("Name");
                    if (uid.uniqueVhgNeeded) {
                        if (!this.uniqueUriGrps.containsKey(uriGrpName)) {
                            Element newUriGrp = (Element)uriGrp.cloneNode(true);
                            newUriGrp.setAttribute("Name", uriGrpName + "_" + this.seqNum);
                            newUriGrp.appendChild(uid.getUri().cloneNode(true));
                            this.uniqueUriGrps.put(uriGrpName, newUriGrp.cloneNode(true));
                            HashSet<String> uniqueUris = new HashSet<String>();
                            uniqueUris.add(uid.getUri().getAttribute("Name"));
                            knownUniqueUris.put(uriGrpName, uniqueUris);
                        } else {
                            HashSet uniqueUris = (HashSet)knownUniqueUris.get(uriGrpName);
                            if (!uniqueUris.contains(uid.getUri().getAttribute("Name"))) {
                                uniqueUris.add(uid.getUri().getAttribute("Name"));
                                ((Element)this.uniqueUriGrps.get(uriGrpName)).appendChild(uid.getUri().cloneNode(true));
                            }
                        }
                        uid.getRoute().setAttribute("UriGroup", uriGrpName + "_" + this.seqNum);
                    } else if (!this.uriGrps.containsKey(uriGrpName)) {
                        uriGrp.appendChild(uid.getUri().cloneNode(true));
                        this.uriGrps.put(uriGrpName, uriGrp.cloneNode(true));
                        uris = new HashSet<String>();
                        uris.add(uid.getUri().getAttribute("Name"));
                        knownUris.put(uriGrpName, uris);
                    } else {
                        uris = (HashSet<String>)knownUris.get(uriGrpName);
                        if (!uris.contains(uid.getUri().getAttribute("Name"))) {
                            uris.add(uid.getUri().getAttribute("Name"));
                            ((Element)this.uriGrps.get(uriGrpName)).appendChild(uid.getUri().cloneNode(true));
                        }
                    }
                    Element vhg = uid.getVhg();
                    String vhgName = vhg.getAttribute("Name");
                    if (uid.uniqueVhgNeeded) {
                        if (!knownUniqueVhgs.containsKey(vhgName)) {
                            Element newVhg = (Element)vhg.cloneNode(true);
                            newVhg.setAttribute("Name", vhgName + "_" + this.seqNum);
                            newVhg.appendChild(uid.getVh().cloneNode(true));
                            knownUniqueVhgs.put(vhgName, newVhg.cloneNode(true));
                            HashSet<String> vhUniqueSet = new HashSet<String>();
                            vhUniqueSet.add(uid.getVh().getAttribute("Name"));
                            knownUniqueVhs.put(vhgName, vhUniqueSet);
                        } else if (((HashSet)knownUniqueVhs.get(vhgName)).add(uid.getVh().getAttribute("Name"))) {
                            ((Element)knownUniqueVhgs.get(vhgName)).appendChild(uid.getVh().cloneNode(true));
                        }
                        uid.getRoute().setAttribute("VirtualHostGroup", vhgName + "_" + this.seqNum);
                    } else if (!knownVhgs.containsKey(vhgName)) {
                        vhg.appendChild(uid.getVh().cloneNode(true));
                        knownVhgs.put(vhgName, vhg.cloneNode(true));
                        HashSet<String> vhSet = new HashSet<String>();
                        vhSet.add(uid.getVh().getAttribute("Name"));
                        knownVhs.put(vhgName, vhSet);
                    } else if (((HashSet)knownVhs.get(vhgName)).add(uid.getVh().getAttribute("Name"))) {
                        ((Element)knownVhgs.get(vhgName)).appendChild(uid.getVh().cloneNode(true));
                    }
                    Element sc = uid.getServerCluster();
                    String scName = sc.getAttribute("Name");
                    if (!knownSc.contains(scName)) {
                        knownSc.add(scName);
                        this.unsharedClusters.add(sc.cloneNode(true));
                    }
                    this.addRoute(uid.getRoute());
                }
                this.unsharedVhg.addAll(knownVhgs.values());
                this.unsharedVhg.addAll(knownUniqueVhgs.values());
            }
        }

        public Hashtable<String, AppInfo> getUniquePluginRep() {
            return this.uniquePluginRep;
        }

        public Node[] getUnsharedServerClusters() throws ParserConfigurationException {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = dbf.newDocumentBuilder();
            this.unsharedDoc = parser.newDocument();
            ArrayList<Node> lstNodes = new ArrayList<Node>();
            Vector<String> primaries = new Vector<String>();
            Vector<String> backups = new Vector<String>();
            int indx = 0;
            PluginMergeToolImpl.this.debug("Building UnsharedCluster information");
            Iterator<Node> itr = this.unsharedClusters.iterator();
            while (itr.hasNext()) {
                Element tmpSc = (Element)this.unsharedDoc.importNode(itr.next().cloneNode(true), true);
                PluginMergeToolImpl.this.debug("ServerCluster Name: " + tmpSc.getAttribute("Name"));
                NodeList nlstServers = tmpSc.getElementsByTagName("Server");
                for (int i = 0; i < nlstServers.getLength(); ++i) {
                    Element serverName = (Element)nlstServers.item(i);
                    PluginMergeToolImpl.this.debug("\t Cluster Server Name: " + serverName.getAttribute("Name"));
                    if (PluginMergeToolImpl.this.G_primaryServers.contains(serverName.getAttribute("Name")) || PluginMergeToolImpl.this.G_primaryServers.isEmpty() || !PluginMergeToolImpl.this.G_backupServers.contains(serverName.getAttribute("Name"))) {
                        PluginMergeToolImpl.this.debug("UnShared: Adding " + serverName.getAttribute("Name") + " to PrimaryServer list");
                        primaries.add(serverName.getAttribute("Name"));
                        continue;
                    }
                    PluginMergeToolImpl.this.debug("UnShared: Adding " + serverName.getAttribute("Name") + " to BackupServer list");
                    backups.add(serverName.getAttribute("Name"));
                }
                Element eServerTmp = (Element)this.unsharedDoc.createElement("Server").cloneNode(true);
                eServerTmp = (Element)this.unsharedDoc.importNode(eServerTmp, true);
                Element ePrimary = (Element)this.unsharedDoc.createElement("PrimaryServers").cloneNode(true);
                ePrimary = (Element)this.unsharedDoc.importNode(ePrimary, true);
                primaries.trimToSize();
                Enumeration e = primaries.elements();
                while (e.hasMoreElements()) {
                    eServerTmp.setAttribute("Name", (String)e.nextElement());
                    ePrimary.appendChild(eServerTmp.cloneNode(true));
                }
                tmpSc.appendChild(ePrimary);
                if (!backups.isEmpty()) {
                    PluginMergeToolImpl.this.debug("Unshared: Backup servers are configured.");
                    Element eBackup = (Element)this.unsharedDoc.createElement("BackupServers").cloneNode(true);
                    eBackup = (Element)this.unsharedDoc.importNode(eBackup, true);
                    backups.trimToSize();
                    e = backups.elements();
                    while (e.hasMoreElements()) {
                        eServerTmp.setAttribute("Name", (String)e.nextElement());
                        eBackup.appendChild(eServerTmp.cloneNode(true));
                    }
                    tmpSc.appendChild(eBackup);
                }
                lstNodes.add(tmpSc.cloneNode(true));
                ++indx;
                primaries.clear();
                backups.clear();
            }
            this.unsharedClusters.trimToSize();
            lstNodes.trimToSize();
            Object[] nodes = new Node[this.unsharedClusters.size()];
            this.unsharedClusters.copyInto(nodes);
            lstNodes.toArray(nodes);
            return nodes;
        }

        public Node[] getSharedServerClusters() {
            Node[] rtnNodes = new Node[this.allSharedScElements.size()];
            Enumeration<Node> e = this.allSharedScElements.elements();
            int i = 0;
            while (e.hasMoreElements()) {
                rtnNodes[i] = e.nextElement().cloneNode(true);
                ++i;
            }
            return rtnNodes;
        }

        public Node[] getFailOverServerClusters() {
            String subServerName = null;
            ArrayList<Node> lstNodes = new ArrayList<Node>();
            Vector<String> primaries = new Vector<String>();
            Vector<String> backups = new Vector<String>();
            Collection<Node> c = this.allSharedScElements.values();
            Iterator<Node> itr = c.iterator();
            PluginMergeToolImpl.this.debug("Building Shared Cluster information");
            while (itr.hasNext()) {
                Element sc = (Element)((Element)itr.next()).cloneNode(true);
                NodeList nList = sc.getElementsByTagName("Server");
                for (int i = 0; i < nList.getLength(); ++i) {
                    Element e = (Element)nList.item(i);
                    String serverName = e.getAttribute("Name");
                    subServerName = serverName.substring(0, serverName.length() - (serverName.length() - serverName.lastIndexOf("_")));
                    if (PluginMergeToolImpl.this.G_primaryServers.contains(subServerName) || PluginMergeToolImpl.this.G_primaryServers.isEmpty() || !PluginMergeToolImpl.this.G_backupServers.contains(subServerName)) {
                        PluginMergeToolImpl.this.debug("Shared: Adding " + serverName + " to PrimaryServer list.");
                        primaries.add(serverName);
                        continue;
                    }
                    PluginMergeToolImpl.this.debug("Shared: Adding " + serverName + " to BackupServer list.");
                    backups.add(serverName);
                }
                Element eServerTmp = (Element)this.sharedDoc.createElement("Server").cloneNode(true);
                eServerTmp = (Element)this.sharedDoc.importNode(eServerTmp, true);
                Element ePrimary = (Element)this.sharedDoc.createElement("PrimaryServers").cloneNode(true);
                ePrimary = (Element)this.sharedDoc.importNode(ePrimary, true);
                primaries.trimToSize();
                Enumeration e = primaries.elements();
                while (e.hasMoreElements()) {
                    eServerTmp.setAttribute("Name", (String)e.nextElement());
                    ePrimary.appendChild(eServerTmp.cloneNode(true));
                }
                sc.appendChild(ePrimary);
                if (!backups.isEmpty()) {
                    PluginMergeToolImpl.this.debug("Shared: Backup servers are configured.");
                    Element eBackup = (Element)this.sharedDoc.createElement("BackupServers").cloneNode(true);
                    eBackup = (Element)this.sharedDoc.importNode(eBackup, true);
                    this.backupServers.trimToSize();
                    e = backups.elements();
                    while (e.hasMoreElements()) {
                        eServerTmp.setAttribute("Name", (String)e.nextElement());
                        eBackup.appendChild(eServerTmp.cloneNode(true));
                    }
                    sc.appendChild(eBackup);
                }
                lstNodes.add(sc.cloneNode(true));
                primaries.clear();
                backups.clear();
            }
            lstNodes.trimToSize();
            Node[] rtnNodes = new Node[lstNodes.size()];
            lstNodes.toArray(rtnNodes);
            return rtnNodes;
        }

        public Node[] getUnsharedVHostGrp() {
            this.unsharedVhg.trimToSize();
            Object[] rtnNodes = new Node[this.unsharedVhg.size()];
            this.unsharedVhg.copyInto(rtnNodes);
            return rtnNodes;
        }

        public Node[] getSharedVHostGrps() {
            this.sharedVhgs.trimToSize();
            Node[] rtnNodes = new Node[this.sharedVhgs.size()];
            this.sharedVhgs.toArray(rtnNodes);
            return rtnNodes;
        }

        public Node[] getUriGrps() {
            Node[] rtnNodes = new Node[this.uriGrps.size()];
            Collection<Node> c = this.uriGrps.values();
            c.toArray(rtnNodes);
            return rtnNodes;
        }

        public Node[] getUniqueUriGrps() {
            Node[] rtnNodes = new Node[this.uniqueUriGrps.size()];
            Collection<Node> c = this.uniqueUriGrps.values();
            c.toArray(rtnNodes);
            return rtnNodes;
        }

        private Element addRoute(Element route) {
            Element rtn = null;
            String key = route.getAttribute("ServerCluster") + "::" + route.getAttribute("VirtualHostGroup") + "::" + route.getAttribute("UriGroup");
            if (!this.routes.containsKey(key)) {
                rtn = (Element)route.cloneNode(true);
                this.routes.put(key, rtn);
            } else {
                rtn = this.routes.get(key);
            }
            return rtn;
        }

        public Node[] getRoutes() {
            Node[] rtnNodes = new Node[this.routes.size()];
            Collection<Element> c = this.routes.values();
            c.toArray(rtnNodes);
            return rtnNodes;
        }

        public int getSeqNum() {
            return this.seqNum;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.plugin.merge.internal.PluginMergeToolImpl$PluginInfo", PluginInfo.class, (String)"Cluster", (String)"com.ibm.ws.http.plugin.merge.internal.resources.Messages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected class FileInfo
    implements Comparable<Long> {
        public String filePath = null;
        Long fileSize = null;
        static final long serialVersionUID = -1885292152373316998L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public FileInfo(String filePath) {
            this.filePath = filePath;
            this.fileSize = new File(filePath).length();
        }

        @Override
        public int compareTo(Long o) {
            int rtn = 0;
            if (o > this.fileSize) {
                rtn = -1;
            } else if (o < this.fileSize) {
                rtn = 1;
            }
            return rtn;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.plugin.merge.internal.PluginMergeToolImpl$FileInfo", FileInfo.class, (String)"Cluster", (String)"com.ibm.ws.http.plugin.merge.internal.resources.Messages");
        }
    }
}

