/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.web.JavaScriptUtils;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.internal.utils.HttpRequestInfo;
import com.ibm.ws.security.saml.sso20.internal.utils.RequestUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ForwardRequestInfo
extends HttpRequestInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient TraceComponent tc = Tr.register(ForwardRequestInfo.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    boolean bNeedFragment = true;

    public ForwardRequestInfo(String requestUrl, String queryString) {
        this.method = "GET";
        this.reqUrl = requestUrl;
        this.queryString = queryString;
        this.requestURL = queryString != null && !queryString.isEmpty() ? requestUrl + "?" + queryString : requestUrl;
    }

    public ForwardRequestInfo(String requestUri) {
        this.method = "POST";
        this.reqUrl = requestUri;
        this.requestURL = requestUri;
    }

    public void setParameter(String key, String[] values) {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        this.parameters.put(key, values);
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public String getRequestUrl() {
        return this.reqUrl;
    }

    /*
     * WARNING - void declaration
     */
    public void redirectRequest(HttpServletRequest req, HttpServletResponse resp, String cookieName, String cookieValue) throws SamlException {
        block17: {
            try {
                if (cookieName != null && cookieValue != null) {
                    RequestUtil.createCookie(req, resp, cookieName, cookieValue);
                }
                if (req.getAttribute("OIDC_END_SESSION_REDIRECT") != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"SP Initiated SLO Request, removing OIDC_END_SESSION_REDIRECT attribute", (Object[])new Object[0]);
                    }
                    req.removeAttribute("OIDC_END_SESSION_REDIRECT");
                }
                resp.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, private, max-age=0");
                resp.setHeader("Pragma", "no-cache");
                resp.setDateHeader("Expires", 0L);
                resp.setContentType("text/html");
                if (this.method.equalsIgnoreCase("POST") || this.parameters != null && !this.parameters.isEmpty()) {
                    StringBuffer sb = new StringBuffer();
                    try {
                        sb.append("<HTML xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\">");
                        sb.append("<HEAD>");
                        sb.append("</HEAD>");
                        sb.append("<BODY onload=\"document.forms[0].submit()\">");
                        sb.append("<FORM name=\"redirectform\" id=\"redirectform\" action=\"");
                        sb.append(this.reqUrl);
                        if (this.fragement != null && !this.fragement.isEmpty()) {
                            sb.append("#" + this.fragement);
                        }
                        sb.append("\" method=\"" + this.method + "\"><div>");
                        if (this.bNeedFragment) {
                            sb.append(this.handleFragmentCookies());
                        }
                        if (this.parameters != null && !this.parameters.isEmpty()) {
                            Set set = this.parameters.entrySet();
                            for (Map.Entry entry : set) {
                                String key = (String)entry.getKey();
                                String[] values = (String[])entry.getValue();
                                if (values != null && values.length > 0) {
                                    for (int iI = 0; iI < values.length; ++iI) {
                                        sb.append("<input type=\"hidden\" name=\"" + key + "\" value=\"" + values[iI] + "\"/>");
                                    }
                                    continue;
                                }
                                sb.append("<input type=\"hidden\" name=\"" + key + " value=\"\"/>");
                            }
                        }
                        sb.append("</div>");
                        sb.append("<noscript><div>");
                        sb.append("<button type=\"submit\" name=\"redirectform\">Process request</button>");
                        sb.append("</div></noscript>");
                        sb.append("</FORM></BODY></HTML>");
                    }
                    catch (Exception set) {
                        void e;
                        FFDCFilter.processException((Throwable)set, (String)"com.ibm.ws.security.saml.sso20.internal.utils.ForwardRequestInfo", (String)"178", (Object)this, (Object[])new Object[]{req, resp, cookieName, cookieValue});
                        throw new SamlException((Exception)e);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("... expect to be redirected by the browser (" + this.method + ")\n" + sb.toString()), (Object[])new Object[0]);
                    }
                    PrintWriter out = resp.getWriter();
                    out.println(sb.toString());
                    out.flush();
                    break block17;
                }
                String urlGet = this.reqUrl;
                if (this.fragement != null && !this.fragement.isEmpty()) {
                    urlGet = urlGet + "#" + this.fragement;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("... expect to be redirected by the browser (" + this.method + ")\n" + urlGet), (Object[])new Object[0]);
                }
                resp.sendRedirect(urlGet);
            }
            catch (IOException urlGet) {
                void e;
                FFDCFilter.processException((Throwable)urlGet, (String)"com.ibm.ws.security.saml.sso20.internal.utils.ForwardRequestInfo", (String)"203", (Object)this, (Object[])new Object[]{req, resp, cookieName, cookieValue});
                throw new SamlException((Exception)e);
            }
        }
    }

    String handleFragmentCookies() {
        String cookieName = "WASSamlReq_" + this.getFragmentCookieId();
        StringBuffer sb = new StringBuffer();
        sb.append("\n<SCRIPT type=\"TEXT/JAVASCRIPT\" language=\"JavaScript\">\n");
        sb.append("document.cookie = '");
        sb.append(cookieName + "=' + encodeURIComponent(window.location.href) + '; Path=/;");
        JavaScriptUtils jsUtils = new JavaScriptUtils();
        String cookieProps = jsUtils.createHtmlCookiePropertiesString(jsUtils.getWebAppSecurityConfigCookieProperties());
        sb.append(cookieProps);
        sb.append("';\n");
        sb.append("</SCRIPT>\n");
        return sb.toString();
    }

    public void redirectPostRequest(HttpServletRequest req, HttpServletResponse response, String cookieName, String cookieValue) throws SamlException {
        this.method = "POST";
        this.redirectRequest(req, response, cookieName, cookieValue);
    }

    public void redirectGetRequest(HttpServletRequest req, HttpServletResponse response, String cookieName, String cookieValue, boolean fragmentOption) throws SamlException {
        this.method = "GET";
        this.bNeedFragment = fragmentOption;
        if (this.bNeedFragment) {
            this.queryStringToParameters();
        }
        this.redirectRequest(req, response, cookieName, cookieValue);
    }

    /*
     * WARNING - void declaration
     */
    void queryStringToParameters() throws SamlException {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        try {
            int index = this.reqUrl.indexOf("?");
            if (index > 0) {
                String urlQuery = this.reqUrl.substring(index + 1);
                this.reqUrl = this.reqUrl.substring(0, index);
                this.queryStringToParameters(urlQuery);
            }
            this.queryStringToParameters(this.queryString);
        }
        catch (UnsupportedEncodingException index) {
            void e;
            FFDCFilter.processException((Throwable)index, (String)"com.ibm.ws.security.saml.sso20.internal.utils.ForwardRequestInfo", (String)"278", (Object)this, (Object[])new Object[0]);
            throw new SamlException((Exception)e);
        }
    }

    void queryStringToParameters(String query) throws UnsupportedEncodingException {
        String[] pairs;
        if (query == null || query.isEmpty()) {
            return;
        }
        for (String pair : pairs = query.split("&")) {
            int index = pair.indexOf("=");
            if (index > 0) {
                String key = pair.substring(0, index);
                String value = pair.substring(index + 1);
                this.handleParameter(key, value);
                continue;
            }
            this.handleParameter(pair, "");
        }
    }

    void handleParameter(String encodedKey, String encodedValue) throws UnsupportedEncodingException {
        String key = URLDecoder.decode(encodedKey, "UTF-8");
        String value = URLDecoder.decode(encodedValue, "UTF-8");
        String[] values = this.getStringArray(key, value);
        this.parameters.put(key, values);
    }

    String[] getStringArray(String key, String value) {
        String[] result = this.getNewArray((String[])this.parameters.get(key));
        result[result.length - 1] = value;
        return result;
    }

    String[] getNewArray(String[] strings) {
        if (strings == null) {
            return new String[1];
        }
        String[] result = new String[strings.length + 1];
        System.arraycopy(strings, 0, result, 0, strings.length);
        return result;
    }

    HashMap<String, String[]> parseQueryString(String str1) {
        String[] entries;
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (String entry : entries = str1.split("&")) {
            int index = entry.indexOf("=");
            if (index < 0) {
                map.put(entry, new String[0]);
                continue;
            }
            String key = entry.substring(0, index);
            String value = entry.substring(index + 1);
            map.put(key, new String[]{value});
        }
        return map;
    }

    public static boolean safeCompare(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    public static boolean safeCompare(int i1, int i2) {
        return i1 == i2;
    }
}

